CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P11    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:35.061861Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @T        data_max      @T        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     <  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?   data_max      @W   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      <  o   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      4  t   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?g	l   data_max      @rGE8   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       <     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      4  p   salinity                	long_name         salinity   units         PSS-78     data_min      @@HU2a|   data_max      @ALC,zx   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      <    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      4 Dl   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @%   data_max      @rL   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        < S   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      4 h   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?7KƧ   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      <    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      4 d   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      ?333333   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       <    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      4 (`   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     < 7   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      4 t\   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      *    data_max      *    C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @Hw    data_max      @Hw    C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `EZqx   data_max      `EZqx   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        o   data_max        o   C_format      %4d        @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     @T     ?@       @@
@      @      @       @"      @#@%@(      @)@,      @.      @/@0fffff@2      @2@3@5@6      @7      @8      @9      @:      @:fffff@<      @=      @>      @?      @?fffff@@     @A      @As33333@B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H@H     @I      @I     @J      @J     @K@K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Qfffff@R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U&fffff@Ufffff@U     @V      @V@     @V     @V     @V@WL@W     @W     @X      @X@     @X     @X     @Xfffff@Y@     @Y     @Y     @Z      @Z@     @Z     @Zfffff@[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]fffff@]@^      @^@     @^     @^     @_      @_@     @_y@_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @aC33333@a`     @a     @a     @a33333@a@b      @b      @b@     @bi@b     @b     @b     @b     @b@c,@c@     @c`     @c     @c     @c     @c     @c@d      @d@     @d`     @d|@d@d     @d     @e      @e      @e@     @ec33333@e33333@e     @e     @e     @f      @f      @f@     @f`     @f     @f@f@f     @g      @g      @g@     @g`     @g|@g33333@g     @h      @h      @h@     @h`     @h33333@h@h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j33333@j@j     @j     @k      @k@kFfffff@k\@kfffff@k@k     @k     @l33333@l      @l<@l`     @l     @l     @lfffff@m      @m@m<@m`     @m     @m     @m@m     @n      @n      @n@     @n`     @np     @n     @n     @n     @o      @o      @o@     @o`     @o|@o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pnfffff@p~fffff@p     @p     @p     @p     @p     @p@pfffff@pfffff@q     @q      @q0     @qFfffff@qNfffff@q`     @qp     @q     @q@qfffff@qfffff@q     @q     @q     @q     @q33333@r@rfffff@r0     @r@     @rP     @r`     @rp     @r~fffff@r33333@r     @r     @r     @r     @r     @r     @s      @s     @sfffff@s.fffff@s@     @sP     @s`     @sp     @s@s     @s     @s     @s     @s     @s     @s     @t      @tfffff@t!@t0     @t>fffff@tP     @t`     @tnfffff@t     @t     @t     @t@tљ@t     @t     @u      @u     @u      @u0     @u<@uQ@u`     @unfffff@ufffff@ufffff@u     @u     @u     @u     @u     @u     @ufffff@v@vfffff@v0     @v@     @vP     @vY@vt@v~fffff@v     @v     @v@v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wNfffff@wd@wnfffff@w     @w     @w     @w     @w     @wљ@wᙙ@w     @x      @x     @x      @x1@x@     @xP     @x`     @xnfffff@x     @x     @x     @x     @x     @x     @xfffff@x     @y      @y     @y      @y0     @y@     @yP     @y`     @ynfffff@y     @y     @y     @y     @y     @y     @y     @y     @yfffff@z     @z      @z0     @z@     @zQ@z`     @zq@z~fffff@zfffff@z     @z     @z     @z     @zٙ@zfffff@{      @{     @{      @{0     @{@     @{Q@{^fffff@{p     @{     @{     @{     @{     @{     @{     @{     @{fffff@|      @|     @|      @|0     @|@     @|P     @|^fffff@|p     @|     @|@|     @|     @|fffff@|fffff@|     @|     @}      @}     @}      @}0     @}@     @}S33333@}`     @}p     @}     @}     @}     @}     @}     @}fffff@}fffff@}@~      @~     @~      @~.fffff@~A@~P     @~`     @~p     @~{33333@~fffff@~     @~     @~@~     @~     @~     @      @     @      @0     @>fffff@P     @`     @p     @@     @     @     @     @fffff@     @     @      @33333@     @     @      @(     @0     @733333@A@H     @P     @X     @`     @ffffff@t     @w33333@     @     @     @33333@fffff@     @     @     @33333@33333@     @     @     @     @     @     @      @33333@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @@fffff@     @     @     @      @(     @0     @8     @C33333@G33333@P     @X     @`     @h     @p     @x     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @      @(@1@8     @@     @H     @O33333@X     @`     @h     @p     @x     @     @     @     @     @     @     @@     @     @     @     @     @     @     @33333@      @     @     @     @      @(     @0     @8     @@     @H     @P@W33333@`     @h     @p     @x     @     @     @@     @     @     @     @     @     @     @     @     @     @@33333@     @      @     @@33333@      @'33333@0@8     @@     @H@L     @X@`     @h     @p     @x     @     @     @     @     @     @@fffff@     @     @     @     @     @     @@     @      @33333@     @     @      @(     @0@8     @@     @H     @P     @W33333@`@h     @p     @x     @     @     @     @fffff@     @     @     @@     @     @     @     @홙@     @      @     @     @     @@,     @0     @8     @@     @H     @P     @X     @^fffff@jfffff@l     @x@     @fffff@@     @     @     @     @     @33333@     @     @     @     @     @     @     @      @     @     @@     @)@/33333@8     @@     @H     @P     @X     @\@p@x     @     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @      @     @     @ @(     @0     @8     @>fffff@X     @`     @h     @p     @x     @~fffff@     @     @     @     @     @     @@33333@     @     @     @     @     @33333@     @     @      @4     @8     @@     @H     @P     @T@h     @o33333@zfffff@     @     @     @     @     @     @33333@33333@     @     @     @@     @     @     @      @33333@fffff@33333@      @(     @0     @8     @@     @H     @M@\     @`     @p@x     @     @     @@     @     @     @33333@     @     @33333@     @     @     @     @     @      @     @@ @(     @0     @8     @@     @H     @P     @X     @a@h     @p     @u@fffff@     @     @     @     @     @     @33333@     @     @     @     @     @     @@     @      @     @     @fffff@(@0     @8     @@     @H     @P     @W33333@h@nfffff@w33333@     @     @     @     @     @     @33333@     @@fffff@     @     @     @噙@     @     @      @@     @     @      @'33333@333333@8     @@     @H     @P     @Vfffff@h@p     @x     @     @     @     @@     @     @     @     @     @     @     @@     @     @@33333@      @     @     @     @      @(     @0     @8     @@     @G33333@P     @X     @`     @e@p@x     @~fffff@fffff@     @     @     @     @@@33333@33333@     @     @     @     @     @33333@      @     @     @     @     @     @     @ fffff@$     @(     @,fffff@0     @4     @8     @<     @@     @D     @H     @L@P     @T     @X     @\@`     @d     @l@p     @t     @x     @|     @     @     @fffff@fffff@fffff@     @     @     @fffff@     @     @     @     @     @     @33333@fffff@     @     @@     @     @     @     @     @     @     @     @33333@33333@     @      @     @     @     @     @     @fffff@@      @$     @(     @,     @0     @4     @7@<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @fffff@     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @홙@     @     @     @     @      @     @     @@@     @     @     @      @$     @(     @+33333@4fffff@8     @<     @@     @D     @F@L     @P     @T     @X     @\     @`     @b@h     @l     @p     @t     @x     @|     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @fffff@fffff@33333@     @     @     @     @     @@@     @     @     @     @     @@@      @$     @'@-@0fffff@3@8     @<     @@     @D     @H     @K33333@T@X     @\     @`fffff@c33333@hfffff@l     @p@t     @x     @|     @     @     @     @     @     @     @     @     @33333@fffff@     @     @     @     @fffff@fffff@     @     @@     @     @     @     @     @     @33333@癙@     @     @     @     @     @      @33333@fffff@     @     @     @     @     @      @$     @(     @+33333@/@4     @8     @<     @@     @D     @M33333@P     @T     @Vfffff@\fffff@`     @d     @h     @j@p@t     @x     @|     @     @     @     @fffff@@@     @     @     @     @33333@fffff@     @     @     @     @     @     @˙@     @     @     @     @     @     @     @     @fffff@@     @     @      @     @     @@33333@     @     @      @$     @'33333@-33333@0     @4     @8     @<     @@     @Bfffff@H@L     @P     @T     @X     @\     @`     @c@i@l     @p     @t     @x     @{33333@@     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @fffff@fffff@     @     @     @ә@@     @     @     @     @     @     @     @     @@      @     @     @     @     @     @33333@33333@      @$     @(     @,     @0     @4     @8fffff@<@@     @D     @H     @L     @P     @T     @Xfffff@[@`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @33333@@     @     @fffff@@     @     @     @     @@     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @ fffff@fffff@	33333@     @     @     @     @33333@      @$     @(     @,     @0     @4     @7@>     @@     @D     @H     @L     @P     @R@]33333@`     @d     @h     @l     @p     @t     @x     @fffff@     @     @     @     @     @fffff@@@     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @33333@     @     @     @     @     @@      @     @     @     @     @     @     @      @$     @&@-33333@0     @4     @8     @<     @?@E33333@H     @L     @P     @T     @X     @Zfffff@`fffff@d     @h     @l     @p     @t     @x     @|fffff@     @     @     @     @     @fffff@     @     @     @fffff@     @     @     @@     @     @     @     @33333@@     @     @     @     @     @     @     @fffff@     @     @     @      @@@     @     @     @     @      @$     @(fffff@,     @0     @4     @8     @<     @@     @D     @H     @K@P     @T     @X     @\     @`     @h@l     @p     @t     @x     @zfffff@fffff@     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@33333@      @     @     @     @     @@     @@!33333@$     @(     @,     @0     @3@8@<     @@fffff@D     @H     @L     @O33333@Y33333@\     @`     @d     @g33333@pfffff@t     @x     @|     @     @     @fffff@33333@     @     @     @     @     @@     @     @     @     @     @fffff@ə@     @     @ә@33333@     @     @     @     @     @33333@@     @     @      @     @     @     @     @@fffff@     @      @$     @&@.     @0     @4     @8     @<     @@     @H     @L     @P     @T     @X     @[@dfffff@h     @l     @p     @t     @x     @|fffff@     @     @     @     @     @     @     @fffff@@     @     @     @     @     @33333@@     @     @     @     @@     @fffff@     @     @     @     @33333@     @     @     @      @     @     @@@@@     @      @$     @(     @,     @.@933333@<     @@     @D     @H     @L     @P     @Y@\     @`     @d     @hfffff@j     @q33333@t     @w33333@~     @     @     @     @     @     @@     @     @     @     @@     @     @     @     @33333@fffff@     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @      @     @@     @     @     @     @     @!@$     @(     @+@0@4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @c@i33333@l     @p     @t     @x     @|     @     @     @     @     @     @@     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @ݙ@     @     @     @뙙@@     @     @     @ fffff@fffff@     @     @     @     @     @      @$     @-33333@0     @4     @8     @<     @@     @Bfffff@H@L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @fffff@     @     @     @     @     @     @     @@33333@     @     @     @     @     @@33333@     @     @˙@fffff@     @     @     @     @     @     @     @@     @     @      @     @@@     @     @     @     @      @$     @(     @,     @/@4     @8     @<     @@     @H@L     @P     @T     @W                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @n@n@|@N;5@䎊@a@O@*0U2@a@O@Ʌoi@@bM@
=p@$tS@Y@|@c	@u"@>@쿱[W@حV@
qu@	@U=@	@䎊r@䎊r@[6@d8@u!@A7K@R<6@wk@
=p@xF@qj@qj@e@F
L0@1@@O
@O
@zxl"h@@S@S@S@ڹ@,<@&@-@-@$xG@@$xG@$xG@Xy=@r Ĝ@/V@/V@$xG@Xy=@@^@d7@C,z@q@V@.2@4֡a@'RT@A [@2W@m\@|@D@%F
L@\(@}Vl@PH@Q@ ѷY@p:~@ A7K@ATɅo@n}Vl@`A7L@1@rGE8@{@U=@C,zx@sh@N;5@o h@xQ@iy@Xy=c@QN;5@GzH@A7Kƨ@7kP@0oiDg8@&,<@O;d@	@7Kƨ@-
@q@2a|@jOv@]cA@ȴ9Xb@s@iB@7KƧ@nP@|hs@y(@vFs@nzG@dZ1@NVu@5?@1-@0U2a|@,<쿱@&I@ۋq
@حV@ɺ^5?}@!.H@kP@O;@M@
=p@n.@qo@L@BI^5@=K]@3g	l@/@.t@.zG@.zG@IQ@PH@y@Z@\(@n@dZ@~m\@/v@o@cA @ߤ@@*0@	7KƧ@D@^@A7K@@}H@C\@&@o@q@*0@&@&I@|j~#@B@4n@>6z@6C-@$?@kP|@@_o@PH@y=c@rGE9@_o@dZ@}H@?@[$@F$/@E@Z@@҉@7KƧ@H˒:@1@`A7L@%@Y@R@84֡@4m@z)y@w1@p'RT@fx@][@ZY@Y|@S*0U2@FFs@?b}V@-(@4J@8YK@TɅ@e@ï@5Xy@YJ@?@{m@.H@<64@p:@$@t#@4D@'@!.H@|@7Kƨ@~($@XbM@4K@6z@$@H˒:@+a@@rGE9@84֡@}E@z@qA [@kU=@eO
@_?@\wkP@ZQ_@RsP@GzH@A@<쿱[@;m]@9=b@7rG@5!R@4!-w2@3|@1@#Z@[@O;d@]cA@a@N@!R@҈@#@\N@hr@U2a|@1.@ݘ@+@p:@YJ@&I@'/@_o@$/@xF@u?@p
=q@kC]@h@f@eu@cA [@cS&@`	k@_䎊r@[q@QN;5@:~@0:~ @-8Y@,1&y@Ϫ͟@@eO@
qu@A7K@ܬ1&@*0@BZc @Z@xl"h
@@a@@RT`e@@e@-@zxl"h@L/{@TɅo@xYJ@Yb}@Np:~@G)^@:~@(@IQ@@@v@/V@ߤ@I^5@?@m8@ݗ+j@B@0
)@qu"@2W@{/V@b3@]}H@Sݗ+k@A@0:~ @'lC@C,zx@&@sh@O
M@@҉@䎊@
jOv@S&@@2X@e+@`d@)^	@4m9@o i@O;@ڹ@~@hۋq@E84@ԕ*@ɠ'RTa@	 @)^	@\(@@Ov_@쿱[W@n.3@/@-
@e+a@Ϫ͟@t@Ʌoi@As@͸@͞%@~($x@C%@ԕ*@eO@@p:@M:@#x@#@g	@Y@&@@S@n.@z)y@v4K@q-@m
qv@j~"@^@V8YJ@VOv_@Stj~@L~($x@Dg8}@;A@6E@5!R@2m\@,1&y@+C]@+C]@+~($@+C,z@+I^@*fB@+U=@*͞&@*͞&@*fB@+I^@+I^@+C,z@*~"@(\)@&1.@#A [@"}Vm@"}Vm@"wkQ@"}Vm@"M@!R<6@ ҈p@ u!@?@"`B@6@?@PH@af@Mj@)^	@u%F@+I@@,zxl@:S@H˒@)y@E@*0U2a@n.3@҈p@wkP@L_@rGE9@)^	@Õ$@<64@eں@W@U2a|@2X@lD@qj@3@҈p@[6@	@u"@ݘ@b}@@O
M@Z@v_ح@@cA \@C%@L_@Q@@@@?@4m@zxl"h
@vFs@ra|Q@p:~ @oiDg8@nzG@kU=@jfB@iB@c
=p@bh	ԕ@aR<6@_	@\N;@ZQ_@Xtj@XU@W@VR<6@RsP@P-
q@Np:~@Mqu"@L~($x@J	 @H@EoiDg@E@ES&@B74@A [7@=Vl!@;A@5%F
L@-(@)*0U2a@&fffff@$Z1@U@+j@Ov_خ@!-w1@!@N@حV@(\@U@l!-@nO@
=p
@o i@\(@b}V@Vl!@kP@'RT@w1@ۋq
@䎊qj@S&@R<6@[6@U=@ ѷY@6@*0@l!-@ѷX@o @]cA@@s@*0@F]c@&IR@s@"@!.H@C\@4m@g@VϪ@rGE@ڹ@	k@5?|@tj@L_@@`A7@g8}@u?|h@tSMj@q@o@oO
M@mhr!@g/V@be+@a@N@`-
@^u@\?@Y0
)@Nߤ?@Dtj@>BZc @=ڹZ@;A@:S&@6C-@-U=@%1@"wkQ@ -
@(\@b}@Ϫ͞@p:@)^@
#9@?@nP@TɅo@hr@:~ @1.@>BZ@Ϫ͞@ӎMj@ҽ<64@|@_o @@'0@@U=@IQ@S@,<@@q@1&x@ѷX@{s@xF@u%F
L@mhr!@h	ԕ+@bM@S@OAs@N;5X@JD@A7Kƨ@<64@7Xe@0U2a|@+I^@쿱[W@-
q@_o@E@xl"h
@Fs@
=q@(@x@唯O
@S@M@ᰉ'R@҈p@ݗ+j@E@@6@^5?|@H@TɆ@wkP@+J@Ov_@,<@	k@PH@qu"@Fs@xF@irGE@`
qu@^ ѷY@Xe+@W@ZQ_@VϪ͟@QR@N_o @JL_@IQ@J#9@HK]c@>vȴ9X@6E@1[W>6@,1&y@(@!o@ߤ@@sP@Mj@	k~(@S&@
H˒@
 ě@
䎊q@
|Q@
bM@
ΤT@
˒:)z@
7Kƨ@
)_@
XbM@
3@
g	l@
a|Q@
3@
^5?|@
)^@
#9@
As@
Ϫ͞@
5Xy>@
]cA@
W'@
ɅoiD@
@@
Ƨ-@
Ƨ-@
8YK@
@
C@
64@
v@
M:@
M:@
nP@
I^5@
hۋq@
$tS@
~\N<@
~($x@
:S@
wkP@
u!.@
vFs@
v_ح@
tD@
t!-w2@
sE@
sPH@
tSMj@
tj~@
sMjO@
u!R@
xF]d@
x73@
}E@
n@
'RT`@
tj~@
'/@
ڹY@
L_@
@
bM@
$tT@
+J@
3@
Ov_خ@
1&@
u@
Fs@
=p@
a@@
'RT@
{@
O
M@
g	l@
}H@
}Vl@
2X@
$tS@
vFs@
=p
=@B@ ѷY@@c	@6@T`d@5Xy>@+@6@iDg8@
qi@
$TɆ@
Eo i@
C\N@
Dg8}@
DS@
F-@
F
L/@
D2W@
C$@
1&x@
 	k@
kP|@
L_@
Fs@˒:)@!.@@	k@
=p@E84@TɅo@Z@^5?|@4m@}H@֡a@m\@ᰊ@֡a@m8@[W>6@
(@a|Q@v@Xy=@wkQ@,=@)^@#@O;dZ@&I@~($x@}E@}!.H@\N;@6C-@0U2a|@*0
@%1@',@6C-@$/@՛=K@8YK@e+a@m(@ffffff@T`d@S@Z1'@S&@GE84@?[W>@4m8@+I^@
%1@
>@
څݘ@
5Xy>@
ʌL_@
@
5Xy@
)_@
|@
zxl"@
tSM@
,=@
@
sh@
҈@
=p
@
Mj@
ԕ*@
@
|?@
v+jg@
s@
m(@
iᰉ'@
iB@
k~($@
_Ft@
\(\@
\?@
[q@
Y|@
Yb}@
Y|@
W
=p@
U2a|@
UϪ͞@
W&@
XU@
ZY@
[$@
ZQ_@
Y>BZ@
\]ce@
_o@
sE@
y=b@
y(@
y=b@
~$t@
qA [@
]+j@
Np:~@
:)y@
/{J#:@
(\)@
4J@
DS@
B&IR@
ATɅo@
0{@
N+@
QX@
`҈p@
m8Y@
tD@
zC\@
yrGE8@
tD@
tD@
tj~@
u!R@
u\(@
lVϪ@
\(\@
hr Ĝ@
nO;@
h>BZc@
a@N@
\>@
K:)z@
JW'@
BZc@
 [6@
	ԕ*@
$/@
n.@
o hی@
n.@
@4n@	Q@	~($@	u@	9XbN@	n.@	Xy=@	u@	glC@	C@	=K]@	O
M;@	Xy=c@	IoiD@	 -
@	쿱[W@	@n@	=<64@	sE@	~m\@	u\(@	qA [@	nc	@	@	3@		@	qu!@	@@	PH@	Vu@	$tS@	˒:)@	sPH@	iB@	Sa@O@	e+a@	lC@	kC]@	jfB@	iB@	j~"@	h	ԕ+@	cA [@	_Ft@	^@	irGE@	\?@	Zݘ@	\>@	Xe+@	T*1@	P*0U@	J#9@	0
(@	0 ě@	Vt@	jg	@	l!-w@	n.2@	o@	q@	^iB@	:^5?|@	1-@	,<쿱@	)y@	'&@	8}H@	4J@	sP@I^@Vu@%2@y(@sMjO@r䎊q@˒:)@4J@:)y@ݗ+k@Q@u%@tSM@U2a|@1@zxl"@E@&x@Q@ǮzH@8YK@?@V@vȴ9@_F@eO@_o@ ѷ@@u%F@rs@de@P*0U@I@C$@>BZc @A@C@O
M;@gfA@xF@|hr@|PH@{s@{s@}E@~\N<@sMjO@l"h	ԕ@g	k@Y|@SZ@TE@VϪ͟@TɅoi@QN;5@PH@N+@DS@@n@2a|Q@+I^@$?@"3@쿱[W@wkP@tj@	ԕ*@!.@`A7L@څݘ@>@@N@Gz@ޞ@ۋq@>BZ@ԕ*1@ӎMj@䎊@@#9@84֡@74@&IR@v@I^@S@sh@҉@rGE9@@Fs@&I@%2@zC\@v+jg@u!R@rGE85@qiB@qu!S@poiDg8@m\@l[W?@iDg8~@h>BZc@gfA@ceO@`҈p@_?@]+j@W
=p@Q@LcA \@I@I@J#9@GzH@E84֡@D2W@?H˒:@=v@:)_@:)_@8Q@5sg@3ߤ@3ߤ@2-V@-U=@#S&@tj@Xe,@-
q@
qu"@?@ IQ@E@(@@빌~($@1.@@N@ ѷY@1'@Ϫ͟@a@O@#9@&IR@ [7@@S&@E@a|Q@{J#:@d7@-@.H@_o@u%@_o@Xe,@L_@_o@|Q@ql@o@nc	@k~($@lVϪ@k~($@`҈p@S&@Rp:@SMj@QR@K:)z@ATɅo@?@9~($@/O
M@)y@&'@$/@#
=p@"wkQ@vȴ9@ߤ@@@@N@'/@o h@b}V@#x@j~@,<@C,@ce@ԕ*1@*0U@cA \@Ƨ@/{J#@@:@/{J#@ʌL_@@s@?|h@|@33333@ߤ@|@2X@͞&@/V@xF@wkQ@!-w1@-V@u"@@@4J@@@@L_@_o@{J#9@o hی@I^5@oiDg@ ѷ@C%@q@@zC\@sMjO@r ě@sg@xF]d@~$t@`҈p@_حV@_?@_o@W@K:)z@B@6E@/O
M@,=@,<@@@@S&@o @I^5?@
=p
@nP@@n.@:S@ 4m9@H˒@(@Y|@-
@@lC@H˒@˒:)@ 4m9@$tS@E@(@=b@@fB@Q@,<@M@@N@;dZ@5?|@ ѷY@ݗ+j@(\@a@O@@@K]c@ěS@@)y@3@֡a@
(@6z@0U2a|@$xG@x@IQ@S@u@xF@?@9@%@+j@*0@*0@S&@-
q@1&x@@{J#9@.H@}Vl!@}!.H@z>B@sPH@o@o hۋ@l!-w@lVϪ@jOv`@ix@d%1@^@\(\@Y|@Vl!-@UfA@Sa@O@QN;5@O
M;@HK]c@D2W@>
(@8)@2-V@0'RT@)^@$/@#
=p@!ae@!-w1@u@,=@u@,=@,=@1&@vȴ@Z@n@ߤ?@C%@JM@M:@tj@ ѷX@hr@C\@l"h	@_ح@!.@Fs@ȴ9X@ȴ9X@\(@1@PH@.2@!-w@빌~($@C,z@rGE@7@S@S@eO@A [@A [@d8@,<@z@[W>6@ ě@2X@zxl"@TɅ@S@-
@Q@u%F@*0@u@$/@|hr@zG{@xF@v_ح@u%F
L@p@kQ@lVϪ@l"h	ԕ@kC]@jOv`@eO
@`A7K@_Ft@^iB@\>@TɅoi@L_@Gy@C@BZc@?H˒:@?H˒:@?[W>@?[W>@?@>6z@>
(@?[W>@;A@64K@.zG@#9@Ov_خ@[@Ov_@*0U2@S&@N;6@$tT@@ߤ?@
@	7KƧ@oiDg@K]d@_o@@m\@#x@1@l@~"@҈p@W>6z@E@҈p:@N;5@*0U@As@ΤT@)^	@D@]cA@W'@K]c@*0@74@p
=@)_@#w@?@֡a@m8@-@zxl"@/@`A@.H@vȴ9@u@u%@6C@_o@Ov_@$tT@Mj@qi@O;dZ@'/@qu"@L_@k~(@#@K]d@n/@M:@IQ@     @4m9@{s@vȴ9X@r ě@l"h	ԕ@jOv`@hۋq
@h>BZc@f1.@c	@ae@aGz@`A7K@_Ft@XD*@O
M;@MjOv@JD@JD@I@I@IoiD@IoiD@I@HK]c@J#9@9#w@5?|h@4֡a@3ߤ@3g	l@1-@,1&y@)lD@"h	ԕ@Ov_خ@u%@=K^@qu!@,<@e+a@Xe,@@$tS@Ov_@S&@҈@	7KƧ@K]d@oiDg@M:@@ڹZ@(@!.@E@s@A [@iDg8@쿱[W?@JL@䎊qj@ⶮ}Vm@ ѷY@c	@ٳ|@ٳ|@ѷX@+@_o @5Xy>@]cA@@ɺ^5?}@ɅoiD@˒:*@E84@Ƨ-@TɅo@n.@)y@}H@KƧ@C-@z@Xy=@-V@1@U=@>B[@zxl"@0
@Xy=@,@/@xF@wk@wkQ@	@,=@wkP@=K^@kP|@_o@0
)@_F@_F@*0@+j@$tS@Ov_@ݗ+k@S&@)^@@\(@'/W@qi@@'/@qiC@eO@#@ݗ+@ݗ+@@4n@}E@{m]@y=b@vFs@uY|@t#@p:~ @m8Y@m(@mhr!@mC\@m\@mC\@nO;@o hۋ@nc	@m(@h	ԕ+@g8}H@d%1@\N;@XU@T`d@N+@IQ@I@H@Eo i@?H˒:@84֡b@3g	l@1-@1o@0{@0{@0
(@0 ě@-U=@,<쿱@,q@'/V@#wk@vȴ9@Q@!-w1@-V@u%@O
M@'/W@YJ@      @      @ ˒:)@ "@ lC@ F]d@ E@  ě@ ~"@ A [@ @N@ o@ ҈p;@ ޞ@ ]ce@ Ϫ͟@ т@ p:~@ @ ͞%@ jOv@ @ g8}@ @ @ C@ 쿱[@ 5Xy@ v@ K]@ 쿱[@ 64@ /V@ Y}@ -V@ 
(@ 'RT@ 2X@ >B[@ RT`e@ zxl"h@ /@ tSM@ 
=p@ S&@ 	@ }H@ qu!@ _o@ +j@ nO@ =p
@ #@ &I@ JM@ @ :S@ |#x@ |hr@ |#x@ |?@ z>B@ x-
@ u\(@ pD@ k~($@ f,<@ de@ cZ@ d%1@ `҈p@ ^5?|@ \>@ Xe+@ W&@ W>6z@ UϪ͞@ T*1@ Rm@ Rm@ Rm@ S&@ Rm@ Rp:@ Rm@ SZ@ Sa@O@ Sa@O@ SZ@ QR@ M@ M5Xy>@ L_@ Ks@ JD@ H9Xb@ F-@ Eo i@ C,zxl@ ATɅo@ ?H˒:@ ?H˒:@ >6z@ <n.@ :~@ 9~($@ 73@ 5?@ 0U2a|@ +U=@ '-@ &'@ %F
L0@ "`A@ !.H@  	k@ !-w1@ u@ ,=@ ,=@ =K^@ tj@ $tS@ ᰉ@ O
M@ :)y@ @ '/W@ 
O;dZ@ @ ҈@ q@ 	 ѷ@ K]d@ n/@ oiDg@ tj@ @ F]c@ nP@ u%F
@  ѷX?.H?m\?!.H?>B?+?Y|?䎊q?s?oiDg8?rGE?Gz?҈p;?Ϫ͞?m?҈p:?䎊?s?74?vȴ9X?v?j~#?j~#?)_?Y}?4m?4m?g	l?q?,?$tS?S&?	 ?M:?@4n?zxl"h
?y=b?wkP?xF]d?wkP?xF]d?u!R?qu!S?o hۋ?o hۋ?m\?hۋq
?`A7K?[W>6z?Q_p?L_?H˒:*?GzH?GzH?GE84?Fs?E84֡?E84֡?6z?4֡a?3ߤ?3ߤ?3ߤ?1-?/v?+a@?+a@?+I^?'RT`e?!R<6?	?[?PH?Ov_?sh?@N?sP?n?sP?sP?4J?҈? hۋq?lC?"`?rGE8?73?䎊q?䎊q?oiDg8?ᰉ'?rGE?,<?%1?Gz?u!?u!?u!?҈p;? ѷY?"`B?حU?҈p:?As?5Xy>?ɅoiD?<64?~($?}Vl?3?g	l                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @@HXy=@@HXy=@@H[6@@HU2a|@@H[6@@HXy=@@H_F@@H[6@@H[6@@H[6@@HbM@@HeO@@HeO@@Hhۋq@@Hl"h	@@Hhۋq@@HoiDg8@@HoiDg8@@Hl"h	@@HeO@@Hhۋq@@Hl"h	@@HeO@@Hhۋq@@Hhۋq@@HeO@@Hhۋq@@HeO@@Hhۋq@@HoiDg8@@Hy=c@@H@@Htj@@H@@H@@Htj@@Hu%F@@HIQ@@HIQ@@H-
@@HIQ@@HIQ@@H
=q@@HIQ@@H-
@@HU@@HU@@HU@@H9Xb@@H@@@HD@@H`A7@@He+@@He+@@HC@@H\)@@I ѷ@@I ѷ@@I@N@@IrGE@@I@N@@I [7@@I*0U2a@@I4J@@IJE@@I^@@I7Kƨ@@Iu@@IX@@Io@@I@@Jn@@J&IR@@Ju%F
@@Jn@@KP{@@KlC@@Le@@NQ@@P@@@R ě@@V1@@_fA@@bT`d@@j3@@vs@@Ov_خ@@]cf@@I^5@@%1@@R<6@@>BZ@@~($x@@]cf@@6C@@qj@@1@@,<@@$@@@@ȴ9X@@'RT@@o@@öE@@H@@r Ĝ@@o@@"`B@@e@@حV@@У
=q@@@@7KƧ@@хoiD@@ӥS@@lC@@rG@@K]c@@	k@@Dg8~@@٠'RTa@@MjO@@%F
L@@ߤ?@@$tS@@H˒:@@b}V@@A [@@S&@@tj~@@䄵?@@K]@@2a|@@hr!@@E@@\N<@@!.I@@$tS@@
qu@@4m9@@bM@@tj@@u%F@@u%F@@薻@@IQ@@{@@齥@@I^5@@^5?|@@)_@@n@@,<@@S@@1&@@7@@#x@@쿱[W?@@D@@e@@V@@[@@/w@@fA@@힃%@@n/@@\(@@@@8YK@@b@@E@@ ѷY@@4K@@fffff@@\N<@@Vu@@l!-@@z@@O;@@-@@-@@-@@}Vl@@&I@@ߤ?@@ߤ?@@&I@@ȴ9X@@6z@@2X@@]cf@@!.I@@ hۋ@@@@)^@@
M;@@
=p@@
M;@@Xe@@v@@'/W@@1@@As@@>6z@@E84@@KƧ@@O
M@@RT`e@@U=@@eں@@iDg8@@o@@{J#:@@4m@@ݗ+@@vȴ9@@[W>@@@@@@-@@Vϫ@@rGE9@@}H@@@@
qu@@	ԕ+@@@@@*0U@@6@@-
q@@:~ @@H@@NU@@U2a|@@_F@@eO@@hۋq@@_F@@r Ĝ@@y=c@@˒:*@@-
@@-
@@𖻘@@-
@@𖻘@@IQ@@
=q@@
(@@
(@@TɅ@@҈p@@{@@$tT@@$tT@@$/@@	k~@@rGE@@_p@@@@4J@@o@@u@@N;6@@ᰉ'@@R@@I^5@@=p
@@GE85@@M@@T`d@@d7@@\(@@@4@@L_@@{m@@u%F
@@~"@@S&@@vȴ@@L/{@@wkQ@@L/{@@n@@ ѷ@@D@@m\@@74@@I^@@'/@@	@@,zxl@@6z@@C%@@&@@C,z@@9@@a@N@@MjO@@C,z@@,zxl@@6z@@W>6z@@]cA@@@N@@C%@@@N@@Z@@xF]@@xF]@@Mj@@ߤ@@Z@@?@@`d@@1&y@@A [@@a@@@U=@@U=@@@@Q@@!-w2@@]ce@@fA@@M:@@v@@;5X@@"@@-V@@+@@&@@8}H@@E84@@v@@!.I@@쿱[W@@Q@@-@@T@@Fs@@T@@af@@@@@@'@@m\@@+@@ hۋ@@v@@4֡a@@>6z@@1@@Xe,@@@@@4m9@@oiDg8@@hۋq@@e+@@A [@@u!S@@u%F
@@wkQ@@n@@fB@@c	@@m@@D@@'/@@,zxl@@S@@S@@҈@@tj@@64@@Z1@@g8}@@tSM@@wkP@@TɆ@@[W?@@Z@@u"@@!-w@@>@@K]@@u@@S&@@fA@@$/@@!R@@!.@@.2@@H@@Ov_خ@@YJ@@YJ@@c	@@fffff@@%@@}Vl@@m\@@1@@,@@$tS@@1@@O
M@@E84@@>6z@@O
M@@O
M@@o@@@@@@@rG@A 
qu@A 6@A $xG@A >BZc@A 1&x@A [6@A u!@A n@A tj@A U@A TɅ@A @@A `A7@A ѷ@A_p@ADg8~@Ao hی@A7Kƨ@AoiD@A@A'RTa@An.@AB@A"`@AlD@Ad7@A~"@A,<@A74@Au%@AP{@Aa@N@Aqu!@AeO@A$@A*0U2@Aa@O@AA [@A%1@Am8@ATɆ@Aj~@Ahr@A84֡@A`A7L@A$/@Ash@A?@A ѷY@A!R<@A8YJ@ABZc @Ac	@A$t@A@A-@A}Vl@AQ@A+@AMj@A hۋ@A@A.H@A>6z@AsPH@A@A@A	k@A?@Ar@Avȴ9@AK]d@AVϫ@A}H@A_F@A-
@ATɅ@AD@A@APH@A	@A	+@A	&x@A	^@A	rGE8@A	rGE8@A	7Kƨ@A	l@A	o@A	ԕ*@A	@A	ᰉ'@A	Y}@A
#9@A
@4n@A
Zc@A
kP|@A
qiC@A
S&@A
L/{@A
n@A
)_@A
͞&@A
c	@AS&@A,zxl@A9@Ag	l@A@A~$@A~$@A{J#9@Ag	l@AQ@AE@A5Xy@As@A(\@A_@A?@A@A
V@A
p
=@A
@A
?@A
L/@AzG@AH@A}Vl@AFs@A6z@Am\@Aߤ?@A쿱[W@A hۋ@A)^@A,@A1@AU=@A_o@A	@A-V@A˒:)@A-@A     @A*0U@A$xG@A1&x@A4m9@AU2a|@Ahۋq@AYJ@Au%F@A
(@A$/@A-w1@AA [@Au!S@Ao@A"`@A-@Au%F@A#9@AS&@AnP@A'/@A33333@A@N@AF]c@AW>6z@A*0U2@A҈@A%2@A@AJ@A@A/{J#@AzG@A@Ao i@AK]@AK]@A'0@A!.H@Aw1@A@A,=@AC\@A5?|@AL/{J@Ap:~@A$t@A-@AC-@Ax@A hۋ@AXe@Av@ART`e@A&@AK]d@A;dZ@A-@A+j@A@A}H@A73@A@AF@Aۋq
@Ae+@A`A7@A@A\)@A [7@A#w@AQ@Ao hی@Ab}@Ao@A'RTa@A'R@AD@As@A	 @A@A&IR@AW'@A~"@A~"@AS&@AL/{@A ѷ@As@AZ@A|@AlC@A1&y@AxF@Atj@A%1@A,<@A9XbN@A<쿱@AI^5?@AVϪ@A]ce@AtSM@AwkP@AtSM@AwkP@A3@AZ@AɅoi@A/@A@Au@Ap
=@AM:@A@AH˒@A8YK@AoiDg@AC\@A!.@A!.@A_o @AVu@Ap:~@AIQ@AIQ@AO;@A,<@A-@Aߤ?@A&I@At@AA@At@AA@AC-@A]cf@A+@A1@AC-@A+@A1@AFt@A$tS@A!-w1@A$tS@A>6z@AKƧ@AlC@A4m@A-V@A$tS@AkP@AkP@A͞@AK]d@A -
q@A 4m9@A oiDg8@A 4֡b@A!rGE@A!_p@A!#w@A!-w1@A!-w1@A!Gz@A!XbM@A!hr @A!u!S@A!|Q@A!oiD@A!(@A!R@A!.H@A"u%F@A"s@A"e+@A"-V@A"3@A":)y@A"-V@A"a|Q@A"h	ԕ@A"nO@A"~"@A"@4@A"~"@A"@4@A"p:@A"ݘ@A"ݘ@A"S&@A"g	@A"<64@A"Y@A"G{@A#g	l@A#lC@A$?@A$wkP@A$o h@A$N;@A$?@A$Ʌoi@A$Z@A%qu"@A%$/@A%hr!@A%%@A%1@A%n/@A&}Vl@A&6z@A&ȴ9X@A&Mj@A'
M;@A'>6z@A'iDg8@A'y@A'kP@A'O;d@A'O
M@A&Ϫ͟@A&ȴ9X@A&@A&'@A&2X@A&&I@A&ߤ?@A&&I@A&쿱[W@A'b}V@A'zH@A(K]c@A()@A)x@A)R<6@A)u@A)@A)X@A)|@A)|Q@A)(@A)-@A*I^5@A*n@A*n@A*I^5@A*&IR@A*0U2a|@A*6C@A*=p
@A*3@A*6C@A*JL@A*kP|@A*qiC@A*{m@A*wkQ@A*}Vm@A*<64@A*n@A*c	@A*~@A+u%@A+nP@A+nP@A+C,z@A+"`B@A+/V@A+F]c@A+]cA@A+Q@A+qu!@A+Q@A+wk@A+*0U2@A+@A+6@A+~($@A+q@A+q@A+E@A+a@O@A+~($@A+Z@A+q@A+:)z@A+&@A+҉@A+u%@A*74@A+'/@A+]cA@A+dZ@A+]cA@A+P{@A+F]c@A+&@A+u%@A+'/@A+PH@A+C,z@A+33333@A+,zxl@A+33333@A+,zxl@A+33333@A+9@A+C%@A+P{@A+dZ@A+a@N@A+~$@A+:)z@A+E@A+6@A+a@O@A+a@@A+%2@A+g@A+C]@A,L_@A,,<@A,L_@A,?@A,<쿱@A,/{J#@A,,<@A,64@A,9XbN@A,C,zx@A,Fs@A,SMj@A,SMj@A,SMj@A,q@A,~($x@A,_@A,zxl"@A,O
M@A,O
M@A,TɆ@A-%F
L@A-jOv@A-ݗ@A-hr!@A-oiDg@A._o @A-!.@A-(@A-b@A-8Y@A-H˒@A-
qv@A.H@A.s@A.$t@A.Fs@A."@A/O
M@A/	@A/K]d@A0	ԕ+@A0@A0F]d@A073@A0>BZc@A0:~ @A0>BZc@A0-
q@A073@A0[6@A0@A0
=q@A0TɅ@A0{@A0$tT@A1@A1 ѷ@A1$/@A0{@A0	k@A0\)@A0PH@A1@N@A1@A10
)@A17KƧ@A0F@A09Xb@A0@A0`A7@A0ۋq
@A0D@A0˒:*@A0D*@A01&x@A0bM@A0hۋq@A0hۋq@A04m9@A0U2a|@A0U@A0)@A1JE@A1@A1@A1oiD@A1o hی@A1N;6@A2C\@A2M@A2Q_@A2:)y@A2Q_@A2a|Q@A2W'@A2JL@A2Q_@A2GE85@A2-V@A2d7@A2p:@A2vȴ@A2@A20
@A2vȴ@A2>B@A2S&@A2S&@A2@A2fB@A3'/@A3J#9@A3dZ@A3xF]@A3~$@A3@A3Q@A3qu!@A3eO@A4xF@A4M:@A4cA \@A4cA \@A4g8}@A4zG@A4?@A4Z1@A4I^5?@A4I^5?@A4I^5?@A4M:@A4PH@A4Z1@A4?@A3Mj@A3dZ@A3dZ@A3Mj@A3E@A36@A41&y@A4Z1@A4Z1@A4j~#@A4~($x@A4tSM@A4o h@A4_@A4zxl"@A4쿱[@A4@A4O
M@A4#x@A4@A4e@A4֡a@A4֡a@A4֡a@A4u"@A5V@A5+a@A5?|h@A5IQ@A5`A7L@A5?|h@A5<64@A5%F
L@A5*0@A5[@A5'0@A5(@A5B@A5O;dZ@A5n/@A5oiDg@A6t@A64K@A6
L/@A6
(@A6!R<@A6($x@A6Ov_خ@A6L/{J@A6YJ@A6iB@A6}Vl@A6-@A6ߤ?@A6m\@A6ȴ9X@A6ȴ9X@A6+@A6쿱[W@A6Fs@A6Fs@A6"@A7
M;@A7,@A7.H@A78}H@A7E84@A7\(@A7RT`e@A7KƧ@A7Xe,@A7|hs@A7vȴ9@A7˒:)@A7حV@A7@@A7;dZ@A7䎊r@A8F]d@A86@A8}H@A8'RT`@A873@A8:~ @A8A7K@A8H@A8eO@A8u%F@A8u%F@A8U@A8
(@A8)^@A8ѷX@A8ѷX@A8ۋq
@A8C@A8	k@A8PH@A9	k~@A9$/@A9$/@A9	k~@A9rGE@A9@N@A9 [7@A9&x@A94J@A9JE@A9JE@A9JE@A9XbM@A9e+a@A9k~(@A9rGE8@A9|Q@A9x@A9oiD@A9oiD@A9~($@A9~($@A9u@A9'RTa@A9B@A9'R@A9X@A92W@A9ԕ*@A9o@A9_o@A9iB@A9Y}@A:	 @A:I^5@A:䎊@A:)y@A::)y@A:C\@A:M@A:W'@A:qiC@A:p:@A:S&@A:vȴ@A:@A:>B@A:}Vm@A:<64@A:,<@A:fB@A:G{@A:䎊q@A:C,@A:~@A;'/@A;	@A;33333@A;=K^@A;F]c@A;P{@A;MjO@A;P{@A;S@A;a@N@A;xF]@A;Q@A;$@A;Mj@A;Mj@A;U=@A;A@A;:)z@A;wk@A;E@A;m]@A;6@A;~($@A;a@O@A;
=p@A;
=p@A;ݗ+k@A;C]@A;s@A<1&y@A<1&y@A<n.@A<J@A<xF@A<@A<Q@A<!-w2@A<64@A<Z1@A<cA \@A<q@A<~($x@A<?@A<3@A<O
M@A<7@A<7@A<Ʌoi@A<*0@A<Ʌoi@A</@A<JM@A<e@A=:@A=:@A=o i@A=o i@A=:@A<!-w@A<e@A<e@A<!-w@A<!-w@A<!-w@A<>@A<>@A=o i@A=o i@A=K]@A='0@A=*0@A=[@A=Q@A=%F
L@A=!.H@A=+a@A=84֡@A=IQ@A=O;dZ@A=ce@A=zxl"h@A=M:@A=ݗ@A=!R@A=zxl"h@A=$/@A=$/@A=$/@A==K@A=H˒@A=1@A=U=@A=1@A=1@A=@A=\(@A=\(@A=@A=,=@A=ڹ@A>_o @A>
(@A>4K@A>$/@A>+jg@A>;5X@A>Ov_خ@A>fffff@A>c	@A>vȴ9X@A>%@A>+J@A>$t@A>@A>ߤ?@A>A@A>҈p;@A>҈p;@A>+@A>1@A>@A>C-@A>x@A>쿱[W@A?Ft@A?'/W@A?+I@A?1@A?O
M@A?U=@A?Xe,@A?Xe,@A?_o@A?b}V@A?_o@A?\(@A?eں@A?|hs@A?{J#:@A?4m@A?&@A?&@A?	@A?-V@A?$tS@A??@A??@A??@A?&@A?͞@A?&@A?͞@A?͞@A?&@A?&@A?͞@A?&@A?͞@A?[W>@A?r@A?[W>@A?3@A?/V@A?@A?+@A?+@A?+@A?@A?fA@A?@@A?-@A?-@A?䎊r@A?rGE9@A@F]d@A@@A@*0@A@:~ @A@:~ @A@D*@A@K]c@A@U2a|@A@Q@A@Xy=@A@Xy=@A@eO@A@hۋq@A@hۋq@A@oiDg8@A@˒:*@A@˒:*@A@@A@@A@@A@9Xb@A@ěT@A@
(@A@)@A@
(@A@)@A@
(@A@ěT@A@@@A@҈p@A@e+@A@4֡b@A@PH@AA	k~@AA	k~@AA@AA	k~@AA@N@AA [7@AA#w@AA&x@AA*0U2a@AA&x@AA#w@AA#w@AA*0U2a@AA&x@AA&x@AA-w1@AA0
)@AA0
)@AA4J@AA7KƧ@AA=b@AAA [@AAGz@AAN;5@AAXbM@AA[W>6@AAXbM@AAA [@AA@AA*0U2a@AA-w1@AA:S@AA7KƧ@AAN;5@AATɅo@AA^@AAo hی@AArGE8@AAx@AA|Q@AA@AA|Q@AAb}@AA@AA@AAoiD@AAo@AAB@AAB@AAB@AA'R@AA|@AA^5?}@AAX@AA^5?}@AA_o@AA@AAD@AAD@AAD@AA_o@AA@AA@AA@AAԕ*@AAԕ*@AA"`@AA"`@AAiB@AA"`@AAR@AA>BZ@AA.H@ABs@ABe+@ABOv`@AB3@AB=p
@AB@4n@ABC\@ABC\@ABC\@ABGE85@ABM@ABd7@ABxl"h
@AB@4@ABL_@ABS&@ABwkQ@AB ě@ABg	@ABL/{@ABL/{@ABL/{@AB>B@AB}Vm@ABY@AB@AB@ABW@ABn@ABW@AB`A@AB͞&@AB,<@ABڹY@ABfB@AB~@ACI^@ACnP@ACs@AC"`B@AC)^	@AC)^	@AC/V@AC=K^@ACMjO@ACW>6z@ACW>6z@ACZ@AC]cA@ACg	l@ACjf@ACjf@ACn.3@AC~$@ACeO@ACeO@ACeO@ACMj@ACeO@ACeO@ACMj@ACA@ACA@ACU=@ACq@AC*0U2@ACq@ACq@ACZ@ACa@O@AC5Xy@ACQ@ACݗ+k@AC҈@AC҈@ACg@ACA [@AC@ACs@AC@ACs@ADxF@AD%1@AD(\@AD2W@AD64@AD2W@AD2W@AD64@AD64@AD<쿱@AD?@AD<쿱@ADg8}@ADm8@ADm8@ADtSM@ADtSM@ADwkP@AD#@ADS@ADTɆ@AD@AD7@AD?@AD@AD@AD֡a@AD/@AD>B[@AD>B[@AD/@AD@ADJM@AD!-w@ADe@ADe@ADE@AEK]@AEu@AEqu"@AE+a@AE(@AE%F
L@AE(@AE(@AE2a|@AE<64@AEIQ@AEL_@AES&@AEY|@AE`A7L@AEce@AEm\@AEp
=@AEsg@AEw1@AEw1@AEzxl"h@AE$/@AEzxl"h@AEM:@AEݗ@AEݗ@AEO
@AE%@AE%@AE@AEv@AEv@AE@AEv@AEXy=@AEsh@AE@AE@AEn/@AE\(@AE8Y@AEcA @AEϪ͞@AEb@AE?@AEb@AE,=@AEoiDg@AEoiDg@AE!.@AEڹ@AF ѷY@AFt@AF
L/@AF
(@AF4K@AF@AFzG@AF!R<@AF!R<@AF$/@AF!R<@AF$/@AFu@AFOv_@AF!R<@AF$/@AF+jg@AF+jg@AF5?|@AF1.@AF8YJ@AF8YJ@AF?@AFH@AFOv_خ@AFR<6@AF_ح@AFfffff@AFl!-@AFl!-@AFvȴ9X@AFz@AF}Vl@AFIQ@AF%@AF+J@AF%@AF@AF@AF$t@AF@AFT@AFaf@AF6z@AFT@AF6z@AF&I@AF&I@AF&I@AFȴ9X@AFϪ͟@AF]cf@AFMj@AF"@AF!.I@AFFs@AF!.I@AG hۋ@AF"@AF!.I@AGFt@AG
=p@AG@AGXe@AG!-w1@AG1@AG4֡a@AG+I@AG>6z@AGKƧ@AGU=@AG_o@AGsPH@AG|hs@AG4m@AG{J#:@AG{J#:@AG	@AGݗ+@AG?@AG?@AG/V@AGo @AG+@AGfA@AGfA@AGfA@AG;dZ@AGVϫ@AG#@AH@AH@AH	ԕ+@AH@AHbM@AH ě@AH'RT`@AH'RT`@AH-
q@AH>BZc@AHD*@AH>BZc@AHA7K@AHD*@AHA7K@AHK]c@AHNU@AHeO@AHl"h	@AHhۋq@AHl"h	@AHu!@AH˒:*@AH'RT@AHYJ@AHYJ@AHYJ@AHYJ@AH'RT@AHtj@AHIQ@AHu%F@AH-
@AH{@AHěT@AH@@AHp:@AHѷX@AHۋq
@AHD@AHC@AHC@AHC@AH4֡b@AH4֡b@AH$tT@AI@AI_p@AI#w@AI-w1@AI-w1@AI4J@AI:S@AI7KƧ@AIA [@AIGz@AIQ@AIXbM@AIXbM@AI[W>6@AIae@AIhr @AIae@AIe+a@AIhr @AIhr @AIhr @AIe+a@AIe+a@AIhr @AIhr @AIk~(@AIo hی@AIx@AIx@AI|Q@AIb}@AI@AIoiD@AI~($@AI~($@AIR<6@AIu@AI'RTa@AI'RTa@AI'RTa@AIl@AIl@AI'R@AIX@AI2W@AIy@AIԕ*@AIiB@AIiB@AI>BZ@AI@AIR@AIs@AI-@AIlD@AI-@AI-@AJu%F@AJ@AJs@AJs@AJOv`@AJ1'@AJ䎊@AJ#9@AJ)y@AJ)y@AJ-V@AJ0U2a|@AJ3@AJ:)y@AJ@4n@AJ:)y@AJ@4n@AJGE85@AJC\@AJJL@AJJL@AJQ_@AJT`d@AJM@AJW'@AJZc@AJZc@AJ^5?|@AJd7@AJd7@AJh	ԕ@AJqiC@AJ~"@AJ@4@AJL_@AJS&@AJS&@AJS&@AJwkQ@AJ@AJn@AJ ě@AJg	@AJ>B@AJg	@AJY@AJ}Vm@AJg	@AJ<64@AJ)_@AJ`A@AJfB@AJC,@AJ74@AJm\@AJm\@AK҉@AK҉@AKnP@AKs@AKnP@AKnP@AKs@AKC,z@AK"`B@AK&@AK&@AK)^	@AK6z@AK=K^@AKMjO@AKZ@AKS@AKW>6z@AKW>6z@AK]cA@AKW>6z@AK]cA@AKa@N@AKqu!@AKtj~@AKxF]@AK{J#9@AKxF]@AK{J#9@AK~$@AKQ@AKq@AKeO@AKq@AK$@AK$@AKߤ@AKU=@AKq@AKS@AKq@AK*0U2@AKm]@AKq@AK@AK@AKE@AKa@O@AK@AK5Xy@AK|@AKa@@AK
=p@AK
=p@AKݗ+k@AKlC@AKC]@AKg@AKA [@AK$@AK@AKs@AK$@AKs@AK\N@ALn.@ALJ@ALߤ@@ALL_@ALL_@AL!-w2@AL2W@AL64@AL64@AL<쿱@ALC,zx                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @rFfffff@r9@r1@r0     @r@     @r<@rI@rD@rC33333@r>fffff@rI@rK33333@rI@r9@r;33333@rA@r<@r4@r8     @r<@r6fffff@r+33333@r8     @r>fffff@r9@r;33333@r1@r)@r)@r4@rD@rC33333@rC33333@r@     @rD@rK33333@rFfffff@rH     @rL@rL@rA@r>fffff@rD@rI@rFfffff@rA@rC33333@r@     @r8     @r,@r333333@r>fffff@r>fffff@r4@r4@r333333@r4@r6fffff@r4@r;33333@r9@r6fffff@r;33333@r>fffff@r>fffff@r9@r6fffff@r4@r333333@r4@r1@r0     @r.fffff@r.fffff@r1@r0     @r&fffff@r     @qfffff@q33333@q     @qvfffff@qfffff@pᙙ@pQ@o9@m     @li@ki@j@j\@j     @jfffff@i33333@i     @iS33333@i@h陙@h@h@h@hffffff@h6fffff@h	@gfffff@g@gp     @gVfffff@g0     @gfffff@f     @f陙@f@ffffff@f33333@f\@f6fffff@f@     @f<@f333333@f&fffff@f@f      @ffffff@f33333@f@e33333@e33333@e@e     @e@e33333@e@e@e     @e     @evfffff@eP     @e0     @e      @e&fffff@e@efffff@e@efffff@d@d@d     @dٙ@də@d33333@dfffff@d@dVfffff@d	@c     @c33333@c     @c     @cfffff@c33333@c33333@cfffff@c|@c`     @cFfffff@c,@c&fffff@c0     @c0     @c      @c	@b33333@bٙ@bfffff@b     @b     @b@b@by@bi@b\@bFfffff@b333333@b)@b&fffff@b@aə@a33333@ay@ac33333@a\@aY@aVfffff@aS33333@a@`@`@`@`     @`fffff@`陙@`33333@`     @`ə@`33333@`33333@`     @`@`@`     @`33333@`33333@`vfffff@``     @`6fffff@`@_Y@_&fffff@^@^ٙ@^33333@^@^     @^     @^ٙ@_fffff@^@^fffff@^s33333@^@     @]33333@]     @]     @]     @]fffff@],@]@\fffff@\     @\fffff@\fffff@\@\fffff@\s33333@\9@\@[fffff@[ٙ@[fffff@[@[fffff@[ffffff@[@     @[Ffffff@[@     @[,@[@[&fffff@[&fffff@[fffff@Zfffff@Zfffff@Zy@Z333333@Z33333@Y33333@Y33333@Y@Yy@YFfffff@Y@     @Y,@Y&fffff@Y      @Y@Y@Y@Yfffff@Xfffff@X     @X     @Xٙ@X     @X33333@X     @X     @Xl@Xffffff@Xffffff@XS33333@X9@X&fffff@X@X@X&fffff@X33333@W33333@W@W@W@W     @W@W     @Wfffff@W@W33333@W@W@Wffffff@WS33333@W@     @W&fffff@V     @Vl@Vfffff@V33333@Vfffff@W      @V@V@V33333@V     @V33333@Uy@U@Tٙ@Ty@S33333@Ss33333@S@     @S@S@     @Sl@Sfffff@S33333@S33333@S@S     @S     @Sٙ@Sfffff@S     @S@S@Sfffff@S@S@Sfffff@Sl@SL@S9@S,@S,@R@R@Rs33333@RL@R&fffff@Qٙ@Q     @QFfffff@P@Pfffff@P@P33333@Pfffff@P     @P     @P@P     @Pfffff@P`     @P,@P      @P      @Offfff@Offfff@O33333@O     @Os33333@Os33333@Os33333@OL@OL@O333333@O333333@N33333@N@Nfffff@Ns33333@N&fffff@M     @Mfffff@Mfffff@Mfffff@Mfffff@Ms33333@Mffffff@M@     @M@M@M      @L@L@L     @Ls33333@Lffffff@LY@LL@L@     @L&fffff@L      @Kٙ@K33333@Kfffff@K@Ks33333@Ks33333@Ks33333@Ks33333@KL@K&fffff@K@K      @J33333@J33333@J@Jfffff@J@JY@J@     @J&fffff@J      @J@J@J@Ifffff@I33333@I@Is33333@I333333@Hٙ@H33333@H@Hs33333@HL@H&fffff@H333333@H@G33333@Gٙ@G33333@G33333@GY@G333333@Ffffff@Fٙ@F     @Fs33333@F@     @F@Eٙ@E@Efffff@E@E@E@E@EL@E&fffff@E@E@E&fffff@E      @E      @Dfffff@D     @D@Dfffff@D@D     @Ds33333@DL@D@     @DY@DL@D&fffff@C33333@C@C@Cs33333@CL@C333333@C333333@C333333@C      @B33333@C      @B@B@B33333@Bfffff@B@B     @Bs33333@Bffffff@BL@Bffffff@B&fffff@B      @Afffff@Afffff@A33333@A@A@A     @Afffff@A@As33333@A@Affffff@AY@A@A&fffff@A@A&fffff@AL@A@     @A@A@@ٙ@@@@s33333@@&fffff@@&fffff@@      @?@?@>33333@>@>L@>ffffff@=fffff@>      @=@=@=@=     @=L@=     @=L@=333333@=      @=@<33333@<@<     @<333333@<@<      @;fffff@;@;@;@;fffff@;@;ffffff@;L@;333333@:fffff@:@:@:L@:      @933333@933333@933333@9ffffff@833333@8@8@8     @8     @8@8@7fffff@7@7@7fffff@7@7@7ffffff@7333333@633333@7      @6@6@7      @6@6L@6333333@6L@6333333@5fffff@5@533333@533333@5@5L@5@5@5333333@5L@5L@4fffff@5      @433333@4@4@433333@4@4L@4ffffff@4333333@4ffffff@4L@4L@4      @3@3@3fffff@3fffff@3fffff@333333@3ffffff@3ffffff@3     @3ffffff@3ffffff@3ffffff@3L@233333@3@233333@3@2fffff@2fffff@2     @2L@2@2@1@1fffff@2      @1@1@1fffff@1@1@1@1@133333@133333@1fffff@1fffff@133333@1@1@133333@133333@1@1@1333333@0fffff@1@1333333@1      @1      @1      @1      @1L@0fffff@0fffff@0@0ffffff@0L@0     @0@0@0@0@033333@033333@0@033333@0fffff@0fffff@1      @0@0@0fffff@0@0@0@0fffff@1      @1      @0@0fffff@0@0ffffff@0@0fffff@0     @033333@0L@/@/@/@/ffffff@.@.@/      @.@.@.@/333333@/      @.@/      @.333333@.333333@.333333@.333333@.333333@.      @-@-@.@.333333@.333333@-@.333333@-@-@-333333@-@-@-@.      @-@-333333@-ffffff@-ffffff@-333333@-      @,@+333333@+      @+      @+333333@+333333@+@+@*@*@*      @)333333@)@)@(@(@'@(      @'@'@'@'@'ffffff@'ffffff@(      @(333333@(@)ffffff@*      @*333333@*333333@*333333@*      @)333333@)ffffff@)333333@)@(@'333333@&ffffff@&333333@&333333@&ffffff@&333333@&@&@&ffffff@&333333@&333333@&      @&333333@&@&ffffff@&333333@&333333@&@&@&ffffff@&@&333333@&333333@'333333@'333333@&@&333333@&@&ffffff@&333333@'      @&333333@&      @&      @&      @&      @&333333@&@&      @&      @&@&@%@&      @&@&@&ffffff@&ffffff@&@'      @'333333@'      @'@'@(      @(333333@(333333@(@(333333@'@(ffffff@(333333@(333333@(@)333333@)ffffff@)@)333333@)@)      @)ffffff@)      @)333333@)      @)      @(@(@)      @)      @)      @)      @)333333@)ffffff@)333333@)@)ffffff@)      @)333333@)333333@)ffffff@)@)333333@)333333@)ffffff@)@)@)@)@)333333@)333333@)333333@)333333@)ffffff@)@)@)ffffff@)333333@)333333@)@)333333@(@(@(@(@(@(@(@)      @)333333@(@(@(@(@(333333@(@(ffffff@'@'ffffff@'@(333333@'@'      @'@(333333@'@'333333@'ffffff@'@(      @'@'ffffff@'333333@'333333@'@'@(333333@'@'@(ffffff@(      @'ffffff@'@(@(      @'333333@'@(ffffff@(ffffff@(@(@(@(@(@)333333@(@)      @(@)333333@)      @(ffffff@(@(@(@(@)      @(ffffff@(@(333333@(333333@(@(@(@(@(@(@(@)333333@(@(@(@(@(@(@(@(@(ffffff@(@)      @(@(@(ffffff@(@)      @)      @(@)333333@)      @)333333@)      @)ffffff@)      @)333333@)333333@)333333@)333333@)      @)      @)      @)ffffff@)@)@)@)333333@)333333@)@)@*      @)@*      @*333333@)@)@*333333@*      @*      @*      @*ffffff@*      @*333333@*@)@*333333@*333333@*      @*@*333333@*      @*333333@*333333@*@*@*@*@*@+      @*      @*ffffff@*@*@*@+333333@*@*@+ffffff@+333333@*ffffff@+ffffff@+@+ffffff@+ffffff@+ffffff@+      @+@+@+@+@+@,      @,333333@+@+@,      @,333333@,      @,ffffff@,ffffff@,@,ffffff@,@,333333@,@,@,@-      @-333333@-ffffff@-      @-333333@-@-ffffff@-ffffff@-ffffff@-ffffff@-333333@-ffffff@-333333@-@-ffffff@-@.      @-@.ffffff@.ffffff@.ffffff@.      @/      @/333333@.@.@.@.@/      @.@.ffffff@/ffffff@/333333@/333333@/ffffff@/333333@/@/ffffff@/      @/333333@/ffffff@/@0      @/ffffff@/ffffff@/@/@/ffffff@/@0      @/@/@0      @0      @/@/ffffff@/@/@0333333@0      @/@/@0L@0L@0L@0ffffff@0@0@0ffffff@0     @0@0fffff@033333@1      @1@0fffff@0fffff@1333333@1@0fffff@1333333@1@1@1L@1333333@1ffffff@1@1@1@1ffffff@1ffffff@1ffffff@133333@1@133333@1@133333@1fffff@1     @1@2L@1fffff@2      @2L@1fffff@2ffffff@2     @2@2333333@2333333@2L@2L@233333@3      @2@2333333@2     @2     @233333@233333@233333@233333@3      @2@3333333@3333333@3ffffff@3     @3     @3     @3     @3333333@3333333@3333333@333333@4333333@333333@3fffff@3     @3@333333@3@333333@333333@333333@3fffff@3@3@3@3ffffff@3fffff@4333333@333333@3@4@3fffff@4      @3fffff@3fffff@4@4333333@4333333@4@4333333@4@4     @4@4333333@4L@4L@4L@4@433333@4@4@4fffff@4fffff@433333@5@5@4@5@5L@5L@5L@5L@5@533333@5@533333@5@5fffff@6      @6      @6     @6@6L@6@6ffffff@6     @6     @6     @7      @6fffff@6     @6@7      @6     @7      @7L@6fffff@7@7ffffff@7L@7@7@7333333@7333333@7     @733333@7fffff@8      @7     @7@7fffff@7fffff@7@733333@8L@8333333@7fffff@8333333@8333333@8333333@8@8      @8333333@8L@8@7fffff@8      @8      @7fffff@8333333@8333333@8333333@8333333@8ffffff@8ffffff@8     @8L@833333@833333@833333@8@8     @8@8fffff@8fffff@9@9@9      @9333333@9@9333333@9333333@9ffffff@9     @9@9@9@:      @:      @9fffff@9fffff@9fffff@:ffffff@:L@:L@:ffffff@:ffffff@:ffffff@:L@:333333@:333333@:333333@:     @:     @:@;@:33333@:@;@;      @:33333@;@:fffff@;333333@;      @:@;333333@;333333@;@;L@;@;@;L@;333333@;333333@;333333@;ffffff@;333333@;ffffff@;     @;     @;     @;33333@;ffffff@;     @;L@;333333@;L@;     @;     @;     @;     @;fffff@;     @;     @;@;@;@<L@<@;fffff@<      @<333333@<@<ffffff@<     @<L@<L@<333333@<L@<     @<     @<     @<33333@<@<ffffff@<@<@<@<fffff@<@=      @<@<33333@<33333@<@=@=      @=      @<fffff@<fffff@=ffffff@=     @=@=@=@=@=fffff@=@=@=fffff@>@>@>333333@>@>     @>@>ffffff@>@>@>33333@>@>@?@>fffff@>fffff@>fffff@?      @>@?L@?333333@>fffff@>@?L@?@?L@?     @?     @?33333@@@?@@@@333333@@@@&fffff@@@@@@@     @@333333@@333333@@@     @@Y@@Y@@Y@@ffffff@@ffffff@@L@@ffffff@@fffff@@@@ffffff@@s33333@@ffffff@@ffffff@@Y@@@@fffff@@33333@@     @@33333@@@@     @@fffff@A@A@@     @@ٙ@@fffff@@fffff@A@A333333@A@     @A&fffff@AY@AL@A@     @AY@Affffff@A@     @A333333@AL@Affffff@A@Affffff@A     @A     @A     @A@A@A@A     @A@A     @A33333@Aٙ@A33333@B@     @B@B@B@B@B@     @B@     @B@B&fffff@BL@B@     @BL@Bffffff@B     @B     @B@Bs33333@Bffffff@B     @B@Bfffff@B@Bfffff@Bfffff@B33333@Bfffff@B33333@Bٙ@Bfffff@C@Bfffff@B@C@B33333@C@C333333@C      @C@C@C@     @C@C@     @C&fffff@C&fffff@C@C@     @C@     @Cffffff@C@     @CY@Cs33333@Cs33333@CL@CY@C@C@C@C@C@C@C@C@C     @Cٙ@C     @C33333@C33333@C     @C     @Cfffff@C33333@C@C@D@Cfffff@Cٙ@C33333@Cfffff@Cfffff@Cfffff@Cfffff@Cfffff@C33333@D@D@D@D@D@D333333@DL@D333333@D333333@D333333@D     @Dffffff@Dffffff@D     @D@     @D@D33333@D@D     @Ds33333@D@D     @D@D@D33333@D33333@Dٙ@D     @Dfffff@E&fffff@D33333@E@E&fffff@E@E@E@E@E333333@E@E333333@EL@EY@Effffff@E     @E     @EY@E@     @Es33333@E@E33333@E     @F      @E@E@Efffff@F      @F@F333333@Efffff@F@FY@FL@FY@F     @F@F@Fٙ@Ffffff@Ffffff@Fٙ@F@F33333@Ffffff@Ffffff@F33333@G      @G      @G      @G      @G@F33333@G@G@F33333@G333333@G@     @GY@GY@G@     @G     @Gs33333@Gffffff@G33333@G     @Gfffff@Gfffff@Gfffff@G@G@G     @G     @Gٙ@Gٙ@Gٙ@Gٙ@Gfffff@G33333@H&fffff@H@     @H      @H@H&fffff@H@     @H&fffff@HY@Hffffff@Hs33333@Hffffff@H@     @HY@H     @H33333@H@H@H33333@H@H@Hٙ@I      @I&fffff@Hfffff@Hfffff@I      @I333333@I@     @I@I&fffff@I@I@I@     @I@I      @I&fffff@I@I@IY@I@IY@IL@IL@I@     @I     @IY@Is33333@Ifffff@Is33333@I@     @I     @Ifffff@I@I     @I     @I33333@Iٙ@I     @J@J@I33333@J@J@J@J333333@J@J@J@     @J&fffff@JY@JY@J333333@JL@JY@JL@JY@Jffffff@JY@J     @J33333@J@J     @J@     @Jfffff@J     @J@Jfffff@J@J     @J33333@J@J@J     @J@J     @J33333@Jٙ@Jٙ@J     @Jٙ@K      @K@K@K@K@K      @K@K      @KL@KY@KY@KY@KY@KL@Ks33333@K@K     @K@K@Kٙ@Kٙ@Kfffff@L@L@L      @L@L&fffff@L      @Kfffff@L      @L      @LL@L333333@L333333@Lffffff@Ls33333@Lffffff@L     @Lfffff@L@LY@L@Lfffff@L@Lffffff@L     @Lٙ@L@Lfffff@L     @L@L@L     @L33333@Lٙ@L33333@Lfffff@L33333@M      @M      @M      @M      @M@M@M@M&fffff@M&fffff@Mffffff@M@     @M&fffff@M333333@M333333@MY@MY@Ms33333@MY@Mffffff@ML@M     @M     @M@Mfffff@M     @M@M33333@M33333@M33333@M@M33333@N      @N@M33333@N@N&fffff@M33333@N@N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ?Vu?䛥S?j~#?7KƧ?zG{?zG{?
=p?1&x?I^5?}?Z1'?-V?-V?+?tj?䛥S? ěT?zG{?Q?+?|hr?bM?+? ěT?I^5?}? ěT?
=p?1&x?+?Q?S?nP?QR?-V?tj~?j~"?ěS?㝲-V?tj~?Q?      ?-V?zG?KƧ?\(\?dZ1?;dZ?lC?
=p?㕁$/?㝲-V?E?Vt?n?vȴ?=p
=?E?E?p
=q?-V?`A7K??|hs?7KƧ?hr!?`A7L?QR?r ě?9XbM?1&x?|hr?vȴ?ߝ-V?x?ާ-?ffffff?p
=q?lC?l?1&?E?;dZ?
=p
?hr!?-V?+J?\(\?˅Q?
=p
?/w?\(?
=p?vȴ9X?S?XbM??+?O;dZ?+??E?$/?
=p
??|hs?E?j~#?+?tj~?E? ě?nO;?-V?lD?lD?hr Ĝ?&x?-V?&x?`A7L?&x?&x?`A7L?`A7L?&x?bM?
=p?`A7L?&x? ěT?
=p?`A7L?`A7L?`A7L?vȴ9X? ěT?
=p?bM?bM?hr Ĝ? ěT? ěT?vȴ9X?;dZ? ěT?vȴ9X?;dZ?Q?Q?Q?;dZ?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?-V?Q?Q?vȴ9X? ěT?Q? ěT?vȴ9X?5?|h?vȴ9X?Q?;dZ?vȴ9X?bM? ěT?;dZ?Q?Q?;dZ?Q?;dZ?Q?5?|h?5?|h?;dZ?;dZ? ěT?;dZ?5?|h?;dZ?;dZ?5?|h?Q?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?
=p?;dZ?Q?;dZ?bM? ěT?bM? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?Q?bM?bM? ěT? ěT?Q?;dZ?;dZ?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?
=p?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?bM?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?bM?vȴ9X? ěT? ěT? ěT?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X? ěT?;dZ?vȴ9X?bM?
=p?vȴ9X?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ? ěT?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ? ěT?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?5?|h?Q?;dZ?Q?Q?Q?5?|h?;dZ?5?|h?;dZ?;dZ?;dZ?5?|h?;dZ?Q?Q?5?|h?5?|h?Q?;dZ?Q?5?|h?Q?5?|h?Q?5?|h?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?5?|h?5?|h?Q?5?|h?5?|h?Q?;dZ?-V?;dZ?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?5?|h?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?5?|h?5?|h?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?5?|h?Q?;dZ?Q?5?|h?Q?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?Q?5?|h?Q?5?|h?Q?Q?Q?Q?5?|h?Q?;dZ?Q?Q?5?|h?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?Q?Q?Q?Q?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?-V?5?|h?5?|h?5?|h?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?Q?5?|h?Q?5?|h?-V?5?|h?-V?5?|h?-V?-V?5?|h?5?|h?Q?5?|h?5?|h?5?|h?/v?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?5?|h?Q?-V?5?|h?/v?5?|h?5?|h?-V?/v?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?-V?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?-V?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?Q?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?5?|h?-V?5?|h?-V?-V?-V?5?|h?5?|h?-V?5?|h?-V?-V?5?|h?5?|h?Q?-V?5?|h?5?|h?-V?-V?-V?-V?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?Q?5?|h?5?|h?-V?/v?/v?5?|h?5?|h?-V?5?|h?5?|h?-V?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?-V?5?|h?/v?-V?/v?-V?-V?5?|h?-V?5?|h?-V?-V?-V?5?|h?/v?Q?-V?5?|h?5?|h?/v?-V?-V?-V?-V?-V?-V?-V?-V?/v?/v?5?|h?/v?5?|h?-V?/v?/v?5?|h?/v?/v?-V?/v?5?|h?-V?/v?-V?/v?/v?-V?5?|h?/v?/v?/v?/v?-V?-V?/v?-V?/v?-V?5?|h?-V?5?|h?/v?/v?/v?1&y?-V?/v?/v?/v?/v?/v?1&y?-V?/v?/v?/v?1&y?/v?/v?/v?/v?/v?1&y?/v?-V?/v?-V?-V?/v?Q?-V?1&y?1&y?-V?-V?/v?1&y?1&y?1&y?/v?-V?/v?/v?1&y?/v?/v?/v?-V?/v?/v?/v?/v?5?|h?/v?-V?5?|h?1&y?1&y?1&y?1&y?/v?/v?/v?1&y?-V?-V?-V?1&y?1&y?/v?/v?-V?/v?1&y?5?|h?/v?1&y?5?|h?/v?/v?-V?1&y?1&y?/v?/v?/v?-V?/v?1&y?-V?1&y?-V?/v?-V?-V?/v?/v?-V?-V?/v?5?|h?/v?/v?-V?/v?-V?1&y?1&y?1&y?-V?/v?/v?/v?1&y?-V?/v?1&y?/v?-V?/v?/v?1&y?1&y?1&y?(\)?/v?-V?/v?1&y?1&y?1&y?1&y?1&y?/v?/v?1&y?1&y?/v?/v?1&y?/v?/v?-V?1&y?/v?1&y?/v?1&y?1&y?1&y?/v?/v?-V?/v?-V?1&y?1&y?/v?1&y?-V?1&y?1&y?/v?/v?1&y?1&y?1&y?/v?/v?/v?1&y?(\)?1&y?(\)?/v?/v?/v?1&y?/v?1&y?1&y?1&y?/v?1&y?/v?1&y?1&y?1&y?/v?1&y?1&y?1&y?/v?/v?1&y?1&y?1&y?1&y?/v?/v?/v?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?-V?-V?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?/v?1&y?/v?/v?/v?1&y?/v                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ?333333?ə?ə?333333?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P11                                     1                                       * BC*3o