CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P10    CAST_NUMBER       2      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:35.089983Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @U         data_max      @U         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     =  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @W33333   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      =  o   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      H     temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?C%   data_max      @($x   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       =  \   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      H  t   salinity                	long_name         salinity   units         PSS-78     data_min      @@A^   data_max      @AL3   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      =    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      H E   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @%         data_max      @r<   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        = U   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      H 4   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?(\)   data_max      ?o   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      = |   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      H ޔ   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      @   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       =    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      H *   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     = :<   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      H wT   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      *   data_max      *   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @HrnO   data_max      @HrnO   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `5Y_a   data_max      `5Y_a   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @U      @      @333333@      @      @      @ 333333@"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H@I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @Pfffff@Q      @Q@     @Q     @Q     @R      @RFfffff@R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @Ufffff@U@V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\fffff@]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @bp     @b     @b     @b     @c      @c      @c@     @c`     @cvfffff@c@c     @c     @d      @d      @d6fffff@d`     @d     @d     @d     @d     @e      @e#33333@e0     @ec33333@e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g33333@g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h@i      @i      @i@     @i`     @i     @ifffff@ifffff@i     @j      @j      @j@     @j`     @j@j     @j     @j     @k      @k      @k@     @kffffff@k     @k     @k     @k     @l      @l      @l@     @l`     @l|@l@l@l     @m      @m      @m@     @m`     @m     @m     @m33333@m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o@o33333@p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p@p33333@pfffff@p     @p     @p     @p     @q      @q     @q      @q.fffff@q@     @qP     @q`     @qp     @q     @q@q     @q     @q     @q     @q     @r      @r     @r      @r+33333@rA@rP     @r`     @rp     @r     @r     @r     @rfffff@r@rfffff@r     @r     @s      @s     @s!@s0     @sC33333@sP     @s\@sq@s     @s     @s     @s     @s     @sə@s     @t      @t     @t      @t0     @t@     @tP     @t[33333@tt@t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u@u4@u@     @uP     @ua@up     @u     @u     @u     @u     @u     @u     @u     @u     @ufffff@vfffff@v#33333@v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v@vᙙ@v     @w      @w     @w      @w,@wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @wfffff@w     @x      @x     @x      @x0     @x@     @xH     @xd@xp     @x     @x     @x     @x     @x     @x     @x     @xfffff@y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y@y33333@y     @y     @y     @y     @y     @yfffff@z     @z      @z0     @z@     @zP     @z`     @zp     @zy@z@z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{@{     @{     @{     @{     @{     @{     @{fffff@|#33333@|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|fffff@|fffff@}     @}      @}0     @}<@}Q@}`     @}p     @}     @}     @}     @}     @}     @}@}     @}     @~      @~     @~      @~+33333@~Ffffff@~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @@     @      @0     @@     @P     @^fffff@@     @     @     @     @     @     @񙙙@
fffff@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @      @     @@     @      @(     @0     @8     @@     @H@P     @X     @`     @h     @p     @x     @33333@fffff@     @     @     @     @     @     @     @33333@     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @>fffff@H     @P     @X     @`     @h     @p     @w33333@33333@     @     @     @     @     @     @     @     @     @     @     @fffff@33333@     @     @      @     @@33333@      @(     @0     @8     @@     @H     @L@X     @`     @h     @p     @x     @     @     @@     @     @     @     @     @     @     @     @     @     @@33333@     @      @     @     @     @@)@0     @8     @@     @H     @P     @X     @`     @i@p     @x     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @33333@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @@     @fffff@     @     @     @     @     @     @33333@33333@     @     @     @      @     @     @     @      @'33333@1@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @O33333@X@`     @h     @p     @x     @     @     @     @33333@@     @     @@     @     @     @     @     @     @     @      @fffff@2fffff@8     @@     @H     @P     @X     @^fffff@rfffff@x     @     @     @     @     @     @     @     @fffff@     @33333@@     @     @     @     @      @     @33333@fffff@      @(     @0     @8     @@     @H@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @@љ@     @     @     @     @     @@     @     @     @      @(     @0     @8@@     @H     @P     @X     @`     @h     @p     @x     @     @     @@     @     @     @     @     @     @     @͙@@     @     @     @     @      @     @@     @      @(     @0     @5@?33333@H     @P     @X     @\@jfffff@p@x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @	@     @     @      @(     @0     @8     @@     @H     @P     @X     @a@h     @p     @x     @     @     @     @@33333@     @     @     @     @     @     @ՙ@33333@     @     @      @@     @      @(     @0     @8     @@     @D@Q@X     @`     @h     @p     @vfffff@@     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @      @     @     @     @      @(     @/33333@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @33333@     @     @     @     @     @@     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @T@h     @p     @x     @     @     @     @     @     @     @     @@fffff@     @     @     @     @     @@@     @     @     @     @     @fffff@      @$     @(     @,     @0     @4     @<fffff@@     @B@H@L     @P     @T     @X     @\     @`     @b@i@l     @p     @t     @w@     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @י@33333@     @     @     @     @     @󙙙@     @     @      @     @     @@     @     @     @      @$     @(     @,     @0     @4     @733333@;@@     @D     @H     @L     @P     @T     @Vfffff@\@`     @d     @h     @l     @q@t     @x     @|     @33333@     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @33333@33333@     @     @     @      @     @     @     @33333@@     @     @      @$     @(     @+33333@0fffff@4     @8     @<     @@     @D     @G@L@P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @}33333@     @@@     @     @     @     @     @     @33333@33333@     @fffff@@     @     @     @     @     @fffff@     @33333@@     @     @     @     @     @@     @     @33333@ fffff@     @     @     @     @     @fffff@     @      @$     @(     @+33333@/@4     @8     @<     @@     @D     @H     @L     @Nfffff@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @zfffff@33333@     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @ۙ@ᙙ@     @     @     @     @     @@     @      @     @     @     @     @     @     @@ @$     @(     @,     @0     @4     @8     @:fffff@Dfffff@H     @L     @P     @T     @X     @\     @`     @e@h     @l     @p     @t     @x     @|     @fffff@@     @     @     @     @     @     @     @@     @     @     @     @     @@     @     @     @     @@@     @     @     @     @33333@     @     @     @     @     @      @@@     @     @     @     @     @33333@$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @g33333@lfffff@p     @t     @x     @|     @     @     @     @@33333@     @     @     @     @33333@fffff@     @     @     @fffff@@     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @@33333@     @     @     @     @     @@$     @(     @+33333@0fffff@4     @8     @<     @@     @D     @H     @L     @Q@T     @X     @\     @`     @b     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @ә@     @     @     @     @     @     @     @33333@     @     @      @     @     @@     @     @     @      @$     @&@0@4     @8     @<     @@     @D     @H     @L     @P     @T     @V     @]33333@`     @d     @h     @l     @p     @s33333@|@     @     @     @     @     @@     @     @     @     @     @33333@33333@     @     @     @     @     @@     @     @     @     @     @     @@     @     @      @     @     @fffff@     @     @      @$     @(     @,     @0     @4     @8     @<     @?@D     @H     @L     @P     @T     @X     @\     @`@c33333@hfffff@l     @o@t@x     @|     @     @     @     @     @     @     @@@     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @      @@fffff@     @     @     @fffff@@      @$     @(     @,     @0     @4     @8     @<     @E@H     @L     @P     @T     @X     @\     @`     @b     @h@l     @p     @t     @x     @|     @     @     @fffff@fffff@     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @@˙@     @     @     @     @     @33333@33333@     @     @33333@     @     @      @     @     @     @     @33333@     @      @$     @(     @,     @/33333@933333@<     @@     @D     @H     @L     @Q@T     @W33333@\     @`     @d     @h     @lfffff@p@t     @x     @|     @     @     @     @fffff@fffff@     @fffff@     @     @     @     @     @     @33333@@     @     @     @     @     @33333@@     @     @     @@     @     @      @     @33333@fffff@     @     @     @      @$@(     @,     @0     @4     @8     @<     @@     @D     @Ffffff@L     @P     @T     @X     @\     @`     @d     @h     @lfffff@p     @t     @xfffff@{@     @     @     @     @     @@     @     @     @     @@@     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @      @     @@@     @     @     @     @      @$     @(     @,     @0     @4     @8     @<fffff@@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @z@@     @     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @     @     @י@@@     @     @@     @     @     @      @@     @     @     @     @     @     @      @$     @&@,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @jfffff@p     @t     @x     @|     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @33333@     @     @     @     @     @@      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @:@@fffff@D     @H     @L     @P     @Tfffff@W33333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @4֡b@Q@rGE8@@~$@vȴ9X@ߤ?@\N<@BZc @E@b@E@b@
(@@v@5Xy@5Xy@5Xy@?@쿱[@j~#@J#9@D@'0@!.@"h	ԕ@S@@҈@$t@m8@"h	ԕ@Xy=@Ov_خ@@As@eO@~\N<@kC]@dxF@aGz@`҈p@_?@^҈p;@^@]-V@^ ѷY@^@^u@ZY@V@V+J@V@Vl!-@VOv_@VOv_@TɅoi@U*0@T,<@S@N@S*0U2@S@N@PH@Np:~@NVu@M@Kq@KxF]@KxF]@L@O'/W@P`A7@R:)y@S*0U2@\>@_o@ ě@'@ߤ@@Zu%F@+@0U2a|@j~@($x@!.H@!.I@oiDg8@%1@@XPH@O\(@3E@y=c@'RT@e+@eO@A@ᰊ@&x@ hۋ@0U2a|@7@|hs@Rp:@;J#9@(@?@Z@	ԕ*@hr@2a|@;dZ@ ѷ@8YK@C-@U2a|@zG@lC@W>6z@bM@Ov_@\(@M:@#@z)y@sMjO@hTɅ@TFs@3ߤ@?@YJ@p
=@Y}@+jg@jf@ae@Fs@:S@eں@:)y@z)_@l>B[@Sݗ+k@S&@B@2ᰊ@+a@@!@N@p:@˒:*@SMj@쿱[W@ᰉ'@vȴ9@@]cA@7KƧ@@4n@zS&@vFs@n2X@Sݗ+k@<n.@0 ě@@5?|@7Kƨ@m]@w1@N;6@74@)y@C,z@Ϫ͞@74@aR<6@X_F@GE84@+C]@@@C]@h	ԕ@!-w1@Q@fA@-
q@K]d@Xy=@*0U2a@/w@ᰉ@fA@qi@^Q@N+@G@@8F]d@0D@)@Q@n.@zG@e@$tT@%2@XbM@Xy=@A [@H@;dZ@@N@$tT@~($x@zG{@z)y@kQ@g-@bM@dxF@^쿱[W@[q@UL_@NVu@A7Kƨ@1-@+I^@%`A7L@%u@cA @2a|@
D@ C@_ح@t@U=@A [@ߊ	@쿱[W@ݲ-V@sPH@ө*0U2@䎊@sP@̲@S&@x@-V@vFs@MO;dZ@F&I@A:S@84֡b@873@4m8@2-V@#Z@L_@74@@@4n@!.H@}Vl@xF@D*@֡af@n@5Xy>@š@\N@a|Q@Q@@ ѷ@ ѷ@TɅo@w+@m\@cA [@[u%@RT`d@Iԕ*@Fs@D2W@?|hs@6!.I@3ߤ@)rGE@%1@[@䎊@vȴ9X@^@*0@@sPH@
=p@@Ƨ@&I@74@ߤ@-V@c	@
qv@I^@	@6C@O;dZ@oiD@)^@kI^@_?@^%@^u@]cA @],=@]cA @\wkP@X*0@J#9@;/V@9XbM@6C-@0:~ @,q@+a@@+~($@*JL@'	k@ 'RT`@
#9@/V@Q@4m@Y|@1.@҉@Mj@]cf@@
(@I^@ۋq
@RT`e@
qu@_o @y~($@iᰉ'@cZ@cZ@dxF@d?@`[6@[qu!@RsP@I@CnP@<?@9(@8}H@7kP@6}Vl@5Xy=@333333@2W@.t@=K^@fA@@Z@@U@bM@O
M@n@bM@
:@S&@5Xy@#w@{m@v@g	@҈p@bM@$tT@s@ƍ@8YK@u%F
@J#9@!.@@O
M@1&y@n.3@;dZ@5?|@1&@N;@ᰉ@@N@rGE9@-
q@bM@R@_p@N;6@n@O;dZ@zH@|64@u!R@nc	@lC@f1.@dqj@c
=p@ae@`-
@^쿱[W@[6@VϪ͟@Mqu"@C@>\N<@;~$@8YJ@4J@3g	l@2 ě@'RT`e@ݘ@N;6@
@M:@:S@쿱[@t@/@޸Q@2a|@䎊@jOv@ǮzH@@TɅo@żn/@K]@ߤ@33333@GE85@U2a|@-V@Xy=@Z@Q@33333@j~@'0@֡a@4֡a@U=@>BZc@ᰉ'@>@L_@|PH@or@ix@g/V@cn.3@\>@q[W>6@{s@or@o-V@Nqi@A@<n.@FYJ@En/@=H˒@8l"h	@7Xe@2GE85@&@Ϫ͟@*0U2@R@X@;5X@˒:*@F]c@@oiDg@?@?@)^@-@?@8YK@u%F
@ȴ9X@A [@	k@
=p@
qu@/w@Ʌoi@o @ڹY@@7KƧ@p:@K]c@ƍ@\N@,zxl@\(@rGE8@33333@U2a|@C\@B@͞&@@lC@L/{J@7@o@O;d@@@o @)^	@˒:*@84֡@JM@o hی@|n.@yD@v!.I@u?|h@nO;@fIQ@`-
@[q@V@U*0@O\(@JڹY@H@F]cf@EQ@@C@=Vl!@<j~#@:)_@9=b@7KƧ@5Y|@3ߤ@/iDg8@)Dg8~@%zxl"h@#eO@ A7K@ce@wkP@>BZ@䎊@tj@^5?|@#@o@w1@ᰉ'@M@߾vȴ9@}H@ܬ1&@wkP@?@ce@ݗ+j@}H@ק&@zG@ҽ<64@R@а{@Ίqi@ʦL/{@JM@a@N@@Țu%F@4m9@E@U2a|@TɅ@Gz@ ѷY@u"@L_@@L_@@#9@W'@#@Q@|PH@yD@yXbM@w3@u%F
L@p
(@o{J#:@l[W?@jg	@i@hr Ĝ@fx@dqj@`҈p@\]ce@WsPH@U$/@S@J=p
@<n.@9~($@8-
@3ߤ@*JL@#	@!'R@҈p;@,=@Q@ݘ@u%@u%@E@4J@L_@@@eO@˒:*@
qiC@
W'@C%@	ԕ*@	@˒:*@&I@%2@	k~@hr!@҈p;@>6z@т@;dZ@ɺ^5?}@@@[W>@rG@zxl"@\)@F
L0@n.3@.H@-w1@ěT@,=@@sP@ߤ?@@0
)@e+a@O;d@)^@hۋq@poiDg8@eO
@Y|@\(\@]+j@Y>BZ@T,<@O;dZ@JL_@C,zxl@:)y@/O
M@(@qu!@@:S@_ح@A [@t@VϪ@JL@@lC@1.@@N@ce@"`B@>BZ@>6z@5Xy>@'0@_o@!R<@_F@xF@wkQ@`A@/@L/{J@zxl"h@-w1@+j@S&@$tT@rGE9@n@!R<@Q@p
=q@g@XbM@Vl!-@N_o @2W@	@}H@	@=K^@0
)@+j@Xe,@1&@vȴ9@@@Mj@#@
_ح@
74@
&@
$tS@
1&@
=K^@
,=@
q@
2W@
)^@
|@
ٳ|@
څݘ@
n@
3@
<쿱@
1@
[@
ݗ@
~m\@
+J@
@@
u%@
=p
@
|Q@
u!R@
kC]@
g@
cZ@
c	@
be+@
_;dZ@
WsPH@
P|@
M:@
F-@
>6z@
*d7@
vȴ@
$/@
*0U2@
S&@
o @
@g@8Y@lC@ޞ@sPH@͞%@o i@D@)@C-@n.@7Kƨ@_p@l!-@fA@&@`A7@D@/V@a@@,=@Q@u%@O;d@7KƧ@%2@-
q@-w1@@1&y@U=@RT`e@
=p@S@Z@!R<@JM@?@qi@@-V@Q@_o@Ov_@u@4J@1&x@xF]d@poiDg8@n.2@m8Y@g@^5?|@Xy=c@e`A7L@dqj@[6@WsPH@O
M;@6}Vl@1-@1&x@.1@,>B[@)lD@+U=@,zxl"@(\)@ 	k@u%@n@o h@o hی@$/@lC@%F
L@l@u!S@	k@e@u!@iB@5?|@ce@D*@+@74@Xe@}Vl@1&y@$xG@R<6@wkP@sP@bM@rGE9@)^@qu!@sP@o h@tj@}E@xF@tj~@sMjO@n.2@k~($@kC]@hۋq
@de@^5?|@Xe+@Rm@Q@O
M;@L/{J#@JW'@F
L/@1o@tj@K]d@
\N<@
J#9@
Y|@
A [@
:~ @
@
:~ @
%F
L@@$/@'RT`e@%F
L0@'&@%1@u@R<6@:)y@-
q@
qu"@
ڹY@	 ѷ@K]d@+I@@@{J#9@
H˒@
+@
䎊q@
C\@
ᰉ'@
fffff@
e+@
ߤ?@
c	@
t@
ѷX@
;dZ@

M;@
5Xy>@
@
;5X@
_o @
Zc@
2X@
>B[@
x@
o@
!-w1@
e+a@
+j@
@
qiC@
F]c@
weں@
vȴ9X@
u%F
L@
r䎊q@
poiDg8@
g8}H@
cZ@
J#9@
Ca@N@
1-@
)*0U2a@
#
=p@
O
M@
)^@
Mj@
#@
YJ@
oiDg@
#@
&I@
&I@	\(@	Ov`@	!-w@	oiDg8@	!R@	 ě@	_ح@	!-w2@	-V@	Dg8~@	唯O
@	͞%@	@	XbM@	m8@	o@	{J#:@	U=@	u%F@	O
M@	҈@	u%F
@	~m\@	y	k~@	u!.@	k~($@	VϪ͟@	B@	u"@	)^@		'RTa@	p:@		 ѷ@	{J#9@	nP@	nP@	:S@	      @	$/@	 IQ@	:S@	 ѷX@	$/@	o hی@	$/@.H@.H@	{J#9@	I^5@	 4m9@˒:)@_ح@ٳ|@
L/@m\@x@@zxl"h@@1@tSM@n.3@n.3@`A@u%@ߤ?@@$tS@y=b@q@["`B@P*0U@GzH@Em\@E@Em\@Em\@Eo i@E@Em\@E84֡@BZc@>
(@5?@,q@+U=@,zxl"@&'@$tS@
@҈@
ڹY@eO@nP@j~@t@C@@䎊qj@e+@ۋq@Ϫ͟@ѷX@:@Q@y@ěS@,zxl@n@64@Vϫ@ěT@qu!@+J@tj~@4J@L/{@n/@o hی@b}V@{J#9@qu!S@o4֡a@l"h	ԕ@jfB@iᰉ'@f,<@cS@_o@Yb}@Rm@O͞@M5Xy>@GzH@E8YK@Ca@N@B&IR@A7Kƨ@>6z@=v@8}H@43@6z@:S&@;/V@:S&@9D@9~($@9D@8}H@6z@0{@*d7@"3@$tS@$/@o @1@\@	k@r Ĝ@ᰉ'@Dg8~@fA@lC@ۋq
@x@>BZc@Gz@d8@@:@y@
L/@E84@]cf@m\@g8}@Õ$@n@
(@D@ěT@Q@6C@sh@zG@@=p
@eO@ݗ+@S&@{s@y	k~@v_ح@t#@r ě@r{m@u\(@{m]@     @$/@:S@o hی@I^5@ѷX@v_ح@nt@m8Y@m8Y@mhr!@k~($@gfA@g@b}Vm@[q@XD*@QN;5@Ks@Ca@N@?@<j~#@2ᰊ@,q@'RT`e@!R<6@Ov_خ@$/@1&x@#@
=p
@oiDg@ݗ@&I@Fs@Fs@+I@&I@oiDg@oiDg@%2@ hۋq@F@O;@~"@ڹ@C,@҈p@c	@>BZ@+@+@حU@e+@ק&@_o @s@5Xy>@As@jOv@8YK@p
=@)y@)@3@z@?|h@J@0U2a|@@L/{J@IQ@n.3@h	ԕ@'RT`@}H@u"@+j@Fs@hr @u@\(@{J#9@~$t@v_ح@uY|@u%F
L@u!.@tSMj@lC@hr Ĝ@dZ1@`҈p@_Ft@_Ft@_;dZ@_;dZ@b@4@]/w@Q@C,zxl@@6@49XbN@/Vϫ@.2X@($xG@#wk@!.H@"wkQ@U=@_o@O
M@-
q@
M:@	ԕ*@eO@eO@'/@
=p
@Q@{J#9@b}V@Vl!@=b@E@1.@@,<@@lC@@fffff@d8@]ce@Ϫ͟@8YJ@Ϫ͞@,<@҈p:@+@n@š@C@n@|hs@@H˒:@ߤ?@vȴ9X@v@j~#@^5?|@XbM@)@YJ@S&@E@֡a@
(@
qv@B@TɅ@9@S&@n.3@wkQ@F
L0@3@@L_@@qiC@&I@n.@     @|?@sPH@qu!S@p:~ @n.2@m8Y@jfB@ffffff@a'R@Zݘ@UϪ͞@Vaf@W>6z@W>6z@W
=p@Rp:@N_o @Jn@Dg8}@>6z@4֡a@(Xy=@#9@"h	ԕ@"3@!ae@"3@ -
@IQ@)^@o h@@.H@ڹZ@m\@˒:)@m\@!.H@xl"h
@rGE8@Fs@SMj@PH@s@GE85@s@ۋq
@@N@	@1.@`A7L@c	@̘_@6z@5Xy@ߤ@|@?|h@4K@Q@}H@4m@KƧ@sg@Vϫ@&@S@wkQ@rGE9@r ě@e@_?@_o@S&@O͞@K]cA@F]cf@B&IR@8Q@2ᰊ@.}Vl@)lD@&x@%S@$TɆ@#wk@ -
@ߤ@@0
)@Ov_@sh@҉@!R<@u%F@@$tS@\N<@($x@xl"h
@ȴ9X@%F
L@s@쿱[W?@ᰉ'@ⶮ}Vm@iB@&@:@@@@2W@v@^5?|@#w@Q@rG@}H@rG@Q@rG@}H@)@}H@g	l@
qv@&@tSM@`A@.H@-w1@IQ@ߤ@@+J@Fs@҉@nO@hr @)^@@@rGE9@$tT@4J@ߤ?@L/{@#@_o@&I@Q@}H˒@}H˒@mhr!@e+a@_?@[q@Y+@S@LcA \@H@F?@D*0@>vȴ9X@;/V@9D@7Xe@6}Vl@6C-@4֡a@-U=@-B@,zxl"@,q@+U=@+jf@+6z@*͞&@*0U2a|@'&@&L/{J@ -
@@sP@q@	k~(@ݗ+@$/@      @ hۋq@\N<@($x@$t@.H@ڹZ@Vl!@hr@ڹZ@!.H@~$@@73@ ě@u!S@iDg8@1.@Ft@?@ۋq@"`B@Ϫ͟@l!-@Ʌoi@|@_p@/{J#@˒:)z@˒:)z@]cA@Ƨ@Ƨ@]cA@˒:*@E84@
L/@\N@|hs@m8@U2a|@͞&@y@y@y@$xG@xF@vȴ9@tj@$/@L/{@ ѷ@eO@&I@n/@JM@o h@%2@nP@@4n@$/@˒:)@b}V@|hr@x73@s@o-V@mC\@m8Y@l!-w@l!-w@jg	@f,<@c	@ae@a@N@`A7K@^5?|@]cA @^5?|@]cA @\>@Xe+@R<64@P{@Ov_ح@JD@IoiD@G)^@E@E84֡@D*0@E84֡@E@DS@=<64@6}Vl@5Xy=@5?@4J@1[W>6@/r@-V@+a@@+6z@($xG@"3@Q@O;d@@4J@-
q@Vu@҈@+I@ ѷ@ xl"h
@ F]d@ _ح@ _ح@ {m@ l@ O;@ fB@ JL@ B@ @ A@ 唯O
@ +a@ %1@ Z@ %1@ %1@ S@ ᰉ'R@ 
qu@ ;dZ@ ҈p;@ >@ ]ce@ +@ sPH@ Ʌoi@ N;5@ |@ v_ح@ jOv@ ɅoiD@ ˒:*@ ǮzH@ o i@ @ 6@ XbM@ a|Q@ lD@ ?@ 'RT`@ Q@ =K^@ S@ S@ _o@ O;d@ O
M@ ݗ+k@ zG@ O
M@ tj~@ sP@ $tT@ )^@ rGE9@ @ O;dZ@ 'RTa@ o h@ nP@ @ @4n@ n.@ ~"@ x-
@ weں@ wkP@ weں@ u\(@ u!.@ vFs@ uY|@ r䎊q@ p:~ @ j~"@ irGE@ c	@ ^iB@ Z1'@ UfA@ P`A7@ O͞@ OAs@ Jn@ H9Xb@ ?@ 8Q@ 5?|h@ 2-V@ 2-V@ 2W@ 2m\@ 3g	l@ 0U2a|@ -U=@ ,<쿱@ '/V@ $xF@ !R<6@ 	@ u@ Q@ 6C@ u%F@ 6C@ e+a@ +j@ O;d@ _F@ @@ @ @ *0@ Ov_@ Fs@ S&@ Mj@ qi@ ߤ?@ Vu@ 
M:@ 
@ 
L/{@ 	ԕ*@ K]d@ Q@ ?@ tj@ u%F
?.H?+jg?VϪ?/w?fA?fA?8YJ?*0U?ɅoiD?Ƨ-?2W??a@N?a@N?74?\(?6?n??\(?\(?C?ěS?ɅoiD??8YK?Q?1?TɆ?ae?ae?vȴ9?u"?=K^?@?҉?hr ?Mj?Q?}Vl!?m8Y?e+a?a@N?\>?Xe+?Xy=c?JL_?A [7?9XbM?+a@?'RT`e?!R<6?䎊r?}H?C,zx?C,zx?Xe,??*0U2?n?'/W?
M:??҈?xF]?xF]?
=p
?	ԕ*?	k~(?Fs?S&?JM?JM?S&?S&?JM???F]c?lC?rGE8?+?!.I?#?-V?C\?쿱[W??JL?ᰉ'??fA?fA?1.?e+?;dZ?b}?fA?,<?n?&IR?[W>?v?Q?rG?~($?^5?|?)_?^5?|?)?E?sg?3?g	l?ᰊ?|?m\?zG?q?1&y?6z?6z?6z?6z?lD?TɅ?Xy=?-?zxl"h?	k?쿱[W?=K^?ᰉ?$/?$/?$/?O
M?Fs?N;6?o ??qi??O;dZ?q?C%?L_?L_?~($x?C%?O;dZ?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @@A^@@Aae@@Aae@@Aae@@Ae+a@@Ak~(@@Ao hی@@Ak~(@@Ao hی@@Ao hی@@ArGE8@@ArGE8@@Ao hی@@Au!S@@Ax@@Ax@@Au!S@@Au!S@@Au!S@@Au!S@@Ax@@Ax@@AoiD@@AiB@@A"`@@A"`@@BOv`@@BJL@@B)_@@C,zxl@@C~$@@Ca@O@@D1&y@@Dtj@@D/{J#@@DPH@@DwkP@@DS@@DO
M@@DC@@DwkP@@DzG@@DzG@@D~($x@@Do h@@DN;@@DS@@D[W?@@D@@D֡a@@D>B[@@DZ@@Du"@@D@@D@@DJM@@DJM@@D@@DJM@@DZ@@D>B[@@D>B[@@D֡a@@D@@D7@@D[W?@@D[W?@@DɅoi@@D>B[@@EV@@EM:@@Eڹ@@F,<@@Fx@@G1@@I&x@@P)@@WfA@@a(@@m!.H@@y+@@^5?}@@y@@=K@@|hs@@o h@@c	@@vȴ9X@@N;6@@+J@@`d@@$xG@@T`d@@˘A@@tj@@͊ڹZ@@,@@Ϫ͞@@@@rG@@-@@4m9@@Ж@@a@N@@}Vl@@bM@@R@@C,z@@xF@@ܯO
M@@L_@@C-@@v@@߀4m@@@@
=q@@ۋq
@@rGE@@b}@@L_@@ڹY@@~@@㋬q@@\N@@`d@@+a@@m\@@!.@@椨T@@䎊r@@tj@@N;5@@o@@馵(@@o@@&IR@@p:@@҉@@믷@@뢜wk@@m8@@'0@@L_@@?@@C\@@$/@@\N<@@%@@'@@ hۋ@@>6z@@y@@阮&@@eO@@eO@@tj@@@@'RT@@4m@@TɅ@@ۋq
@@\)@@0
)@@JE@@=b@@^@@u!S@@@@ԕ*@@e@@3@@=p
@@xl"h
@@c	@@,zxl@@W>6z@@@@q@@q@@ߤ@@_@@qu"@@>@@o i@@>@@!-w@@!-w@@V@@*0@@!.H@@'0@@<64@@Vl!@@ce@@fA@@=K@@E@@t@@ᰉ@@@@8Y@@b@@\(@@@@\(@@@@U=@@H˒@@v@@O
@@ڹZ@@%@@U=@@8Y@@4K@@Ov_@@Ov_@@E@@\N<@@p:~@@s@@}Vl@@%@@@@҈p;@@Fs@@$tS@@Xe@@v@@,@@+I@@As@@;dZ@@+I@@.H@@H˒:@@RT`e@@{J#:@@͞@@zH@@/V@@;dZ@@6@@73@@y=c@@'RT@@[6@@$xG@@rGE9@@+j@@*0U@@;dZ@@$xG@@:~ @@U2a|@@l"h	@@@@{@@)@@C@@4֡b@@&x@@#w@@*0U2a@@[W>6@@x@@oiD@@@@@@R<6@@(@@2W@@B@@X@@.H@@n@@C\@@kP|@@vȴ@@,<@@D@@nP@@9@@]cA@@tj~@@E@@5Xy@@Q@@tj@@Q@@%1@@?@@VϪ@@]ce@@%1@@"h	ԕ@@"h	ԕ@@%1@@,<@@(\@@64@@j~#@@쿱[@@/@@!.H@@%F
L@@2a|@@84֡@@/w@@'0@@>@@o i@@zxl"h@@@@@@@@@@sh@@n/@@,=@@;5X@@BZc @@H@@Ov_خ@@iB@@$t@@}Vl@@'@@ߤ?@@m\@@Ϫ͟@@@@E84@@RT`e@@O
M@@RT`e@@eں@@&@@fA@@䎊r@A bM@A }H@A D*@A Q@A oiDg8@A |@A 
=q@A 4֡b@A-w1@A [7@A@A'RTa@AD@A_o@A>BZ@AlD@AJL@A{m@A@A<64@A@A͞&@A`A@A,<@AڹY@A ѷ@AG{@AI^@A33333@A/V@A,zxl@A)^	@AJ#9@AMjO@Ag	l@AA@Aq@Am]@AZ@A5Xy@An.@AxF@A!-w2@A,<@A?@AwkP@Azxl"@A?@A֡a@Ae@AE@Ao i@AQ@A84֡@A?|h@AB@AB@AIQ@Ace@A!R@Av@A-V@AoiDg@A ѷY@AzG@A!R<@A($x@A!R<@A.2@A8YJ@AOv_خ@A\N<@Avȴ9X@A}Vl@Aȴ9X@A]cf@A"@A
M;@A@A@A,@A,@A.H@A;dZ@AE84@Ab}V@A&@AkP@A&@A[W>@A/V@A/V@AK]d@A;dZ@A     @AbM@A}H@A4m9@A-
q@A:~ @A@Ad8@A
(@Ae+@A4֡b@A	 ѷ@A	rGE@A	&x@A	u!S@A	@A
Q_@A
g	@AS&@A)^	@A9@Aa@N@Aqu!@Ag	l@AA@A
=p@AxF@AQ@A"h	ԕ@AFs@AwkP@A쿱[@Au"@A
%F
L@A
K]@A*0@AD@AD@A֡a@A>B[@A
%F
L@A

qv@A1.@A5?|@Avȴ9X@A;5X@A4K@A8YJ@Aߤ?@A hۋ@A1@AϪ͟@A
=p@AC-@Aߤ?@AϪ͟@AMj@Av@Ab}V@A[W>@A@A     @A1&x@ANU@Al"h	@AIQ@A
(@A@A@A@AC@A@A@A:S@Ao hی@Al@A@AOv`@A#9@A6C@AC\@AGE85@AT`d@Ad7@AnO@Aݘ@Aᰊ@A ě@APH@AP{@AS@AS@AZ@A]cA@AdZ@Ajf@A{J#9@A@A*0U2@AJ@AQ@AQ@AC,zx@A`d@Aj~#@A~($x@A?@A3@ATɆ@A@A7@A@AD@AQ@AS&@A@A(@A_o @AL/{J@AiB@A%@A@A,<@A&I@AϪ͟@A]cf@AϪ͟@A+@A]cf@AMj@Av@A$tS@A>6z@AXe,@AiDg8@AO;d@A	k@A&@Ao @AVϫ@A*0@A[6@Ay=c@AYJ@A@AU@AD@AF@A`A7@A{@A\)@A$tT@A@A#w@AJE@A@A@A@A@A@A'RTa@AR<6@A(@A^5?}@A"`@A'R@A@Axl"h
@Ap:@Ap:@Avȴ@AY@A`A@A~@A"`B@AC%@Ajf@AQ@A$@Aq@A~($@Aݗ+k@AC]@AC]@Aߤ@@A/{J#@A<쿱@A]ce@Am8@A?@A#@A*1@Azxl"@A[W?@AD@Aqu"@A<64@AO;dZ@Asg@A+j@AϪ͞@Aᰉ@At@Au@A1.@A.2@A5?|@A?@A5?|@A.2@A($x@A($x@A.2@A.2@A.2@A+jg@AL/{J@A\N<@Az@A}Vl@AQ@A1@A hۋ@A hۋ@AFt@A
M;@A!-w1@A.H@Ab}V@Aݗ+@A?@A͞@Ao @A#@A *0@A Xy=@A bM@A u!@A n@A tj@A -
@A IQ@A -
@A d8@A d8@A 
=q@A U@A 
(@A )^@A `A7@A!@A!@A!@A!#w@A!A [@A!ae@A!ae@A!rGE8@A!@A!oiD@A!@A!'RTa@A!|@A!iB@A!Y}@A"0U2a|@A"nO@A"@4@A"S&@A"wkQ@A" ě@A"͞&@A"C,@A"74@A"74@A#S&@A#u%@A#'/@A#s@A#C,z@A#C,z@A#C,z@A#C,z@A#)^	@A#/V@A#6z@A#@N@A#J#9@A#@A#Ƨ@A#@A$L_@A$/{J#@A$<쿱@A$Fs@A$`d@A$o h@A$#@A$#@A$C@A$#@A$_@A$O
M@A$*0@A$JM@A$u"@A$D@A$!-w@A%u@A%!.H@A%/w@A%84֡@A%F
L0@A%O;dZ@A%fA@A%M:@A%-V@A%Ϫ͞@A%E@A&t@A&
(@A&
L/@A%oiDg@A%S@A%b@A&_o @A&Ov_@A&$/@A&_ح@A&Mj@A'Xe@A'>6z@A'eں@A'sPH@A'{J#:@A'ݗ+@A'?@A'zH@A'zH@A'&@A'{J#:@A'K]d@A'@@A'rGE9@A'+j@A(@A(F]d@A(@A(*0U@A(*0U@A(@A(6@A(}H@A(-
q@A(D*@A(Xy=@A(|@A(-
@A(n@A(-
@A(-
@A(-
@A(@A(U@A(TɅ@A(ěT@A(F@A(p:@A(ѷX@A(p:@A(@@A(4֡b@A(	k@A(PH@A)@A)-w1@A)Dg8~@A)(@A)y@A)ᰉ'@A)@A)lD@A*n@A*n@A*s@A*3@A*GE85@A*qiC@A*~"@A*ݘ@A*\(@A*G{@A+9@A+xF]@A+:)z@A+U=@A+*0U2@A+q@A+wk@A+$@A+:)z@A+q@A+U=@A+a@O@A+҈@A+\N@A,Q@A,2W@A,Fs@A,M:@A,?@A,_@A,_@A,C@A,*1@A,N;@A,N;@A,N;@A,zxl"@A,E@A-84֡@A-`A7L@A-ce@A-$/@A-ݗ@A-ڹZ@A-hr!@A-ڹZ@A-hr!@A-=K@A-%@A-@A-v@A-U=@A-1@A--V@A-Xy=@A-sh@A-n/@A-8Y@A-cA @A-Ϫ͞@A-Ϫ͞@A-,=@A-(@A-(@A-ᰉ@A-(@A-(@A-E@A. ѷY@A.4K@A.!R<@A.;5X@A.1.@A.8YJ@A.H@A.Vu@A.vȴ9X@A.IQ@A.IQ@A.@A.p:~@A.+J@A.af@A.-@A.@A.,<@A.@A.-@A.+@A.C-@A.!.I@A/,@A/'/W@A/>6z@A/H˒:@A/v_ح@A/	k@A/͞@A/zH@A/3@A/[W>@A/?@A/ݗ+@A/-V@A/&@A/͞@A06@A0'RT`@A073@A0:~ @A0D*@A0eO@A04֡b@A1@A1TɅo@A1~($@A1l@A1^5?}@A1ԕ*@A1e@A1>BZ@A1R@A1@A1s@A1-@A1Y}@A1lD@A1lD@A1-@A1-@A2	 @A2Ov`@A2e+@A2&IR@A2-V@A2=p
@A2JL@A2=p
@A2JL@A2Q_@A2a|Q@A2kP|@A2xl"h
@A2{m@A2ݘ@A2p:@A2ᰊ@A2S&@A2@A2n@A2)_@A2c	@A2fB@A2D@A274@A2m\@A3u%@A3҉@A3҉@A3nP@A3/V@A3=K^@A3C%@A3/V@A333333@A3s@A3PH@A3"`B@A3,zxl@A3/V@A3=K^@A3C%@A3J#9@A3P{@A3Z@A3~$@A3U=@A3q@A35Xy@A35Xy@A3҈@A41&y@A4/{J#@A4`d@A4q@A4*1@A4S@A4*1@A43@A4?@A4#x@A4?@A4?@A47@A4#x@A47@A4@A4?@A4*0@A4>B[@A4Z@A4֡a@A4֡a@A4/@A4u"@A4*0@A4֡a@A4!-w@A5[@A5%F
L@A5+a@A5%F
L@A55Xy>@A5<64@A584֡@A5IQ@A5S&@A5O;dZ@A5O;dZ@A5O;dZ@A5Vl!@A5Y|@A5Vl!@A5Vl!@A5\@A5`A7L@A5Vl!@A5S&@A5\@A5`A7L@A5}H@A5sh@A5
qv@A5@A5H˒@A5b@A5\(@A5H˒@A5cA @A5cA @A58YK@A5
qv@A5S@A5ᰉ@A5!.@A5C\@A5C\@A6t@A6zG@A6.2@A61.@A6E@A6Ov_خ@A6Vu@A6Vu@A6R<6@A6YJ@A6_ح@A6\N<@A6c	@A6p:~@A6IQ@A6,<@A6'@A6@A6ȴ9X@A6Ϫ͟@A6x@A6"@A6@A7 hۋ@A7)^@A7+I@A7H˒:@A7KƧ@A7Xe,@A7O
M@A7Xe,@A7Xe,@A7_o@A7_o@A7b}V@A7iDg8@A7o@A7sPH@A7y@A74m@A7{J#:@A7O;d@A7-V@A7[W>@A7r@A7@A7o @A7@A7@A7-@A7#@A8bM@A86@A84m9@A8A7K@A8NU@A8K]c@A8K]c@A8Xy=@A8eO@A8oiDg8@A8n@A8'RT@A8tj@A8IQ@A8-
@A8IQ@A8-
@A8
=q@A8@A8d8@A89Xb@A8@@A8҈p@A9rGE@A9&x@A9*0U2a@A9-w1@A94J@A97KƧ@A9:S@A9Dg8~@A9Q@A9k~(@A9rGE8@A9x@A9@A9@A9x@A9ae@A9hr @A9u!S@A9o hی@A9@A9b}@A9~($@A9~($@A9o@A9u@A9n.@A9'R@A9@A9_o@A9ᰉ'@A9lD@A9.H@A:n@A:@A:s@A:@A:Ov`@A:1'@A:1'@A:&IR@A:=p
@A:=p
@A:JL@A:d7@A:kP|@A:xl"h
@A:@4@A:{m@A:p:@A:0
@A:Y@A:<64@A:͞&@A: ѷ@A:C,@A:D@A;S&@A;C%@A;g	l@A;n.3@A;xF]@A;tj~@A;qu!@A;~$@A;q@A;S@A;q@A;q@A;q@A;@A;Z@A;~($@A;ݗ+k@A;g@A;C]@A;s@A<J@A<xF@A<1&y@A<1&y@A<tj@A<9XbN@A<I^5?@A<tSM@A<zG@A<zG@A<j~#@A<qj@A<쿱[@A<@A<?@A<*0@A<*0@A<*0@A<Z@A</@A</@A</@A<u"@A<hr@A<!-w@A=o i@A=o i@A='0@A=V@A=u@A=[@A=[@A=qu"@A=Q@A=!.H@A=Q@A=V@A<>@A<e@A<E@A=K]@A=u@A=[@A=%F
L@A=%F
L@A=+a@A=5Xy>@A=?|h@A=B@A=L_@A=sg@A=w1@A=}H@A=$/@A=O
@A=+j@A=-V@A=ᰉ@A>
L/@A>@A>zG@A>@A>!R<@A>!R<@A>Ov_@A>u@A>@A>u@A>Ov_@A>Ov_@A>$/@A>+jg@A>.2@A>.2@A>+jg@A>.2@A>8YJ@A>;5X@A>8YJ@A>;5X@A>H@A>R<6@A>fffff@A>+J@A>&I@A>+@A>x@A>Mj@A?Ft@A?@A?
=p@A?@A?$tS@A?$tS@A?+I@A?;dZ@A?1@A?.H@A?>6z@A?_o@A?v_ح@A?4m@A?&@A?	@A?	@A?&@A?|hs@A?4m@A?ݗ+@A?@A?@A?ݗ+@A?-V@A?	k@A?zH@A?o @A?@A?حV@A?@@A?@@A?rG@A?@A?䎊r@A?rGE9@A@@A@F]d@A@bM@A@*0U@A@bM@A@}H@A@*0@A@4m9@A@>BZc@A@H@A@K]c@A@Q@A@Xy=@A@Q@A@bM@A@hۋq@A@n@A@'RT@A@@A@IQ@A@U@A@{@A@d8@A@9Xb@A@d8@A@9Xb@A@ѷX@A@F@A@ۋq
@A@`A7@A@@A@4֡b@A@	k@AA$/@AA@AA#w@AA&x@AA0
)@AA0
)@AA=b@AAJE@AAe+a@AAhr @AAe+a@AAhr @AAe+a@AAk~(@AAx@AArGE8@AAx@AA@AA@AA~($@AA@AAl@AA'R@AA'R@AAB@AA|@AA(@AAB@AAB@AAX@AA_o@AB&IR@AAy@AAo@AA_o@AAԕ*@AAN;6@AAN;6@AA@AAy@AA_o@AAN;6@AA_o@AAԕ*@AAR@AAY}@AAlD@AAlD@ABOv`@AB0U2a|@AB0U2a|@AB)y@AB䎊@AB&IR@AB^5?|@ABnO@ABqiC@ABxl"h
@AB@4@ABݘ@AB0
@ABwkQ@AB0
@ABwkQ@ABL/{@AB@AB@ABg	@ABn@AB}Vm@ABL/{@ABvȴ@ABwkQ@AB͞&@ABW@AB`A@ABsP@AB ѷ@ABm@ABm\@ACS&@AC'/@ACnP@AC'/@ACs@ACPH@ACPH@AC"`B@AC,zxl@AC6z@AC=K^@AC9@ACC%@ACMjO@ACW>6z@ACZ@AC]cA@ACg	l@ACqu!@ACqu!@ACn.3@ACxF]@ACeO@AC$@ACA@ACwk@AC6@AC@AC5Xy@AC
=p@ACQ@AC\N@ACA [@ACC]@ACA [@AC@AC@AC@ACs@AC\N@ACs@ACs@AC\N@ADxF@ADQ@AD(\@AD,<@AD,<@AD,<@AD2W@ADC,zx@ADFs@AD]ce@AD`d@ADcA \@ADg8}@ADj~#@ADj~#@ADj~#@ADm8@ADm8@ADj~#@ADg8}@ADzG@ADo h@AD#@ADC@ADqj@AD*1@AD3@ADTɆ@ADj~@ADɅoi@AD>B[@AD>B[@ADZ@AD!-w@AEK]@AE'0@AEV@AE[@AE%F
L@AE+a@AE84֡@AE5Xy>@AE5Xy>@AE5Xy>@AE?|h@AEL_@AEIQ@AEO;dZ@AE\@AES&@AES&@AES&@AEVl!@AEVl!@AEY|@AE`A7L@AEjOv@AE}H@AEڹZ@AE+j@AE+j@AE+j@AEU=@AE1@AEXy=@AE-V@AE-V@AEU=@AE1@AE-V@AE-V@AE@AEsh@AEsh@AEsh@AE@AE@AEcA @AE@AEcA @AE,=@AE!.@AEڹ@AEڹ@AEڹ@AF_o @AFt@AF_o @AF@AF$/@AFOv_@AFOv_@AFOv_@AFOv_@AFu@AFOv_@AF$/@AF1.@AF8YJ@AF1.@AF5?|@AF?@AFVu@AF_ح@AFl!-@AFp:~@AFp:~@AFs@AFl!-@AFz@AFIQ@AF@AFO;@AF'@AF@AF&I@AFm\@AFm\@AFm\@AFA@AFA@AFA@AFA@AF҈p;@AF+@AF+@AFߤ?@AFx@AFFs@AF"@AG hۋ@AG@AGFt@AG
=p@AG
M;@AG@AG,@AG,@AG!-w1@AG$tS@AG'/W@AG+I@AG$tS@AG'/W@AG+I@AG4֡a@AGAs@AG>6z@AGH˒:@AGE84@AGKƧ@AGRT`e@AGU=@AG_o@AGXe,@AGXe,@AG\(@AG\(@AGy@AG{J#:@AG	@AG&@AG	@AGO;d@AGݗ+@AG-V@AG-V@AG	k@AG͞@AG/V@AGo @AGfA@AG@AGVϫ@AG-@AG+j@AG+j@AGrGE9@AHF]d@AH@AHF]d@AH
qu@AH
qu@AH6@AH ě@AH'RT`@AH$xG@AH*0@AH-
q@AH73@AH:~ @AHA7K@AHA7K@AHH@AHD*@AHH@AHK]c@AHK]c@AHXy=@AH[6@AH[6@AH_F@AHbM@AHhۋq@AHeO@AHl"h	@AHr Ĝ@AH˒:*@AHn@AHn@AHYJ@AH@AHIQ@AHtj@AHIQ@AHd8@AHd8@AH
(@AH)^@AHD@AHe+@AHC@AH	k@AH\)@AH{@AH\)@AHPH@AI	k~@AIrGE@AI_p@AI+@AI_p@AI [7@AI [7@AI-w1@AI-w1@AI-w1@AI0
)@AI7KƧ@AIDg8~@AITɅo@AIXbM@AI[W>6@AI^@AIae@AIae@AIu!S@AIu!S@AIx@AIu!S@AI|Q@AI|Q@AIrGE8@AI|Q@AIb}@AIoiD@AIR<6@AIu@AIn.@AIB@AI@AI2W@AI_o@AIԕ*@AIN;6@AI_o@AI_o@AI_o@AIy@AI_o@AIiB@AI>BZ@AI>BZ@AIe@AIᰉ'@AIlD@AJ	 @AJ	 @AJ	 @AJs@AJe+@AJ&IR@AJ)y@AJ3@AJ=p
@AJ:)y@AJ@4n@AJ@4n@AJGE85@AJJL@AJC\@AJGE85@AJJL@AJM@AJQ_@AJJL@AJQ_@AJZc@AJa|Q@AJd7@AJd7@AJd7@AJkP|@AJnO@AJqiC@AJqiC@AJ{m@AJݘ@AJ@4@AJ@4@AJp:@AJ\(@AJS&@AJS&@AJ}Vm@AJ<64@AJn@AJ<64@AJ@AJ)_@AJ͞&@AJ`A@AJ͞&@AJ`A@AJ`A@AJ,<@AJ`A@AJڹY@AJ,<@AJ͞&@AJ`A@AJ`A@AJsP@AJ,<@AJ`A@AJ`A@AJ`A@AJ ѷ@AJfB@AJD@AJ~@AJm\@AJ~@AJm\@AJm\@AKS&@AKu%@AK'/@AKnP@AKs@AKC,z@AK&@AK9@AK=K^@AKC%@AKF]c@AKJ#9@AKZ@AKg	l@AKtj~@AKq@AKq@AKMj@AK:)z@AKA@AKߤ@AKߤ@AKS@AKq@AK@AK@AKE@AK~($@AK~($@AK~($@AK6@AK~($@AKZ@AK6@AK6@AK@AK5Xy@AKƧ@AKƧ@AK5Xy@AK@AK@AK5Xy@AKa@@AK5Xy@AKa@@AKQ@AKQ@AKݗ+k@AK҈@AK%2@AKlC@AKlC@AKg@AKg@AKC]@AKC]@AKA [@AK$@AKs@AKs@ALJ@AL1&y@ALxF@ALtj@AL%1@AL,<@AL2W@AL9XbN@AL9XbN@AL9XbN@AL64@AL9XbN@AL<쿱@ALFs@ALM:@ALM:@ALM:@ALPH@ALPH@ALM:@ALSMj@AL]ce@AL`d@AL`d@AL]ce@AL]ce@AL`d@ALcA \@ALcA \@ALcA \@ALj~#@ALj~#@ALm8@ALq@ALtSM@ALzG@AL?@AL?@AL#@AL?@ALC@ALqj@ALqj@ALN;@AL*1@AL*1@AL*1@ALS@AL3@ALS@AL쿱[@AL쿱[@ALS@AL3@AL쿱[@AL3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @r<@r+33333@r33333@qfffff@r@r33333@r33333@qfffff@q33333@q@r@r     @r     @r33333@r33333@r     @r@r@r@r33333@r@r33333@r     @r@r@r33333@r	@r@rfffff@r@r33333@r      @r@rfffff@r@r     @r     @r33333@rfffff@rfffff@rfffff@rfffff@r33333@r!@r)@r,@r(     @r      @r      @r$@r+33333@r+33333@r(     @r(     @r      @r@r33333@r$@r)@r+33333@r(     @r)@r+33333@r,@r)@r+33333@r0     @r(     @r#33333@r      @r33333@r@r@r@r@qfffff@q|@p陙@pA@offfff@m#33333@k33333@ii@h`     @g33333@g&fffff@ffffff@ffffff@fvfffff@f#33333@efffff@ec33333@e#33333@d@dٙ@dfffff@d     @d     @dy@d|@d33333@d33333@dp     @d<@c     @cfffff@cfffff@c     @cl@cY@cP     @c33333@b33333@b33333@b     @b@b@b@b     @b33333@b|@b|@b|@b|@bvfffff@bp     @bc33333@bS33333@b)@b@afffff@a@a33333@afffff@afffff@afffff@a     @avfffff@aP     @a@     @a33333@`陙@`     @`ٙ@`     @`33333@`ə@`@`@`i@`Ffffff@`9@`<@`0     @`&fffff@`      @`&fffff@`#33333@`      @`33333@`      @_33333@_@_@_@_33333@_33333@_L@_      @^     @^@^`     @^fffff@]     @]      @\     @\33333@\33333@\fffff@\ffffff@[fffff@[      @Z@Z     @Zfffff@Z33333@[      @Z33333@Z     @Z     @Zfffff@Z33333@Z33333@Zs33333@Zl@Z&fffff@Yٙ@Y@Y33333@Y33333@Y33333@Y33333@Y@Y@Y     @Yfffff@Y     @Y@Y@Y@Y33333@Y@Y33333@Yl@YFfffff@Y      @Y@X@X     @X     @X@X33333@X     @Xs33333@Xl@X,@W33333@W33333@Wfffff@Wfffff@Wfffff@W@Wfffff@W@Wfffff@Wl@W`     @W333333@W@W33333@W      @Vٙ@V     @Vy@V9@V@V&fffff@V@     @V`     @V     @V33333@Vs33333@V333333@Vfffff@Ufffff@U@U     @Uffffff@UL@U333333@U&fffff@U33333@T33333@Tٙ@T@T     @T`     @TFfffff@T@     @TS33333@TL@T@     @T&fffff@Tfffff@S@Sfffff@S@Sy@S333333@S      @R33333@R@R@Rl@RL@R9@R@Q@Q@Q@Q@Qfffff@Qy@Qffffff@Q@Q33333@Q33333@Q33333@Qfffff@Q     @Q     @Qffffff@Q333333@Q      @Pfffff@P@P     @P     @P@P33333@P33333@P@Ps33333@P@     @P,@P&fffff@P33333@P33333@P      @P      @O     @O     @OL@OL@OL@O@N     @N     @N     @N     @NY@N@     @Mfffff@M     @M@M@M@MY@L33333@Lfffff@L     @Lffffff@L@     @L@L      @Kfffff@L&fffff@K@K@K@J@Jffffff@JY@J@     @J      @J@I     @Is33333@Is33333@I333333@I&fffff@I@I@I@I@I@Hfffff@I      @Hfffff@H@Hfffff@Hffffff@Hs33333@H     @Hffffff@Hffffff@H@     @H      @Gfffff@H      @G33333@H      @G33333@G     @G     @GL@G&fffff@F33333@F@F33333@F@Ffffff@F     @F@     @FL@FL@F@     @FL@F&fffff@F@Efffff@F      @E@E@E     @Es33333@EY@EY@E@     @EL@EY@E&fffff@E@D33333@Dfffff@D@Dfffff@D@D     @Dffffff@Dffffff@DL@DY@Ds33333@DL@D@C33333@C@C33333@C@Cٙ@C33333@Cfffff@C@C@Cs33333@C     @Cffffff@CL@C@C@Bٙ@B     @B@B     @BL@B@     @BL@B@A@A@A      @@     @@fffff@@@@     @@ffffff@@Y@@L@@@     @?fffff@?fffff@?@?ffffff@?L@?@>@>@>     @>ffffff@>     @>     @>L@>ffffff@>L@=@=      @<     @<ffffff@<@<33333@<@<      @;33333@;     @;ffffff@;@;@;33333@;fffff@;33333@;ffffff@;@:@:     @:L@:L@933333@9ffffff@9L@9@9ffffff@9ffffff@9      @8     @8fffff@8@8L@8L@8@733333@7     @7ffffff@7L@6fffff@7333333@7L@7      @7      @7      @7      @633333@6@6333333@5fffff@6      @5fffff@5fffff@6      @6@6      @5@5@5ffffff@5L@5     @5333333@4fffff@5      @5      @4fffff@433333@4@5      @4@4L@4     @4ffffff@4ffffff@4@3@3333333@3L@3L@3@3      @3      @2@3      @233333@2@2@233333@2     @2@2@233333@233333@2@2     @2L@2      @1fffff@2      @1fffff@1@1@1L@1L@1ffffff@1ffffff@1     @1L@1@1L@1@1L@1@1      @0fffff@0@033333@0@033333@1      @0fffff@033333@0@0@033333@0@0L@0333333@0333333@0      @/@0@0@/@/@/ffffff@.@.@/333333@/333333@.@.@/      @.@.ffffff@.333333@.333333@.333333@.ffffff@.@.333333@.ffffff@.      @-333333@-@.ffffff@.333333@-@,@-333333@-333333@,@,ffffff@,ffffff@,@,@,@,@-      @,@-      @-      @-      @-      @-333333@-      @-333333@,@,@,@,@,ffffff@+@+@+@,333333@,      @+@+@+@+@+@+ffffff@+ffffff@*@*@*@+      @+333333@+      @+      @*@*@+      @*333333@*@+@+333333@*333333@*      @*333333@*      @*@*@*@*@*ffffff@*      @*      @*      @*      @*      @*      @*      @)@)ffffff@)333333@)333333@)ffffff@)@)333333@)333333@)333333@)333333@)ffffff@)333333@)333333@)      @)333333@)@)333333@)333333@)      @)      @)333333@)333333@)@)ffffff@(@(@(@(333333@'@(333333@(@(333333@(      @(ffffff@(ffffff@(ffffff@(333333@(333333@(      @'@(      @(      @'@(      @(      @(333333@(@(333333@(333333@(@(ffffff@'@'@'@'ffffff@'@'ffffff@(      @(333333@(ffffff@(333333@(@(@(333333@'@&@'      @'333333@'ffffff@&@&333333@&@'333333@&@'@&@&@'333333@'      @'333333@&@&ffffff@&@'      @'      @'333333@'ffffff@'ffffff@'333333@'      @&@'      @&@'      @'      @'      @'333333@'      @'      @&@&@'      @'      @&@'      @'333333@&@'      @'      @&@&@'      @&@&@&@&ffffff@&      @&ffffff@&333333@&ffffff@&ffffff@&@&333333@&333333@&333333@&ffffff@&333333@%@%@%@&      @&      @&      @%@%@%@&      @%@&      @%@&      @%ffffff@%333333@%@%@%ffffff@&      @%@%333333@%@%@%ffffff@%@%333333@%@%      @%@&      @%      @%ffffff@%@%@%ffffff@%@%@%@%ffffff@%@&      @%@%@%ffffff@%333333@%@&      @%ffffff@%ffffff@&      @%      @&      @&333333@%@%@%@&333333@&      @&      @&      @%@&ffffff@%@&      @&333333@%@%      @%@&333333@%@&333333@&@&      @&ffffff@&      @&      @%ffffff@%@&      @%333333@%@&ffffff@&333333@%@&      @&      @%@&@&ffffff@&333333@&@%@%@&ffffff@&@%@&333333@&@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&@&ffffff@&@&@'      @&@&ffffff@'ffffff@&@&@'333333@'333333@&@'      @'ffffff@&@&ffffff@&@'ffffff@'333333@'      @'      @'333333@'@'333333@&@'333333@'333333@'@'ffffff@'333333@'@'@'333333@'@'ffffff@'@'@'@'@'ffffff@'@'@'@'@'@(      @'@'ffffff@'ffffff@(      @'@'@'@'@'@'@(      @'@'@'@(333333@(ffffff@'ffffff@'@(333333@(333333@(ffffff@(@(@(ffffff@(@)      @)      @)      @)      @(@(@(@(@(@)      @(@)      @(@(@)ffffff@)ffffff@)      @(@)      @)333333@(@)      @(@)@)333333@)      @)333333@)ffffff@)333333@)ffffff@)@)ffffff@(ffffff@)@)@(@(@)@)@)ffffff@)@)333333@)333333@)333333@)@)@)ffffff@)@)ffffff@)ffffff@)@*      @)@)ffffff@)@)@)@)@*      @*ffffff@)@)@)@*@*      @)@*@*@*      @*      @*ffffff@*333333@*      @)@*      @*      @*@*@*@*ffffff@*@+333333@+      @*333333@+      @*@+333333@+ffffff@+ffffff@+@+@+333333@+@+333333@+      @+@,      @+333333@+ffffff@+@+ffffff@+@+@+ffffff@+@,ffffff@,333333@+ffffff@,@,ffffff@+@,      @,333333@,333333@-      @-333333@-      @,@-      @-333333@,@-333333@-      @-ffffff@-ffffff@-@-333333@-333333@-@-@-333333@-333333@-ffffff@-@-@-@-@-@.@.@.ffffff@.@.ffffff@.@/333333@/      @/      @.@.@.@/      @.ffffff@.@/333333@.@.@/333333@/333333@/333333@/333333@/333333@0      @/333333@0      @/@0333333@/@0      @0L@0L@0333333@/@0      @0@0@0@/@0@0ffffff@0ffffff@0     @0@033333@0ffffff@0@0@0fffff@1      @0@0fffff@1@1333333@1@1     @133333@1333333@1     @1fffff@1@1L@1     @1@1@1@133333@133333@133333@1@1@1fffff@2@2      @2@2L@2333333@2      @2L@2ffffff@2@2L@2@2@2@2     @3@3333333@3L@3      @3333333@3333333@3@3      @3L@3@3L@333333@3L@3333333@3ffffff@3L@3     @3     @3     @3ffffff@3@3L@3@3L@3L@3      @3@3333333@3ffffff@3@3@3ffffff@3     @3@3ffffff@3@3L@3     @4      @4      @333333@4@4      @4L@4@4@4fffff@5      @4@4fffff@5L@5      @4@4fffff@5333333@4@5ffffff@5      @4fffff@4fffff@5      @5333333@5      @5      @5333333@5@5333333@5@5@4fffff@5@5@5fffff@6@6     @6L@6333333@6     @6@633333@6fffff@7@6@633333@6@7@7@7L@7333333@7ffffff@733333@7     @7@7333333@7ffffff@7     @7@7ffffff@7@7@7ffffff@7@8      @8      @7@8333333@8333333@8L@733333@8@8     @8333333@8L@833333@8L@8     @8@8@8@8fffff@8@833333@8fffff@8@8@8fffff@9@9@9333333@9L@9fffff@9     @9@:      @9@933333@9fffff@:      @:      @9fffff@:      @:L@:ffffff@:L@:@:fffff@:     @:ffffff@:     @:     @:@:L@:ffffff@:@;333333@;333333@;333333@;333333@;      @;     @;ffffff@;@;33333@;     @;     @;@;@;@<      @;fffff@;33333@;@;@;@;fffff@;fffff@;fffff@<L@<@<@<      @<@<333333@<@;@<      @<333333@<@<     @<33333@<ffffff@<@<     @=ffffff@=      @<fffff@<fffff@=@<@=ffffff@=@=33333@>      @>333333@=33333@=@=@>333333@>     @>      @=@=@=@>      @>@>      @=@>333333@>@>L@>ffffff@>@>@>33333@>33333@>@>@>@?333333@?ffffff@?L@?@?     @?333333@?L@?L@?L@?     @?@?@?@?33333@?@?@?@@      @@&fffff@@&fffff@@@@      @@@@L@@s33333@@     @@ffffff@@     @@fffff@@@@@@@@@@ٙ@@fffff@@@@fffff@@@@33333@@     @@ٙ@@33333@@ٙ@@fffff@@fffff@A@A@A@A@A@     @A@     @AL@A@AY@Affffff@A@A@     @AL@AL@A@     @A333333@AY@A@A@As33333@A@A@A     @A     @A@Aٙ@Afffff@B@B333333@B@B@     @BY@BY@Bs33333@B@     @B@     @B@     @BL@B@Bfffff@Bs33333@B     @Bffffff@B     @B@B@B@B     @B33333@B     @Bfffff@Bfffff@B33333@Bfffff@Bٙ@C@C@C&fffff@C@C@C@C      @Bfffff@C&fffff@C333333@C@C&fffff@C@C@C&fffff@C@C333333@CL@CL@C@     @CL@CY@Cffffff@C     @C@Cfffff@C@C@C     @C@C33333@C@C@C33333@Cfffff@Cfffff@Cfffff@C33333@Cfffff@Cfffff@Cfffff@Cٙ@D&fffff@D@D@D@D333333@D@D&fffff@DL@D&fffff@Dffffff@D@D     @D     @D     @D@D33333@D     @D     @D     @D33333@D33333@Dٙ@Dfffff@Dٙ@Dٙ@D33333@E      @D33333@D33333@E@Dfffff@E      @E@E333333@E@E@E@E@E@E&fffff@E&fffff@E@     @E&fffff@EY@E     @Effffff@E@Effffff@E     @E33333@E@Efffff@Efffff@Es33333@EY@E@E@Eٙ@E@E@F      @Efffff@Eٙ@E33333@F@E33333@F      @F@FY@F@     @F&fffff@F@FY@F@F     @Fffffff@F@     @Fs33333@F@F@F@F33333@F     @Fٙ@Fٙ@F33333@Fٙ@Fٙ@Ffffff@F33333@Ffffff@G&fffff@F33333@G@G@G333333@F33333@G@     @G@G@G@G333333@G@     @G333333@G&fffff@GY@Gs33333@Gffffff@Gffffff@Gffffff@Gs33333@Gfffff@Gs33333@G33333@Gٙ@G33333@G     @G@HL@H@H&fffff@H@     @H&fffff@H333333@H&fffff@HL@Hffffff@HY@HY@H@     @Hffffff@H     @HL@HY@Hs33333@Hs33333@H@H     @H     @H@H33333@H33333@H@Hfffff@I@H@Hٙ@Hٙ@H@H@I@I@I      @Hfffff@I&fffff@I@     @I@     @IY@IY@IY@I     @I     @I33333@I33333@I     @I@Ifffff@Iٙ@I33333@I@I33333@Ifffff@Ifffff@Iٙ@Iٙ@J@J@Iٙ@Ifffff@J&fffff@J@     @JY@J@     @J&fffff@Jffffff@JL@JL@J@     @Js33333@J@Jffffff@Jffffff@Jffffff@Jffffff@JY@J     @J     @J@Jfffff@J     @J@J@J33333@Jfffff@J@J33333@Jfffff@J33333@K      @Jfffff@Jٙ@K&fffff@K@     @KY@K&fffff@K@     @KL@KL@K     @Ks33333@KL@Kffffff@Kffffff@KL@K@Kffffff@KY@Ks33333@KY@Kffffff@KY@Kffffff@Ks33333@Kffffff@KY@K@K@K     @K33333@Kٙ@Kٙ@K     @Kfffff@Kfffff@L      @Kٙ@Kٙ@L@L@L333333@L@L333333@LL@LY@Ls33333@L@L33333@L33333@Lٙ@Lٙ@M@L@M@M      @L33333@M&fffff@M      @L33333@M@M&fffff@M@M@ML@M      @M&fffff@M333333@M333333@M@     @M@     @M333333@Mffffff@MY@M333333@M@M333333@ML@M333333@M333333@Ms33333@Ms33333@ML@M     @Ms33333@M     @Mffffff@Mfffff@M     @M@M     @M@Ms33333@M@M@Mfffff@M@M@Mٙ@M33333@M33333@M33333@N      @M33333@N&fffff@N&fffff@N&fffff@M33333@N@NL@N&fffff@NY@N@N333333@NL@N333333@N&fffff@NL@N&fffff@NL@NL@N@     @NY@Nffffff@N@     @Nfffff@N333333@Ns33333@N     @Ns33333@N     @N     @N@N@N33333@Nfffff@N33333@N     @Nfffff@N33333@Nfffff@Nfffff@N@N     @N@N33333@Nfffff@Nffffff@Nٙ@N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ?bM?C%?E?Vu?lC?Q?+?l?柾vȴ9?+I?333333?bM?vȴ9X?Gz?旍O;d?+I?=p
=?ffffff?I^5??&x?hr Ĝ?lD?m?Q?Q?1&?-V?"`B?KƧ?\(\?I^5?l?x?Gz?vȴ?333333?-V?O;dZ?vȴ9X?ěS?GzH?o?GzH?9XbN?`A7L?/w?7KƧ?/w?      ?zG?QR?tj?dZ1?E?E?O;dZ?KƧ?+I^?\(?Gz?畁$/?333333?Gz?O;dZ?nO?+?tj~?Q?n?S?hr ?1&y?1&x?`A7?;dZ?Vt?      ?ܬ1&y?xF?j~"?XbM?+?~"?KƧ?/w?nO;?lD?nP?-V?p
=q?^5?|?QR?KƧ?
=p
?ȴ9Xb?E?l?333333?-V?333333?l?l?nO;?lD?`A7L? ě?&x?`A7L?`A7L? ěT? ěT?&x? ěT? ěT?bM?;dZ?;dZ?vȴ9X?
=p?
=p?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?5?|h?Q?;dZ?vȴ9X?vȴ9X?Q?Q?;dZ?;dZ?;dZ?Q?;dZ? ěT?;dZ?Q?bM?vȴ9X?;dZ?5?|h?Q?Q?Q?;dZ?Q?;dZ?Q?;dZ?Q?vȴ9X? ěT?Q?5?|h?Q?;dZ?bM?;dZ?vȴ9X?Q?vȴ9X?Q?Q?Q?Q?Q?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ? ěT?;dZ?;dZ?vȴ9X?
=p?vȴ9X?;dZ?;dZ? ěT?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?bM?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ? ěT?vȴ9X?vȴ9X?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?vȴ9X?Q?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ? ěT?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X? ěT?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ? ěT?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ? ěT?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X? ěT?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT? ěT? ěT?vȴ9X?;dZ? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ? ěT? ěT? ěT?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?bM? ěT? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?bM?bM? ěT? ěT?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X? ěT?
=p? ěT?vȴ9X? ěT? ěT? ěT?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT? ěT? ěT?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT? ěT?;dZ? ěT?vȴ9X? ěT?bM?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X? ěT?vȴ9X? ěT? ěT? ěT?;dZ? ěT? ěT?vȴ9X?bM? ěT? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?bM? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X? ěT? ěT?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X? ěT? ěT?vȴ9X? ěT?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X? ěT? ěT? ěT?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?bM?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?;dZ?Q?;dZ? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?
=p?bM?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?5?|h?Q?;dZ?Q?Q?5?|h?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?vȴ9X?Q?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?5?|h?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?vȴ9X?Q?Q?5?|h?5?|h?Q?Q?Q?;dZ?Q?5?|h?Q?5?|h?Q?Q?5?|h?Q?Q?Q?Q?5?|h?5?|h?5?|h?;dZ?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?Q?;dZ?5?|h?5?|h?Q?Q?Q?5?|h?Q?5?|h?Q?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?Q?Q?5?|h?Q?Q?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?Q?5?|h?Q?Q?Q?Q?5?|h?;dZ?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?;dZ?Q?5?|h?Q?Q?Q?Q?5?|h?5?|h?5?|h?-V?Q?5?|h?1&y?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?/v?-V?5?|h?5?|h?-V?5?|h?-V?5?|h?-V?-V?5?|h?5?|h?Q?-V?5?|h?5?|h?5?|h?5?|h?Q?5?|h?-V?/v?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?-V?5?|h?Q?5?|h?5?|h?Q?-V?5?|h?/v?5?|h?5?|h?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?-V?/v?5?|h?Q?5?|h?Q?Q?Q?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?Q?-V?-V?5?|h?5?|h?-V?-V?-V?-V?-V?5?|h?5?|h?5?|h?5?|h?/v?5?|h?5?|h?Q?5?|h?Q?Q?Q?5?|h?/v?5?|h?5?|h?/v?/v?5?|h?/v?-V?5?|h?5?|h?-V?-V?Q?Q?5?|h?5?|h?-V?5?|h?-V?5?|h?-V?-V?5?|h?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?-V?/v?5?|h?-V?-V?5?|h?-V?/v?5?|h?5?|h?Q?5?|h?5?|h?5?|h?-V?Q?5?|h?-V?5?|h?-V?/v?5?|h?/v?-V?-V?-V?-V?/v?-V?5?|h?/v?/v?/v?5?|h?/v?5?|h?-V?-V?-V?/v?-V?5?|h?-V?-V?-V?/v?5?|h?-V?5?|h?5?|h?-V?5?|h?-V?-V?-V?5?|h?/v?/v?-V?-V?-V?5?|h?/v?/v?/v?-V?/v?/v?-V?/v?1&y?1&y?-V?5?|h?/v?-V?-V?/v?/v?-V?-V?/v?/v?-V?-V?-V?-V?-V?/v?/v?1&y?/v?-V?5?|h?/v?-V?/v?1&y?5?|h?1&y?/v?1&y?1&y?/v?/v?-V?1&y?-V?/v?1&y?1&y?/v?/v?/v?-V?/v?-V?/v?/v?-V?/v?/v?/v?/v?/v?/v?-V?/v?5?|h?-V?-V?-V?/v?/v?/v?/v?/v?/v?-V?/v?-V?1&y?5?|h?-V?1&y?/v?/v?1&y?/v?/v?/v?/v?/v?1&y?/v?/v?/v?/v?/v?/v?1&y?/v?1&y?/v?/v?/v?/v?1&y?/v?1&y?1&y?/v?/v?/v?-V?1&y?1&y?-V?/v?1&y?1&y?/v?/v?/v?1&y?/v?-V?-V?1&y?/v?1&y?1&y?-V?1&y?/v?/v?/v?1&y?1&y?1&y?-V?/v?/v?1&y?/v?1&y?1&y?/v?/v?/v?1&y?/v?/v?1&y?-V?1&y?/v?1&y?/v?/v?1&y?/v?/v?/v?1&y?1&y?1&y?/v?/v?/v?/v?1&y?1&y?1&y?/v?1&y?1&y?1&y?/v?1&y?/v?/v?/v?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @	@@
ffffff@@333333@ ??333333??      ?ffffff??333333?񙙙?      ?      ??陙?陙?ffffff?ffffff?ffffff?333333?333333?      ?      ?      ?ٙ?ٙ?ٙ?ٙ?333333?333333?333333?333333?333333?333333?ə?ə?ə?ə?ə?ə?ə?ə?????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P10                                     2                                       *BCu3