CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P4     CAST_NUMBER       3      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.639257Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @5         data_max      @5         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER       2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @   data_max      @   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC        Rd   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        q   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @Ov`   data_max      @#zG   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC         y   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        D   salinity                	long_name         salinity   units         PSS-78     data_min      @@+S&   data_max      @A2   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC        $   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d           oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @$         data_max      @qi   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC          Ȅ   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d           CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?1&y   data_max      ?S   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC           CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       d   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      @陙   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC        D   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       6   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC      >   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       ^$   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( f   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( f,   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )   data_max      )   C_format      %10d       fT   latitude               	long_name         latitude   units         	degrees_N      data_min      @HSI'>   data_max      @HSI'>   C_format      %9.4f          fX   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _
Ri   data_max      _
Ri   C_format      %9.4f          f\   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        f`   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        X   data_max        X   C_format      %4d        fd@5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @5      @@ffffff@ffffff@@333333@ffffff@       @"      @$      @&      @(      @*      @,      @.      @/@1@2      @3      @4      @5      @6      @7      @8      @9      @:      @;333333@<      @=      @>      @?      @@      @@     @A      @A@B      @B     @C      @C     @D      @D@E@E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K@L      @L     @M      @M     @N      @N     @O@O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @Wfffff@X@X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @cfffff@c     @c     @d      @d      @d@     @d`     @d     @d     @dfffff@d33333@e      @e      @e@     @eS33333@e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h#33333@h333333@h@h     @h     @h@i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j333333@j`     @j     @j     @j     @jٙ@k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l33333@l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @nvfffff@n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p9@pQ@p`     @pp     @p     @p     @pfffff@p@pfffff@p     @p     @p     @q      @q     @q      @q0     @q>fffff@qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t@t@t     @t     @t     @t33333@t33333@t     @u      @u     @u      @u0     @u@     @uI@ua@up     @u     @u     @u     @u     @ufffff@u     @u     @u     @v      @v     @v      @v0     @vA@vS33333@va@vp     @v     @v33333@v33333@v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x@x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z@z     @z     @z     @z     @z     @z     @{      @{@{!@{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|nfffff@|     @|     @|     @|     @|     @|fffff@|33333@|     @}      @}     @}      @}0     @}@     @}P     @}`     @}l@}33333@}     @}     @}     @}     @}ə@}fffff@}     @~      @~     @~      @~0     @~C33333@~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @q@     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @      @     @     @33333@"fffff@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @33333@     @     @     @     @@fffff@     @     @     @     @     @33333@      @     @     @     @      @(     @/33333@:fffff@@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @33333@+33333@0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @ᙙ@     @     @     @      @     @     @33333@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@fffff@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @,@8     @@     @H     @P     @X     @a@h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @_33333@p     @x     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @      @@     @     @      @(     @0     @8     @?33333@I@P     @X     @`     @h     @p     @x     @     @@     @     @     @     @     @     @33333@     @     @     @@噙@33333@     @      @     @     @@      @(     @0     @8     @@     @H     @M@X@`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@@      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @~fffff@33333@     @     @     @     @@     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @m@y@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @      @     @     @     @      @&fffff@1@8     @@     @H     @P     @X     @`     @h     @p     @x     @}@fffff@     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @"!$/@"#$@"$o h@"$qj@"%o i@",@"9D@"=p
=@"=ڹZ@"<u"@"<Z@"<j~#@"<PH@"7
=p@"6Ϫ͟@"5Xy=@"4Fs@"2p:@"1@"1R@"/As@",!-w@"+C]@"1iB@"4`d@":Q_@"G-@"H>BZc@"L1&y@"RnO@"V8YJ@"]Vl!@"eڹ@"oiDg8@"tm8@"}ڹZ@"@"TɆ@"
L/@"҈@"iDg8@"Vϫ@"{m@"j~@"S&@"쿱[W@"-
@"b}V@"4m9@"Q@"\N<@"n@"R<6@" [7@"@N@"o h@"?@"_o@"L/{@";5X@"ݲ-V@"@"@@"˒:)z@"W>6z@"⩓@"0U2a|@"u@"-w1@"@"Z@"J#9@"ٌ~($@"ރ%@"M@"-
@"xF@"2W@",@"1'@"@"u%F
@"յsh@"ٌ~($@"-
@"&@"U2a|@#?@#҉@#zG@#o @#
5Xy>@#!-w@#
qu"@#
O;dZ@#~($@#_o@#Xy=@#fffff@"Q_@"R@"VϪ@"ⶮ}Vm@"˒:)@"lC@"S&@"'RTa@"JL@",<@"@4n@"PH@"bM@"Z@"jf@"H˒:@"#@" hۋ@"	k@"E@"-@"@"uϪ͞@"],=@"GK]d@"?H˒:@"43@""wkQ@"^5?|@"{@"*0@!~($@!x@!=K^@!7Kƨ@!@!"h	ԕ@!7KƧ@!&I@!zQ_@!y@!p{@!e@!_U=@![=K^@!T*1@!R䎊@!KxF]@!FIQ@!6ȴ9X@!&-@!	k~@!@N@ 1@ U2a|@ H@ t@ ٦(@ u"@ 唯O
@ ߤ@@ D@ яo@ a@@ ˒:*@ ȴ9Xb@ ۋq
@ Gz@ @ ᰉ@ l!-@ 6C@ q@ >BZ@ PH@ ͞&@ |PH@ |hs@ @ ݗ@ 2W@ \(@ $/@ $/@ d8@ 
qu@ vȴ9@ !-w1@ }ce@ u$/@ q@ m8Y@ lzxl"@ jW'@ `	k@ \Q@ WkP@ Sg@ KQ@ ;u%@ $o h@#@Fs@Gz@=K@\]ce@6ȴ9X@]ce@_o@w1@y=c@Ǔݗ+@D@e+a@i^@iB@^%@o{J#:@˒:)z@\)@҈p@ae@M@䎊qj@ⶮ}Vm@ݗ+j@kP|@JE@>6z@T`d@ɠ'RTa@84֡@.H@lC@Z@)_@PH@
=q@C,z@@7@wk@-w1@c	@҉@@xl"h	@mhr!@aR<6@VϪ͟@M@F?@8Q@#
=p@S&@˒:)@Ϫ͟@?@>BZc@Q_@@cA \@@@u%F
@zC\@v}Vl@tj~@q[W>6@_حV@T`d@Rn@LL_@F&I@EoiDg@>$t@ ҈p@D*@sP@
=p
@@.H@/V@MjO@ٳ|@	 @ɺ^5?}@?@	k~@lC@e+a@bM@qu"@˒:*@o h@6@&IR@}ڹZ@m\@jJL@g-@fL/{J@dtSM@a.H@`'RT`@]ce@Xtj@TzG@SMj@N!R<@HeO@G)^@C\N@5\(@0D@/iDg8@+6z@*͞&@)rGE@,=@$@0
)@xF]@$@Xe@D@@4@ۋq@@@̘_@$/@!R@0U2a|@`A7L@U=@tj@bM@{5Xy@u?@ra|Q@i*0U2a@d/@Rp:@E8YK@E@B74@>vȴ9X@7rG@%u@ ěT@E84@Dg8~@ߊ	@wkP@bM@յsh@\(@g@`A@Q_@K]c@}v@kP{@eO
@`A7K@Ye+a@O;dZ@DJM@/v@A [@ᰉ@Y}@_o@$@rm\@b}Vm@]cA @XPH@F@@ۥS@Fs@˒:)@a@N@Q@$t@D@"h	ԕ@g	@	k@-@-
q@'/@|@*0@ᰉ@H˒:@.2@
=p@ [7@2a|@k~($@\N;@Xe+@ݗ@|Q@4֡a@m8@F@hr!@ڹ@
qu@vȴ@o @{dZ@t3@pU2a|@mV@j͞&@lq@hr Ĝ@e1@\wkP@\N;@XPH@T,<@OAs@J	 @?$tS@q@L_@74@4K@	@Q@kP|@ȴ9Xb@b}V@IQ@Fs@(@IQ@~vȴ9X@sE@lVϪ@ao@FYJ@)@$qj@u%F@\(@Dg8~@+I@&x@ěT@sPH@ ѷ@g,@][@CF]c@8Q@)*0U2a@*0U2a|@+C]@$TɆ@PH@8YK@{m@
qu@tj~@x}H@?|hs@9"`@$Z1@E@@!R@TɅ@TɅ@0U2a|@C,z@g	@1&y@@C,@@IQ@G{@Vl!@Y}@
qv@R<6@@S&@kP{@ZkP|@V@M%@:~@a@N@;dZ@($x@$t@Y}@j~#@/V@dZ@j~#@4m9@҈p;@w1@fB@0
@^@|Q@N;5@~($x@*0U@*0@lD@\)@D@}Vl@M@As@}v@zS&@-
q@Ʌoi@{@M:@be+@bh	ԕ@`u!@Z6C@W>6z@V@VOv_@O
M;@I@B\(@>vȴ9X@3|@䎊r@@5?|@u%F@*0@T@1&x@ n@v@K]@#x@+@D@ߤ@2W@O;@Q@zxl"h@1'@H@o i@4m9@H˒@5Xy@G{@4֡b@3@!.@m\@r@1@t@t@2X@zG@\@w1@v@U2a|@@C\@GE85@Zc@)^@4J@ϐ@'/W@k~(@o i@a@N@SMj@q2W@O@I^5?}@GE84@?@<Q@8)@73@7kP@9	k~@:@=p
=@?@?@>vȴ9X@>6z@>ߤ?@>"@?[W>@@6@@IQ@ATɅo@C,zxl@DS@Eo i@G)^@I'RTa@MjOv@M(@Ov_ح@P{@N+@Mqu"@Mqu"@MjOv@L_@JL_@HK]c@F
L/@?.H@8)@2 ě@-w1@*~"@*JL@&x@ 'RT`@0
)@hr @
5Xy>@)@B@@ۥS@䎊@cA \@oiDg@TɅo@!-w2@C]@*0U2a@,<@9@-
@>@bM@sP@L_@ݗ@wXe@f,<@\]ce@Y_o@U=K@Rn@JL_@An.@>m\@<hr@䎊r@ d8@cA @_F@@N@T`d@u@{@N;5@t@@tj@@/{J#@S&@Z@!-w2@g	@Dg8~@-V@#w@,zxl@{J#9@n.@\(@74@|hs@a|Q@zG@Q@@`A@R<6@쿱[W@ce@/w@W>6z@ٙ@@`d@4J@As@̲@n@_o@F]c@ [7@@4֡b@v@U=@~($@^@	k@'@TɆ@ce@,<@L/{@JM@\(@˒:)@{/V@vE@lVϪ@]ce@Xe+@W@Vl!-@Rm@O
M;@K'/@I7KƧ@Fs@D?@B ѷ@@6@:G{@8F]d@6ȴ9X@5\(@5Xy=@5!R@4J@3ߤ@0@,"h	ԕ@*~"@(>BZc@'&@&L/{J@%O
@%+a@$/@$7@"@4@c	@D*@R<6@*0U2@p:@nO@T`d@䎊@X@4J@_o @n/@      @%F
L@"h	ԕ@~"@x@%1@Gz@ٳ|@ѷX@@K]@?|h@Vϫ@V@0
@0
@'@-w1@ߤ@@@qi@$/@     @}ڹZ@{m]@yrGE8@t#@mhr!@hr Ĝ@bC,@WsPH@LcA \@I^5?}@G)^@;dZ@5Xy=@0 ě@,<쿱@)^@&L/{J@"`A@Q@e+a@@@Xe,@@ᰉ@O
M@nO@-
q@rGE9@
L/{@o h@($x@Y|@g	@䎊qj@ۋq@@/V@)@-V@6z@U=@$/@ԕ*@4m9@p
=q@_?@S&@Ks@JW'@A [7@9Y}@8)@6}Vl@1o@-U=@)^@'/V@&x@%zxl"h@!.H@Q@+J@S&@~($x@'/@K]d@      @
F@
%F
L@
D@
+jg@
"`@
hr@
ڹZ@
?@
#x@
!.H@
"@ hۋq@
lC@
䎊q@
hr!@
ڹ@
`A7L@
ⶮ}Vm@
Gz@
d8@
W>6z@
ٳ|@
+@
y=c@
֡af@
l!-@
8YJ@
`d@
҈p:@
`A7@
cA \@
@
s@
@
]cf@
Õ$@
Zc@
|hs@
5Xy@
|@
-V@
0U2a|@
tj~@
ڹY@
%2@
˒:)@
yrGE8@
ql@
nO;@
gfA@
dZ1@
bM@
a@N@
^iB@
]ce@
["`B@
XbM@
U2a|@
T,<@
QX@
K)^	@
HK]c@
C@
As@
>vȴ9X@
9D@
73@
4J@
($xG@
($xG@
&@
"h	ԕ@
IQ@
+j@
'/W@
I^5?@
&I@
{J#9@
n.@
 ѷX@b}V@!.H@F]d@@r Ĝ@Gz@e+@:@W'@#9@Q@@@E84@,zxl@ߤ?@Z@/V@S&@~($@rG@4m@4K@m8@|@g	l@ᰊ@o@O
M@U=@^@@xF@wkQ@	@1&@@Z@*0U2@@@qiC@S&@}E@rs@]cA @T`d@L/{J#@B\(@73@.zG@ [6@'/W@
=p
@($x@!.@PH@@P{@Ov`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @@+S&@@+q@@+a@O@@+a@O@@+Q@@,/@@.%@@/,@@/'/W@@/;dZ@@/H˒:@@/O
M@@/O
M@@/H˒:@@/RT`e@@/_o@@/As@@/.H@@/.H@@/4֡a@@/'/W@@/+I@@/y@@0D*@@0r Ĝ@@1@@23@@26C@@2S&@@3s@@3J#9@@3lC@@4q@@5Q@@5
qv@@6҈p;@@7@@7[W>@@8
qu@@8IQ@@8TɅ@@8$tT@@9JE@@9o hی@@9Y}@@:L_@@:~@@;PH@@;{J#9@@;a@O@@;Q@@<9XbN@@<C@@<zxl"@@<N;@@=ce@@=H˒@@>t@@>}Vl@@>!.I@@AD@@FBZc @@G hۋ@@J{m@@Lzxl"@@N_ح@@Qo@@R`A@@R74@@S/V@@S	@@S9@@T1&y@@U2a|@@WrG@@Y-w1@@Z3@@_y@@c҉@@g'/W@@hu%F@@i*0U2a@@i@@n5?|@@pѷX@@s=K^@@x}H@@حV@@C\@@jf@@Y|@@.2@@E@@!.@@_ح@@'/W@@|Q@@9XbN@@=K@@O;d@@u!S@@`A@@p
=@@R<6@@@@qu!@@}H@@u!@@Y}@@,zxl@@u"@@E@@-@@@@C,zx@@8YK@@o@@D@@ [7@@s@@\(@@I^5?@@@@>@@!R<@@RT`e@@~"@@ʬ>B@@ˋq@@84֡@@Ov_خ@@حV@@D@@,zxl@@ըXy=@@C-@@     @@ěT@@Ov`@@PH@@Fs@@ܲ@@e@@@@Z@@'0@@zxl"h@@ݮ1@@޵'@@Vϫ@@\)@@Gz@@T`d@@u%F
@@L/{@@,<@@W>6z@@Mj@@Z1@@?@@7@@?|h@@C\@@qi@@1@@RT`e@@_o@@KƧ@@kP@@fA@@>BZc@@ěT@@rGE@@邩@@鰉'R@@ڹY@@lC@@e@@ce@@퇓ݗ@@sh@@b@@?@@S@@_o @@4K@@!R<@@Vu@@+@@$tS@@Xe,@@iDg8@@阮&@@ﴢ3@@ﴢ3@@/V@@u!@@)@@4J@@Dg8~@@fA@@O;@@.2@@,=@@!-w@@,<@@"h	ԕ@@3@@q@@PH@@?@@_@@<쿱@@wkP@@Z@@fA@@As@@6C@@]cA@@A@@Q@@C]@@"h	ԕ@@Ʌoi@@>B[@@u"@@/@@D@@e@@e@@JM@@>B[@@Z@@JM@@Q@@[@@(@@\@@p
=@@sg@@$/@@}H@@hr!@@%@@@@H˒@@1@@S@@C\@@ ѷY@@ ѷY@@.2@@_ح@@+J@@+J@@R<6@@C-@@As@@_o@@4m@@4m@@	@@r@@;dZ@@˒:)@@@@@@@@4m9@@73@@K]c@@-
@@9Xb@@)@@	k~@@+@@ [7@@Dg8~@@7KƧ@@XbM@@ae@@rGE8@@n.@@@@'R@@2W@@@@u%F@@s@@	 @@lD@@-@@e+@@@@n@@䎊@@@4n@@@4n@@JL@@Q_@@a|Q@@d7@@d7@@kP|@@xl"h
@@@4@@>B@@Y@@@@,<@@c	@@s@@"`B@@"`B@@&@@&@@)^	@@,zxl@@@N@@6z@@6z@@9@@,zxl@@/V@@C%@@9@@Q@@Mj@@@@eO@@dZ@@W>6z@@P{@@9@@6z@@n.3@@jf@@@@xF]@@{J#9@@ߤ@@*0U2@@:)z@@S@@Z@@a@O@@ߤ@@@Q@@/{J#@@%1@@n.@@s@@s@@1&y@@*0U2@@q@@MjO@@Z@@,zxl@@nP@@ ѷ@@n@@S&@@vȴ@@\(@@~"@@&IR@@JE@@JE@@$tT@@hۋq@@#@@Vϫ@@o @@͞@@͞@@>6z@@Ov_خ@@
qv@@n/@@!R@@cA @@S@@ ѷY@@
L/@@@@!R<@@L/{J@@_ح@@$xG@@u%F@@vȴ@@Y@@@@=p
@@s@@X@@@@6@@b}V@@!-w1@@>6z@@ěT@@B@@Ov`@@ݘ@@'/@@m\@@҉@@C%@@Z@@U=@@Q@@$@@ߤ@@m]@@a@O@@~($@@6@@|@@
=p@@҈@@ݗ+k@@҈@@
=p@@a@@@Z@@dZ@@~$@@U=@@~$@@W>6z@@W>6z@@=K^@@@@@@"h	ԕ@@M:@@g8}@@qj@@qj@@zG@@o h@@zxl"@@!-w@@E@@!.H@@5Xy>@@%F
L@@B@@jOv@@}H@@ڹZ@@$/@@S&@@S&@@\(      @@ᰉ@@oiDg@@.2@@Ov_خ@@l!-@@_ح@@.2@@5?|@@_ح@@@@(@@S@@ᰉ@@@@_o @@'/W@@
M;@@v@@E84@@O
M@@3@@K]d@A r Ĝ@A ѷX@A D@A+@A=b@AXbM@AR<6@A|@A@Ae@A>BZ@A@Ao hی@Ak~(@Ab}@A@Ak~(@A d8@@&@@@@@@rGE9@A      @A Xy=@A l"h	@A r Ĝ@A -
@Ae@A>B@AڹY@AfB@A~@AI^@A҉@A"`B@An.3@AƧ@AZ1@A@A(\@A1&y@A҈@AƧ@A@A$@A?@A?@Aj~@Ag8}@A$@APH@A_@A#x@A/@A@A'0@A(@A[@A'0@AV@AE@AF
L0@A}H@A%@An/@A4K@AIQ@Aȴ9X@A@Av@A$tS@A4֡a@AH˒:@Aeں@Ao@A{J#:@AkP@Avȴ9@A-@AbM@A
qu@AU@A	@A	7KƧ@A	JE@A	TɅo@A	rGE8@A	R<6@A	B@A	o@A	-@A
s@A
&IR@A
6C@A
JL@A
W'@A
u%F
@A
S&@APH@AeO@AE@A~($@AM:@A
sg@A($x@A($x@A5?|@A.2@A@A!R<@AOv_@AOv_@A
8Y@A
sh@A
@A
=K@A
b@A
(@A4K@A+jg@AH@Avȴ9X@Aaf@A쿱[W@A     @A@A`A7@A+@A-w1@ADg8~@ATɅo@Ae+a@Au!S@A7Kƨ@AN;6@A#9@Aa|Q@AL/{@A6z@A5Xy@A`d@A*0@Au@AS&@AM:@A8Y@Ab@AOv_@A\N<@A}Vl@A@AMj@A@A"@AMj@A,@A+I@A4֡a@AH˒:@AXe,@AsPH@AsPH@A@A/V@AK]d@A;dZ@AbM@A1&x@A[6@Au!@AC@A0
)@A=b@AQ@Ahr @Ax@A~($@An.@A@AiB@As@AlD@Ad7@A~"@Axl"h
@A\(@AS&@A@A䎊q@AG{@AC,@A͞&@AW@An@A}Vm@A)_@A@AW@AC,@APH@Ajf@AU=@AA [@A"h	ԕ@AI^5?@AwkP@A?@ASMj@Aq@A*0@A!-w@A(@AjOv@Ap
=@Asg@A}H@A}H@AڹZ@A1@A-V@A_o @Afffff@A}Vl@AIQ@A@AO;@A@A-@A6z@A}Vl@Am\@A]cf@AMj@A!-w1@A'/W@AKƧ@A{J#:@A-V@A[W>@A 	ԕ+@A y=c@A @A -
@A 9Xb@A ěT@A @@A e+@A!_p@A!XbM@A!n.@A!y@A!@A"s@A"3@A":)y@A"xl"h
@A"D@A#u%@A#҉@A#PH@A#/V@A#J#9@A#jf@A#~$@A#q@A#ߤ@A#q@A#Ƨ@A#\N@A$n.@A$xF@A$tj@A$tj@A$tj@A$%1@A$,<@A$C,zx@A$cA \@A$j~#@A$~($x@A$qj@A$S@A$S@A$*1@A$_@A$쿱[@A$O
M@A$/@A$D@A%:@A%'0@A%[@A%*0@A%Q@A%!.H@A%Q@A%(@A%<64@A%p
=@A%+j@A%sh@A%8Y@A%Ϫ͞@A%Ϫ͞@A%(@A%!.@A&_o @A&($x@A&H@A&l!-@A&qi@A&af@A&&I@A&ߤ?@A&&I@A&҈p;@A&x@A'Ft@A'+I@A'4֡a@A'As@A'KƧ@A'\(@A'_o@A'v_ح@A'@A'[W>@A'[W>@A'o @A'@A(@A(bM@A($xG@A(NU@A(bM@A(u!@A(@A(IQ@A(U@A()@A()^@A(e+@A(4֡b@A(@A(C@A(4֡b@A(C@A(\)@A($tT@A) ѷ@A)	k~@A)rGE@A)&x@A)N;5@A)[W>6@A)e+a@A)|Q@A)|Q@A)oiD@A)~($@A)~($@A)'RTa@A)l@A)|@A)y@A)iB@A)Y}@A*I^5@A*)y@A*䎊@A*#9@A*=p
@A*GE85@A*JL@A*^5?|@A*a|Q@A*nO@A*{m@A*ݘ@A*L_@A*0
@A*vȴ@A*n@A*sP@A*fB@A*D@A+I^@A+'/@A+u%@A+PH@A+33333@A+P{@A+Z@A+q@A+S@A+6@A+5Xy@A+|@A+Q@A+҈@A+A [@A,ߤ@@A,9XbN@A,VϪ@A,zG@A,zG@A,#@A,*1@A,*1@A,S@A,1&@A,@A,@A,?@A,#x@A,#x@A,7@A,@A,@A,Z@A,Z@A,JM@A,u"@A,D@A-:@A-K]@A-'0@A-Q@A-84֡@A-?|h@A-Y|@A-1@A-U=@A-sh@A-\(@A-Ϫ͞@A-
qv@A-,=@A-C\@A-C\@A-C\@A-C\@A. ѷY@A._o @A.
L/@A.4K@A.zG@A.zG@A.@A.Ov_@A.$/@A.($x@A.($x@A.($x@A..2@A.8YJ@A.1.@A.8YJ@A.5?|@A.8YJ@A.8YJ@A.?@A.L/{J@A.H@A.R<6@A.fffff@A.p:~@A.%@A.IQ@A.}Vl@A.+J@A.af@A.҈p;@A.!.I@A/$tS@A/_o@A/4m@A/&@A/	@A/O;d@A/ݗ+@A/ݗ+@A/?@A/vȴ9@A/o @A/vȴ9@A/K]d@A/˒:)@A/حV@A/+@A/@A/@@A/@A/@A/rG@A/Vϫ@A/rGE9@A0	ԕ+@A0bM@A0bM@A0@A0$xG@A0-
q@A073@A0A7K@A0K]c@A0K]c@A0U2a|@A0_F@A0hۋq@A0y=c@A0-
@A0U@A0`A7@A0PH@A1@N@A10
)@A1JE@A1e+a@A1@A1e@A1e@A1iB@A1s@A1-@A2u%F@A2@A2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @qffffff@qi@qffffff@qffffff@qh     @q\@qP     @qI@qI@qQ@qY@qX     @qT@qY@qY@qT@q[33333@q\@q\@q^fffff@qa@qa@qd@qc33333@q\@qa@q^fffff@q\@qVfffff@qNfffff@qL@qP     @qL@qD@qC33333@q333333@q(     @q(     @q(     @q(     @q(     @q!@q#33333@q#33333@q@q@q@q@qfffff@q33333@q     @q@qfffff@q@qfffff@q      @pfffff@p@pfffff@p񙙙@p     @p9@pS33333@pfffff@o|@nə@n#33333@n#33333@n\@nvfffff@nfffff@n@nL@m     @mc33333@mP     @m#33333@lfffff@k@k@ki@kY@kC33333@j陙@j@jVfffff@ifffff@i      @h9@g33333@g@g     @gfffff@g33333@g33333@g33333@gvfffff@gFfffff@g@ffffff@f     @f     @f<@f      @f<@f33333@f     @fٙ@f33333@fvfffff@f      @e33333@e     @e,@d     @dfffff@dY@d      @d@d@d@cٙ@c33333@c0     @c      @b     @bə@b33333@b     @b33333@b     @bl@b6fffff@b33333@a@a@a@a     @al@a@     @a33333@a	@a     @a33333@a33333@a     @a33333@afffff@`陙@`@`33333@`     @`|@`y@`33333@`fffff@`fffff@`33333@`Ffffff@`0     @`)@`     @_33333@_ٙ@_     @_     @_@_33333@`33333@`	@_y@_333333@_@_Ffffff@_ffffff@^@^@],@\33333@\33333@\fffff@\@\@\@\@\@\33333@\     @\y@\`     @\Ffffff@\9@\&fffff@\@     @\l@\33333@\s33333@\@     @\S33333@]&fffff@^fffff@`      @``     @`@`@aY@a@afffff@ai@avfffff@a33333@a@a     @a     @a@afffff@`@_@]33333@]      @]      @\@\fffff@\fffff@\@\ٙ@\@\@\fffff@\S33333@\      @[fffff@[33333@[     @[@[     @[ٙ@[@[33333@[33333@[@[33333@[@[33333@[33333@[fffff@[@[fffff@[y@[l@[L@[      @[      @Z33333@Z@ZS33333@Z&fffff@Z&fffff@Z333333@Z@     @Z9@Z333333@Z9@Zfffff@Z33333@Z33333@Zfffff@Y@Y@Y33333@Y33333@Yfffff@Y     @Y     @Y@Yy@Yl@Y`     @YY@YS33333@Y@     @Y,@Y&fffff@Y      @Y33333@Y33333@Y@X33333@Xٙ@X     @X33333@Xٙ@Xfffff@Xٙ@Xfffff@X@X@X@X     @X@X@X     @X@Xs33333@X`     @XY@XS33333@XFfffff@X@     @X@     @XFfffff@X333333@X&fffff@X      @X      @Xfffff@X      @W33333@W33333@W33333@W@W     @Wfffff@W     @W@Ws33333@W@     @W      @W      @W@W      @V     @Vٙ@V@V33333@V      @Ufffff@U     @V      @Ufffff@U33333@U@U@U33333@Uy@U@     @U      @U9@U@V9@Vy@V33333@V33333@V     @Vfffff@W@W@     @WS33333@W`     @Wffffff@W     @W     @W33333@W@Wfffff@Wٙ@Xfffff@X     @X@Y333333@Y@Y@Z33333@Z9@Z@     @Z9@Z`     @Z@[fffff@\fffff@\@[@[fffff@[s33333@[@     @[&fffff@[&fffff@[fffff@Z33333@Yfffff@X      @VL@V&fffff@VL@V     @W@W`     @Wfffff@Xfffff@Y33333@Yl@Yffffff@X@W@Vٙ@V@     @Uٙ@U@U@Ul@U      @T@Tfffff@T@T     @T33333@T@T@T@Tfffff@T@T@T@T     @T@T     @T33333@Tfffff@T@T33333@T@Tfffff@Tٙ@T@T33333@Tl@T33333@S     @S     @Sfffff@S     @Sl@Sffffff@Sffffff@SS33333@S@R@R     @R@R@Ry@R@     @R&fffff@R@Rfffff@R      @Q33333      @Q     @Q     @QL@Q9@Q,@Q33333@Qfffff@P@P@P     @Pfffff@P33333@P     @P     @P@O33333@Offfff@OL@O&fffff@N33333@N@N@N@M@ML@M      @L33333@L     @LL@L&fffff@L@L      @Kfffff@Kfffff@L      @L&fffff@L&fffff@Kٙ@Kfffff@Lffffff@L     @M      @M@L33333@L@Lfffff@L@L     @L333333@KL@JL@I@I@Ifffff@I@I@I     @I&fffff@I      @Hffffff@H@H&fffff@HL@H     @H@Hfffff@H@H@     @G@G33333@Gٙ@H      @H      @Gٙ@Gfffff@Gs33333@Gs33333@Gffffff@GY@GL@G333333@G      @G@G      @F33333@F     @F     @F@     @E@E     @EY@E@E      @E@Dfffff@Dٙ@Dٙ@D33333@D@D33333@D@Ds33333@D@     @D      @C33333@Cs33333@CY@C&fffff@C@B33333@B33333@Bfffff@B@B33333@Bfffff@Bs33333@B     @BY@BL@BL@A33333@Afffff@A@     @A&fffff@@@@&fffff@?L@>     @>L@>L@>     @>     @>@>fffff@?@?L@?@?@?33333@?33333@?ffffff@?@>fffff@>@>L@=33333@<     @;     @:@:     @:L@:      @:     @:@:      @9@9L@9L@9      @8L@7     @6@6L@5ffffff@4@433333@4@4333333@4      @333333@3@3ffffff@3     @3      @2@233333@3L@3333333@3      @2fffff@3      @3      @2fffff@3      @3ffffff@3@2fffff@3      @2fffff@2fffff@2@2     @2L@2333333@133333@1@1@1@1@1     @1L@1ffffff@1ffffff@1333333@0fffff@0L@0@033333@0@0L@0L@0     @0ffffff@0      @/@/@/@/@/333333@/ffffff@0      @/ffffff@/ffffff@/@/333333@/333333@/      @/      @.@.@.ffffff@.333333@.      @.333333@.ffffff@.      @.      @.      @.ffffff@.      @.      @-@-ffffff@-      @,@-333333@,@,@,@,      @,ffffff@-      @,ffffff@,333333@,ffffff@,ffffff@,333333@+@+@+@+@+333333@+@+ffffff@+      @*@+333333@+333333@+333333@*@*ffffff@*@*@*@*333333@)@*      @*      @)333333@)@(@(@)      @)333333@)      @(ffffff@(@(@(@(@(@(@(333333@(ffffff@(ffffff@(      @(333333@(@(333333@(333333@(333333@(333333@(      @(333333@(333333@(333333@(333333@(333333@(      @'@(      @'@(      @(      @'@'@'@'@'@'@(      @'333333@'ffffff@(@'333333@'@'@(      @'ffffff@'@'333333@'      @'333333@&@&@&ffffff@&ffffff@%@%333333@%@%@%@%@&ffffff@&333333@%@&      @%@%ffffff@%333333@%@%@%@%ffffff@%@&      @%@%@%@%ffffff@%ffffff@%@%333333@$@%333333@%      @%      @%      @%333333@%333333@%333333@%333333@$@%      @%333333@%333333@$@$@%      @%333333@%      @$ffffff@$@%      @%      @$@$@%      @$@$ffffff@$@$@$ffffff@$@$@$@$@%333333@$@$ffffff@$      @$ffffff@%      @$@%333333@$333333@$@$      @$@$@$@$@$      @$@%      @$ffffff@$@$@%      @$      @$@$@$@$@$@%      @$ffffff@%333333@%333333@%      @%333333@$@$@%333333@%      @$@%      @%ffffff@%333333@%333333@%333333@%      @%333333@%333333@$@%      @$@%333333@%333333@%      @$@%      @%@%      @%333333@$@%333333@%333333@%      @%333333@%      @%333333@%333333@%      @%      @%333333@%      @%ffffff@%      @$@%ffffff@%      @%@%      @$@%      @%      @$@%333333@%333333@%333333@%333333@%333333@%      @%333333@%      @$@$@%333333@%ffffff@%333333@%333333@%333333@%333333@%@%333333@%ffffff@%@%@&ffffff@%@&      @&      @%@&      @&ffffff@%@%@%@&@%@&      @%@%@&@&      @&      @%@%@%@&333333@%ffffff@%@&ffffff@&ffffff@&      @&      @&333333@&      @&      @&      @&ffffff@%@&ffffff@&333333@&@&ffffff@&333333@&@&@&@&@&@'      @'ffffff@'                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ?ݡo?"`?߮zG?zG{?"`?QR?$/?tj?;dZ?E?Q?ěS?/w?7KƧ?噙?xF?n?
=p
?柾vȴ9?I^5?S?ȴ9Xb?KƧ?旍O;d?E?I^5??zG?E??|hs?1&x?-V?333333?~"?ᙙ?n?|hr??"`?m?9XbM?+?tj?Ƨ-?ܛS?r ě?KƧ?ȴ9Xb?
=p
?5?|h?lC?\(\?ԋC%??Q??+?ӕ$/?ӶE?tj~?S?
=p?\(\?bM?      ?ϝ-V?hr!?ɺ^5?|?1&x?ȴ9XbN?XbM?p
=q?xF?E?7KƧ?ȴ9Xb?$/?tj?`A7K?šo?ěS?S?\(?nO?l?n?M?hr Ĝ?bM?      ?E?E?/v?/v?hr!?-V?hr!?(\)?p
=q?p
=q?j~"?(\)?vȴ9?-V?"`B?1&?Gz?hr!?E?j~"?5?|h?vȴ9X?p
=q?p
=q?vȴ9X?dZ1?dZ1???E?QR?+?+?ȴ9Xb?+I?+I?$/?$/?j~#?9XbM?tj~?E?+?l? ě?Q?`A7L?
=p?`A7L?
=p?
=p?vȴ9X?;dZ?vȴ9X? ěT? ěT?;dZ?bM?
=p?
=p?vȴ9X?;dZ?;dZ?;dZ?Q?5?|h?Q?5?|h?5?|h?-V?/v?5?|h?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?Q?5?|h?5?|h?Q?5?|h?-V?5?|h?5?|h?;dZ?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?5?|h?Q?-V?-V?-V?Q?5?|h?-V?5?|h?5?|h?-V?-V?-V?-V?5?|h?/v?/v?-V?1&y?1&y?1&y?1&y?1&y?/v?-V?-V?1&y?1&y?1&y?1&y?-V?1&y?-V?/v?1&y?/v?/v?Q?5?|h?5?|h?5?|h?/v?-V?-V?1&y?/v?-V?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?-V?-V?-V?-V?vȴ9X?-V?5?|h?-V?Q?-V?-V?-V?-V?5?|h?5?|h?5?|h?-V?Q?-V?-V?-V?/v?/v?Q?Q?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?5?|h?-V?Q?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?Q?Q?-V?Q?5?|h?5?|h?5?|h?5?|h?;dZ?Q?5?|h?-V?5?|h?Q?5?|h?Q?5?|h?Q?5?|h?5?|h?-V?5?|h?Q?5?|h?-V?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?-V?5?|h?;dZ?Q?5?|h?5?|h?Q?-V?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?Q?Q?-V?5?|h?-V?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?5?|h?Q?Q?Q?5?|h?-V?;dZ?Q?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?vȴ9X?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?;dZ?Q?5?|h?;dZ?5?|h?Q?Q?Q?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?5?|h?;dZ?5?|h?Q?5?|h?5?|h?Q?;dZ?5?|h?Q?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?Q?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?;dZ?;dZ?5?|h?Q?Q?5?|h?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?5?|h?Q?Q?Q?;dZ?Q?Q?;dZ?Q?-V?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?-V?Q?;dZ?Q?;dZ?Q?Q?;dZ?Q?5?|h?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?5?|h?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?
=p?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?Q?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?vȴ9X?vȴ9X?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?Q?Q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @     @陙@|~fffff@x33333@xٙ@r@qy@n@lC33333@i@gl@eVfffff@c0     @bI@`     @\@\33333@Y@W      @UFfffff@S@R9@P     @N@K33333@J@Hٙ@G@     @E@Cfffff@Bfffff@A&fffff@>fffff@<@;      @8fffff@7      @5     @4L@2@2      @1333333@0333333@.ffffff@,ffffff@*ffffff@(@'@&@%333333@$333333@#      @!@ @@333333@333333@@      @      @ffffff@333333@      @@333333@
@      @	@      @ffffff@@333333@ffffff@ ?ffffff??333333??      ?ffffff??333333?񙙙?      ??陙?ffffff?ffffff?333333?333333?      ?      ?ٙ?ٙ?333333?333333?333333?333333?ə?ə?ə?ə?ə?ə??????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P4                                      3                                       )BBIU3X