CDF       
      time      pressure     latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        40     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:22.430296Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_040 (40) * LATITUDE: 40.700000 * LONGITUDE: 2.280000 * DATE/TIME: 2016-08-27T10:31:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      7  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
  ^   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*H$xG   data_max      @:7lC   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       7  l   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
  \   salinity               	long_name         salinity   units         PSS-78     data_min      @CH   data_max      @CHD*   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      7  H   salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
     oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @eR<6   data_max      @pPH   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        7     	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
 /   CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?)y   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      7 =   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
 u0   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ə   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     7    CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d      
    time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &-   data_max      &-   C_format      %10d       ȸ   latitude               	long_name         latitude   units         	degrees_N      data_min      @DY   data_max      @DY   C_format      %9.4f          ȼ   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @=p
=   data_max      @=p
=   C_format      %9.4f             	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3;   data_max      3;   C_format      %8d           	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d           station                	long_name         STATION    units         unspecified    C_format      %s        (    cast               	long_name         CAST   units         unspecified    C_format      %s        ( @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @:7lC@: hۋ@9tSM@9"`@98}H@8/o @7fffff@78}H@7{=K^@7np:~@7\1&y@7I@7;"`B@7)@7tSM@6
L/@6/V@6lC@6䎊r@6kP{@6Qae@6E`A7L@6.p:~@6@6m@5m\@5KƧ@5̑N;@5@5}K]@5<@4e+a@4NU@4tFs@4[6@3fA@3"wkQ@2+j@2:S@2(@@2@1@1O-V@1=O;dZ@1$g8}@0Շݗ@0:~ @0C{J#9@0
=p@/_p@/S@.O;dZ@.q@.R@.r:)y@.#A [@-~($@-A7K@-H˒:@-W'@-[dZ@-4D@- 4m@,	k~@,˒:*@,v@,G{@,zxl"@,P{@,xl"h	@,]<64@,Ik~(@,=!.H@,;=K^@,/O
M@,u%@+>@+U2a|@+
=p@+~$@+@+҈p:@+KƧ@+և+J@+-
q@+v@+ͫU=@+RT`e@+C@+sPH@+?@+,<@+iDg8@+rGE@+
(@+@+a@N@+y	k~@+s&@+p@+hXy=@+dqj@+]E@+Y(@+L_@+BC,@+?	@+;Q@+>%@+C{J#9@+>쿱[W@+;m]@+AR<6@+@	k@+FL/{J@+KU=@+VC-@+[dZ@+Y+@+V+J@+RGE85@+OVϫ@+Rs@+WrG@+eF
L0@+gy@+g@+bZc@+LC@+6Ov_@+3g	l@+6C-@+9XbM@+..2@+\(@+@+}Vm@*:)y@*!R<@*w1@*_@*}Vl@*@@*ڹZ@+s@+	ԕ*@+qi@+s@+MjO@+sg@+_ح@+Ϫ͞@+Z@+p:@+~($x@+ 6@*C\@*p:@*o@*
(@*{J#:@*@*D@*n@*!-w@*(@*Mj@*U2a|@*䎊@*2a|@*!R@*=K@*Ϫ͞@*Ϫ͞@*=K@*?@*+jg@*Fs@*C-@*>6z@*O;d@*@*eں@*O;d@*YJ@*0
)@*S&@*6@*m]@*S@*m]@*Q@*n.@*]ce@*E@*ce@*A@*"`B@*C\@*#w@*bM@*t@*SMj@*33333@*W@* ě@* ě@*<64@*䎊q@*PH@*33333@*g	l@*E@*g@*!-w2@*zG@*!R@*$tS@*bM@*S&@*Vl!@*b@*Ft@+ d8@+ 	k@+o@+`A@+{J#9@+tj@+7@+/@+84֡@+S@+]cf@+r Ĝ@+
ڹY@+q@+҈@+/{J#@+VϪ@+@+
:@+
U=@+}Vl@+4֡a@+\(@+v_ح@+'/W@+
@+
(@+
:@+@+@+@+C@+@+~($@+
L/{@+	@+	7KƧ@+r Ĝ@+RT`e@+@+&I@+A@+8}H@+y@+	ԕ+@+˒:*@+@+	x@+
͞&@+]cA@+C%@+
D@+
0
@+
0U2a|@+
qiC@+
͞&@+'/@+6z@+P{@+P{@+C,z@+
d7@+	ԕ*@+u@+7@+ [7@*?@*/w@*쿱[@*wkP@*J#9@*G{@*ݘ@*Q_@*~($@*F@*bM@*4֡b@*(@*>BZ@*D@*PH@*@*Xe@*@*8YJ@*?@**1@*@*a|Q@*@*TɅ@*9Xb@*@*K]d@*fffff@*+a@*eO@*tj@*M:@*o h@*?@*o i@*m\@*8YK@*,@*fA@*'@*JM@*Z1@*%1@*%1@*tj@*n.3@*@*@4@*⩓@*⩓@*@4@*I^5@*@N@*@N@*&IR@*\(@*o hی@*@*,=@*ݥv@*ۘA@*s@*"`B@*ٙ@*}H@*ٙ@*"`@*^5?|@*kP|@*ڬ>B@*ڹY@*G{@*~@*qu!@*n.@*]ce@*wkP@*wkP@*lC@*Q@*C\@*@*և+J@*8YJ@*ᰉ@*%F
L@*J@*hr @*|@*o @*O
M@*ϐ@*ϝ-V@*Ϫ͞@*@*@*;dZ@*а{@*ќu@*A [@*A [@*iB@*g@*ԇ#@*J@*g	l@*nO@*$tT@*\(@*ΗO;@*}Vl@*}Vl@*\(@*ϝ-V@*As@*ΗO;@*!R<@*_o @*v@*Ϸr@*σ{J#:@*As@*As@*
M;@*t@*α2X@*ξߤ?@*}Vl@*Vu@*+@*ξߤ?@*̈́M:@*͞%@*jOv@*w1@*͑hr!@*B@*B@*\@*\@*O;dZ@*5Xy>@*5Xy>@*(@*V@*@*̋C@*~($x@*q@*"h	ԕ@*˹~($@*˹~($@*˒:)z@*D@*d7@*Q@*$xG@*@@*fA@*&I@*?@*fffff@*ƍ@*ƀIQ@*?@*1.@*
L/@*@*ŔO
@*š@*`A7L@*u@*ĨTɆ@*ĨTɆ@*ĨTɆ@*g8}@*Z1@*tj@*ÈeO@*ÈeO@* ѷ@*wkQ@*M@*$/@*NU@*
qu@*	@*Ov_خ@*v@*IQ@*>@*wkP@*lC@*S@*q@*qu!@*"`B@*>B@*ݘ@*u%F@*>BZ@*"`B@*6C@*-
@*_F@*+@*af@*+J@*l!-@*8YJ@*4K@*\(@*L_@*E@*3@*MjO@*:)y@*[W>6@*@*{@*D@*@*@*As@*'/W@*t@*@*V@*@*zxl"@*cA \@*<쿱@*s@*:)z@*C,z@*I^@*g	@*L_@*0U2a|@*'RTa@*@*fA@*,@*)^@*A@*&I@*,<@*,<@*'@*L/{J@*oiDg@*zxl"h@*u@*o i@*S@*@*eO@*{J#9@*n.3@*n.3@*a@N@*h	ԕ@*&IR@*e+@*.H@*R<6@*|Q@*Gz@*ěT@*IQ@*4m@*ěT@*4m@*-
@*[6@*6@*U=@*쿱[W@*"@*!-w1@*@*%@*}H@*<64@*#x@*wkP@*C,zx@*64@*C,zx@*Q@*n.@*q@*W>6z@*J#9@*"`B@*c	@*xl"h
@*e+a@*73@*>6z@*l!-@*!.@*?@*sh@*Y|@*2a|@**0@**0@*%F
L@**0@*%F
L@**1@*9XbN@*@*@N@*-V@*iB@*u!S@*{@*D@*`A7@*:~ @*@*'/W@*;5X@*8Y@*O;dZ@*cA \@*"h	ԕ@*/{J#@*L_@*]cA@*C%@*'/@*ڹY@*=p
@*ԕ*@*rGE@*ۋq
@*@*K]c@*/V@*	k@*	k@*,<@*$/@*84֡@*Z1@*%2@*Z@*Z@*a@N@*F]c@*74@*}Vm@*u%F
@*h	ԕ@*e@*o@*Gz@*Gz@*Gz@*Gz@*$/@*IQ@*4m9@*U=@*~"@*~6z@*~iB@*~
(@*}+j@*}}H@*}!.H@*|wkP@*{5Xy@*{=K^@*{u%@*{u%@*{u%@*z,<@*zvȴ@*zvȴ@*zY@*zvȴ@*zS&@*zxl"h
@*zC\@*z)y@*zkP|@*zxl"h
@*zݘ@*zvȴ@*zY@*z>B@*zS&@*zS&@*z^5?|@*z1'@*yD@*yrGE8@*yJE@*y0
)@*y+@*xF@*xU@*xF@*x)@*xD*@*x}H@*x}H@*w+j@*w3@*wO;d@*wKƧ@*vC-@*vaf@*uϪ͞@*usg@*u'0@*tSMj@*t,<@*t@*sݗ+k@*stj~@*rsP@*rm@*rm@*r<64@*r䎊@*qu!S@*q[W>6@*qhr @*qA [@*qA [@*p{@*poiDg8@*poiDg8@*poiDg8@*o@*oVϫ@*oAs@*o hۋ@*o hۋ@*n1@*nߤ?@*n_o @*m5Xy>@*m(@*m5Xy>@*m5Xy>@*l@*lVϪ@*l"h	ԕ@*l1&y@*ks@*ka@@*k:)z@*kU=@*kU=@*k:)z@*k6z@*jڹY@*jfB@*kI^@*jD@*k'/@*k'/@*jfB@*jL/{@*jOv`@*iB@*h@*hu%F@*hr Ĝ@*hr Ĝ@*h˒:*@*h˒:*@*h@*hu%F@*h@*hXy=@*g-@*g/V@*glC@*f]cf@*f'@*f&I@*fs@*f?@*f
L/@*eoiDg@*e@*eQ@*d/@*d/@*dJM@*dJM@*dJM@*dTɆ@*do h@*dxF@*c
=p@*ceO@*cF]c@*cF]c@*c	@*c,zxl@*c,zxl@*c9@*c9@*c,zxl@*cS&@*b@*b&IR@*ae@*as@*ao@*aR<6@*a|Q@*ao hی@*a:S@*aGz@*a [7@*`C@*`d8@*`IQ@*`-
@*`u!@*`NU@*`NU@*`NU@*`     @*_䎊r@*_˒:)@*_|hs@*_H˒:@*_Ft@*^ߤ?@*^6z@*^m\@*^$t@*^5?|@*^u@*^u@*^($x@*^
(@*],=@*]H˒@*]cA @*][@*\1&@*\쿱[@*\쿱[@*\?@*\쿱[@*\N;@*\j~#@*\wkP@*\wkP@*\N;@*\?@*\]ce@*\n.@*[lC@*[5Xy@*[W>6z@*Z~@*ZG{@*Z~@*Zc	@*Zc	@*ZY@*ZQ_@*Z1'@*Z@*Zu%F@*Zu%F@*YY}@*YY}@*Y|@*Y+@*XF@*X)@*XU@*XYJ@*X_F@*XD*@*X73@*X73@*X73@*XD*@*X*0@*XbM@*XbM@*XF]d@*W+@*W&@*WO;d@*W&@*WKƧ@*WXe@*WXe@*W
=p@*VϪ͟@*V}Vl@*VFs@*Vl!-@*VE@*V+jg@*VOv_@*Uᰉ@*U\(@*Usg@*UY|@*U%F
L@*TO
M@*T3@*T3@*TzG@*TzG@*TSMj@*T,<@*S@*Sݗ+k@*SE@*Sݗ+k@*S|@*S*0U2@*Sg	l@*S@N@*RsP@*RnO@*RGE85@*RGE85@*RGE85@*R䎊@*R䎊@*QR@*Q2W@*QX@*Ql@*Qhr @*QN;5@*Qhr @*Qhr @*Qhr @*Q[W>6@*QA [@*P$tT@*PD@*PD@*P)^@*P)^@*P{@*PoiDg8@*P ě@*O;dZ@*O-V@*OO
M@*OAs@*Ov@*NMj@*Nt@*Nt@*N+@*N+@*O hۋ@*Ov@*NT@*Np:~@*Np:~@*Nc	@*NH@*N!R<@*N_o @*MC\@*M(@*MC\@*M8Y@*MjOv@*MO;dZ@*MB@*M\@*Mw1@*Mw1@*M\@*M5Xy>@*L!-w@*L@*L[W?@*Lzxl"@*Lzxl"@*LcA \@*LVϪ@*L<쿱@*Ks@*KƧ@*KƧ@*K~($@*KU=@*KxF]@*Kjf@*Kjf@*Kjf@*KP{@*KC,z@*JD@*JfB@*JD@*JD@*J͞&@*Jn@*J0
@*J0
@*JL_@*JL_@*JL_@*Jd7@*J=p
@*JJL@*JOv`@*IlD@*IlD@*IlD@*IlD@*IlD@*IlD@*I@*I@*Iԕ*@*I^5?}@*I^5?}@*I^5?}@*I^5?}@*I^5?}@*IB@*I^5?}@*I^5?}@*IB@*I@*Ik~(@*IDg8~@*I^@*Ik~(@*Ik~(@*Ix@*I^@*I^@*I^@*IoiD@*Ix@*IoiD@*I^@*I^@*I^@*Ik~(@*Ix@*IoiD@*I@*I'RTa@*IB@*Ix@*I*0U2a@*H\)@*Hۋq
@*HTɅ@*H@*Hu%F@*Hu%F@*H˒:*@*H>BZc@*H$xG@*H$xG@*H>BZc@*H>BZc@*HK]c@*HXy=@*HXy=@*H˒:*@*H@*H@*H@*Hu%F@*H@*Hr Ĝ@*Hr Ĝ@*H˒:*@*H˒:*@*H˒:*@*H@*H@*H@*HTɅ@*H9Xb@*H9Xb@*HTɅ@*HTɅ@*Hp:@*HTɅ@*H9Xb@*Hu%F@*H@*H@*H@*H˒:*@*Hr Ĝ@*H@*Hu%F@*H9Xb@*H9Xb@*H˒:*@*H@*H@*Hu%F@*H˒:*@*Hr Ĝ@*Hr Ĝ@*H˒:*@*HeO@*H˒:*@*H˒:*@*Hr Ĝ@*Hu%F@*H@*H@*Hr Ĝ@*HXy=@*HeO@*Hr Ĝ@*Hr Ĝ@*H˒:*@*Hr Ĝ@*Hr Ĝ@*Hr Ĝ@*HXy=@*HXy=@*HK]c@*HeO@*Hr Ĝ@*Hr Ĝ@*HXy=@*HK]c@*H>BZc@*HK]c@*HXy=@*HK]c@*HK]c@*HeO@*Hr Ĝ@*H˒:*@*H˒:*@*Hr Ĝ@*HeO@*Hr Ĝ@*H˒:*@*H˒:*@*H˒:*@*H@*H@*H@*H˒:*@*Hr Ĝ@*HXy=@*HXy=@*HeO@*Hr Ĝ@*H˒:*@*Hu%F@*H@*H@*H9Xb@*HTɅ@*HTɅ@*Hp:@*Hp:@*Hp:@*Hۋq
@*H@*H@*H@*H@*Hۋq
@*Hۋq
@*H@*Hۋq
@*H\)@*H\)@*IrGE@*IrGE@*Hۋq
@*Hۋq
@*Hۋq
@*Hp:@*H@*H\)@*I ѷ@*IrGE@*IrGE@*IrGE@*I@*I*0U2a@*I*0U2a@*I*0U2a@*IDg8~@*IQ@*IQ@*I^@*Ix@*IoiD@*Ix@*Ix@*IoiD@*I@*I'RTa@*IB@*I^5?}@*I^5?}@*Iy@*Iᰉ'@*IlD@*IlD@*J	 @*J	 @*IlD@*IlD@*J	 @*J#9@*J=p
@*JJL@*J~"@*JL_@*JL/{@*Jn@*Jn@*JڹY@*JfB@*JfB@*JfB@*KI^@*KI^@*K'/@*KC,z@*K)^	@*K)^	@*KC,z@*K6z@*KC%@*KC%@*KP{@*K]cA@*Kjf@*KQ@*KQ@*K:)z@*KU=@*Kq@*K~($@*K~($@*K~($@*KƧ@*K҈@*KC]@*Ks@*L1&y@*L"h	ԕ@*L/{J#@*L<쿱@*L<쿱@*L<쿱@*LI^5?@*LcA \@*L~($x@*L~($x@*L~($x@*LC@*Lzxl"@*Lzxl"@*L@*L[W?@*L[W?@*L@*L>B[@*L@*L!-w@*M:@*MV@*Mqu"@*M:@*M:@*L!-w@*L!-w@*M:@*MV@*Mqu"@*Mqu"@*M5Xy>@*MO;dZ@*MO;dZ@*M\@*M\@*MjOv@*MjOv@*Mw1@*M%@*MjOv@*Mw1@*MM:@*Mhr!@*Mhr!@*Mhr!@*Mhr!@*MU=@*M@*M@*MC\@*MC\@*MC\@*M
qv@*M
qv@*M(@*MC\@*MC\@*N_o @*N!R<@*N.2@*N;5X@*NVu@*Np:~@*N}Vl@*N}Vl@*NO;@*NO;@*NT@*N2X@*N2X@*Nt@*N+@*N+@*N+@*Nt@*N+@*NMj@*O hۋ@*Ov@*O'/W@*O'/W@*OO
M@*O\(@*OO
M@*OiDg8@*O@*Or@*O;dZ@*P@*P*0U@*P ě@*PH@*PU2a|@*PbM@*PoiDg8@*P'RT@*P
=q@*P{@*P
(@*P)^@*PD@*PD@*P`A7@*P$tT@*Q@*Q_p@*Q&x@*Q4J@*Q&x@*Q&x@*Q&x@*Q&x@*Q4J@*Q4J@*QA [@*Q&x@*Q@*Q@*Q_p@*Q&x@*QA [@*Qu!S@*Q@*Q@*Qo@*Qu@*Ql@*Ql@*QX@*Q2W@*QiB@*QR@*Rn@*R䎊@*R-V@*RGE85@*RT`d@*Ra|Q@*R{m@*Rp:@*RS&@*R ě@*R ě@*RW@*RW@*RsP@*RsP@*R䎊q@*Rm@*R䎊q@*Rm\@*S҉@*S҉@*SPH@*S&@*S33333@*S@N@*SMjO@*SMjO@*S@N@*S@N@*SMjO@*SZ@*Sg	l@*S@*SMj@*SMj@*Sߤ@*SE@*Sa@O@*Sݗ+k@*Sg@*S@*T@*T@*T,<@*T,<@*T9XbN@*T9XbN@*T,<@*T9XbN@*TFs@*TSMj@*T`d@*Tm8@*T#@*T*1@*T3@*T3@*TO
M@*TɅoi@*TɅoi@*T֡a@*TD@*TE@*U'0@*U'0@*U*0@*U2a|@*U%F
L@*U*0@*U%F
L@*U%F
L@*U?|h@*U?|h@*U?|h@*UL_@*UY|@*Usg@*Usg@*Usg@*U!R@*U=K@*UXy=@*UXy=@*U\(@*U?@*Ush@*UXy=@*Ush@*UϪ͞@*UϪ͞@*U!.@*V4K@*VOv_@*V+jg@*V+jg@*V+jg@*V+jg@*VOv_@*V4K@*VOv_@*V4K@*VOv_@*V4K@*V4K@*V4K@*V+jg@*V8YJ@*V8YJ@*V8YJ@*VE@*V8YJ@*V8YJ@*VE@*VE@*VE@*V_ح@*V_ح@*V_ح@*V_ح@*Vz@*VFs@*V}Vl@*Vȴ9X@*VC-@*V@*V!.I@*WXe@*W
=p@*W
=p@*W
=p@*W
=p@*W$tS@*W1@*W$tS@*W1@*W1@*W1@*W$tS@*W1@*W>6z@*WKƧ@*WXe,@*WsPH@*WsPH@*W4m@*WO;d@*WO;d@*W&@*W3@*W+@*W+@*W@*W+j@*XF]d@*X}H@*X*0@*X*0@*XbM@*X*0@*X73@*X*0@*X73@*X_F@*Xl"h	@*Xy=c@*XYJ@*X-
@*X)@*X@@*XF@*Xe+@*Xe+@*Xe+@*XF@*Xe+@*X4֡b@*X4֡b@*XF@*XPH@*XPH@*Y	k~@*Y+@*Y#w@*Y0
)@*Y=b@*Y=b@*Y=b@*YJE@*YXbM@*Ye+a@*YrGE8@*Yb}@*Y@*Y(@*Y(@*YD@*YD@*Y_o@*Y"`@*Y>BZ@*YY}@*Zu%F@*Zu%F@*Z@*Z1'@*Z)y@*Z6C@*Z6C@*ZC\@*ZC\@*ZQ_@*ZQ_@*Z^5?|@*ZkP|@*ZkP|@*ZkP|@*Zݘ@*ZS&@*Z>B@*Z>B@*ZY@*Z)_@*Z)_@*Z,<@*ZG{@*ZG{@*Zc	@*Z,<@*Z)_@*Z,<@*ZG{@*ZG{@*Z)_@*Z)_@*Z)_@*Z)_@*Z)_@*ZG{@*Z~@*Zc	@*Z~@*[u%@*[u%@*Zc	@*ZG{@*Z,<@*ZY@*Z)_@*Z,<@*ZG{@*Z~@*[u%@*["`B@*[/V@*[=K^@*[J#9@*[W>6z@*[dZ@*[=K^@*[=K^@*[=K^@*[=K^@*[J#9@*[=K^@*[W>6z@*[W>6z@*[W>6z@*[J#9@*[W>6z@*[W>6z@*[W>6z@*[W>6z@*[dZ@*[qu!@*[qu!@*[~$@*[q@*[A@*[A@*[q@*[q@*[q@*[A@*[A@*[S@*[S@*[m]@*[m]@*[m]@*[m]@*[m]@*[6@*[5Xy@*[Q@*[Q@*[lC@*[$@*\n.@*\ߤ@@*\ߤ@@*\(\@*\64@*\C,zx@*\]ce@*\j~#@*\j~#@*\?@*\N;@*\N;@*\쿱[@*\?@*\Z@*\u"@*]K]@*]K]@*]K]@*][@*][@*]K]@*]!.H@*]/w@*]IQ@*]IQ@*]Vl!@*]ce@*]p
=@*]p
=@*]ڹZ@*]+j@*]v@*]-V@*]cA @*]b@*]E@*^ ѷY@*^
(@*^($x@*^5?|@*^Ov_خ@*^iB@*^vȴ9X@*^%@*^$t@*^6z@*^Q@*^m\@*^m\@*^҈p;@*^쿱[W@*^"@*^"@*_Ft@*_@*_@*_!-w1@*_!-w1@*_.H@*_!-w1@*_!-w1@*_.H@*_;dZ@*_H˒:@*_b}V@*_|hs@*_	@*_$tS@*_?@*_[W>@*_vȴ9@*_@*_䎊r@*`
qu@*`6@*`4m9@*`A7K@*`NU@*`[6@*`hۋq@*`u!@*`-
@*`IQ@*`d8@*`4m@*`ѷX@*`҈p@*`	k@*a$/@*`	k@*`C@*`ѷX@*`ěT@*`4m@*`ěT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @C D@C]cf@CN;@Cq@CwkP@Ce+a@C-V@Cv_ح@C,@C@C
$/@C
[@CtSM@Cu%@Cq@C?@C
}H@C
(@C
W'@CH@CsPH@C33333@C쿱[@C@C
Q_@CL/{J@C@C@CGE85@C74@C6z@C)^	@Cm\@C\)@C=b@C-w1@CQ@C+j@C}Vl@Ce@CA [@CqiC@C[@CN;@CBZc @C;dZ@C	ԕ+@C_ح@C{@C)_@CcA \@CjOv@C@CɅoi@C
=p@CU=@C@C+j@C @C -
@C!0
)@C"S&@C"d7@C!s@C!:S@C 
(@C!Q@C!y@C#C,z@C#|@C#S@C#ݗ+k@C$%1@C$SMj@C$[W?@C$qj@C$!-w2@C$@C$/{J#@C$@C%?@C%Ϫ͞@C&-@C'v@C'RT`e@C(F]d@C(@C(bM@C(`A7@C(@C)@C*JL@C*,<@C*m\@C+MjO@C+W>6z@C+҉@C*m\@C*c	@C*,<@C*@C*vȴ@C*vȴ@C*fB@C*74@C+u%@C*D@C*c	@C+g	l@C+ݗ+k@C+a@O@C,S@C-F
L0@C--V@C.ߤ?@C/?@C1u!S@C2u%F@C20U2a|@C2~"@C2D@C3@C4L_@C52a|@C7@C74֡a@C7\(@C7O
M@C6%@C5ᰉ@C6
L/@C6@C7iDg8@C6C-@C6;5X@C6
L/@C584֡@C4j~#@C4Fs@C4(\@C4ߤ@@C4PH@C5ce@C5(@C6}Vl@C7Ft@C7@C8>BZc@C8tj@C9~($@C9@C:=p
@C:{m@C:p:@C:Q_@C:e+@C:u%F@C9s@C:e+@C:1'@C:#9@C:1'@C:6C@C:a|Q@C:<64@C: ѷ@C;S&@C;@N@C;~$@C;g@C<J@C<ߤ@@C<(\@C<g8}@C<O
M@C<Z@C<hr@C=(@C=S&@C=w1@C=O
@C=-V@C=n/@C=8YK@C>Ov_@C>BZc @C>vȴ9X@C>2X@C>t@C>!.I@C?4֡a@C?H˒:@C?Xe,@C?{J#:@C?+@C?+j@C@     @C@F]d@C@	ԕ+@C@6@C@*0@C@1&x@C@bM@C@@C@)^@CA@CA:S@CA^@CAo hی@CAx@CA@CA@CAy@CAe@CAY}@CB	 @CBGE85@CBp:@CB@CCu%@CCg	l@CCxF]@CC~($@CC\N@CDxF@CD<쿱@CDq@CD*1@CD1&@CD@CD*0@CDu"@CD>@CE/w@CE}H@CE,=@CF_o @CF
(@CFu@CFOv_@CF+jg@CF5?|@CFVu@CFz@CFO;@CF@CFaf@CF}Vl@CFȴ9X@CFt@CFA@CFA@CF҈p;@CFA@CFϪ͟@CFA@CF"@CG@CG$tS@CG8}H@CGO
M@CGb}V@CGiDg8@CGsPH@CG&@CG$tS@CGkP@CG	k@CG	k@CG&@CG@CG+j@CH@CHF]d@CH     @CHF]d@CHF]d@CH	ԕ+@CHbM@CH@CH6@CH}H@CH*0@CH-
q@CH'RT`@CH ě@CG#@CH*0U@CG䎊r@CG;dZ@CG˒:)@CG@CG˒:)@CGo @CGvȴ9@CG/V@CGK]d@CG@CG;dZ@CGVϫ@CH-
q@CH>BZc@CHD*@CHD*@CHA7K@CH73@CH4m9@CH1&x@CH:~ @CH73@CH*0@CH}H@CH@CG˒:)@CG	k@CG	k@CG-V@CG@CGy@CGeں@CG\(@CGsPH@CGy@CG&@CG@CGkP@CG?@CGzH@CGfA@CG;dZ@CG@CG+@CG˒:)@CGo @CGo @CGK]d@CG@CG/V@CGr@CG/V@CG3@CGr@CG[W>@CG?@CG͞@CGK]d@CGfA@CGK]d@CG3@CG?@CG	k@CG&@CG&@CG	@CGy@CGsPH@CG-V@CG-V@CGzH@CGr@CGo @CG˒:)@CGfA@CGحV@CGVϫ@CHF]d@CH
qu@CHbM@CHbM@CH
qu@CH@CH     @CG@@CG@CG@CGحV@CG˒:)@CGr@CGkP@CGݗ+@CG&@CG{J#:@CGO;d@CGO;d@CGO;d@CG	@CGO;d@CG	@CG	k@CG3@CGr@CG3@CGK]d@CGrGE9@CHF]d@CHF]d@CGrGE9@CGrG@CGحV@CGo @CG/V@CGr@CGr@CG+@CGfA@CG+@CG˒:)@CGK]d@CGK]d@CGrG@CG䎊r@CG䎊r@CG+j@CG+j@CG䎊r@CG䎊r@CG䎊r@CGrGE9@CG䎊r@CG+j@CH@CH     @CG+j@CG+j@CG+j@CG+j@CG#@CGrGE9@CH     @CH@CH
qu@CHbM@CHbM@CH
qu@CHbM@CH*0U@CH*0U@CH6@CH6@CH6@CH6@CH@CH@CH*0U@CH
qu@CH
qu@CG#@CG䎊r@CG-@CGVϫ@CG@CG@@CG@CGrG@CG@CG@CG@CG@@CG;dZ@CG;dZ@CG;dZ@CG@CGحV@CGfA@CGfA@CG@CG@CG+@CG˒:)@CGK]d@CGK]d@CG@CGvȴ9@CG3@CGzH@CG&@CG?@CG	k@CG@CG	@CG{J#:@CG4m@CG|hs@CGsPH@CGo@CGo@CGlC@CGeں@CGb}V@CG_o@CGXe,@CG\(@CGv_ح@CGeں@CGU=@CGRT`e@CGKƧ@CGE84@CGAs@CGAs@CG;dZ@CG8}H@CG4֡a@CG1@CG+I@CG'/W@CG@CG
M;@CG@CF"@CF!.I@CFFs@CFx@CF1@CFC-@CFߤ?@CF+@CFt@CFm\@CFߤ?@CFߤ?@CFQ@CFQ@CF'@CF}Vl@CF-@CF-@CF-@CFaf@CFaf@CF,<@CF@CF%@CF}Vl@CFvȴ9X@CFs@CFs@CFs@CFl!-@CFl!-@CFiB@CFc	@CF\N<@CFYJ@CF\N<@CFOv_خ@CFH@CFH@CFE@CFBZc @CF?@CF?@CF1.@CF.2@CF.2@CF+jg@CF($x@CF!R<@CF!R<@CF@CF@CFzG@CF@CF4K@CF4K@CF
L/@CF_o @CE!.@CE!.@CEoiDg@CEE@CEE@CE,=@CEb@CE8YK@CE@CE@CE@CE8Y@CE\(@CE\(@CE\(@CE@CEsh@CE@CE-V@CEsh@CEU=@CE%@CE!R@CE$/@CEsg@CEm\@CEm\@CEjOv@CE\@CE\@CE\@CEY|@CEVl!@CES&@CES&@CEL_@CEF
L0@CEB@CE84֡@CE(@CE%F
L@CEQ@CEu@CE[@CEu@CEK]@CDE@CDe@CDhr@CDZ@CD>B[@CD@CDɅoi@CDɅoi@CD7@CDj~@CDj~@CD@CDO
M@CDzxl"@CD3@CD*1@CDN;@CDqj@CD#@CD~($x@CDzG@CDzG@CDm8@CDg8}@CDZ1@CDM:@CDFs@CDC,zx@CD?@CD<쿱@CD<쿱@CD2W@CD,<@CD(\@CD%1@CD"h	ԕ@CDQ@CDtj@CDtj@CD@CD@CDߤ@@CD1&y@CDn.@CCA [@CCC]@CClC@CC%2@CCݗ+k@CC
=p@CC
=p@CC|@CC6@CCZ@CCm]@CCq@CCq@CC*0U2@CCS@CCwk@CCU=@CCwk@CCwk@CCU=@CCߤ@CCA@CCߤ@CCU=@CCwk@CCA@CCߤ@CCߤ@CCA@CC$@CC$@CCMj@CCq@CCeO@CC@CC{J#9@CC{J#9@CCtj~@CCtj~@CCqu!@CCqu!@CCqu!@CCjf@CCa@N@CCdZ@CCa@N@CCZ@CCZ@CCS@CCMjO@CCJ#9@CCC%@CC9@CC33333@CC)^	@CC"`B@CC"`B@CCC,z@CCs@CC'/@CC'/@CCu%@CCu%@CB~@CBD@CBc	@CBc	@CBc	@CBfB@CBG{@CBG{@CBڹY@CBڹY@CB͞&@CB`A@CB)_@CB@CB@CB<64@CBY@CB>B@CBvȴ@CBvȴ@CBvȴ@CBwkQ@CB0
@CBL_@CBL_@CBp:@CBݘ@CB@4@CB{m@CB{m@CB{m@CBxl"h
@CBu%F
@CBnO@CBnO@CBqiC@CBnO@CBkP|@CBkP|@CBd7@CBa|Q@CBZc@CBW'@CBGE85@CBC\@CB@4n@CB=p
@CB=p
@CB@4n@CB=p
@CB:)y@CB:)y@CB3@CB-V@CB-V@CB#9@CB1'@CBe+@CBe+@CBs@CBI^5@CB	 @CBn@CBu%F@CAlD@CAs@CAs@CAY}@CAs@CA@CA@CA>BZ@CAᰉ'@CAiB@CA"`@CAԕ*@CAN;6@CA_o@CAN;6@CA_o@CA_o@CAN;6@CA_o@CAy@CAD@CA^5?}@CA|@CA|@CA|@CA'R@CAl@CAl@CA(@CA(@CAn.@CAu@CAu@CA@CAR<6@CAo@CA@CAo@CA~($@CA~($@CAoiD@CA@CA|Q@CAx@CAu!S@CArGE8@CAk~(@CAk~(@CAk~(@CAe+a@CAae@CA^@CA^@CA[W>6@CAXbM@CATɅo@CAQ@CAJE@CADg8~@CAA [@CA=b@CA=b@CA=b@CA:S@CA7KƧ@CA7KƧ@CA7KƧ@CA4J@CA4J@CA0
)@CA*0U2a@CA*0U2a@CA&x@CA@CA_p@CA+@CA+@CA+@CA@N@CA@CA	k~@CA ѷ@CA ѷ@C@$tT@C@$tT@C@PH@C@	k@C@	k@C@4֡b@C@C@C@@C@`A7@C@e+@C@҈p@C@ۋq
@C@ۋq
@C@D@C@D@C@F@C@F@C@p:@C@p:@C@)^@C@@@C@@@C@TɅ@C@ěT@C@
(@C@)@C@)@C@4m@C@{@C@{@C@U@C@d8@C@@C@
=q@C@-
@C@IQ@C@@C@@C@tj@C@@C@'RT@C@n@C@YJ@C@n@C@|@C@y=c@C@y=c@C@u!@C@oiDg8@C@oiDg8@C@l"h	@C@eO@C@eO@C@bM@C@bM@C@Xy=@C@Q@C@Q@C@NU@C@K]c@C@H@C@H@C@A7K@C@>BZc@C@>BZc@C@>BZc@C@73@C@73@C@4m9@C@4m9@C@1&x@C@4m9@C@*0@C@*0@C@'RT`@C@'RT`@C@$xG@C@$xG@C@}H@C@6@C@@C@*0U@C@	ԕ+@C@@C@@C@     @C?#@C?rGE9@C?rGE9@C?+j@C?+j@C?rGE9@C?+j@C?䎊r@C?Vϫ@C?Vϫ@C?Vϫ@C?rG@C?@C?@@C?@@C?@C?@C?حV@C?fA@C?@C?+@C?@C?@C?@C?+@C?o @C?K]d@C?vȴ9@C?@C?vȴ9@C?/V@C?r@C?3@C?[W>@C?͞@C?͞@C?͞@C?&@C??@C?	k@C?	k@C?-V@C?kP@C?$tS@C?$tS@C?ݗ+@C?@C?O;d@C?ݗ+@C?O;d@C?	@C?&@C?	@C?&@C?{J#:@C?{J#:@C?4m@C?|hs@C?y@C?v_ح@C?sPH@C?sPH@C?sPH@C?sPH@C?o@C?lC@C?lC@C?iDg8@C?iDg8@C?eں@C?eں@C?b}V@C?b}V@C?_o@C?b}V@C?eں@C?_o@C?_o@C?Xe,@C?U=@C?Xe,@C?RT`e@C?U=@C?RT`e@C?RT`e@C?RT`e@C?RT`e@C?O
M@C?O
M@C?O
M@C?O
M@C?H˒:@C?H˒:@C?KƧ@C?H˒:@C?H˒:@C?H˒:@C?H˒:@C?E84@C?E84@C?E84@C?;dZ@C?;dZ@C?8}H@C?1@C?.H@C?1@C?.H@C?+I@C?'/W@C?'/W@C?$tS@C?$tS@C?$tS@C?$tS@C?$tS@C?$tS@C?!-w1@C?$tS@C?!-w1@C?$tS@C?$tS@C?$tS@C?v@C?,@C?v@C?v@C?v@C?Xe@C?v@C?v@C?Xe@C?Xe@C?@C?Xe@C?@C?)^@C?)^@C?)^@C?@C?
=p@C?
=p@C?
=p@C?
=p@C?
=p@C?Ft@C?
=p@C?Ft@C?Ft@C? hۋ@C?@C?@C? hۋ@C? hۋ@C>!.I@C>!.I@C>!.I@C>"@C>"@C>Fs@C>Fs@C>Fs@C>Fs@C>Fs@C>Mj@C>Mj@C>쿱[W@C>@C>@C>쿱[W@C>쿱[W@C>쿱[W@C>x@C>x@C>1@C>1@C>1@C>1@C>C-@C>C-@C>C-@C>ߤ?@C>ߤ?@C>ߤ?@C>ߤ?@C>]cf@C>]cf@C>]cf@C>]cf@C>]cf@C>+@C>+@C>+@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>҈p;@C>҈p;@C>A@C>t@C>t@C>A@C>t@C>t@C>t@C>ȴ9X@C>t@C>A@C>ȴ9X@C>t@C>ȴ9X@C>ȴ9X@C>ȴ9X@C>ȴ9X@C>m\@C>ȴ9X@C>m\@C>m\@C>m\@C>&I@C>&I@C>&I@C>&I@C>&I@C>ߤ?@C>@C>@C>@C>Q@C>Q@C>Q@C>@C>@C>@C>Q@C>Q@C>'@C>Q@C>'@C>Q@C>'@C>'@C>2X@C>'@C>'@C>'@C>2X@C>2X@C>'@C>'@C>'@C>Q@C>2X@C>'@C>2X@C>Q@C>Q@C>2X@C>'@C>2X@C>'@C>2X@C>2X@C>'@C>2X@C>'@C>2X@C>Q@C>'@C>'@C>'@C>2X@C>2X@C>'@C>2X@C>2X@C>2X@C>'@C>2X@C>'@C>}Vl@C>2X@C>}Vl@C>}Vl@C>2X@C>2X@C>}Vl@C>2X@C>2X@C>2X@C>}Vl@C>}Vl@C>2X@C>}Vl@C>2X@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>2X@C>}Vl@C>}Vl@C>}Vl@C>2X@C>6z@C>6z@C>}Vl@C>}Vl@C>6z@C>6z@C>6z@C>}Vl@C>}Vl@C>}Vl@C>6z@C>6z@C>}Vl@C>6z@C>-@C>-@C>-@C>6z@C>-@C>-@C>-@C>T@C>T@C>af@C>af@C>af@C>T@C>@C>T@C>af@C>af@C>af@C>af@C>af@C>af@C>@C>af@C>,<@C>@C>,<@C>,<@C>,<@C>,<@C>O;@C>O;@C>O;@C>O;@C>O;@C>Fs@C>O;@C>Fs@C>Fs@C>@C>$t@C>$t@C>$t@C>$t@C>$t@C>$t@C>Fs@C>Fs@C>Fs@C>$t@C>Fs@C>$t@C>$t@C>Fs@C>$t@C>$t@C>@C>@C>$t@C>$t@C>@C>qi@C>@C>$t@C>@C>qi@C>$t@C>@C>qi@C>qi@C>$t@C>$t@C>Fs@C>$t@C>$t@C>O;@C>$t@C>Fs@C>Fs@C>O;@C>Fs@C>Fs@C>O;@C>O;@C>Fs@C>Fs@C>Fs@C>Fs@C>Fs@C>$t@C>Fs@C>$t@C>O;@C>$t@C>$t@C>$t@C>@C>$t@C>@C>@C>qi@C>+J@C>qi@C>@C>+J@C>+J@C>qi@C>@C>qi@C>qi@C>@C>+J@C>qi@C>%@C>+J@C>+J@C>qi@C>qi@C>qi@C>+J@C>qi@C>qi@C>+J@C>qi@C>qi@C>qi@C>+J@C>+J@C>@C>+J@C>+J@C>+J@C>+J@C>+J@C>qi@C>+J@C>+J@C>%@C>+J@C>%@C>+J@C>%@C>%@C>%@C>%@C>%@C>IQ@C>%@C>%@C>%@C>%@C>IQ@C>%@C>IQ@C>IQ@C>%@C>%@C>%@C>%@C>%@C>%@C>IQ@C>IQ@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>IQ@C>}Vl@C>IQ@C>}Vl@C>}Vl@C>}Vl@C>z@C>}Vl@C>}Vl@C>}Vl@C>z@C>z@C>z@C>z@C>z@C>}Vl@C>z@C>}Vl@C>z@C>vȴ9X@C>vȴ9X@C>z@C>vȴ9X@C>vȴ9X@C>z@C>vȴ9X@C>vȴ9X@C>vȴ9X@C>vȴ9X@C>s@C>p:~@C>s@C>s@C>p:~@C>p:~@C>p:~@C>p:~@C>p:~@C>s@C>l!-@C>p:~@C>l!-@C>l!-@C>p:~@C>iB@C>p:~@C>l!-@C>fffff@C>iB@C>iB@C>fffff@C>iB@C>iB@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>c	@C>_ح@C>_ح@C>c	@C>c	@C>c	@C>c	@C>c	@C>fffff@C>c	@C>c	@C>c	@C>c	@C>_ح@C>c	@C>c	@C>c	@C>_ح@C>_ح@C>_ح@C>_ح@C>\N<@C>\N<@C>\N<@C>YJ@C>\N<@C>\N<@C>YJ@C>\N<@C>\N<@C>YJ@C>YJ@C>\N<@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>Vu@C>Vu@C>Vu@C>YJ@C>Vu@C>Vu@C>Vu@C>R<6@C>Vu@C>R<6@C>Vu@C>YJ@C>R<6@C>R<6@C>R<6@C>Vu@C>R<6@C>R<6@C>R<6@C>R<6@C>Ov_خ@C>L/{J@C>Ov_خ@C>Ov_خ@C>L/{J@C>L/{J@C>Ov_خ@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>H@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>H@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>H@C>H@C>H@C>E@C>L/{J@C>H@C>E@C>E@C>E@C>H@C>E@C>E@C>E@C>H@C>E@C>E@C>BZc @C>BZc @C>BZc @C>E@C>E@C>BZc @C>BZc @C>E@C>BZc @C>BZc @C>BZc @C>BZc @C>E@C>?@C>BZc @C>BZc @C>;5X@C>?@C>?@C>;5X@C>8YJ@C>;5X@C>8YJ@C>;5X@C>;5X@C>8YJ@C>;5X@C>5?|@C>8YJ@C>1.@C>1.@C>1.@C>1.@C>1.@C>1.@C>1.@C>1.@C>.2@C>1.@C>1.@C>1.@C>1.@C>1.@C>.2@C>.2@C>.2@C>+jg@C>($x@C>+jg@C>+jg@C>+jg@C>($x@C>($x@C>($x@C>($x@C>($x@C>$/@C>$/@C>$/@C>!R<@C>!R<@C>$/@C>$/@C>!R<@C>!R<@C>!R<@C>!R<@C>Ov_@C>Ov_@C>Ov_@C>Ov_@C>u@C>u@C>u@C>@C>u@C>u@C>u@C>@C>@C>@C>@C>u@C>@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>4K@C>zG@C>4K@C>4K@C>4K@C>4K@C>4K@C>4K@C>4K@C>4K@C>
(@C>
(@C>
L/@C>4K@C>4K@C>
L/@C>
L/@C>
(@C>
(@C>
(@C>
L/@C>
(@C>
L/@C>
(@C>
(@C>4K@C>4K@C>
(@C>
(@C>
(@C>
L/@C>4K@C>
(@C>
(@C>
L/@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
L/@C>
(@C>
L/@C>
(@C>
L/@C>
L/@C>
(@C>
L/@C>
L/@C>
(@C=8YK@C>
(@C>
(@C>
(@C>
L/@C>
L/@C>
L/@C>
(@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>_o @C>t                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @i!=K^@il"h	@i>BZ@jBNU@j$tS@k7ڹZ@kE!.@kB*0@kPTɆ@kMo@k~oiDg8@ku$@k$/@kѷX@kU=@k-
@k5Xy@kx@l2:~ @lV
(@l"H@l8Ov_خ@l6}Vl@l1$/@lyB@l&@lL_@l쿱[W@m@ȴ9X@m%1@nx@m
qv@nQ@n`A7L@n@nIQ@nfB@nS&@oFe@o!-w@oȵ'@pZ"`@p,<@p*0U2@pPH@p&@pB ѷY@p7D*@p[qu"@pH䎊q@p!?@pL/{J@p"u@p$@pvȴ9@oѶE@oZ@oxoiDg8@o;-w1@n1'@n.2@n$xG@n/o @ms@mJL/{J@m(䎊q@m3R@m>74@m+I@l*0@lHsP@l%1@l {m@k%@kT`d@k
xl"h
@jp:~@jXy=@jA@jA@j@j=p
@jjoiDg8@jJvȴ9X@j'sh@j$@j*s@j$/@j/oiDg@jJNU@j4I^5@j8.2@j5^@j+U=@jRy=c@js@js@j@@j_ح@j_F@jFs@jnP@jqiC@j$/@jלߤ@jᰉ@jv_ح@jbM@jɩ*0U2@j	@jK]@j{N;6@jmg@j@jslC@j$/@i)^@ikqu!@i5Xy>@ix@iuv@iSn/@iwkQ@hڹY@ht
L/@hqi@h3@i%+@iI^5?@j]cA@iڹY@iC,z@i	 @i"h	ԕ@i}&x@i]5Xy>@i!x@iu!@i)^@h4K@h	@i%%@io8}H@i@i(@iku%@iI[W>@i/IQ@i&m@iFڹY@i<쿱@i)y@j hr@i͈eO@iiB@iQS@ioiDg8@h?@h!.H@hK]c@hןU=@i䎊r@il@ho@htj@hw\(@hkAs@h^n@hSn.@h@/{J#@hb@hnF]d@hN4K@hG@h>m\@h=`A7L@h0ߤ?@h%@h@N@h ?@gw1@gs@h =p
@ghr!@g֐-
@gāo h@g)_@gFs@ga|Q@g
L/@g*0@gR<6@g1.@g*1@g/V@gu@g,@gH@g84֡@gu@gϊڹZ@g9Xb@g?@gZ@gE@gS@goiDg8@gtj@gC%@gB@ghr@g4J@gy@gL_@gH˒@gMjO@g?@gtj~@g@gqiC@g=K@g]!R@f#x@fTɅo@f?@foiDg8@f2W@fa@O@f\(@fg	@fO;dZ@fiB@fTɅ@f]cf@fpn@f]+j@fYo@ffJL@fk@fd1@fT;5X@fB-
q@f1@f@ȴ9X@fCMj@fD{@f?dZ@fB*0@fGX@fK҈@fX`d@fc|hs@fR҈p;@fQo hی@fUA@fbtj@fiu%@f\+J@f\YJ@f\?@f\%@f\@4@fU@fVMj@fD䎊q@fC$/@fV{@fNIQ@f;+a@f*o h@f`A7@f䎊q@f     @f-F]c@f+S@f+@@f0
qu@f*~"@f ?@f&T`d@f+@@fb}V@fE@f\N@fu%F@f"($x@f'3@f$쿱[W@f-A [@f41.@fCxF]@f[@N@f`af@f]Q@fXL/{J@fY1@fR<64@f?J#9@f9n/@fCsg@fjT`d@fqF
L0@fgO;d@fRQ@ff(\@fv҈p;@fy@f'/W@f}a@O@fa#@fNC@fJ`d@fhhr@f	k@f!.@fZ@f@f֡af@fO
M@gW@g!-w@f-w1@fJ#9@ffA@ftSM@f@fn/@f@f<쿱@fg8}@f@fK]d@fĎqj@f+I@fu@fĎqj@fV@fb}@f֛S@fD@fD@f)y@fݍO;d@fϩl@fϩ*0U2@f=K@fr@fČL_@f@fqi@fC]@gzG@gT@gT@g/x@g
=q@g*1@g	-@f	k@f+@f@4n@fR@f_o @f
=q@f+@fR@f1&y@f+@f#w@f_o@fM:@f֒S&@fsg@fQ@ftSM@f쿱[@f@gH@g9*0U2a@g>Q@gPm\@gG@g+F
L0@g%r@g(~"@g$U2a|@g+F
L0@g'qu"@fVu@f֏\(@f+a@f䎊r@f)@fz1@f)^@f@f'/@fȪd8@f*0U2@g!.I@g!.I@f~$@fbM@fT`d@f8}H@f.H@fᰉ'@f~($x@f,<@f.H@fxQ@f8}H@f~($x@fE84@fX@f@f|E@fr@fy~$@fr@fj73@fuS@f҉@f}Xy=@frL_@fj6C@fUae@fVm\@fG~$@f4
qu@f.~"@f(D@f2TɆ@f.~($x@fFs@f@f@f
)^	@f
qu@f
qu@f
(@f
a|Q@fZ@f
a|Q@fo @e~($x@eE84@eR<6@eE@f҈p;@fPH@f5?|@fqi@fߤ?@fߤ?@f O;@f4J@f҈p@f~@f
&@f9Xb@f{J#9@f{J#9@f+j@f4m9@f~@fg	@f
%F
L@f ѷ@f#]cA@fu%@f?@f/@fv@fR@fR<6@fOv`@fn.@f
#w@f$@f	k@f5Xy@f5Xy@fzG@f{@f͞&@f
"`B@f5Xy@fMjO@f͞&@fzG@f>BZc@f ě@fe@fe@fO
M@f>BZ@fs@f@f<쿱@fv_ح@f<쿱@f<쿱@f+@fg8}@f!Y}@fZ@fg	l@f-
q@fn@fD@ftj~@f!E@f*H@f'@f&Ov_@f%@fI^@f19@f:{@f8+jg@f2IQ@f6@@f9Mj@fHF@f?@f@˒:*@fL$tT@f`q@f`p:~@fc7KƧ@fe\N@f]*0U2@fV4m@fSoiDg@fY~$@fa@fX6@fR@fY~$@f`oiDg8@f`oiDg8@fj($x@fhěT@fh@fdu%F@f\C\@flc	@fs
qv@fosh@fg`A7L@fr|@fkڹZ@fc5Xy>@fh@fkڹZ@fs;dZ@fnQ_@felD@fQ'/W@fRC@fj&IR@f|4m9@fs;dZ@fY|hs@fV?@faN;6@faN;6@fY|Q@fZߤ?@fL!.I@fK@fY|Q@fKA@fKA@fQ&x@fQ&x@fJ5?|@fSC]@fY|Q@fSC]@fSC]@fZߤ?@fo|@fvzxl"@fes@f`l!-@fX@fc4J@fuA [@fn.@f]cf@fvT@f|1.@f}$@f}R<6@fuA [@fyjf@fnOv_خ@frz@f\N<@f}$@f#w@fzp:@fg]cA@fkݗ@fg@fxF]@fᰉ@fzG@fۋq
@fH˒@f}O
@f"`B@fYJ@fᰉ@fYJ@fYJ@f{@fH˒@fᰉ@f/V@fQ@f>BZc@fڹY@fhۋq@f!.H@f ě@fڹY@fhۋq@fhۋq@f@fhۋq@fڹY@fS&@ffB@f ě@f/w@f<64@fXy=@ffA@fu@f@f@f<64@fF]d@fحV@f<64@ffA@f-
q@ffA@ffA@fW@fF]d@fW@f<64@fF]d@f!-w@f䎊@fu@f@fI^@f!-w@f/V@f@f@f:)y@fVl!@f+a@f1&@fH˒:@f@fsPH@f:)y@fK]d@f:@f@f-V@fd7@f:)y@fd7@f+I@fK]d@fȏ\(@f+a@f:@f̹Y@fZ@f䎊r@fVl!@f̹#x@fd7@fe@f+I@fZ@fqiC@ffA@fqiC@ffA@fӪ͞@fGE85@f̹#x@fu@fU=@fy@fπ4m@fqiC@fqiC@fԕ*@f@@fF
L0@f)y@fO;d@fr@fb}V@fڛS@fTɆ@fv@fr@fᰉ'@fa|Q@fE@fo@fZ@fo@fE@fE@gu"@fo@fZ@g҉@gnO@fS&@fRT`e@f'/W@fZ@fTɆ@fkP@g'0@g
#@g&@f2W@g|hs@g|hs@fC@gu"@g	@g0
@g|hs@g|hs@gnO@gڹZ@g0
@g&@g&@g'0@g|hs@g0
@g3@gڹZ@g_o@ghr@g7@g&IR@ghr@g	@g	@g	N;6@ghr@g7@g_@g3@g 	ԕ+@g	@g	@ghr@gQ_@gAs@g!lC@g%$tS@g(^5?|@gAs@g	@gzxl"@giB@g 	 @g!lC@g!lC@g&>@g2@g3zxl"h@g-Vϫ@g)@g(^5?|@g$3@g 	 @g&>@g6@4n@g4/@g0@g+$tS@g,#@gAs@g 	 @g:kP|@gFC,@gA\@g6@4n@g3y@g0@g"A@g&"@g-R@g9K]@g:kP|@g4/@g9Ft@g7?@g7?@g>ᰊ@g?-@g3y@g7?@g;_o@g:j~#@g:j~#@gFJM@gK[@gM@gHM@gI[W>@gHM@g;_o@g:j~#@gE&@g7n.@g=1@g[vȴ9@gO?|h@gLxl"h
@gO?|h@gWݗ+@gK@gK@gK[@gLwkP@gFx@gHM@gO>6z@gV0U2a|@gT@gP3@gI'R@gEoiD@gEoiD@gK@g]!.H@gaL_@g_rG@gRn@gV0U2a|@gZZc@gP3@gRn@gHM:@gV0U2a|@gbO
M@g]!.H@gSiDg8@gWݗ+@gWݗ+@g[@gev_ح@gbO
M@g^?@g]!-w1@gV/{J#@gZZ1@gZZ1@gbO
M@gev_ح@glh	ԕ@gwM:@gq+j@gq+j@gq+j@gev_ح@gds@g_>BZ@g_>BZ@gev_ح@gko i@gmo@gf>B[@g[@gqY}@gtj~@gpN;@gqY}@gi'RTa@gk@gpN;@gw{J#:@gqY}@gk@gf+@gqY}@g}u@gحV@g;dZ@geں@g}u@g}u@g~u%F
@gw{J#:@gx@g})^@gx@gx@gF]d@gu%F@g@g!-w@g!-w@gɅoi@g!-w@gW'@gQ@g@g@g쿱[@geں@gɅoi@g@g@4@g!-w@g;dZ@g;dZ@g})^@g!-w@g֡a@gIQ@gsPH@g@g@g@4@g@gH˒:@go h@g1&@g֡a@g1&@gVϪ@gH˒:@g,@ge@g:)y@g:@g֡a@g:@g+a@gH˒:@g:)y@g-V@g:@g䎊r@g-V@gsPH@gY@g䎊r@g:)y@gU=@gU=@g1'@g#x@g:@g-V@g4m@gqiC@g͞@g1'@gGE85@g+I@gs@gfA@gqiC@gV@g+I@g4m@g1'@g hۋ@g4m@gm@g)y@gZ@g1'@g!R@gO;d@gGE85@g)_@gr@gԕ*@gb}V@gqiC@g?@g?@gO;d@g@@gD@gr@gƩ@gƩ@gr@gGE85@gr@g73@gD@gԕ*@gqu"@g@@gqu"@gqu"@gƩ@gp
=@g?@g
M;@gr@ga|Q@go @g
qu@g?@g
M;@gr@go@gp
=@ga|Q@g73@g͛=K@gZ@gF
L0@g
qu@gp
=@gԌL_@go@g@@gԌL_@gض}Vm@gT`d@g)y@gI^5@gI^5@g6C@g(@g}H@g6C@g~($x@g(@gD*@g҉@gߨXy=@gG{@gE@gG{@gQ@g5Xy>@gE@gE@gD*@g@g6@go @gߧ&@gD*@g}H@ge+@ge+@g5Xy>@g0
@g@gC\@go @g(@go @g@gc	@g#@gC\@gߧ&@g#@g-@gu"@g'RT`@gQ@gS&@gԌL_@g'0@g5Xy>@g@g|@gQ@gc	@g
L/@g
L/@gQ@gnO@gnO@g{m@gc	@g#@gc	@gQ@gQ@gc	@gL/{@g	ԕ+@g4m9@g4m9@gm\@g+j@gc	@g#@g@gQ@g	ԕ+@g*0@gߧ&@g@g	ԕ+@h
{J#9@g4m9@g4m9@g`A@g+j@g`A@gB@h_F@h'RT@h\(@h_F@h'RT@h_F@g`A@h(@g4m9@g	ԕ+@h ~@h ~@h&@hp:@g4m9@gL/{@h@hl"h	@hϪ͞@h33333@h@hp:@h	O;dZ@hVϫ@hp:@h
g	@hv@h
zxl"h@hϪ͞@hl"h	@h ѷ@h
g	@hA7K@h@h
zxl"h@hu%@hu%@hA7K@h^5?|@h^5?|@hA7K@hl"h	@gAs@gAs@hv@hA7K@hv@h ѷ@h@h2a|@hA7K@h C,@h\@hK]@h2a|@h\@hrGE9@h&y=c@h#-V@h\@h ѷ@hK]@hᰊ@h2a|@h#-V@h&y=c@h2a|@h+@hᰊ@h$xG@h2a|@hݗ@h1O
@h.͞&@h%s@h*S&@h%[@h&y=c@hᰊ@hn@h\@h#[W>@h"M@h&@h,@h*S&@h*S&@h01&x@h,@h,@h*S&@h.͞&@h*S&@h,@h JM@h$xG@h$xG@h"M@h&xl"h
@h4[6@hB?@h01&x@h"M@h*S&@h8YJ@h< ě@h274@h&xl"h
@h,@h4[6@h5H˒@h<{@h;L_@h,@h'@h4[6@h7!.H@h< ě@h8ݘ@h5vȴ9@h8ݘ@h;L_@h.͞&@h,@h7!.H@h1O
@h)?|h@h*S&@h1O
@h01&x@h00U2a|@h4Zc@h9rG@h1ݗ+@h;L_@hGcA @h;L_@h9rG@hC@hC@h@ڹY@hES&@h@ڹY@h?w1@hES&@hC@hJtj@hC@h>*0U@hFhۋq@h< ě@h7!.H@h4Zc@h8ݘ@h8ݘ@h9rG@hB>BZc@h>*0U@h?w1@h>*0U@h?w1@h>*0U@h?w1@hI/w@hK+j@h8ݘ@h-iDg8@h4Zc@h>*0U@h>*0U@hC@hI/w@h>*0U@h;L_@h@ڹY@h?w1@h00U2a|@h< ě@h?w1@h@ڹY@hG˒:)@h@ڹY@h< ě@h?v_ح@hK+j@hI/w@hG˒:)@h>s@h9rG@h@>B[@hI/w@hC	k@hB=p
@hG˒:)@hI/w@hG˒:)@hC	k@h8?@hFh	ԕ@hC	k@hI/w@hK+j@hFh	ԕ@h@>B[@h>s@hEo i@hEo i@hC	k@hI/w@hMY|@hK+j@hJS&@hI/w@hG˒:)@hJS&@hQM:@hP ě@hMY|@hMY|@hJS&@h>s@h@>B[@hMY|@hFh	ԕ@hTJL@hK+j@hG˒:)@hP䎊@hI/w@hI.H@hJS&@hMY|@hP䎊@hTJL@hP䎊@hC	k@hJS&@hP䎊@hFh	ԕ@hJN;@hWu@hNj~@hI.H@hB=p
@hFg8}@hI.H@hTJL@hWu@hP䎊@hGo@hJN;@hP䎊@hR@hKY}@hI.H@hP䎊@hTJL@hC'RTa@hI.H@h`W@hWu@h`W@hUzH@hR@hTJL@hJN;@hQ{J#:@hR@hKY}@hUzH@hWu@hUzH@h[<64@hYحV@hYحV@h[;dZ@h[<64@hWu@hP䎊@hNj~@hTJL@hY@hb-V@hiQ@hfW'@hJN;@hC'RTa@hR1@hc@hk@hNj~@hGo@hUB@hQ@hR1@h_eں@h[;dZ@hP!-w2@hP!-w2@h\쿱[@hc@h^u%F@hY@h[;dZ@hXtSM@hW)^@hXtSM@h^u%F@h`Ʌoi@h^u%F@h_eں@h_eں@h_eں@h[;dZ@hR1@hI.H@hCU=@hP!-w2@hQ@hXtSM@hb-V@h_eں@hR1@hN@h[;dZ@hY@h[;dZ@hW)^@h[;dZ@h_eں@hb,<@hg^5?}@h\쿱[@hR1@hW)^@hb,<@hco@hg^5?}@h`Ʌoi@hR1@hUB@hY
=p@hTI^5?@hTI^5?@hXtSM@h^u%F@hb,<@hdMj@hTI^5?@h?tj~@h;J#9@hCU=@hJ$t@hK$@hN)@hN@hXs@hWrGE@hWrGE@hXs@hUq@hXs@hWrGE@hXs@hQ@hFeO@hKE@hKE@hKE@hMW>6z@hKE@hUq@hTH@hUq@hY
=p@hXs@hb,<@hg^5?}@h\@hJ-
@hI,zxl@hXs@hjIQ@h`ȴ9X@hY
=p@h\@hUq@hC%@hB:~ @hPOv_@hN)@h_dZ@hd{@hcMj@h^ ѷY@hb+jg@h_dZ@hWrGE@h_dZ@hfVu@hmGz@hw hۋ@hmGz@hfVu@hb+jg@h`@@h\IQ@h^ ѷY@hN)@hWrGE@hg~($@hd{@hcMj@h[9@hN)@hMW>6z@hXr Ĝ@hi@h`@@hUU=@hXr Ĝ@h^ ѷY@hfVu@hqrGE8@h\IQ@hN)@hMVl!@hW'/@hY8YK@hFeO@hPOv_@h^ ѷY@hcMj@hd{@hcMj@h[9@hNY@hGK]d@hR䎊q@h[9@h^ ѷY@h`@@h^ ѷY@hg@hb+jg@hcMj@hi@hj˒:*@hkS@h^ ѷY@hb*0@h_dZ@hiC,z@hmF]c@hg@hj˒:*@hYfA@h^ ѷY@hj˒:*@h^ ѷY@hb*0@hqqu!@huߤ@hc!R@hc!R@hiC,z@hc!R@hb*0@hnd8@hrF@hj˒:*@hfU2a|@h`)_@h`)_@hj˒:*@hqqu!@hqqu!@hkS@hdm@hmF]c@hr,<@hqqu!@hr,<@ht73@hu=K@hqp
=@hk@@h\wkQ@h\wkQ@hfT`d@hr,<@hvm\@hj~"@h^     @h[84֡@hj~"@hj~"@hfU2a|@hfT`d@h_b}V@h[8}H@h`?@hr,<@ht73@hp
qu@hgr@hfT`d@h`?@hiqu"@hTFs@hMU=@hb)y@hgr@hfT`d@hdD@hj~"@hdD@hTFs@hXq@hTFs@hW
M;@h`?@h_b}V@hpI^5@hn@h`?@hTFs@h`?@h`?@hRC-@hPQ@h].H@hpI^5@hj~($x@hd@h`?@hdD@h[8}H@hQb}@hMTɅo@hPQ@h].H@hXq@hGƧ@hUl@h[7KƧ@h[8}H@hUl@hYԕ*@h[7KƧ@h]\N@h`m\@hTFs@hb(\@hYԕ*@hMTɅo@hMTɅo@hKA [@hNQ@hQb}@hNQ@hKA [@hTE@hMTɅo@hKA [@hPQ@hPQ@hXq@hYa@@h_ae@hW@hPQ@hPu@hRC-@hYa@@hRC-@hN4m@h8˒:*@h;F]c@h<d8@h>
(@h9S@hGƧ@hW@hPu@h<d8@h?qu!@h;F]c@h8˒:*@hI)^	@hMS@hI)^	@hCߤ@hNQ@h[7KƧ@hU*0U2@hKoiDg@hB8YJ@hTE@hQ~$@hRe+@h<d8@h@F@hN4m@hN4m@hU*0U2@hG8Y@hJ@hPu@hB73@hJ@hXp:~@hTE@hTE@hU*0U2@hY@hXoiDg8@hTE@hW҉@hW@hW҉@hW@hPu@hPu@hPu@hN4m@hFbM@hQ4m@hfR<6@hY@hPu@hKoiDg@hQ~$@h[6z@h]ڹ@hb($x@hfR<6@h_a@N@hPu@hW҉@h[6z@h`ěT@h_a@N@h\u%F@h[6z@hd4֡b@hcq                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ???nP?+j?l?a|Q?u%??hr Ĝ?o ?2a|Q?@4?+I?҈?4J?PH?$?As?S&?/V?>BZc ?#x?}H?+jg?;dZ?쿱[W??c	?}Vl!??a|Q?'/W?,<?n?Q?ߤ??Ďqi?L_?|??tj?~$?A [7?ݗ+j?L_?5Xy=?Ϋ6z?@?вᰊ?4֡a?+a@?䎊r?W'?ӎMj?tj?˒:)z?eڹ?'/W?xF]?D*?+?4J?,<?x?x?64K?ܼj~#?^5?|?L_?[?Q_p?m\?@4?rGE9???nO;??|hs?)y?tj~?\(\?!-w1?(?)^?ae?u%F
?rGE85???k~($?XbM???k~($?N;5?t?*0?Ӂ?6C-?I^5??Z?9XbM?Z???Fs???Xe,? ѷX?*0U?©?=p
=?*0U2a|?,<?{?}H?!R<6?#w?F]c?ѷX?TɅo??ÈeO?³g	l?Fs?I^5??vȴ?˒:)?p:~ ?:)y?}H˒???sg?\(?S&?JL?Z?-
q?"`B?_حV? ěT?IQ?g	?-
qv?$?j~#?e+a?Ov_خ?e+?:)y??ᰉ'?ᰉ'?(\)?e+?kP{?1&y?4J??kP{?Z?+J?Y|?}H˒?Fs?u"?Mj?=K]?C,zxl?n/?4J?Ϫ͞?L_?2a|Q?1&??$tS?ᰉ'?*0
?O;dZ?u"?|1&y?|1&y?)^	?ݗ+j?$/?nO;?$tSM?_Ft??sg?n?}H˒?Z?|??	 ?A?sg?N;5f?)^	?$tS?tj~?}Z?҈?O
M?$tS?},<?~Ov_ح?Q?n/?{Q_?-
qv?g?rnO;?Xe?$tS?vOv_خF?hr Ĝbn/?}Z?4J?nO;?$tSM?bM?{qu!S?:)y?wXe+?{Q_?wkP?tj~?3*0U2a?bM?҈?%2m}H˒p)^	c*0U2a?S&?)^	PbM?p:?A?䎊r?Ϫ͞?6C-?u"{u%F?C*0U2a?H?tj~?*0U2?bsPHnOv_ح]}H˒?uL_`bM?ɅoiD?sg?Z?A?@NU?n/?R<64        pbM?*0?kP{?a4J?zvȴ9?N;5?:)y?u"?~Ov_ح?sg?E?ݗ+jUL_g?xtj~?|C,zxl?bM?S&?4J?wkP?Xe?,<?U=K?qu!S?	 ?~Ov_ح?{qu!S?n/?u"?|1&yc*0U2a?}}H˒g?|??$/?sg?@bM?e+a?6C-?U=K?u%?=K]?sg?hr Ĝ?sg?$tS?o䎊q޿F?`d8?ᰉ'?,<쿱?$tSp)^	j6C-?,<?sg?_o ?*0U2?,<?*0U2a?-V?ݗ+j?S*0U2a?hr Ĝ?u"?:)y?u%F
?Ϫ͞?_o?Z6C-?W>6z?	 ?!-w1?},<Z6C-?x*0
qu"ku%F?!-w1??bM?:)y?tj~?|1&y?Ov_ح?=K^?҈?dzG{?u"?,<?Ϫ͞?Sٿ,<rsPHo!-w1?~Ov_ح?	 ?hr Ĝ?@NU?N;6?tZ?IQ?$/?s@NU?:)y?ᰉ'?%2?{Q_?o䎊q޿ie+a?}}H˒?:)y?tj~?S&¿@bM?T`d?$tSZ6C-g?o䎊q?4J?|??*0?Q?u!?sPH?Xtj~?0
(??$tS?Xe+?@NU?*0?tj~?nO;?S&?S&?`bM?S?pbMg?htj~?y_o ?}Z?`bMS*0U2a?_Ft?6C-F?	 ?o!-w1ſkQ_j6C-[Q_?<64C*0U2a?rnO;?䎊q?ᰉ'?ᰉ'?L_?u"?F?u"??u"?0
(?Xe?ᰉ'?sg?Zݘ?-
qv?bMbn/ie+a?-V?$tSM??)^	?}H˒?N;5?@bM?n/?!-w1ſwXe+ԿM}H˒?tn?Z6C-?҈?*0U2a?IQ?-V?+I?҈?$/J6C-?,<?qu"nOv_حs@NU?3*0U2a?)^	?}}H˒?-
qv?y_o ?y_o ?$tS?y_o ?},<?*0U2a?@NU_!-w1?l1&yo!-w1?rsPH?PbM?ku%F?%2?Ϫ͞?-V?!-w1?	 ?-
qv?+jg?:)y?Z?u!?nO;?sPH?*0U2a?@NUXtj~rn/?htj~`bM?nOv_ح6C-?bsPH?4J?u"?ie+anOv_حnOv_ح?	 ?T`d?tzG{o!-w1?xtj~ie+a`bM?Xe?sg?u"??u!?z6C-?+jg?sPH?*0
?Z?*0U2?{qu!S?xtj~?qu"?s@NU?~Ov_ح?|C,zxl?n/J6C-ku%F?rnO;C*0U2a?qu"?~Ov_ح??N;5?0
(?Q?PbM?ku%F?sg?zG{?S&?bM?zvȴ9s*0U2a?{qu!S?&?o!-w1?htj~?v?$tS?Xe+Կ*6C-PbM?{Q_?{qu!S?O;dZ?IQzvȴ9o䎊q?{qu!S?Mj?y_o ?w?|C,zxl?kQ_p)^	?wkP?kQ_?F?y_o ?vȴ9?ye+aj6C-?bsPH?o䎊q?N;5?*0?-Vw?{u%F?N;5rnO;?,<?hr Ĝ??x*0
?3*0U2a?s@NUkQ_?O;dZ?|1&y?o䎊q޿[Q_S*0U2a?{qu!S?xtj~?Ov_خ?)^	?uL_nOv_ح?tZ?l?bM?)^	_!-w1?l1&y?u"?nO;?x*0
?{Q_?䎊q?$tSM?Rn/UL_?n?bM?rn/ku%F?xtj~?vOv_خ?|C,zxlrsPHz6C-?s@NU?vǿ]}H˒?}H˒?ᰉ'?!-w1?a4JnOv_ح6C-J6C-s@NUa4J?L_?L_?ᰉ'?Zݘbn/?vȴ9X?p:bsPH?u%FV?0
(?UL_?Rn/?Z?wkP?z6C-?䎊q?{Q_?ݗ+j?:)y?s*0U2aye+as@NU?|1&y?a@N?qu"?rnO;?{u%F?`A7L?nOv_حF?wXe+?ߤ??=K^?	 ?rn/tn)^	q4J?nO;?䎊q?a@N?hr Ĝ?Zݘ?Fs?}Zc*0U2a?g?kP{?tn!-w1ſZ6C-?*0
?O
M?+jg?S*0U2a?*0?*0U2?usg},<?v+I?fǿwXe+?bsPHxtj~3*0U2a?ku%F?htj~?kQ_?S*0U2a?bsPH?=K]?4J?1&y?tj~?u%FS*0U2a?`A7L?fOv_خ?tn?tj~?n?Zݘ6C-?ie+a?zvȴ9?,<?tZ|C,zxlwpbM?nO;?*0U2	 ҿbn/??u"?,<쿱?{u%F?j6C-j6C-?H?nXtj~?$tSM?ߤ??}Z?`bMnOv_ح?s*0U2a?ae?zG{f?p)^	?usg?{Q_?vOv_خ?v?{Q_?o䎊q?pbM?}H˒?sg?wXe+?u%?}}H˒@bM?:6C-Rn/?s@NU?o䎊q޿rnO;?p)^	?ku%F?g?v?xPH?rnO;?bn/s@NU?/v?!-w1?Z?=K]?M}H˒:6C-?O;dZ?*0U2?O
M?=K^?,<s*0U2aqu"?rsPH?x*0
?xtj~??_!-w1?bn/?y_o J6C-rn/rnO;-
qvxPHeL_?tzG{?ݗ+j?ɅoiD?nO;?xPH?hr Ĝ?tj~?Zݘ?usgtZusg?Rn/g?[Q_?1&y?u!?xPH?v+I?n??_!-w1?T`d?ye+a?zG{?*0?ݗ+j?}}H˒o䎊q?s@NUfOv_خuL_?c*0U2a?-
qv?tj~?*0?L_?2a|Q?rn/?wXe+?E?*0?₿kQ_?n/?-
qv?$/?*0
?z6C-?bM?*0?ɅoiD?Z?*0?sPH?rsPH?z6C-?@bMnOv_ح?c*0U2a?|1&y?ye+a?rn/?{u%F?*0
?)^	o!-w1?nOv_حj6C-?N;5?x*0
?uL_??vȴ9?j6C-?pbM?}}H˒?!-w1?vȴ9?,<?FǿXtj~?ݗ+j?N;5X?xtj~?{u%F?eL_o!-w1?xtj~?*0U2a?E?$tStZ?fǿq4J$tS?{Q_?`d8?~Ov_حUL_?w?vOv_خ?bM?tj~?nO;Rn/?n/?|1&y?x*0
uL_uL_?rnO;?xPH?f?pbM?ie+a_!-w1?v?Ov_خ@bM??w?p)^	f?v+I?@NU?Zݘrn/{u%F?j6C-rn/{Q_$tS?@bM?v        `bM?L_?$/?n/?J6C-?tn?<64?kQ_?`A7Ltn~Q?fǿvǿ{qu!S?tj~?$/?v?*0
?zG{?rnO;?rn/?|C,zxl?eL_pbM?qu"g?+?Ϫ͞?O
M?N;5?w?u%?fOv_خ?:)y?Q_?tZ?3*0U2aM}H˒?PH?QtzG{@bM?JD?*0U2a?@NUqu"?쿱[W??`bM?j6C-??uL_UL_z6C-{Q_Rn/?s@NU?a4JdzG{?UL_?dzG{s@NU?l1&y?ie+apbM?sPH?J6C-?tn?}Z?䎊q?	 ?M}H˒?Z6C-?:6C-?4J?-
qv?zvȴ9?ye+a?$tS?~Ov_ح?ɅoiD?=K^???Fshtj~ku%F?Xe?y=b?*0
?tZ?rsPH?x*0
?xPH?gF?w?v?q4JrnO;?vOv_خ?|C,zxl?ye+ag?Ϫ͞?-V?x*0
?䎊q?1&y?qu!S?bsPH?eL_??uL_?Ov_خ?e+ahtj~Rn/?Fs?ɅoiDM}H˒?rsPHm}H˒?J6C-?-V?Ov_خ?s@NU?=K]?vȴ9X?-
qv?qu"Z6C-?tj~?{ſm}H˒?wXe+?l1&yvǿs@NU?eL_?z6C-?|C,zxl?Z?v+I?hr Ĝ?{qu!S)^	PbM??Z?$/?:)y?rn/g?p:?|1&y?nOv_ح?ye+a?:)yVǿq4J?IQ?$tS?䎊q??w?M}H˒?*6C-?_o?$?Z?l?tj~?|?o!-w1?v?-
qv?:)y?3*0U2a?rnO;?wXe+Կg?@bM?_o ?C,zxl?tj~?2a|Q?ᰉ'?!-w1ſ`bM?{Q_?xPHm}H˒?qu"?{qu!S?l?bM?bM?ɅoiD?*0
?xtj~?dzG{PbM?u!?+J?`A7L?~Ov_ح?wg?:)yuL_?kQ_?Xe?y_o tn?j6C-?-
qv?|C,zxl?|C,zxl?x*0
?s@NU?tZ?z6C-?},<?fǿku%F?|1&y?|1&y?$tS?&?Fsa4J?,<?+jg?kP{?_Ft?Q_?fA?쿱[W??6C-?vȴ9X?y_o ?nOv_حJ6C-?sPH?x*0
qu"?uL_?$tS?$tS?-
qv?$tS?}}H˒?}}H˒?|C,zxl?qu!S?S&¿rnO;fOv_خ?Fǿc*0U2a?ݗ+j?*0U2a?ݗ+j?+?hr ĜZ6C-?q4J?~Q:6C-?S?S?c*0U2a?UL_?`bM?@bM?-
qv?)^	?v+I?*6C-?&?҈?tZ?|C,zxl?},<fǿtzG{?u%F?+I?{qu!S?%2?n/s@NU        ?pbMXtj~?xPH?	 ?ݗ+j?䎊q޿ie+a?tZuL_rsPH?Q_?Xe+?)^	?0
(?Q?sg?$/?fA?_FtXtj~?wXe+?-
qv?tj~?Ov_خ?W>6z[Q_?usg[Q_q4J?_!-w1?}Z?!-w1?},<?%2?*0U2a?S*0U2a?~Ov_ح?R<64?䎊r?:)y?a@N?n/bsPH?v+IrsPH?qu"?zvȴ9?~Q?䎊q?xPH?{Q_?}Z?_o ?IQ?|C,zxl??rsPHm}H˒q4JpbM?vǿhtj~?hr Ĝ?@NU]}H˒?htj~Vǿ{qu!S?V?vOv_خ?wkP?A?V?hr Ĝ?x*0
Xtj~?bM?wXe+?~Q?|1&y?}}H˒?nO;gnOv_ح?qu"?*6C-?eL_?{Q_?}Z?Z6C-S*0U2a?dzG{Rn/?0
(?IQku%F?|C,zxl??䎊q?uL_wo䎊q?tnPbM?p)^	_!-w1ſtn?$tSM?PH?䎊q?bM?w?{qu!S?bsPHJ6C-?~Q?}Z?m}H˒p)^	ie+a?usg?wie+a?tn?4J?y_o ?wVǿs*0U2a?xtj~?L_?+I?C*0U2a?rnO;?{Q_?&x[Q_?{ſ_!-w1?~Q?	 ?|1&y?{qu!SfOv_خ?ku%F?2a|Q?T`d?_!-w1ſnOv_حl1&ytzG{?S*0U2a?fA?p:?tnm}H˒?z6C-?)^	?	 ?|1&y?n/?zG{?u"?쿱[W??L_?v+Iz6C-PbM?zvȴ9?nO;?fA?E?vȴ9Xl1&y?}Z?v+Im}H˒?$tSVǿpbMhtj~?ku%F?-
qv?Q_?s@NU        `bM?y_o ?sPH?$/?u"c*0U2a?|C,zxlm}H˒pbMtn?q4J@bM?rsPH?u"?Ϫ͞?wkP?},<?3*0U2a6C-?s@NU?htj~?Q?hr Ĝ?&_!-w1?tzG{?䎊q?-
qv?u"?hr Ĝ?Ov_خ?xtj~?ye+a?{Q_?},<?4J?V?g?`A7L?q4JuL_s*0U2arn/j6C-?N;5J6C-vOv_خs*0U2a?f?C*0U2as*0U2a?eL_??j6C-rn/:6C-?qu"fOv_خ?xPH?uL_?xPHhtj~?v+I?w?u"?:)y?`A7L?_o ?!-w1ſ6C-rn/?g?vȴ9X?x*0
?:)y?L_?䎊r`bM?tzG{?v+I?ie+ausg|C,zxl?p:?!-w1?bM?sg?$tSo䎊q?vOv_خ?$/?Q_s@NU*6C-?&?+?u"?~Q?{u%Fie+a?wXe+?ye+a?usg?C*0U2a?O
M?sg?fA?>BZc?#?tj?fA?fA?҈οhtj~o䎊q?v?}Z?xtj~?T`d?sg?vȴ9X?@?Z?tj~ۿC*0U2a?~Ov_ح?kP{?$tS?usgq4J?wXe+Կtnwtn?)^	?FsF?o䎊q?~Q?*6C-?N;5?,<?vȴ9?Ϫ͞?0
(Rn/?ye+a?n/?2a|Q?Z?`d8Xtj~?|??Xtj~?o䎊q?_o?L_??IQ?u%F:6C-        ?[Q_?nOv_ح?Ϫ͞??{u%F?p)^	o䎊q?v+I?nO;j6C-?u"?sg3*0U2as*0U2a?Z?q4JrsPH?UL_?Z6C-M}H˒?y_o ?a4JRn/?nOv_حs@NUpbM?wXe+?&a4J?o䎊q?zvȴ93*0U2a?ie+a?ie+a[Q_?J6C-?}Z?gs*0U2as@NUm}H˒?tZPbM?Fs?L_?-
qv`bM?Q_?zG{?{Q_PbM?zG{??_o ?|??u"?xtj~?hr Ĝ?vȴ9XV?l?xtj~ie+axPH?c*0U2a?Q??-V?E?ye+a?䎊q?sPH?`bM?L_?sg?nO;?@NU?䎊rtzG{v+I{qu!S?l1&y?v+I]}H˒??zG{?O;dZ?}H˒?u%F?xPH?{Q_?pbMz6C-Xtj~?N;5X??+?~Q?S&?hr Ĝ?&?S&?N;5X?j6C-?a4J?|C,zxl6C-tzG{vOv_خ?nOv_ح?u!]}H˒?N;5?nO;g?ye+a?)^	?|C,zxldzG{?nOv_ح?|1&y3*0U2a?zG{?6C-?:6C-ie+aJ6C-?g?w?$tSM?e+a?},<?q4J?V?&?bM?}}H˒?$tS?$tSM?`bM?@bM?qu"@bM?+?`d8?N;5?}Z?z6C-?-
qv?~Ov_ح?u"?*0?~Ov_ح??Rn/?|??@bM?N;5?4J?|C,zxl?{u%F?L_?`A7L?~Ov_ح?|1&y?tj~?2a|Q?Z?	 ?bn/?Xe+?҈?!-w1?p:?-
qv?},<?j6C-?qu"?L_?e+a?bM?wdzG{?҈?4J?}H˒?ߤ??	 ?,<?zvȴ9*6C-?pbMv+ItZ?o䎊q?[Q_?pbM?tj~?!-w1?},<                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ?????????????????????????????????????????????????????????????ə???????????ə?ə?ə????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      &-B"@3;40                                      1                                       