CDF       
      time      pressure  \   latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        39     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:22.273543Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_039 (39) * LATITUDE: 40.600000 * LONGITUDE: 2.350000 * DATE/TIME: 2016-08-27T08:06:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      :  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        a   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*BM   data_max      @:En/   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       :  p   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity               	long_name         salinity   units         PSS-78     data_min      @C        data_max      @CIB   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      :  @   salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d            oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @ed8   data_max      @qM8Y   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        :    	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       >   CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?73   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      : Mp   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       P   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     :    CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d          time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &-f   data_max      &-f   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @DL   data_max      @DL   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @   data_max      @   C_format      %9.4f             	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3;   data_max      3;   C_format      %8d           	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min        &   data_max        &   C_format      %4d           station                	long_name         STATION    units         unspecified    C_format      %s        (    cast               	long_name         CAST   units         unspecified    C_format      %s        ( @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @:Bᰊ@:En/@:B䎊q@:=+j@:#A [@9ꟾvȴ@9oiDg8@91.@9q@9=B@8"`@8@8c&@7m\@7۲m]@7n.@7O
M@7xPH@7faf@7LC@7af@6 hۋ@6C-@6҈@6
M;@66@6x@6<쿱@6r@6[dZ@6BnO@6!N;5@65Xy@5@5hr@5TɅo@5m8@5ZW'@5A [@4R<6@4@4/@4%ڹ@3zH@2@@2dSMj@1$/@1~($@1U2a|@1nP@0a@N@0^5?|@0L_@0\j~#@0Ca@N@0*Q_@/Ƨ-@/Sa@O@/,[W?@/o i@.sPH@.l!-@.S&@.oiD@.lVϪ@.aTɅo@.`hۋq@.vE@.s@.Q_p@.b}V@-Xe,@-)^@->B@-fA@-R:)y@-8}H@,}H@,ï@,s@,M:@,stj~@,TE@,HK]c@,>Ov_خ@,,<쿱@,=b@,&@+Mj@+֡a@+%1@+p:@+I^5@+Mj@+JL@+.H@+y=b@+hXy=@+Vȴ9X@+N2X@+E@+?[W>@+8tj@+1hr @+-@+*ڹY@+"I^5@+%@+*=p
@+-U=@+)*0U2a@+)oiD@+-%@+/@+!@+!s@+%8YK@+%m\@+"C,@+!@+'lC@+&@+ 
qu@+Q_@+u%F@+Y@+S@+C\@++@+)@+'RT@+
n@+YJ@*/w@*g@*qi@*zG@*
qv@*VϪ@*:@*T@*2W@*}Vl@*Xe,@*$/@*!-w2@*u@*v@*1@*}Vl@*Vu@*As@*E@*@*}H@*%@*ce@*Q@*Q@*)y@*XbM@*U@*Xe,@*eں@*eں@*$tS@*af@*l!-@*sg@*,<@*33333@*$tT@*2W@*X@*-
q@*#@*o@*@*'RT@*a|Q@*Ʌoi@*D*@*>BZ@*u%F@*+@*73@*C-@*Xe,@*@*l!-@*af@*ȴ9X@*t@*֡a@*SMj@*@*L_@*}Vl@*+j@*e+a@*(@*tj@*@*F@*&@*ȴ9X@*Xe@*eں@*e+@*"`B@*>@*@+@4@+u%F
@+R<6@+I^5@*!-w1@*
(@*cA @* ѷY@*m\@*[W>@+ 6@+ [6@+ [6@+ -
@+$/@+ [7@+7Kƨ@+@+TɅo@+ A7K@*@*@*-V@*\N<@*[W>@*;dZ@*IQ@+ 	k@+o h@+$/@+`A7L@+$@+@4n@+ u!@+ A7K@+ 4m@*ڹZ@*6@*dZ@*S&@*kP|@*xl"h
@*C\@*ݘ@*>B@*1'@*~@*=K^@*=K^@*_o@*3@*&@*@*^5?|@*Y}@*
=p@*ᰉ@*+j@*YJ@*=K@*9XbN@*Fs@*m8@*Ʌoi@*%F
L@*Z@*E@*?@*}Vl@*KƧ@*O;d@*@**0@*0
)@*"`@*D@*e+a@*@*^5?|@*u%@*m]@*)_@*"`@*PH@*U@*U@*F]d@*&@*}H@*tj@*@*Fs@*_ح@*Ϫ͟@*$tS@*@*Xe@*>6z@*kP@*+j@*y=c@*)@*e+@*PH@*	k~@*e+@*l"h	@*+j@*+j@*@*&@*O;d@*@**0@*Q@*l"h	@*F]d@*bM@*73@*&@*$tS@*ȴ9X@*ᰉ@*Z@*9XbN@*,<@*&@*a@O@*J@*!-w2@*@*PH@*m\@*sP@*u@*{@*:~ @*v_ح@*v_ح@*Mj@*c	@*@*qu"@*쿱[W?@*_@*<쿱@*:)z@*6z@* ѷ@*Fs@*zxl"h@*M:@*㕁$@*S@*@*\(@*Zc@*ὥ@*@N@* [7@*Gz@*n@*ߤ?@*޸Q@*cA @*ܞ쿱[@*ڟvȴ@*C\@*#w@*D*@*
=p@*4K@*Վ!R@*D@*Ԣ3@*m8@*MjO@*-@*яo@*u!S@*u!S@*N;5@*&x@*α2X@*zG@*͞%@*:@*/{J#@*s@*xF]@*C%@*6z@*6z@*]cA@*]cA@*xF]@*˅Q@*˒:)z@*͞&@*Dg8~@*rGE@* ѷ@*\)@*Ȍ@*Ǡ	k@*ƍ@*@*m\@*84֡@*JM@*%2@*{J#9@*	@*74@*`A@*&IR@*R<6@*|Q@*ae@*Gz@*u!@*@*|hs@*!-w1@*Q@*BZc @*BZc @*$t@*ߤ?@*Ft@*@*!-w1@*BZc @*!.H@*?@*A@*)_@*u%F@*+@*73@*+@*F]d@*D*@**0@*ȴ9X@*t@*!R@*2a|@*fA@*fA@*?|h@**1@*3@*j~@*`d@**0U2@*m\@*҉@*{m@*iB@*hr @*@*o@*@*_p@*{@*o @*
M;@* hۋ@*Mj@*v@*v@*'/W@*'/W@*
M;@*Mj@* hۋ@*ߤ?@*C\@*O;dZ@*@*I^5?@*"h	ԕ@*:)z@*]cA@*C,z@*6z@*'/@*0U2a|@*Ov`@*@*B@* ѷ@*˒:*@*1&x@*	k@*E84@*,@*@*]cf@*&I@*IQ@*
L/@*u@*Z1@*xF@*%2@*
=p@*%2@*@*@*a@N@*\(@*n.@*@N@*ěT@*4m9@*˒:)@*@*"@*@*ߤ?@*ߤ?@*쿱[W@*vȴ9X@*Vl!@*#x@*PH@*$@*A@*/V@*c	@*xl"h
@*@*_o@*b}@*~($@*b}@*b}@*JE@*+@*tj@**0@*O;d@*Fs@*$/@*Ʌoi@*E@*g	l@*MjO@*<64@*T`d@*GE85@*:)y@*GE85@*-V@*s@*-@*l@*@*$tT@*H@*-
q@*Vϫ@*͞@*iDg8@*Mj@*t@*p:~@*Vu@*.2@*zG@*M:@*:@*V@*@*1&y@*fB@*L/{@*lD@*k~(@*7KƧ@*Dg8~@*9Xb@*	k@*&@*+I@*RT`e@*E84@*E84@*8}H@*]cf@*@*IQ@*@*$/@*
L/@*ڹ@*8YK@*+a@*tSM@*
=p@*M@* [7@*NU@*|hs@*H˒:@*@*~Q@*~
(@*}-V@*|u"@*|Q@*{m]@*{~$@*{dZ@*{W>6z@*zQ_@*xe+@*vC-@*v@*wXe,@*w
=p@*vϪ͟@*v@*w1@*v}Vl@*v_ح@*v+jg@*vt@*uᰉ@*u?@*u$/@*ufA@*ufA@*usg@*u$/@*u!R@*ush@*u\(@*u%F
L@*t,<@*s|@*sg	l@*sMjO@*rsP@*rsP@*rsP@*rS&@*rT`d@*r-V@*qR@*qA [@*p$tT@*poiDg8@*o@*o
M;@*o
M;@*o
M;@*nMj@*nߤ?@*nc	@*nH@*n;5X@*nH@*nH@*nc	@*nc	@*np:~@*nVu@*n.2@*n.2@*m8Y@*m5Xy>@*mqu"@*mV@*l~($x@*lL_@*kU=@*k]cA@*k]cA@*k]cA@*k]cA@*kjf@*kC,z@*j͞&@*j0
@*j#9@*i@*iᰉ'@*i^5?}@*i^5?}@*iB@*ik~(@*h\)@*hۋq
@*h@*hK]c@*g-@*gzH@*g&@*g8}H@*g,@*g)^@*f]cf@*f-@*fIQ@*f@*e1@*e@*eݗ@*em\@*e+a@*d7@*d?@*dTɆ@*dS@*dqj@*do h@*dtSM@*dxF@*c@*cZ@*c@*c{J#9@*c{J#9@*cF]c@*bC,@*b@*b}Vm@*bh	ԕ@*be+@*be+@*be+@*b&IR@*a@*a7Kƨ@*ao hی@*a [7@*`҈p@*`n@*`IQ@*`A7K@*`
qu@*_䎊r@*_حV@*_@*_@*_@*_?@*_$tS@*_$tS@*_Ft@*^҈p;@*^@*^($x@*]b@*]cA @*]H˒@*]H˒@*]H˒@*]-V@*]+j@*]}H@*]p
=@*]Vl!@*]/w@*]!.H@*\hr@*\N;@*\64@*\n.@*[6@*ZG{@*Zݘ@*Y(@*X4֡b@*XF@*X@@*Xe+@*XQ@*XbM@*W&@*WXe,@*W>6z@*WXe@*V@*VϪ͟@*V}Vl@*Vȴ9X@*V+J@*V8YJ@*V4K@*U!.@*U\(@*UϪ͞@*UϪ͞@*UϪ͞@*Uᰉ@*Uᰉ@*U!.@*U!.@*U!.@*U!.@*UϪ͞@*U=K@*Usg@*UfA@*U2a|@*TZ@*TD@*TZ@*T3@*TO
M@*T#@*T@*S@*S*0U2@*Sg	l@*Sg	l@*SZ@*SZ@*RsP@*R{m@*Rn@*Ql@*Ql@*Ql@*Qu@*Q@*Qu!S@*Q4J@*P$tT@*P)^@*P'RT@*P
=q@*P
=q@*P
(@*P'RT@*PH@*O@*O\(@*OAs@*O hۋ@*N2X@*NO;@*NT@*NT@*Nqi@*N!R<@*N_o @*MC\@*N_o @*MC\@*M@*Mhr!@*MjOv@*Mw1@*M\@*M\@*Mw1@*MjOv@*Mw1@*MjOv@*MjOv@*Mw1@*Mw1@*Mw1@*Mw1@*M%@*M%@*MM:@*Mw1@*Mw1@*M\@*M\@*MB@*MV@*M:@*L@*L@*LC@*LcA \@*L<쿱@*L/{J#@*K~($@*KxF]@*KxF]@*Kjf@*KxF]@*KP{@*KP{@*K6z@*KC%@*KC%@*KC,z@*Jg	@*JL/{@*Jg	@*Jn@*J0
@*JL_@*JL_@*J~"@*JqiC@*J~"@*JqiC@*Jd7@*JL_@*JL/{@*JqiC@*JOv`@*IB@*IoiD@*Ix@*H\)@*HTɅ@*HTɅ@*HTɅ@*H@*HTɅ@*HTɅ@*H˒:*@*Hu%F@*Hu%F@*H@*H@*HeO@*H1&x@*H1&x@*H$xG@*GfA@*G	k@*G_o@*G8}H@*GRT`e@*G&@*Gݗ+@*GlC@*G_o@*GE84@*GE84@*GRT`e@*G+I@*GE84@*G)^@*G)^@*Fx@*F'@*FIQ@*F,<@*F-@*F'@*Fs@*Ffffff@*Ffffff@*FL/{J@*F1.@*F1.@*F1.@*F$/@*F$/@*F?@*F@*Eڹ@*EoiDg@*E@*E@*E8YK@*EoiDg@*F
L/@*F@*F@*F1.@*FL/{J@*F$/@*F
L/@*F
L/@*En/@*EO
@*Eݗ@*EF
L0@*ES&@*Ezxl"h@*En/@*E@*E@*E@*En/@*E8YK@*ES@*Eڹ@*Eڹ@*Eڹ@*F
L/@*F@*F
L/@*F
L/@*F@*F@*F@*F@*EoiDg@*EoiDg@*Eڹ@*E8YK@*Ezxl"h@*Em\@*E`A7L@*Eݗ@*Ezxl"h@*Ezxl"h@*Eݗ@*Eݗ@*E+a@*D/@*D?@*D?@*D7@*DTɆ@*DS@*Dqj@*D2W@*Dtj@*CZ@*CeO@*CeO@*Cwk@*C@*Cwk@*C9@*CS&@*B`A@*B}Vm@*B@*B\(@*BwkQ@*B@*B@*B@*B@*B`A@*B@*B}Vm@*B}Vm@*B`A@*CS&@*CF]c@*CS@*CS@*Ca@N@*Cn.3@*CF]c@*Ca@N@*C{J#9@*C{J#9@*Ca@N@*Cn.3@*Ca@N@*C9@*C9@*C,zxl@*C,zxl@*CF]c@*CS@*Cn.3@*C{J#9@*Ca@N@*C9@*CS&@*CS&@*CS&@*CnP@*C	@*CS&@*B@*BM@*BM@*Bu%F
@*B\(@*BwkQ@*BwkQ@*BwkQ@*BwkQ@*BwkQ@*B\(@*B\(@*B@4@*Bh	ԕ@*B@4@*Bu%F
@*Bh	ԕ@*Bh	ԕ@*Bu%F
@*B@4@*B@4@*B@4@*B\(@*B@4@*B@4@*Bu%F
@*B@4@*Bu%F
@*B@4@*B\(@*B\(@*Bu%F
@*Bh	ԕ@*Bu%F
@*B\(@*B\(@*Bu%F
@*Bu%F
@*B@4@*B}Vm@*B@*B@*B@*B@*CS&@*CnP@*C9@*CS@*CS@*Ca@N@*C{J#9@*Ca@N@*CF]c@*C	@*C,zxl@*C,zxl@*C9@*C9@*CS@*Ca@N@*C{J#9@*Cwk@*C@*CZ@*C
=p@*D%1@*Dqj@*DTɆ@*DTɆ@*D?@*D7@*D*0@*DJM@*Eu@*E84֡@*ES&@*ES&@*E`A7L@*E`A7L@*E`A7L@*E`A7L@*Em\@*Em\@*E@*E@*ES@*Eڹ@*F@*F1.@*F1.@*F?@*FYJ@*Fs@*FIQ@*Ffffff@*FYJ@*Ffffff@*FYJ@*FL/{J@*Ffffff@*Fs@*FIQ@*F@*F,<@*F,<@*F,<@*F,<@*F@*FIQ@*Fs@*Fs@*FIQ@*F,<@*F,<@*Fs@*FIQ@*FIQ@*F@*F@*Fs@*F@*F,<@*FA@*G)^@*G+I@*G8}H@*GRT`e@*G_o@*Gy@*G&@*Gݗ+@*G	k@*GzH@*G/V@*GK]d@*GfA@*G-@*H	ԕ+@*H@*H@*H$xG@*H1&x@*HK]c@*HeO@*HeO@*H˒:*@*H˒:*@*H@*Hu%F@*H@*H@*H@*H9Xb@*H9Xb@*HTɅ@*Hp:@*Hp:@*Hp:@*Hۋq
@*Hp:@*Hۋq
@*H@*H@*H@*Hۋq
@*H\)@*H\)@*I ѷ@*I ѷ@*I@*I*0U2a@*I*0U2a@*IDg8~@*IQ@*I^@*Ix@*IoiD@*I@*I@*I'RTa@*IB@*I^5?}@*Iy@*Iԕ*@*Iy@*Iᰉ'@*I@*J	 @*J	 @*J#9@*J0U2a|@*J=p
@*J=p
@*J=p
@*J=p
@*J=p
@*J0U2a|@*J0U2a|@*J0U2a|@*JJL@*JJL@*JJL@*Jd7@*JqiC@*JL_@*J0
@*Jg	@*Jg	@*Jn@*J͞&@*J͞&@*JڹY@*JfB@*JfB@*JD@*JD@*K'/@*KC,z@*K'/@*K)^	@*K6z@*KC%@*KP{@*KP{@*KP{@*KQ@*K:)z@*KU=@*KU=@*K:)z@*K:)z@*K:)z@*K:)z@*KU=@*K~($@*K҈@*Ks@*L1&y@*L"h	ԕ@*L<쿱@*LVϪ@*LVϪ@*LVϪ@*LVϪ@*LI^5?@*LVϪ@*LVϪ@*LVϪ@*LI^5?@*LcA \@*LC@*L@*L[W?@*L[W?@*L>B[@*L!-w@*M:@*MV@*M(@*M5Xy>@*MB@*MB@*MO;dZ@*MjOv@*MjOv@*MjOv@*MjOv@*MjOv@*Mw1@*Mw1@*MM:@*M%@*M@*M@*M8Y@*M@*M
qv@*M(@*M
qv@*M@*M@*M@*M@*M(@*MC\@*N_o @*NzG@*N!R<@*N;5X@*NH@*NVu@*Np:~@*Nc	@*N}Vl@*Nqi@*NO;@*NT@*NT@*N2X@*Nߤ?@*NT@*N2X@*Nߤ?@*Nߤ?@*Nt@*Nߤ?@*N2X@*Nt@*N+@*N1@*N+@*N2X@*NT@*N2X@*Nߤ?@*N+@*N1@*NMj@*O
M;@*O
M;@*O'/W@*OAs@*O\(@*O\(@*O\(@*OO
M@*OO
M@*OO
M@*OO
M@*OiDg8@*Ov_ح@*O@*O-V@*O͞@*Or@*Oo @*O@*O@*O;dZ@*OrGE9@*P@*P@*P@*OVϫ@*OrGE9@*P@*P*0U@*P ě@*P-
q@*P:~ @*PH@*PbM@*PoiDg8@*P|@*P'RT@*P
=q@*P
(@*P)^@*PD@*P`A7@*P`A7@*P$tT@*Q@*Q_p@*Q_p@*Q@*Q&x@*Q4J@*QA [@*QN;5@*Q[W>6@*Qhr @*Qu!S@*Q@*Qo@*Ql@*QX@*Q2W@*QN;6@*QR@*Q-@*Rn@*Rn@*Q-@*R䎊@*R-V@*R:)y@*RGE85@*RGE85@*RT`d@*RnO@*R{m@*R{m@*Rp:@*RS&@*RS&@*R<64@*R ě@*R<64@*RW@*R䎊q@*Rm@*Rm\@*S҉@*S&@*S33333@*S33333@*S@N@*SZ@*Stj~@*S@*SMj@*Sߤ@*S*0U2@*Sa@O@*Sa@O@*Sݗ+k@*Sg@*TJ@*T@*T,<@*T9XbN@*TFs@*TFs@*TSMj@*Tm8@*T#@*Tj~@*T֡a@*TZ@*TɅoi@*Tj~@*TO
M@*TɅoi@*T֡a@*TZ@*TZ@*TD@*TE@*U'0@*TE@*TE@*TZ@*TD@*U'0@*U*0@*TE@*U'0@*U'0@*U*0@*U%F
L@*U2a|@*U?|h@*UY|@*UY|@*UY|@*UfA@*U$/@*U$/@*U!R@*U!R@*U!R@*U$/@*U$/@*U!R@*U!R@*U=K@*U=K@*UXy=@*Ush@*U\(@*UϪ͞@*Uᰉ@*U?@*U?@*UϪ͞@*Ush@*U\(@*UϪ͞@*U?@*Uᰉ@*U!.@*V4K@*VOv_@*VOv_@*VOv_@*V+jg@*V8YJ@*VE@*V8YJ@*V+jg@*V+jg@*V8YJ@*VR<6@*VR<6@*VE@*VE@*VE@*VE@*VR<6@*V_ح@*V_ح@*Vl!-@*Vl!-@*Vz@*V+J@*V+J@*Vaf@*V}Vl@*Vȴ9X@*Vȴ9X@*VϪ͟@*VϪ͟@*VC-@*V@*V@*V@*W
=p@*WXe@*W$tS@*W1@*WKƧ@*WXe,@*WXe,@*Weں@*W4m@*W4m@*WO;d@*W4m@*Weں@*WsPH@*WkP@*W3@*W3@*W@*W@*WrG@*W@*W@*WrG@*WrG@*W@*W@*W@*WrG@*W+j@*XbM@*XbM@*X*0@*X73@*XD*@*XQ@*XQ@*X_F@*Xy=c@*XYJ@*Xy=c@*Xy=c@*Xy=c@*Xtj@*XYJ@*Xtj@*X-
@*X-
@*XU@*X)@*XU@*X)@*XF@*Xe+@*Xe+@*X4֡b@*XPH@*Y	k~@*Y#w@*Y=b@*Y=b@*Y=b@*YXbM@*Ye+a@*Yb}@*Y~($@*Y(@*YD@*Y|@*Y|@*Y|@*YD@*Y"`@*Y>BZ@*Zu%F@*Z@*Z)y@*ZC\@*ZQ_@*ZQ_@*ZkP|@*Zݘ@*Zݘ@*Zݘ@*Zvȴ@*Z>B@*Z,<@*Zc	@*Zc	@*Z~@*Z~@*[s@*["`B@*[/V@*[=K^@*[W>6z@*[qu!@*[qu!@*[~$@*[q@*[q@*[A@*[m]@*[6@*[Q@*[$@*\n.@*\Q@*\64@*\PH@*\PH@*\]ce@*\j~#@*\wkP@*\N;@*\쿱[@*\1&@*\1&@*\1&@*\1&@*\1&@*\1&@*\?@*\?@*\Z@*\hr@*\>@*\hr@*\>@*]K]@*][@*]!.H@*]/w@*]IQ@*]Vl!@*]IQ@*]Vl!@*]ce@*]}H@*]ڹZ@*]-V@*]-V@*]H˒@*]cA @*]b@*]E@*^ ѷY@*^u@*^u@*^($x@*^Ov_خ@*^\N<@*^vȴ9X@*^%@*^$t@*^6z@*^Q@*^҈p;@*^ߤ?@*^쿱[W@*_Ft@*_!-w1@*_.H@*_H˒:@*_b}V@*_o@*_|hs@*_	@*_$tS@*_[W>@*_vȴ9@*_حV@*_䎊r@*`     @*`6@*`'RT`@*`A7K@*`[6@*`u!@*`hۋq@*`u!@*`-
@*`d8@*`4m@*`ѷX@*`҈p@*`	k@*a$/@*a [7@*a-w1@*a:S@*aGz@*aTɅo@*ao hی@*a7Kƨ@*aR<6@*a'R@*a@*ao@*a@*as@*a.H@*be+@*b&IR@*b@4n@*bM@*bh	ԕ@*bu%F
@*b@4@*bwkQ@*b@*b}Vm@*b`A@*b`A@*b74@*cS&@*cnP@*c,zxl@*cF]c@*cS@*cn.3@*c{J#9@*c$@*c@*cZ@*c
=p@*cA [@*c\N@*dxF@*d%1@*d2W@*dM:@*dZ1@*dtSM@*dqj@*dS@*dTɆ@*d7@*d/@*dJM@*dJM@*eo i@*eQ@*eQ@*eQ@*e+a@*e+a@*e84֡@*eF
L0@*e`A7L@*em\@*ezxl"h@*eO
@*e1@*en/@*e@*eS@*eڹ@*f
L/@*f$/@*f?@*fL/{J@*fYJ@*fs@*fIQ@*f,<@*f'@*f&I@*fA@*fx@*g@*g)^@*g+I@*g8}H@*gE84@*g_o@*glC@*g&@*g	k@*g/V@*g@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @CrGE8@CrGE8@C@Chr @C>BZc@CTɅo@C-
@C;dZ@C_ح@CL/{J@Cg	l@C	@C
@C
䎊@Cp:@C	@C
}H@C+jg@C
Ϫ͞@C
%@CNU@Ca@O@Cvȴ9@C@CXe@C}Vl@C+I@C@C>6z@C6z@Cu@C
8Y@Cfffff@C-@C     @C{m@C!.I@C	n.@C     @C}H@CC]@C&x@Ce@C˒:)@C&@C|@Ca@@Cn.@C84֡@C@C҈@C>B[@CC%@CF@C)^@C{@CAs@Ce+@C%@C5Xy>@Czxl"@C%1@CA@Cs@C(@Cm\@C!X@C&.2@C'@C(*0@C)0
)@C)(@C*)_@C*@4@C*p:@C*h	ԕ@C*0U2a|@C*wkQ@C*m\@C+qu!@C+ݗ+k@C,Fs@C,j~#@C,SMj@C,cA \@C,S@C,e@C-84֡@C-2a|@C-Vl!@C-@C-E@C.8YJ@C.m\@C/RT`e@C/rGE9@C0d8@C0eO@C0Xy=@C0eO@C0@C0)^@C1	k~@C10
)@C1N;5@C1x@C1ԕ*@C20U2a|@C3xF]@C4"h	ԕ@C4!-w2@C4M:@C5%F
L@C5v@C5Vl!@C5U=@C68YJ@C6p:~@C6_ح@C6iB@C7@C74m@C7@C7y@C7sPH@C7{J#:@C7vȴ9@C7+j@C8NU@C8y=c@C8_F@C8A7K@C8     @C7˒:)@C7@C7	k@C73@C7/V@C8-
q@C8YJ@C8ěT@C9JE@C9>BZ@C:-V@C:3@C:Q_@C:^5?|@C:h	ԕ@C:xl"h
@C:{m@C:ݘ@C:g	@C;MjO@C<L_@C<쿱[@C<E@C=?|h@C=jOv@C=sg@C=Xy=@C=8Y@C=b@C>t@C>
(@C>4K@C>$/@C>8YJ@C>BZc @C>BZc @C>?@C>L/{J@C>IQ@C>'@C>m\@C>m\@C?!-w1@C>!.I@C>!.I@C?v@C?RT`e@C?$tS@C@	ԕ+@C@H@C@'RT@C@-
@C@IQ@C@tj@C@
=q@C@
=q@C@-
@C@@C@{@C@9Xb@C@)^@C@ěT@C@F@CA	k~@CADg8~@CAo hی@CAu@CAB@CAB@CA@CB	 @CB@CB@CB-V@CBQ_@CBS&@CB74@CC9@CCqu!@CC҈@CC\N@CDL_@CDPH@CDcA \@CDZ1@CDZ1@CDj~#@CDS@CD7@CDZ@CD֡a@CD>B[@CDhr@CEo i@CEV@CE/w@CE84֡@CEF
L0@CEO;dZ@CEY|@CE\@CEY|@CEM:@CE@CEb@CE@CF1.@CFvȴ9X@CFO;@CFO;@CFqi@CFIQ@CFiB@CFc	@CFs@CF\N<@CFOv_خ@CFR<6@CFE@CFBZc @CFL/{J@CF_ح@CFfffff@CF+J@CF$t@CF&I@CF҈p;@CFx@CFMj@CF+@CFC-@CGv@CG,@CG@CF@CFx@CG@CG+I@CG
=p@CG hۋ@CGFt@CG@CG'/W@CGAs@CGKƧ@CGXe,@CGy@CGݗ+@CG?@CG&@CGzH@CG/V@CGfA@CG-@CGrGE9@CH     @CHbM@CH*0@CH>BZc@CHXy=@CH_F@CHQ@CHK]c@CHH@CHH@CHD*@CHD*@CHQ@CHeO@CHy=c@CHr Ĝ@CHy=c@CH@CH-
@CH9Xb@CH
(@CH@@CHp:@CHD@CH\)@CI@CI#w@CI#w@CI&x@CI-w1@CI0
)@CIA [@CIJE@CITɅo@CITɅo@CITɅo@CI^@CIk~(@CIu!S@CI@CIo@CI@CIR<6@CI'RTa@CIn.@CIn.@CIu@CIR<6@CIo@CIo@CI~($@CI@CI'RTa@CIl@CIB@CIB@CIl@CI(@CI'RTa@CI@CI@CIR<6@CIR<6@CI@CIo@CIo@CI~($@CI7Kƨ@CIoiD@CI@CIb}@CIu!S@CI[W>6@CIDg8~@CI7KƧ@CI-w1@CI#w@CI@CI_p@CI@N@CIrGE@CI	k~@CI$/@CI$/@CI$/@CHPH@CH{@CH@CH҈p@CHѷX@CHěT@CHěT@CH9Xb@CH{@CH@CH-
@CHu%F@CH@CHtj@CH'RT@CHn@CHu!@CHu!@CHr Ĝ@CHr Ĝ@CHl"h	@CHl"h	@CHXy=@CHQ@CHK]c@CHD*@CH>BZc@CH73@CH4m9@CH4m9@CH4m9@CH-
q@CH1&x@CH1&x@CH-
q@CH1&x@CH-
q@CH'RT`@CH6@CH@CH*0U@CHbM@CH
qu@CHF]d@CGrGE9@CG+j@CG-@CGVϫ@CG@CG@CGحV@CG@CG@CG+@CGo @CG@CGvȴ9@CG@CGvȴ9@CGr@CG[W>@CG&@CG&@CG	k@CG	k@CG	k@CG?@CG[W>@CGzH@CG͞@CGzH@CG	k@CG$tS@CG@CG{J#:@CGsPH@CGo@CGb}V@CGU=@CGU=@CGU=@CG\(@CGXe,@CGH˒:@CG>6z@CG;dZ@CG;dZ@CG;dZ@CG;dZ@CG4֡a@CG.H@CG.H@CG4֡a@CG.H@CG'/W@CG,@CG!-w1@CGv@CG
M;@CG
=p@CGFt@CG
M;@CG
=p@CG@CF"@CFMj@CF쿱[W@CFx@CF1@CF1@CFx@CFx@CFx@CFx@CFx@CFx@CF1@CFߤ?@CF+@CF҈p;@CFt@CFm\@CF@CFߤ?@CF@CF&I@CF&I@CFQ@CFQ@CF2X@CF}Vl@CFaf@CFaf@CF,<@CF$t@CF@CFqi@CF+J@CF%@CFIQ@CF}Vl@CFvȴ9X@CFiB@CF_ح@CFYJ@CFYJ@CFVu@CFVu@CFOv_خ@CFL/{J@CFE@CF;5X@CF.2@CF($x@CF!R<@CF@CFzG@CF
L/@CF
L/@CF
(@CF
L/@CF
L/@CF
L/@CF_o @CEE@CE(@CE,=@CE
qv@CE?@CE8YK@CEϪ͞@CE@CE8Y@CEH˒@CE@CEsh@CEsh@CE-V@CEU=@CEXy=@CE@CE=K@CEO
@CEݗ@CEzxl"h@CEm\@CE\@CEVl!@CEVl!@CEL_@CEL_@CEIQ@CEIQ@CEIQ@CEF
L0@CE?|h@CE?|h@CE84֡@CE84֡@CE2a|@CE%F
L@CE%F
L@CE!.H@CEqu"@CE*0@CEV@CE'0@CEo i@CEo i@CE:@CDe@CDD@CDhr@CDhr@CDJM@CD>B[@CD*0@CDɅoi@CD7@CD#x@CD@CD@CD1&@CDS@CD*1@CDqj@CD*1@CDqj@CDqj@CDC@CD?@CDo h@CDzG@CDwkP@CDtSM@CDtSM@CDtSM@CDq@CDcA \@CD]ce@CDPH@CD9XbN@CD(\@CDtj@CD@CDxF@CDJ@CC\N@CC$@CCA [@CC%2@CCa@@CC|@CC@CCƧ@CC6@CCm]@CCU=@CCQ@CCQ@CCeO@CCQ@CC@CC~$@CC~$@CCxF]@CCqu!@CCqu!@CCn.3@CCjf@CCdZ@CCa@N@CCa@N@CC]cA@CCZ@CCZ@CC]cA@CCa@N@CC]cA@CCS@CCF]c@CC33333@CC6z@CC6z@CC/V@CC,zxl@CC,zxl@CC&@CC"`B@CC	@CCPH@CCnP@CC҉@CCI^@CBڹY@CBc	@CBc	@CBc	@CBfB@CB䎊q@CBG{@CBڹY@CBڹY@CBڹY@CBsP@CBsP@CBsP@CBsP@CB,<@CB`A@CB`A@CBW@CBn@CB<64@CB}Vm@CBg	@CB ě@CBL/{@CBS&@CBvȴ@CBwkQ@CBwkQ@CBvȴ@CBᰊ@CBS&@CB\(@CBݘ@CB@4@CB@4@CB~"@CB{m@CBxl"h
@CBu%F
@CBqiC@CBnO@CBh	ԕ@CBd7@CBZc@CBW'@CBW'@CBM@CBJL@CBJL@CBC\@CBC\@CB=p
@CB:)y@CB0U2a|@CB0U2a|@CB-V@CB-V@CB#9@CB1'@CB䎊@CB1'@CBe+@CBe+@CBOv`@CBs@CBI^5@CB	 @CB	 @CBn@CBu%F@CA.H@CA.H@CA-@CAY}@CAs@CAR@CAe@CA>BZ@CAe@CAᰉ'@CA"`@CA"`@CA@CAN;6@CA_o@CAy@CA2W@CAD@CA^5?}@CA^5?}@CA^5?}@CAX@CAX@CA|@CA'R@CA'R@CAl@CAn.@CA'RTa@CAu@CA@CA@CAo@CAo@CA7Kƨ@CA7Kƨ@CA7Kƨ@CAoiD@CA@CAb}@CAb}@CA|Q@CA|Q@CAx@CAo hی@CAhr @CAe+a@CA^@CAQ@CAJE@CA=b@CA4J@CA0
)@CA-w1@CA0
)@CA&x@CA#w@CA@CA@N@CA@N@CA@N@CA@CA@CA$/@CA$/@C@$tT@C@PH@C@PH@C@\)@C@{@C@{@C@4֡b@C@4֡b@C@C@C@C@C@C@C@@C@@C@@C@`A7@C@e+@C@҈p@C@҈p@C@D@C@F@C@F@C@p:@C@)^@C@p:@C@@@C@TɅ@C@TɅ@C@4m@C@4m@C@9Xb@C@9Xb@C@{@C@d8@C@-
@C@u%F@C@@C@tj@C@@C@-
@C@-
@C@@C@'RT@C@YJ@C@n@C@|@C@y=c@C@y=c@C@|@C@u!@C@r Ĝ@C@eO@C@eO@C@_F@C@[6@C@Xy=@C@U2a|@C@U2a|@C@Q@C@Q@C@H@C@H@C@D*@C@D*@C@A7K@C@A7K@C@:~ @C@:~ @C@73@C@4m9@C@73@C@1&x@C@4m9@C@4m9@C@-
q@C@-
q@C@-
q@C@-
q@C@*0@C@*0@C@*0@C@*0@C@'RT`@C@$xG@C@$xG@C@'RT`@C@$xG@C@ ě@C@}H@C@@C@@C@*0U@C@*0U@C@
qu@C@
qu@C@	ԕ+@C@     @C?#@C?#@C?rGE9@C?rGE9@C?+j@C?+j@C?䎊r@C?䎊r@C?-@C?Vϫ@C?@C?@C?@@C?@@C?@@C?@C?;dZ@C?@C?@C?@C?@C?fA@C?حV@C?حV@C?@C?˒:)@C?K]d@C?o @C?o @C?/V@C?/V@C?3@C?3@C?[W>@C?[W>@C?zH@C?zH@C?͞@C?͞@C?͞@C?&@C??@C?-V@C?	k@C?-V@C?-V@C?$tS@C?@C?O;d@C?O;d@C?@C?O;d@C?	@C?	@C?&@C?&@C?{J#:@C?{J#:@C?{J#:@C?|hs@C?4m@C?|hs@C?v_ح@C?v_ح@C?sPH@C?sPH@C?o@C?lC@C?lC@C?lC@C?eں@C?eں@C?eں@C?eں@C?_o@C?b}V@C?\(@C?\(@C?\(@C?\(@C?U=@C?U=@C?Xe,@C?U=@C?Xe,@C?\(@C?U=@C?Xe,@C?Xe,@C?U=@C?RT`e@C?O
M@C?O
M@C?KƧ@C?H˒:@C?As@C?E84@C?E84@C?H˒:@C?E84@C?As@C?E84@C?As@C?As@C?>6z@C?As@C?>6z@C?>6z@C?>6z@C?>6z@C?>6z@C?;dZ@C?;dZ@C?8}H@C?8}H@C?4֡a@C?1@C?4֡a@C?1@C?1@C?'/W@C?'/W@C?$tS@C?$tS@C?$tS@C?$tS@C?$tS@C?$tS@C?v@C?@C?@C?@C?)^@C?
M;@C?
=p@C?
=p@C?@C?@C>"@C>"@C>Mj@C>Fs@C>"@C>Mj@C>쿱[W@C>x@C>1@C>C-@C>C-@C>ߤ?@C>]cf@C>]cf@C>ߤ?@C>ߤ?@C>]cf@C>]cf@C>+@C>+@C>Ϫ͟@C>]cf@C>ߤ?@C>ߤ?@C>ߤ?@C>ߤ?@C>ߤ?@C>ߤ?@C>]cf@C>ߤ?@C>ߤ?@C>]cf@C>]cf@C>]cf@C>]cf@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>҈p;@C>Ϫ͟@C>Ϫ͟@C>A@C>ȴ9X@C>ȴ9X@C>ȴ9X@C>ȴ9X@C>ȴ9X@C>m\@C>ߤ?@C>@C>@C>&I@C>@C>@C>@C>Q@C>@C>Q@C>Q@C>2X@C>'@C>2X@C>}Vl@C>2X@C>2X@C>}Vl@C>}Vl@C>6z@C>-@C>6z@C>-@C>-@C>-@C>-@C>T@C>T@C>-@C>T@C>-@C>T@C>af@C>af@C>T@C>af@C>@C>,<@C>@C>,<@C>@C>@C>@C>af@C>@C>T@C>T@C>T@C>T@C>af@C>af@C>@C>af@C>,<@C>O;@C>O;@C>O;@C>O;@C>,<@C>,<@C>,<@C>O;@C>O;@C>,<@C>,<@C>af@C>T@C>-@C>-@C>-@C>-@C>-@C>-@C>-@C>-@C>6z@C>6z@C>6z@C>6z@C>}Vl@C>6z@C>-@C>-@C>-@C>6z@C>6z@C>}Vl@C>}Vl@C>2X@C>2X@C>2X@C>2X@C>2X@C>2X@C>6z@C>}Vl@C>6z@C>}Vl@C>6z@C>-@C>6z@C>}Vl@C>-@C>-@C>-@C>-@C>-@C>T@C>T@C>@C>@C>af@C>@C>@C>,<@C>,<@C>,<@C>,<@C>O;@C>O;@C>O;@C>O;@C>O;@C>@C>@C>af@C>,<@C>@C>af@C>,<@C>@C>af@C>@C>@C>T@C>@C>@C>@C>@C>,<@C>,<@C>,<@C>@C>@C>@C>@C>af@C>@C>@C>@C>@C>,<@C>,<@C>,<@C>,<@C>,<@C>,<@C>,<@C>O;@C>O;@C>Fs@C>O;@C>O;@C>O;@C>Fs@C>$t@C>Fs@C>Fs@C>Fs@C>Fs@C>Fs@C>Fs@C>$t@C>Fs@C>$t@C>Fs@C>Fs@C>Fs@C>Fs@C>$t@C>Fs@C>Fs@C>$t@C>Fs@C>Fs@C>$t@C>$t@C>$t@C>$t@C>$t@C>$t@C>$t@C>$t@C>$t@C>$t@C>@C>qi@C>@C>$t@C>@C>+J@C>qi@C>qi@C>+J@C>qi@C>qi@C>@C>qi@C>qi@C>qi@C>qi@C>qi@C>qi@C>qi@C>+J@C>qi@C>qi@C>qi@C>%@C>+J@C>%@C>+J@C>+J@C>%@C>+J@C>%@C>IQ@C>%@C>IQ@C>IQ@C>IQ@C>IQ@C>IQ@C>%@C>IQ@C>%@C>+J@C>%@C>%@C>+J@C>+J@C>+J@C>%@C>%@C>%@C>%@C>IQ@C>IQ@C>IQ@C>}Vl@C>%@C>%@C>IQ@C>IQ@C>IQ@C>IQ@C>%@C>IQ@C>IQ@C>IQ@C>IQ@C>IQ@C>IQ@C>}Vl@C>}Vl@C>IQ@C>IQ@C>}Vl@C>z@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>}Vl@C>z@C>z@C>z@C>z@C>vȴ9X@C>vȴ9X@C>z@C>z@C>z@C>z@C>z@C>vȴ9X@C>vȴ9X@C>vȴ9X@C>z@C>z@C>z@C>z@C>vȴ9X@C>vȴ9X@C>s@C>s@C>vȴ9X@C>s@C>s@C>s@C>p:~@C>p:~@C>l!-@C>p:~@C>s@C>p:~@C>p:~@C>l!-@C>iB@C>l!-@C>iB@C>iB@C>iB@C>iB@C>iB@C>fffff@C>iB@C>iB@C>l!-@C>iB@C>fffff@C>iB@C>fffff@C>fffff@C>iB@C>fffff@C>iB@C>iB@C>iB@C>c	@C>fffff@C>iB@C>c	@C>fffff@C>fffff@C>_ح@C>fffff@C>fffff@C>c	@C>_ح@C>_ح@C>\N<@C>_ح@C>c	@C>_ح@C>c	@C>c	@C>_ح@C>c	@C>c	@C>c	@C>_ح@C>_ح@C>_ح@C>_ح@C>_ح@C>c	@C>_ح@C>_ح@C>_ح@C>_ح@C>\N<@C>YJ@C>\N<@C>_ح@C>\N<@C>\N<@C>YJ@C>\N<@C>\N<@C>YJ@C>\N<@C>\N<@C>YJ@C>YJ@C>\N<@C>\N<@C>\N<@C>YJ@C>\N<@C>YJ@C>Vu@C>\N<@C>YJ@C>YJ@C>Vu@C>YJ@C>YJ@C>YJ@C>YJ@C>Vu@C>Vu@C>Vu@C>YJ@C>Vu@C>R<6@C>R<6@C>R<6@C>Vu@C>R<6@C>Vu@C>Vu@C>R<6@C>Vu@C>R<6@C>Vu@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>L/{J@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>Vu@C>Vu@C>R<6@C>Ov_خ@C>R<6@C>Ov_خ@C>Ov_خ@C>R<6@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>H@C>H@C>L/{J@C>H@C>H@C>E@C>H@C>H@C>H@C>E@C>H@C>E@C>H@C>E@C>E@C>BZc @C>E@C>BZc @C>BZc @C>?@C>?@C>BZc @C>?@C>BZc @C>BZc @C>BZc @C>;5X@C>?@C>?@C>;5X@C>;5X@C>8YJ@C>8YJ@C>8YJ@C>;5X@C>;5X@C>8YJ@C>;5X@C>8YJ@C>8YJ@C>5?|@C>5?|@C>5?|@C>5?|@C>1.@C>5?|@C>5?|@C>1.@C>.2@C>.2@C>.2@C>1.@C>1.@C>1.@C>.2@C>.2@C>.2@C>.2@C>.2@C>.2@C>.2@C>+jg@C>+jg@C>+jg@C>+jg@C>+jg@C>($x@C>($x@C>($x@C>($x@C>($x@C>($x@C>$/@C>($x@C>($x@C>($x@C>$/@C>($x@C>($x@C>$/@C>($x@C>$/@C>$/@C>!R<@C>!R<@C>$/@C>!R<@C>!R<@C>!R<@C>!R<@C>$/@C>!R<@C>!R<@C>!R<@C>Ov_@C>Ov_@C>u@C>u@C>u@C>u@C>@C>@C>@C>u@C>u@C>u@C>u@C>@C>@C>zG@C>@C>zG@C>zG@C>4K@C>zG@C>4K@C>zG@C>4K@C>4K@C>zG@C>4K@C>4K@C>4K@C>4K@C>4K@C>zG@C>4K@C>4K@C>4K@C>4K@C>4K@C>4K@C>
(@C>4K@C>4K@C>
(@C>4K@C>4K@C>4K@C>
(@C>
(@C>
(@C>4K@C>
(@C>
(@C>
(@C>4K@C>
(@C>
(@C>4K@C>
L/@C>
L/@C>
(@C>
(@C>
L/@C>
(@C>
L/@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
L/@C>
(@C>4K@C>
L/@C>
(@C>
L/@C>
L/@C>
(@C>
L/@C>
L/@C>
L/@C>
L/@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
L/@C>
L/@C>
(@C>
L/@C>
L/@C>
(@C>_o @C>_o @C>_o @C>_o @C>_o @C>_o @C>
(@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>_o @C>t@C>t@C>t@C>
L/@C>
L/@C>
L/@C>
L/@C>_o @C>
L/@C>t@C>_o @C>_o @C>_o @C>_o @C>
L/@C>
(@C>
(@C>
(@C>
L/@C>
(@C>_o @C>
L/@C>
L/@C>_o @C>
L/@C>
(@C>
L/@C>
L/@C>
(@C>
(@C>
(@C>_o @C>
L/@C>
L/@C>
L/@C>
(@C>
(@C>
(@C>
L/@C>
L/@C>_o @C>_o @C>_o @C>
L/@C>_o @C>
L/@C>
L/@C>
(@C>
L/@C>
L/@C>
(@C>
L/@C>
L/@C>
L/@C>
L/@C>
(@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
(@C>
L/@C>
L/@C>
L/@C>_o @C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>_o @C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>_o @C>
L/@C>
L/@C>_o @C>_o @C>
L/@C>_o @C>
L/@C>
L/@C>
L/@C>
(@C>
(@C>
L/@C>
L/@C>
L/@C>
(@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>
L/@C>_o @C>_o @C>_o @C>_o @C>_o @C>_o @C>_o @C>
L/@C>_o @C>_o @C>_o @C>t@C>_o @C>_o @C>_o @C>
L/@C>_o @C>_o @C>
L/@C>_o @C>t@C>t@C>_o @C>_o @C>t@C>_o @C>_o @C>_o @C>_o @C>_o @C>t@C>_o @C>_o @C>_o @C>t                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @i6o h@iKo@iPPH@i@i_@i&IR@i/@j@jPH@jS@jhr@k>B@kٲm]@k/V@kzxl"@k]o@k/$@k4Z@kO(@ksg@k)^@kh@kV0U2a|@k^u!@k84֡@k0
@k#@k@kH@kzxl"h@k*0U2a@lo h@l/^@lZI^5?@l!.I@lIQ@l?@mu@m?>BZ@mq@n	k@n@n%lD@nU&@n\)@oQ_@pF&@ps)^@plC@qh	ԕ@qM8Y@pO
M@pqv@pY[W>6@pU*0@p	m@pD@pJPH@pDZ1@p'u@p",<@p'O
M@pS&@pu%F
@pnP@p^cA \@piDg8@q4,=@prGE9@py1@p:@p)˒:)@p;u%F@pEeں@oYJ@oߤ?@n.H@o<͞&@nO
M@o
l"h	@o@p~($@on/@o5+a@nbM@nOv_@mBZc @mo i@nU/w@nV{m@m,<@mU]cA@l@l*0U2@l@7@kihr @k0g8}@kPH@knZ@j-w1@j&@jߤ@@jt{@jH73@jH3@j8@j8҈p@j7u!S@j(@j/@j-@j&j~@j`d@j
-V@j
U=@jL_@i|@i0
)@iL/{J@i\)@i۝-V@iԦL/{@ihr @iH@iH@ie+a@i     @iƵ?@i?|h@i@iy@iE@io'/W@i_?@ibvȴ@ieb}V@ia6z@iJ!.I@i8x@i7{J#:@i7@i8C-@i:C,zx@i4@i@h>BZ@h@hd7@h#x@hԕ*@hl@ho @h4J@i8@iW>6z@ir@iq3@iA+@h+@hڹY@h®}Vl@hu%F@hGE85@hb}@hc	@hp
=@ha|Q@hnO@h|@hhr@hz@hZ1@hvȴ@hu%F
@h-
@h@h䎊r@hF]c@hm@hS@h{o @hp@h:{m@gv@g_o @gs@gjOv@g[6@gw1@g
(@gS&@gݗ+@g/w@h$:~ @h3@h':@hH@gӪ͞@g!R@gԕ*@gT`d@g@gC]@g~@gl"h	@g@N@g74@gZ@ghO
M@g:+@g+@gsP@f䎊r@f1'@fu@f'RT`@g kP|@g3@g@[6@g3@ge@f/V@f*0U@f/V@gt@fh	ԕ@fJE@fu!S@fD@f>B@fo h@frGE8@fƧ@f8Y@f*0U2@f64@f_o@fҗO;@f$tS@f3@fjl!-@fb@ffA7K@f}?@f@f@f@f"`@f\)@f;5X@f ѷ@fD@f-w1@f:~ @fȴ9X@fo h@fcA \@f˒:*@fFs@fm\@fL_@f`d@fߤ?@f@f(@f_F@f@f@fA7K@f@fK]@f@fְ ě@f>B[@fJ@fZ@fh	ԕ@fo@fJE@fu%F
@fحV@f@fB@f$@f{ ѷ@fm	@fbu%F@fV1@fXH@fXH@fRY@f=e@f'U=@f=S@f\q@fcae@f\p:~@fTu@fVe+@fU~$@fQS&@fF6C@fJ_ح@fM&x@fD`A@f<{m@f-4J@f_F@f^5?|@f*0@f|@f쿱[W@e@e"@eR@eܤT@e$tS@e1@e2X@e74@eݗ+@eхoiD@e@et@ehr @evȴ9X@e@N@eʒS&@eXe,@eծzH@eу{J#:@e)^@e;dZ@eW>6z@eOv_@e ѷY@e9@er Ĝ@e䎊r@es@ey@eU=@eb}@eC-@e*0U2a@ed8@e8Y@ep:~@eoiDg8@eG{@eD*@e(@eI^5@e'/W@e|Q@en.3@e5?|@e_ح@eѷX@eQ@ePH@eC\@eVϫ@es@e$@e\N<@ey=c@erGE9@e2a|@e͞&@e1&x@e?|h@e&@e͞&@e͞&@e!.H@eZc@e0U2a|@ehr @e=K^@e [7@en/@eF]d@eحV@eu%F@e!-w@e@4@e@e,@f-V@frGE8@frGE8@e^5?}@eMj@e%2@fF@f
(@eU2a|@e!R@e˒:*@eC,z@f @f
qu@eF
L0@e~"@f=K@f
bM@f8Y@f,<@eO;d@e~"@fE@fS&@f-@fkP@fkP@eᰉ'@f -@f2W@e}Vl@eDg8~@f
`d@f
_ح@fѷX@f
&x@fa@O@fn.3@eQ@f L/{@f\(@f'RT@f+j@f
_F@fzxl"h@f41&y@f41&y@f/ݗ+k@f!rGE9@f'ݗ@fS@fc>6z@fS@f_@fNiB@f6p:@f5jOv@f#\(@f(JM@f&#9@f+J@fN;5@f!@fxF]@f$/@f:e@f@?@f6t@f/Q@f-@N@f6t@f9@f5hr @f4J@fAlC@fK'RTa@fAlC@fCJE@f-nP@f1=K^@fA,=@f5fA@f8-
q@fCJ#9@f?	@fA,=@fCJ#9@f4F]d@f(@f.u%F
@f@@4@f=/V@fCIQ@fCIQ@fGsg@fJ:~ @fUW>6z@f`r Ĝ@fj+jg@fa8YK@fQ+a@fCH˒:@fGsPH@fJ:)y@f6ȴ9X@f<VϪ@fRqj@fUU=@fX1'@fgb}V@f}=K@fx
qu@fgb}V@f_
M;@f\Fs@f]l@fe\N@f\Fs@f]*0U2@faa@@f_@f`p:~@fc7KƧ@fgae@fgae@fXu@f\E@fZe+@fV4m@fa@fY~$@fUS@fj($x@fj($x@f]*0U2@fSoiDg@f\D*@f`oiDg8@fa@fS-@fKkP@f\D*@flc	@fXe+@fRL_@fkڹZ@fv@fvL/{@fr|@f~~@fym\@fq*0@fuB@fo3@fg_o@flhr@flhr@fg_o@fj&IR@fnQ_@f_
=p@f`m8@felD@fr{m@fq*0@fk	@fo|@fqXe@f|3@f^5?|@fD@fo|@fo|@frz@fsݗ+k@f#@fOv`@f}R<6@fzA@frz@fx1&y@fx1&y@f~"@f#w@fFt@fj~#@fFt@f?@f#w@fzp:@fyjf@f6@f|1.@fyjf@f#w@fzp:@fry=c@f+J@f@f@fߤ?@f@fQ@f!.@f?@fyjOv@fzG@f@fQ@fL/{J@fhۋq@f{@fcA @ftj@f!.@fL/{J@f@fhr @f
(@fZ@f@f@f@N@ft@fYJ@f)^@f)^@flC@fJ#9@fn@f\)@f:)z@f	@fhr!@fhr!@f4K@ffffff@ftj~@f ѷ@ftj~@f;5X@f̺)@fI^@f%@fӬq@f9@fr Ĝ@fW>6z@f:~ @fOv_@f̺)@fE@fH@fOv_@fdZ@fMj@f}H@feO@fH@fӫU=@fӫU=@f9@f9@f'/@fӫU=@fρ@fӫU=@fVu@f+jg@f8YK@f˒:*@fVu@fm@fU2a|@fdZ@f帺@fm@f!R@fVu@fC,z@f8Y@fm\@fF@f8Y@fS@f8Y@f73@f73@f˒:*@fF]c@f@f
(@fbM@fS@fbM@foiDg@fS@f8Y@foiDg@f4m@gXy=@f=K@f
qu@f@fbM@f@f}Vm@f)^	@gXy=@g
ڹ@g	@gXy=@gD*@f}Vm@gG{@gG{@gD*@fa|Q@f(@gXy=@g
ڹ@ga@N@gQ@goiDg8@gXy=@g'RT`@g@ga@N@gڹZ@gC%@gC%@g
qv@gڹZ@gڹZ@gC%@g@g@g$4m9@g$5?|@gPH@gsh@g@gC%@g%+j@g
qv@gsh@gB@g 	ԕ+@g-(@g,'RT@g3@g&IR@g*0@g!m\@g)\(@g$4m9@gL/{@g7S@g,'RT@g,'RT@g9u%@g6A7K@g4 ѷ@g/O;dZ@g09Xb@g/O;dZ@g0g	@g4 ѷ@g,p:@g(_F@g%+j@g+&@g/O;dZ@g2@g(_F@g+%F
L@g;Ϫ͞@g9u%@g0g	@g,p:@g4 ѷ@g-Vϫ@g/O;dZ@g>@gEݗ@g7v@g:l"h	@g=33333@g>ᰊ@gBn@g9K]@g3zxl"h@g3zxl"h@g;+@gEݗ@gEݗ@g;+@gI-V@gKs@g=2a|@gLy=c@gSjOv@gWO
@g^YJ@g_ᰉ@gWO
@gLxl"h
@gHM@gFJM@gT͞&@g_ᰉ@gO?|h@gLxl"h
@g[H˒@gWO
@gPS&@gI[W>@g:j~#@gT͞&@gWO
@gX74@g[H˒@gkS&@gfڹY@g^YJ@gV1&x@g^YJ@gd*0U@g_ᰉ@gI[W>@gHM@gO?|h@gWݗ+@gi@gd*0U@gR@gaL_@gd*0U@gaL_@gXe@gZZc@g^ݘ@gb ě@g]!.H@gZZc@gkS&@gew1@gew1@gq+j@gpS&@gsY|@gv ě@gko i@gew1@gh=p
@go/w@gko i@gm˒:)@gpS&@go/w@gko i@gq+j@gq+j@gf>B[@go/w@g-
@g-
q@gvȴ@glh	ԕ@gds@gh=p
@gt<64@gq+j@gtj~@gtj~@g{zH@gt<64@gzJL@gXy=@gD@gzJL@gqY}@g}u@gF]d@gv䎊@gw{J#:@gx@gfA@g<64@gsXe,@gzJL@gvȴ@gحV@gtj~@gzJL@g~u%F
@g}u@g}u@gF]d@gfA@gvȴ@g~u%F
@gF]d@gF]d@g~u%F
@gF]d@g!-w@gɅoi@gbM@gsP@g/V@g@g쿱[@g/V@gW'@g-V@g~tSM@g})^@g~tSM@g@g@4@gbM@gsg@gbM@gW'@g@g>B@g:)y@g@4@g@g-V@gt@g쿱[@g@g:@gVl!@g$/@gVl!@gd7@g-V@g-V@g}H@g\(@g-V@gd7@g\(@g䎊q@g\(@g+a@gH@gY@g}H@gY@g$/@gGE85@gV@gGE85@gZ@g:)y@ge@gd7@g\(@gU=@g䎊r@g͞@gqiC@gGE85@gU=@g4m@gfA@g)_@g     @g!R@g     @g84֡@g)_@gS@g)_@gU=@g+I@g4m@gGE85@g1'@gce@g~"@g@g*0@g*0@gT`d@gqu"@gr@gT`d@gqu"@g@@g8Y@g~"@gp
=@gT`d@g@@g8Y@gbM@gp
=@g,<@g,<@g@@gO;d@g͛=K@gƩ@gƩ@gm\@g,<@g,<@g
qu@g73@gG{@gߨXy=@g-@gbM@g,<@gض}Vm@g-@g~"@gm\@gm\@g͛=K@gԌ@g͚kP@gm\@g,<@ga|Q@g(@gS&@gض}Vm@gض}Vm@g}H@gض}Vm@gԌL_@gE@g(@ga|Q@gƨTɆ@g(@gZ@go@gض}Vm@gߨXy=@gߨXy=@gG{@gƨTɆ@go@gD*@g҉@gض}Vm@gE@g6@g6@gض}Vm@g6@g}H@g6@gG{@gC\@gڹZ@gsh@g(@gE84@g6@g'RT`@g'RT`@gڹZ@g|@g'RT`@gڹZ@g
L/@g
L/@g0
@gPH@g4m9@g
qv@gB@g`A7L@g'RT`@gc	@g*0@gB@gm\@h ~@g	ԕ+@gB@g`A7L@gB@g{m@ghr@g;dZ@g4m9@gm\@h&@h&@g	ԕ+@g;dZ@g+j@hA7K@h ѷ@h&@hVϫ@h	P{@h	O;dZ@g+j@h%F
L@h ѷ@hu%@hp:@g;dZ@h@h ѷ@h ѷ@h ѷ@hu%@h]cA@hA7K@hp:@hv@h
g	@h
zxl"h@h@h%F
L@h
g	@h
g	@h@hA7K@hϪ͞@hݗ@h2a|@hu%@hl"h	@hϪ͞@hA7K@hl"h	@h\@h\@hn@hᰊ@hݗ@hݗ@hݗ@hᰊ@hkP|@h C,@h&y=c@h#-V@h"NU@h,_o @h#-V@hn@h$xG@h#-V@h
y@hᰊ@h)@N@h1$@h1$@h%s@hrGE9@h*
=q@h'?@hᰊ@h-jOv@h4[6@h*S&@h)?|h@h4[6@h1O
@h9ᰉ@h>zG@h.͞&@h.͞&@h&xl"h
@h1@h#9@h&xl"h
@h01&x@h5H˒@h5H˒@h-jOv@h4[6@h1O
@h274@h5H˒@h>*0U@h9ᰉ@h9ᰉ@hB>BZc@h7"`B@h*S&@h9ᰉ@hES&@h< ě@h-jOv@h1O
@h5vȴ9@hB>BZc@hES&@hC@h8ݘ@h2e@h?w1@h< ě@h< ě@hC@hB>BZc@h< ě@h7!.H@h;L_@h8ݘ@h8ݘ@h;L_@h7!.H@hC@h8ݘ@h4Zc@hJtj@hN
(@hES&@h8ݘ@h4Zc@hFhۋq@hTK]c@hR@h?w1@h@ڹY@h< ě@h9rG@hC	k@hK+j@hP ě@hFhۋq@hI/V@hP ě@hN
(@hQM:@hGcA @h00U2a|@h5vȴ9@hGcA @hK+j@hK+j@hC@h@ڹY@hFh	ԕ@h>*0U@hI/w@hRfB@hEo i@hC	k@hU1@h\-
@hQM:@hP ě@hEo i@hB=p
@hG˒:)@hK+j@hP ě@hG˒:)@hFh	ԕ@hXu!@h\vȴ@hEo i@h?v_ح@hP ě@hTK]c@hN<64@hJS&@hG˒:)@hG˒:)@hK+j@hP ě@hP ě@hTJL@hTJL@hN<64@hUzH@hTJL@hRfB@hWu@hK+j@hI/w@hB=p
@h@>B[@hN<64@hR@hWu@hYحV@hchr!@hUzH@hGo@hQ{J#:@hUzH@hXu%F
@hfXy=@hi	@h_fA@hNj~@hJN;@hR@hb-
q@h[<64@hI.H@hR@h^F]d@hXu%F
@hWu@h^F]d@hc@h^F]d@hWu@hYحV@hUzH@hWu@hb-
q@h^F]d@hYحV@h[<64@hchr!@h_fA@h`W@hb-
q@hXu%F
@hQ{J#:@hYحV@h\vȴ@h_eں@hd!-w@h`Ʌoi@h^u%F@h`Ʌoi@hb-V@hfW'@hTJL@hP䎊@hMXe,@hXtSM@h\쿱[@h_eں@hn>B@hn>B@hfW'@h[;dZ@hN@hP!-w2@hXtSM@h[;dZ@h_eں@hiQ@hfW'@h[;dZ@hQ@hE@hFg8}@hW)^@hXtSM@h[;dZ@hUB@hR1@h_eں@h\쿱[@hXtSM@hY@h_eں@hg/V@hb-V@h\쿱[@h_eں@hd!-w@hfW'@hke@hiQ@hd!-w@hi,@hb,<@hY@hb-V@hfVϪ@hfVϪ@hb,<@h_e+a@hr֡a@hi,@hXtSM@h\쿱[@hg^5?}@hp@hp@h`ȴ9X@hMXbM@hG@hXtSM@hb,<@hyK]d@h{+a@hco@hi,@hfVϪ@h^n.@h`ȴ9X@hg^5?}@hn1&@hyy@huu@ht9XbN@hjo h@h_e+a@hb,<@hke@hke@hn1&@hp@hmH˒:@hp@hyy@huu@hqrGE8@hw hۋ@h{+I@hrϪ͟@huu@hi@h\@hrϪ͟@h͞@huu@h`ȴ9X@hco@h^n.@hfVϪ@hpߤ@@hpߤ@@hn6z@hmGz@hrϪ͟@hn6z@hpߤ@@huu@ht9XbN@hqrGE8@hpߤ@@hmGz@hqrGE8@hpߤ@@hpߤ@@hpߤ@@huu@h{+I@h|qj@h1'@h|qj@hrϪ͟@hyy@hyy@hyy@ht9XbN@ht9XbN@hqrGE8@hk%2@hpߤ@@hQ@hw hۋ@hrϪ͟@hqrGE8@hpߤ@@h{+I@hC-@h{+I@hn6z@hjIQ@hrϪ͟@hrϪ͟@hw hۋ@hQ@hTɅo@hrϪ͟@hmGz@hn6z@hrϪ͟@hv$tT@hyƧ@h|@hw hۋ@hg~($@hk%2@h{*0U2a@hyƧ@hjIQ@hk%2@hk%2@hnd8@hpߤ@@h|@hC-@hC-@hqqu!@hpߤ@@hp
(@hnd8@hk%2@ht8YJ@hpߤ@@hqqu!@hk%2@hpߤ@@ht8YJ@hTɅo@hTɅo@hyƧ@hQ@hxc	@huߤ@hqrGE8@hn6z@hi@hv$tT@hFs@hFs@hQ@hyƧ@huߤ@hnd8@h{*0U2a@hb}@hQ@h{*0U2a@h|@hFs@hQ@hrF@hp
(@hj˒:*@hnd8@he+@hu@hyƧ@ht8YJ@hE@h@h}A [@h|@h}oiDg@h}oiDg@h~$@h7KƧ@h~$@hp
(@hnd8@hS@hm\@h,<@hS@hmF]c@ht8YJ@hE@hu@h@hp:~@h{)^	@hnd8@hy8Y@hp:~@h7KƧ@ha@@h}oiDg@hvm\@hS@h~$@h*0U2@ha@@hS@h}oiDg@h{)^	@hxbM@hS@hu=K@hn@hxbM@h|@ht73@hj~"@hqp
=@hXy=@h|@h|@hxbM@hu=K@h{)^	@hu@hu@hXy=@h}H@hS&@hj~"@hp
qu@hxbM@hxa|Q@h6@h}Vm@h}Vm@h}Vm@h}H@h}Vm@h|L_@hyo @hu=K@hvm\@hD*@hS&@h|L_@hG{@h}Vm@h}Vm@hS&@ht6C@hyo @h}Vm@hG{@h}Vm@h|L_@h{(@hukP@hrZ@hxa|Q@h6@h}-@h{(@hyo @hvE@hnTɆ@hukP@hukP@hrZ@h{(@h}Vm@hS&@hyo @hS&@h}Vm@h6@hG{@h}-@hqo@hqo@h|L_@hC\@h&@h6@h}-@h{(@h{(@ht6C@hvE@h?@h}Vm@h|hs@h|hs@h5Xy>@h#@h|hs@hyo @hmE84@hrZ@hqo@h}@h'0@hx`d@h|C@h?@h|hs@hnO@hu"@hRT`e@h|hs@hC\@h|hs@hRT`e@h|hs@hnO@h5Xy>@h|hs@hy2W@h{'/W@hv!.I@h{'/W@hnO@h@h{'/W@hmDg8~@hr҈p;@h?@h&@h@hx`d@hj}Vl@hnTɆ@hRT`e@hRT`e@h?@h|C@h|hs@h&@h{'/W@he+@hߤ?@hu"@hC\@h&@h'0@hC,zx@h?@h_@h4֡a@hm8@h{'/W@hj}Vl@ht64@hRT`e@hy2W@he+@h
=p@hC,zx@hߤ?@hRT`e@hu@h|Q@htj@hQ@htj@hm8@h|Q@hu@hi_p@ht64@hQ@hm8@h|qi@huA@hQ@htj@hqn.3@hn@h(@h7@h4֡a@hߤ?@hN;6@h'@hmC%@ht5?|@hC,zx@hvPH@ht5?|@hvPH@hvPH@h}C]@hx_ح@h}C]@h{&x@hQ@hS@h'@hya@O@hx_ح@h{J#9@h|qi@hrѷX@h{&x@hx_ح@hp
L/@hrѷX@hya@O@hx_ح@hvPH@hp
L/@hrѷX@hrѷX@hvPH@hrѷX@hx_ح@h@h@h}(@h'@h{J#9@h}C]@h|Q@h'@hvPH@h}C]@h{J#9@h	k~@h}(@h9Xb@h9Xb@ht5?|@hqn.3@h}C]@hk
qv@hs@h	k~@h	k~@h}(@hk
qv@hya@O@h{&x@h|'RT@hk
qv@hk
qv@hrѷX@hu+j@h{J#9@h҈p@h@hrѷX@hrѷX@hy\(@hrѷX@h@h{&@hmC%@hy\(@hx_F@h{&@hn@hp
L/@h|'RT@h|'RT@hS@hya@O@hqn.3@hy\(@hP{@hvPH@hp
L/@hp
L/@h{&@hy\(@hu+j@h|'RT@hv~@ht4m9@hv~@hP{@hr`A@hu+j@h@h|'RT@hu+j@h@h|'RT@hv~@h{&@hp	ԕ+@hP{@h{&@h|'RT@hqm\@hr`A@ht4m9@hqm\@ht4m9@hi*0@hqm\@h}(@h{&@hr`A@hr`A@hx_F@hp	ԕ+@hr`A@hu+j@hS@h{J#9@hj{m@hqm\@hr`A@hqm\@hP{@hx_F@hr`A@hr`A@hnL/{@hr`A@hv~@hgsh@h}(@hu+j@h{&@hiPH                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ?d7?Xe???W'?.H? ěT?&I?-V?xF]?/V?'RT`? ѷ?/{J#:?N;6?XbM?fA?҉?Gz?64K?C%?sPH?$/?=K]?hr ?U=?vȴ9?,?M:?Ƨ-?F]c??N;5X?4m?2W?Zc	?^5?|?C$?Ğ쿱[W?eں?ڹZ?vȴ?2W?9XbM?ݗ+j?E84֡?eڹ?K]d?а{?Ѯ1??фM:?)y?ȴ9Xb?ߤ??m\?+jg?ԯO
M????VϪ?	ԕ*??;dZ?64K?҈??As?]ce?cA \?ۋq?K]cA?;5Xy?c	?F]cf?Dg8}?TɅo?+jf?73?1o?ٸ)?ٙ?Ov_خ?Z?*0U2?iDg8~?D*??iB?\N<?I^5?}?$?ҫ6z?Ӄ{J#9?$tSM?&IR?	k~(?Y|?p
=q?_o?K]d?z?.2X?|?L_?|?8YK?m\?	k~(?5?|h?Ϫ͞?C,z?5Xy>?Gz?:)y?Q_p?)^?Q_p?c	?wkP?O
M;?-
qv?>BZ?}H?_o?2a|Q?`d8?|Q?,<?g	?=K]?>6z?5Xy>?Vl!-?Z?b}V?ݗ+j?C,?hr!?>BZc?E?>B?tj~?Fs?,<?
=p
?҈p:?ݗ+j?-
qv?*0U2a?L_?Z?_Ft?3*0U2a?nOv_ح?|??ߤ??T`d?O;dZ?tj~?sg?p:?:)y?$/?*0?*0?@NUF?sPH?n?hr Ĝ?0
(?+J?u"?)^	?䎊q?htj~kQ_?@bM?n/?C,zxl?=K]?ye+aPbM?:)yVǿbn/?:)y?Ov_خ3*0U2a?-V?tzG{g?q4J?{qu!S?V?*6C-?_o ?Ϫ͞?fA?҈?sg?l?*0U2a?tj?/v?*6C-q4J?U=K??S?e+a?@bMj6C-?|1&y?R<64?zvȴ9?ǿ[Q_?n?sg?Fs?	 ?n/?a@N?u"?҈?2a|Q?fA?Ϫ͞?ɅoiD?m}H˒?3*0U2a??ᰉ'?`A7L?_o?
=p?u%F
?@NU?zvȴ9ie+a?n/?1&y?+jg?Zݘ?O;dZ?nO;?A:6C-?qu"?	 ?a4J?|1&y?{?kQ_?:6C-?-
qv?xPHj6C-        ?Z?2a|Q?sPH?N;5]}H˒?vOv_خ3*0U2a?qu"?|1&y?	 ?-V?ᰉ'?*0U2a?usg?2a|Q?Q?tzG{?C,zxl?L_?ݗ+jF?~Q?E?Fs?kP{?bM?0
(?*0
?$?e+?L_?J6C-?l1&yl1&y_!-w1?xtj~?@NU?Mj?Fs?!-w1?vǿbn/?:)y??e+a?Z??:6C-?c*0U2a?-
qv?$tS?:)y?l*6C-?fǿie+aeL_?n/?䎊r3*0U2a?S&?Fs?N;5?{Q_?@NU?+I?}}H˒?S*0U2a?tj~?ᰉ'?u%F?!-w1?xPH?IQ?Ϫ͞?ᰉ'?4J?FsV?_Ft?Ϫ͞?+?sPH?|C,zxl?uL_m}H˒?w?N;5?S*0U2a?xPH?{u%F?usg?usg?:6C-?4J?y_o ?v?{?j6C-?*6C-?_oҿ6C-?p:?xPHfOv_خ?@?Ϫ͞?2a|Q?3*0U2a?sg?|?ߤ??n/??|1&y@bM?Xe+?{?)^	?usg]}H˒?҈?:)y?O
M?Z?zG{?E?$tS[Q_???rn/?{qu!S?|C,zxl?u"?*0
?$tS?$/?:)y?vOv_خ?	 ?䎊q?sPH?S&?tj~?n/V?q4J`bMtZtzG{?{qu!S?!-w1?|1&y?tj~?䎊q?R<64??zG{?nO;?},<ku%F?u"?zG{c*0U2a?s*0U2a?vȴ9X??{qu!S?v+IS*0U2a?}}H˒?$/?-V?%2?W>6z?<64?g?|1&y?nO;rn/tzG{?vOv_خ?v+IdzG{?p)^	?!-w1?Q?PH?S?,<쿱?fA?2a|Q?-
qv?Fs?*0U2o䎊q޿usgrnO;?xtj~?l?Z>?vOv_خ?䎊q?},<?!-w1?vȴ9X?*0?%2?$/?H?A?ߤ?fOv_خ?uL_htj~?)^	?sPHbsPHvOv_خ?}H˒?UL_?rnO;fǿwXe+?$/?ᰉ'?!-w1?},<?䎊q?j6C-q4J?M}H˒?Z?E?Z?zG{?쿱[W??Ov_خ?PbMo䎊q޿pbM?kQ_?L_?cA \?a@N?e+a?_Ft?"`A?n/?z6C-?y_o ?-
qv?@NU?`d8?L_?Z?xtj~fǿtzG{?ie+a?xtj~3*0U2a:6C-?w?v+I?y_o ?o!-w1ſusgfOv_خ?????}}H˒?xPHs@NUtzG{m}H˒?Ov_خ?+jg?~Ov_ح?䎊q?,<?E?䎊q??{?xtj~?{qu!S?S&?`d8?tj~ۿbn/?N;5X?Fs*6C-x*0
?qu"??w?kP{?C,zxl?qu"?*0pbM~Q{Q_s@NU?䎊q޿w?g?s@NU?usg?v+I?xPHfOv_خ?J6C-?wXe+?},<?6C-`bM??:)ydzG{?Z6C-f?o䎊q?p)^	?m}H˒v?eL_?|?usg{u%Fzvȴ9?kQ_??V?҈?L_?m}H˒?*0U2a?zG{rnO;Rn/?uL_?nOv_ح?gnOv_ح?s*0U2aqu"?w?0
(?3*0U2a?}H˒?ᰉ'?!-w1?bM?},<C*0U2atzG{`bM?PbMy_o ?bn/?T`d?)^	?~Ov_ح?{qu!So䎊q޿o䎊q޿rnO;o!-w1?kQ_?y_o ??|C,zxl?}Z?u!?,<?S?u%F
*6C-?}H˒?S?$/?ݗ+j?zG{?,<쿱?S&??w]}H˒?rnO;?s@NU6C-?y_o ?6C-PbMc*0U2a?ku%Frn/?S*0U2a?fA?S&?4J?S&?)^	?@NU?dzG{rsPH?tj~??{u%F?`bMp)^	?[Q_?-
qv?nOv_حJ6C-?sg?N;5X?wXe+?}Z?x*0
?Mj?*0U2a?!-w1?҈?C,zxl?IQ        v+I?n??$tSM?*0?_o?vOv_خ?q4Jo!-w1ſS*0U2a?{m]?,<쿱?)^	Xtj~?`A7L?Xe+Կf?`bM?3*0U2a?Z6C-?[Q_?䎊q?n?kQ_?PHvǿrn/?p)^	?}Z?₿-
qv|1&y?o䎊q??V?Rn/?v?zvȴ9?dzG{l1&ybM]}H˒?S&?1&yq4J??O
M?fA?Q_c*0U2a?usgf?o!-w1?$tS?>BZc?@?w*6C-]}H˒?pbM?v?dzG{{Q_ku%F?o!-w1ſkQ_?@NU?ݗ+j?}}H˒?o!-w1?vȴ9X?sPH?Z?]}H˒}}H˒?C*0U2a?:6C-Xtj~?C*0U2a?htj~?H?~Q?,<쿱?Zݘ?*0?n/dzG{?l1&y?vȴ9?8YJ?hr Ĝ?usg?%2?*0?zvȴ9`bM3*0U2an)^	`bM?n?`d8?L_?`d8?o䎊q޿w?[Q_?{qu!S?vȴ9X?:6C-Fǿo!-w1?`bM?u!?u%F?q4J?O
M?qu!S?PbM?:)y?|C,zxl?{u%F?w?ye+a?p:?Fs?-
qv?w?zvȴ9?ye+a?},<?:6C-tZ?*6C-@bM?nOv_ح?쿱[W??rsPH?rn/?~Q?₿vOv_خ{u%F?z6C-?Zݘ?z6C-uL_w?wkP?]}H˒?_o ?bsPH?6C-?ᰉ'?U=K?u%F
`bM?x*0
?=K]?{qu!S?dzG{?zvȴ9?sg?bM?!-w1?rn/zvȴ9?xtj~dzG{?Q?=K^?+I?rsPH?6C-?$/w?vOv_خ?4Jie+a3*0U2ao!-w1?fǿye+a?eL_?}}H˒?N;5?z6C-?l?ye+a?pbM?|??O
M?uL_?q4J?`bM?pbM        vǿy_o v+I?pbM?c*0U2a?~Ov_ح?nO;?{u%FeL_?N;5X?|1&yie+a*6C-?tzG{[Q_?J6C-??-V?[Q_?3*0U2a$tSo!-w1??u"?v+Ij6C-?>6z]}H˒?bM?Z?&?@NU?S?pbMc*0U2aS*0U2adzG{?*0U2a?,<쿱?*0U2?tj~?2a|Q?Mj?xPH?gp)^	rnO;?IQ?*0?},<?S&?D*0?=K]?ߤ??hr Ĝ?rnO;?*0?쿱[W??ye+a?q4J?]}H˒usgv+I?bM?zvȴ9o!-w1?+I?PbM?:6C-Z6C-?J6C-?p)^	?s@NU?VǿV??rn/6C-~Qusg?|C,zxl?ݗ+j?bMg?eL_?ᰉ'?kP{?s*0U2a?usg?tj~?+jgg|C,zxl~Ov_حZ6C-?{u%F?4J?p:?vOv_خ?m}H˒?tntZ?J6C-?uL_?pbM?zvȴ9?_o ?rn/[Q_?tZ?rsPH?bM?H?gxtj~?eL__!-w1?Zݘ?+uL_?`A7L?nO;?rnO;ie+a?y_o ?Ov_خie+av?$tSM?D*0?쿱[W??F?PbMtZ?{Q_?tj~?tn?,<a4J?bsPHRn/?O
M?o䎊q޿z6C-:6C-?tZ?Ov_خ?=K^?ᰉ'?u%},<-
qvs*0U2a?w?rsPHv?l1&y?s@NU?~Q?wXe+Կo䎊q޿v?q4J?-V?n/?}H˒?Rn/rn/?Vǿl1&y?fA?a@N?pbMwXe+?q4JbsPHz6C-xPHvOv_خ?Xtj~?_!-w1?䎊q?Zzvȴ9?fOv_خ?1&yc*0U2a?tZ?ie+ax*0
?tn?T`d?	 ?s@NU?s@NUl1&yPbM?u!?{Q_?Z6C-?~Q?+I?2a|Q?N;5?o䎊q?[Q_?$tS?nOv_حfOv_خ?vOv_خ?v+I?}Z?Y}?ku%F?uL_F?A?*0?PH?3*0U2a{u%F:6C-?|1&y?kQ_q4J?bM?<64?y_o ?$tS?tj~?ɅoiDRn/?o䎊q޿bn/?ie+a??vȴ9?rn/?zvȴ9?C,zxl?O
M?zG{?Z?T`d?ye+a?xPH?Mj?sPHa4J?䎊q?@?|1&y?x*0
?3*0U2a?`bM?qu!S?g࿉e+aXtj~?rn/?bsPH?{ſ`bM?u"?}}H˒?},<m}H˒x*0
?Xtj~dzG{vOv_خ?bn/?q4J?|1&y?u%F?fA?{?_Ft?u"?c*0U2auL_?tno䎊q޿vOv_خ?pbM?Q?:6C-tn?0
(?sg?0
(:6C-?F?`bMPbM?|C,zxl?xPH?rsPH?4J?@NU?}Zf?p)^	o䎊q?m}H˒bn/p)^	?1&y?PH?O
M?%2?m}H˒?qu"?zvȴ9?xPH?o!-w1?tn?}}H˒?y=bc*0U2a?rnO;?|C,zxl?{qu!S?ye+aPbM?]}H˒?*6C-?g?}}H˒?}}H˒?O;dZ?@fOv_خ?rn/?bM?`d8?L_?ɅoiD?{Q_fOv_خ?nOv_ح?N;5X?ɅoiD?O;dZ?-
qv?xtj~?x*0
?e+a?O;dZvOv_خf?x*0
?zvȴ9?u"?<64?hr Ĝ?|1&y?S&?n?{u%F?H?PH?*0U2?+J?+J?tj~?tn?E?p:?s@NUj6C-?tn?@NU?tj~ۿ3*0U2a?qu!S?E?V?p)^	?|1&y?|C,zxl?~Q?u%F?bM?0
(?$tSM?fOv_خ?zG{?a@N?zvȴ9s*0U2as*0U2a?zvȴ9o!-w1?c*0U2a?rn/`bM?J6C-?s*0U2a?C,zxl?~Ov_حC*0U2a?ku%FtzG{?usg?ݗ?<64?{Q_?v+I?_o?x*0
?ye+a?4J?{qu!S?},<?-
qv?$tSM?,<?%2?kP{?u!?!-w1?}Z?o䎊q޿y_o ye+a~Q?tn?ldzG{?o䎊q޿l1&y?bsPH?|C,zxl?z6C-?Z?xtj~rsPHs@NU?rnO;?	 ?!-w1?o䎊q޿pbM?|C,zxl?v?!-w1?@NU?hr Ĝ?htj~{Q_xPH?p)^	?xPH?{u%F?}}H˒6C-{Q_?[Q_?{Q_?]}H˒vǿx*0
wo!-w1ſw࿀-
qvku%F?v+IkQ_?wXe+?wXe+?n/?}ZbsPH?ku%FPbM|1&y?6C-?y_o ?{u%F?+I?p:?{qu!S?S&?L_?+UL_?p:?S&?-
qv?!-w1?},<?hr ĜS*0U2a?hr Ĝ?S?tj~?fA?䎊q?{Q_?w?ie+a?a4J?6?~Ov_حhtj~?Q?₿kQ_?m}H˒:6C-nOv_ح?Rn/PbMM}H˒?Rn/?zvȴ9?	 ?!-w1?~Q?!-w1?hr Ĝ?sPH?~Ov_حq4Js*0U2a?vȴ9X?fA?O;dZ?)^	?M}H˒?V?PbM?m}H˒?fA?bM?uL_?:6C-?,<쿱?,<쿱?n/?zG{?fA?*0?g?uL_?:)y?ɅoiD?=K]?v?{u%F?j6C-?S*0U2azvȴ9nOv_ح?v+IV?a@N?Fs?n/?y_o ?~Q?:)y?PbMtn?]}H˒?zvȴ9?F?M}H˒?bsPH?o!-w1?Q_c*0U2a?{qu!S?N;5?ݗ+j?}Z?zvȴ9?vOv_خ?4J?{Q_?-
qv?usg?Q_?z6C-v+I?zvȴ9?{?tj~?N;5?vǿku%F?{qu!S?n?a@NC*0U2a?vȴ9X?`bM?H?Q_?Q_3*0U2auL_{u%FpbM?g?_o?Fs?!-w1ſpbM?x*0
?|1&ynOv_ح?x*0
??},<bsPH?kQ_?UL_*0
rn/?xPH?~Q?PH?`A7L?l1&y?J6C-?L_?tj~ۿbn/?wXe+?~Ov_ح?|C,zxldzG{s@NU?c*0U2a?!-w1?u%F?M}H˒uL_?M}H˒?ku%FrsPH`bM?w_!-w1?xPH?x*0
l1&y?vȴ9X?Z6C-?htj~?	 ҿ3*0U2a?n?=K^?҈?},<?N;5X?!-w1?c*0U2arsPHhtj~?usg?{Q_?Mj?$tS?N;5X?bn/?$tSM?uL_rnO;?PbM?F?pbM?Z~Ov_حM}H˒?₿fOv_خ?w?}}H˒?}}H˒?rsPHa4J?eL_bsPH?qu"[Q_ye+arnO;?S*0U2a?qu!S?,<?-V?Ov_ح?htj~?bn/?ɅoiD?
=p
?e+a?{qu!S?ws*0U2adzG{?Xe+?pbM?UL_Z6C-?:)y??p)^	?vOv_خ?xPH?fǿdzG{?zG{?҈ο*6C-?߿bn/?s@NU?xtj~o䎊q޿w?rnO;?x*0
?*6C-?[Q_?y_o ?-
qv?tn?tzG{?zG{?*0?n?sPH?*0U2a?ݗ+j?n/?-
qv[Q_?p)^	?Fǿtn?-
qv?%2@bMz6C-?s@NU??N;5?|?fǿpbMg?)^	?sPHtn?S*0U2al1&y?},<?ɅoiD?s*0U2aV?tZ?!-w1?=K]̿eL_?v?v+IRn/?N;5X`bM?wXe+?q4J?wXe+ԿbsPHs@NUv?$tS?	 ?Rn/?Rn/ie+a?},<?p)^	Xtj~?@NU??zvȴ9pbM?xtj~?y_o ?
=p
?bM?u%F
?~Q?,<?u!?~Ov_ح?bM?|C,zxl?$tS?~Ov_ح?rnO;ie+a?zvȴ9?*0U2a?ɅoiD?~Q?䎊r@bM?PbM?}Z?~Ov_ح?*6C-?{u%F??kQ_?wkPbn/?v+IusgbsPH?䎊r`bMs*0U2a?䎊q?E        ?htj~?xtj~?rnO;?|C,zxl?}}H˒?zvȴ9?䎊q?y_o ?0
(?6C-?~Ov_حpbM?tn?y_o ?xtj~?uL_?H??p)^	?}H˒?Z?f?x*0
??f?2a|Q?$/?_oҿRn/?l?$tS?!-w1?{u%FM}H˒?kP{?l1&yqu"?ie+a?Z?:)y?M}H˒?fOv_خJ6C-?	 ?usgv+IxPH?y_o ?*0U2a?E?hr Ĝ?~Ov_ح?~Ov_حXtj~?Z?Fs?j6C-?rn/?xPH?s*0U2a[Q_?hr Ĝ?bMq4J?v?eL_?{u%F?tj~ۿC*0U2a?C*0U2ao!-w1ſ:6C-?*0?zG{?}Z?$tS?䎊q?L_qu"?eL_fOv_خ]}H˒?j6C-?3*0U2a?쿱[W??2a|Q?p)^	usg?x*0
?}}H˒?_o?tzG{?:)y?C*0U2a?J6C-?C*0U2a?ie+a?*0?M}H˒?3*0U2ausg?o!-w1?-
qv?hr Ĝ??v+I?u!?fA?sg?nOv_ح?v+I?rnO;?dzG{?F?ݗ+j?6C-M}H˒?*6C-?	 ?Rn/?Zݘ?~Q?}Z?Ov_ح?bn/?$tS?S&?1&y?S*0U2a?s@NU?kQ_rnO;?F?xtj~:6C-?*0
?zvȴ9?Xtj~?y_o ?+I?o!-w1?$tSM?1&y?htj~?)^	?xPH?{Q_?4J?vOv_خ?pbM?e+a?{u%F?dzG{?ku%Fqu"J6C-?p:?{Q_?qu"?u"?[Q_                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            &-fB"ff@ff3;&39                                      1                                       