CDF       
      time      pressure  T   latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        32     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:21.397744Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_032 (32) * LATITUDE: 42.380000 * LONGITUDE: 3.580000 * DATE/TIME: 2016-08-26T02:15:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC        '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        9   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*F]d   data_max      @6а{   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC         >X   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        P   salinity               	long_name         salinity   units         PSS-78     data_min      @C9   data_max      @CM1   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC        U   salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d        h@   oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @e'RT   data_max      @p@   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC          l   	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d           CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      *6C-   data_max      ?Z   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC        0   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d           	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ٙ   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC       x   CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d           time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &&g   data_max      &&g   C_format      %10d           latitude               	long_name         latitude   units         	degrees_N      data_min      @E0
=q   data_max      @E0
=q   C_format      %9.4f              	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @
=p   data_max      @
=p   C_format      %9.4f              	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3:   data_max      3:   C_format      %8d            	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min            data_max            C_format      %4d            station                	long_name         STATION    units         unspecified    C_format      %s        (     cast               	long_name         CAST   units         unspecified    C_format      %s        (  @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @6а{@6n/@6to h@6VR<6@6>qi@6:L/{@6P{@5,@55?|@5bM@5W>6z@5ԛS@5u%F@5z@5U@5GKƧ@54O
M@53҉@5(}H@4BZc @4@4Q@4E@4_F@4[6@4e@4*0U@4U=@4Fs@4TɅo@4hr!@4@4sA [@4@3e+@2$@1o@1PH@1t3@1iJE@1]IQ@1(D*@0S@0RM@/@/4Fs@.о
(@.kC,z@.> ѷY@.+Q@-b}@-K]@-kC%@-Z1'@-4SMj@-[@-l!-@-
M:@-e+a@-bM@-TɆ@,Z@,?@,ӎMj@,:@,L/{J@,^5?|@,Mj@, ě@,҈@,A@,hۋq@,>BZ@,sg@,n@,qiC@,K]c@,%1@,ѷX@,{"`B@,tSMj@,nT@,g	k@,\u"@,U%F
L@,Hp:@,A|Q@,>BZc @,;6@,9XbM@,8tj@,3Z@,0bM@,)oiD@,	@,O;d@,X@,
JL@, C@+8YJ@+}H@+Vl!@,7@,m\@,n/@,@,@+U@+/V@+&@+v_ح@+'/W@+.2@+qu"@+/{J#@+]cA@+]cf@+.H@+]ce@+J#9@+F@+C-@+8YJ@+>6z@+KƧ@+Ӝߤ@+о
(@+Mj@+
qv@+@+I^5?@+˹~($@+~"@+rGE@+@+@@+_o@+ǻ/V@+_o@+8YK@+Gz@+IQ@+-
@+>6z@+_ح@+Ʌoi@+@+ߤ@+o @+ԕ*@+qiC@+#9@+_@+r@+U=@+<쿱@+!-w@+1&y@+C%@+'/@+d7@+ԕ*@+˒:*@+ݗ+@+y@++I@+ݗ+@+zH@+x@+ڹ@+tSM@+}Vm@+     @+?@+^5?|@+@+GE85@+g@+SMj@+*1@+2a|@+sP@+T@+L_@+#@+L/{J@+Fs@+hۋq@+zc	@+z>B@+xbM@+stj~@+o;dZ@+n}Vl@+mO;dZ@+jqiC@+eS@+b3@+_˒:)@+]/w@+[=K^@+YXbM@+XbM@+WKƧ@+TSMj@+RGE85@+Ra|Q@+R:)y@+Ql@+Sg@+OAs@+LcA \@+K]cA@+P'RT@+O͞@+J0U2a|@+F,<@+F
L/@+DM:@+B`A@+B@+BwkQ@+B74@+Em\@+E@+ES@+En/@+G,@+Hr Ĝ@+K]cA@+L<쿱@+LVϪ@+K҈@+J͞&@+IQ@+GzH@+GfA@+HXy=@+Hۋq
@+I*0U2a@+I@+JfB@+KxF]@+Ka@@+KU=@+KU=@+Kq@+KU=@+Kq@+KU=@+Kq@+K~($@+KƧ@+K҈@+Ks@+K~($@+Kq@+Kq@+KU=@+KQ@+KC%@+I@+CZ@+7Xe,@+0*0U@+.}Vl@+/iDg8@+0@+/As@+-(@+-(@+.!R<@+-
qv@+-w1@+,@+,C@+,@+-V@+,@+,@+,[W?@+,@+,zxl"@+,@+,>B[@+,>B[@+,@+,zxl"@+,I^5?@+*͞&@+*=p
@+) ѷ@+(@+(Xy=@+($xG@+(	ԕ+@+'fA@+'	k@+'&@+'ݗ+@+'&@+'lC@+'_o@+'_o@+'+I@+')^@+&x@+&L/{J@+%1@+%Q@+$*0@+%m\@+%O
@+%S@+&,<@+&Fs@+'/V@+)k~(@+)*0U2a@+'K]d@+(Xy=@+)*0U2a@+)oiD@+)@+)x@+)Dg8~@+)7KƧ@+)rGE@+(ۋq
@+(ۋq
@+) ѷ@+)7KƧ@+)^@+)oiD@+*L/{@+,C@+-w1@+/iDg8@+1A [@+2䎊@+2n@+1N;6@+1X@+1iB@+1R@+1-@+12W@+1u@+2n@+2ᰊ@+4Fs@+5Ϫ͞@+73@+8}H@+8bM@+873@+7+j@+9XbM@+:)y@+9Y}@+9>BZ@+:Q_@+<64@+>5?|@+?.H@+B3@+E8YK@+G&@+GK]d@+G@@+GzH@+EQ@+As@+@ěT@+?$tS@+=+j@+;s@+9D@+8l"h	@+71@+4!-w2@+2䎊@+0-
q@+/;dZ@+0H@+1R@+5sh@+6_ح@+4O
M@+1o@+12W@+3@+68YJ@+6!.I@+8PH@+;u%@+CnP@+DxF@+DS@+=}H@+9e+a@+8e+@+7Xe@+2:)y@+1@+.}Vl@+,_@+,zxl"@+,"h	ԕ@++P{@++]cA@+*fB@++C,z@+,cA \@+-5Xy>@+._o @+;s@+<u"@+<wkP@+;m]@+;$@+>\N<@+B74@+A:S@+>5?|@+:>B@+7&@+6@+7+j@+9e+a@+7@+7sPH@+5Ϫ͞@+3tj~@+2䎊q@+2 ě@+2nO@+1iB@+/o @+/4֡a@+..2@+,q@+)^5?}@+*d7@+(˒:*@+(r Ĝ@+(˒:*@+&A@+$g8}@+#$@+!7Kƨ@+H˒:@+?@+1&@+j~#@+u"@+[@+<64@+hr@+Vl!@+ce@+<64@+hr@+Q@+b}@+XbM@+e+@+bM@+@+z@+<64@+&x@+@+rGE9@+
B@+1&y@+L_@+@+/{J#@+1&y@+VϪ@+I^5?@+~($x@+cA \@+]cA@+
~"@+	^5?}@+	*0U2a@+9Xb@+˒:*@+1&x@+K]c@+-@+Fs@+E84@+8}H@+K]c@+@+u%F@+@@+84֡@+Q@+84֡@+S&@+F
L0@+S&@+`A7L@+`A7L@+`A7L@+m\@+e@+e@+Q@+84֡@+84֡@++a@+Q@+m\@+@+n/@+1@+@+S@+`A7L@+S&@++a@+u@+JM@+/@+/@+tSM@+Z1@+%1@+A [@+tSM@+g8}@+g8}@+%1@+tj@+eO@+{J#9@+eO@+nP@+@4@+e+@+\(@+M@+ [6@+ 'RT`@+ 'RT`@+ 'RT`@*˒:)@*iB@*($x@*5?|@*5?|@*u@*u@*BZc @*($x@*
(@*E@* ѷY@*($x@*,=@*p
=@*}H@*v@*p
=@*}H@*ce@*hr@*#x@*]ce@*64@*Q@*lC@*m]@*"`B@*@*Y}@*Y}@*Y}@*@*kP|@*>B@*vȴ@*xl"h
@*vȴ@*S&@*>B@*Y@*D*@*bM@*F]d@*(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @C-V@Cp:@Cu%F@C@C?@C3@CVϫ@C'@C
'0@C?@C*0@C:S@C7KƧ@C0
)@CK]c@C'RT`@C-V@C$tT@CXy=@CڹZ@C9@CU=@C
M:@CKƧ@C?@C?@C&@C#@C@CVϫ@CzH@C/V@C#@CE84@CQ@C'/@C	@C@C#@C|hs@C+J@CjOv@Cڹ@C
qu@C@CqiC@CC%@CVϪ@C%1@CU=@C	@C~$@C\N@CQ@CcA \@CV@C@CKƧ@C!+@C!o@C"M@C"Zc@C!y@C"n@C")y@C"3@C"Q_@C"@4@C">B@C",<@C"74@C#"`B@C#jf@C#@C#~$@C#5Xy@C#a@@C#A [@C$xF@C$<쿱@C$wkP@C$S@C$@C%5Xy>@C%zxl"h@C%oiDg@C&u@C&Ov_@C&!R<@C&;5X@C&iB@C&Q@C&1@C'8}H@C'/V@C'˒:)@C'K]d@C'+j@C(
qu@C'[W>@C( ě@C(D@C)oiD@C)o@C)~($@C)oiD@C)u!S@C)+@C)R@C)iB@C)k~(@C)x@C)@C)'RTa@C)'R@C)iB@C*e+@C*:)y@C*W'@C*a|Q@C*>B@C*m@C+jf@C+Ƨ@C+|@C+\N@C,_@C-Q@C-sg@C-8Y@C-
qv@C-!.@C.;5X@C.ߤ?@C/&@C/&@C/K]d@C0NU@C0|@C0)@C0ěT@C0-
@C0˒:*@C0IQ@C09Xb@C0TɅ@C0)^@C1JE@C1n.@C1e@C26C@C2 ѷ@C3jf@C3g@C4xF@C4I^5?@C4?@C5p
=@C5Ϫ͞@C5!.@C6Ov_@C6BZc @C6Fs@C6ȴ9X@C6Ϫ͟@C6"@C7$tS@C7@C7vȴ9@C7Vϫ@C8@C8 ě@C873@C8NU@C873@C8_F@C84m@C8ۋq
@C8҈p@C8\)@C9:S@C9@C:e+@C:@4n@C:C\@C:kP|@C:p:@C:<64@C;I^@C;C%@C;]cA@C;Q@C;~($@C;5Xy@C;$@C<1&y@C<,<@C<<쿱@C<PH@C<Z1@C<q@C<N;@C<3@C<@C<JM@C=*0@C=!.H@C=F
L0@C=ce@C=U=@C=ݗ@C=sg@C=M:@C>@C>Ov_@C=ᰉ@C=@C=S@C>_o @C>zG@C>
(@C>
(@C>Vu@C>ȴ9X@C>҈p;@C>쿱[W@C?;dZ@C?lC@C?@C?@C?䎊r@C@	ԕ+@C@'RT`@C@73@C@73@C@NU@C@l"h	@C@-
@C@@@C@ѷX@C@	k@CA+@CA7KƧ@CAJE@CAQ@CA[W>6@CAu!S@CAb}@CA@CA~($@CAR<6@CA'RTa@CAn.@CAl@CA^5?}@CAᰉ'@CA-@CAlD@CA.H@CB	 @CB1'@CBu%F@CAX@CA#w@CA ѷ@CA@CAGz@CAae@CA'R@CBI^5@CB6C@CBa|Q@CBnO@CBxl"h
@CBᰊ@CB)_@CBG{@CC҉@CC"`B@CCF]c@CCZ@CC{J#9@CCA@CC@CCQ@CC%2@CCg@CC@CD@CDqj@CDZ@CD!-w@CDE@CE:@CEo i@CEo i@CEK]@CEV@CEV@CEV@CEV@CEu@CE[@CE*0@CEqu"@CE[@CE*0@CEqu"@CE%F
L@CE<64@CEm\@CE+j@CE@CEᰉ@CF ѷY@CF
(@CF($x@CFl!-@CFiB@CFs@CF6z@CFϪ͟@CFMj@CF!.I@CGFt@CG
M;@CGv@CG!-w1@CG>6z@CGH˒:@CGRT`e@CGRT`e@CGU=@CG\(@CG4m@CG@CG;dZ@CH ě@CHbM@CHn@CH-
@CHtj@CHu%F@CHѷX@CH@CHC@CI$/@CI7KƧ@CI[W>6@CIrGE8@CI(@CIN;6@CJ1'@CJ6C@CJ=p
@CJM@CJa|Q@CJᰊ@CJ@CJS&@CJL/{@CJ ě@CJ ѷ@CK'/@CK"`B@CKg	l@CKZ@CKݗ+k@CKlC@CKg@CKlC@CK@CKq@CKwk@CKߤ@CKq@CKqu!@CK@CKtj~@CKdZ@CK=K^@CK"`B@CKS&@CJm\@CKu%@CK33333@CK@CKMj@CKdZ@CKC%@CK@N@CKjf@CK$@CKwk@CK5Xy@CLtj@CL7@CL/@CLhr@CL*1@CLtSM@CLwkP@CLm8@CLC,zx@CL9XbN@CL@CLn.@CK\N@CK@CKA [@CKC]@CKlC@CKC]@CLJ@CLߤ@@CL%1@CM!.H@CM5Xy>@CM5Xy>@CM(@CM<64@CMp
=@CM1@CMO
@CMjOv@CM84֡@CM[@CMK]@CMQ@CM/w@CM[@CM%F
L@CMV@CLD@CLZ@CLu"@CL/@CLZ@CLɅoi@CL7@CL7@CLTɆ@CL#@CL*1@CLtSM@CLtSM@CLtSM@CLSMj@CL<쿱@CL%1@CL1&y@CKg@CK@CK@CK6@CK@CKƧ@CKƧ@CKƧ@CK@CK@CKƧ@CK6@CKm]@CK$@CK:)z@CKeO@CK@CK{J#9@CKa@N@CK33333@CK	@CKPH@CK'/@CJC,@CJ ѷ@CJ ѷ@CJC,@CJ ѷ@CJG{@CJC,@CJfB@CJC,@CJ䎊q@CJ ѷ@CJ,<@CJ,<@CJ)_@CJn@CJn@CJ<64@CJY@CJ ě@CJS&@CJL/{@CJS&@CJ ě@CJ ě@CJ>B@CJ0
@CJ~"@CJ{m@CJ@4@CJ@4@CJ~"@CJ~"@CJ~"@CJ~"@CJ{m@CJ{m@CJ{m@CJ{m@CJ~"@CJ~"@CJ~"@CJ~"@CJ~"@CJ@4@CJ\(@CJ\(@CJL_@CJS&@CJᰊ@CJᰊ@CJ\(@CJL_@CJL_@CJL_@CJݘ@CJݘ@CJ~"@CJ@4@CJ~"@CJ{m@CJ{m@CJ{m@CJxl"h
@CJu%F
@CJu%F
@CJnO@CJqiC@CJnO@CJkP|@CJkP|@CJkP|@CJkP|@CJh	ԕ@CJa|Q@CJ^5?|@CJ^5?|@CJZc@CJT`d@CJQ_@CJT`d@CJT`d@CJW'@CJT`d@CJT`d@CJW'@CJW'@CJW'@CJW'@CJW'@CJW'@CJW'@CJQ_@CJT`d@CJT`d@CJQ_@CJQ_@CJQ_@CJM@CJJL@CJGE85@CJGE85@CJGE85@CJC\@CJ@4n@CJ=p
@CJ3@CJ0U2a|@CJ0U2a|@CJ-V@CJ0U2a|@CJ-V@CJ0U2a|@CJ3@CJ0U2a|@CJ-V@CJ-V@CJ0U2a|@CJ0U2a|@CJ&IR@CJ#9@CJ&IR@CJ&IR                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @j@k1hr!@kRj~@kV?@kHIQ@k5Xe@kiH˒@k~fffff@ks$tS@kw84֡@k\Q@kJ#@kt@k
(@kc	@l<_o @l+4֡a@lVϪ@l3@l4쿱[@lN@l"s@kFt@kn@kL/{J@kݚkP@ko i@kxF]@k@kxF]@lAa@N@lf@krG@lO
M@mN;@n].H@mU=@lB@m4}H@m+J@nY|@n9@o6wkQ@oCE@pW>6z@p@@p sP@oS@nC\@nF]c@n!oiD@m     @mp:@mM:@mTS&@m7JE@mN͞&@miDg8@nحV@n,	k@ml!-@lbZc@joiD@jtj@jtj@iUjf@h0;5X@hq@h+a@hL/{@h"`B@hg3@h@)_@hحV@i6TɆ@i2u!@h˥v@hm(@h$t@h	PH@h  ě@h/䎊r@h&2W@hQ@gr Ĝ@h=K^@h'qu!@h,!.I@h zG@hs@g9@gu%@g>BZc@go hی@g﹌~($@h$~($x@hN'RT`@hevȴ9@h
(@he+a@hk>6z@gFt@g(D@g1F]c@ggtj~@gg	l@g1&x@geں@gTɅ@g_o @g74@gxF]@g0U2a|@grG@g!-w2@g8YK@g!.I@h9PH@h6@h(@hƿ[W?@hzU2a|@gJE@g\N@g@h䎊@hqu!@h_o @hJL@hI^5@hN;6@hp:@hL_@hm@hR@hYJ@h!-w1@h%2@hᰉ'@h	 @i1&x@i
ݘ@iD@h1'@h4m@h64@hhr@hJE@h)^	@h-V@h+@h0
@hg@h=K^@h:~ @hoiDg@hk~(@h,<@h҉@h@hkP|@h$/@hIQ@h@h?@h-@h;dZ@h@h{	@hfH@hka@@ht'RT`@hgv@hcw1@ht!R<@hS@huzxl"h@hrg	@h&I@htOv`@h`3@hU4m@hJ\N<@hY'RTa@haE@hY=K@hDm\@hQ?|h@hOfA@hF6@hRO;@hZ@hJ9XbN@hH,<@hZu"@hZ ѷ@hAb@h<H@h<E@hA@hNOv_خ@hNM:@hH<64@hEY}@hGTɅo@h@_ح@hNC,zx@h/|@h%rGE9@h.M:@hC!-w1@hJ4K@h6@h)_@hF
L0@h3@h9_o@h6O;@h.?@h.>BZc@h9Z@h>@h-V@gd8@gU2a|@gqu"@g4m9@glC@gC@g$tS@g_o @gݣn.@g*0U@g)^@gˑhr!@ge@gU2a|@g@g@gXy=@gC]@g{m@g7Kƨ@gp:@gR@gk~(@g@g?|h@gO
@gvȴ9@g"`@g
(@gQ@g@N@gY|@g-w1@g-
@gq@gE@g䎊r@gU=@gZ@g=K@gL/{@hiB@gt@gJE@gn/@g*0@g	@gl"h	@g2X@gᰉ@gᰉ@g@gɅoi@g,<@g+jg@g*0U2a@goiDg@g҉@g~PH@go3@go|@glC,@gk&@gu?|h@g|0U2a|@go@gR˒:*@gGa@N@gL쿱[W@gNPH@gLC@g?u%@g8@gErGE9@gQs@gNNU@gErGE9@g1$tS@g<?@gH[W?@gA_o@gK&@gYjOv@g^e@gLx@gO@g@g8}@g'eں@g,{@gV@g@g#7KƧ@g!@gZ@g |@fPH@gAs@fNU@fL_@fᰉ@fۋq
@f>BZc@frG@f>BZ@fKƧ@ffA@f-
q@f>B@fsP@fQ@fu%F@fĻ@f:@f,@fqiC@fߤ@f,<@f(@f-@fo @fѷX@f(@f	 @fkϪ͞@fjj~#@f["`B@fJwkP@fRt@fPJ@fD@f=$@f?XbM@fGq@f4:)y@f#Mj@f&Vu@f1rGE8@fFFs@f0
(@f͞@f1'@fA [@e!R@eb}@eܸQ@eb}@e@eo@fe+@fC]@f	&x@f
'RT@fVϫ@f@fn.@f?@f0
)@f'@f!.@f&L/{J@f2t@f4.2@fS&@f>BZ@f'RTa@f+j@f@f}Vl@f
JE@eu!@e<64@e˒:)@eJL@e%@evȴ@en@e%2@e*0U2@ea@N@f @eO;@fPH@f1&y@fR<6@fT@fC@eϪ͞@e^5?|@eC\@f
=q@f$xG@ep:@eåS@e쿱[W@e7@e	 @e$tS@e1&y@eϪ͞@e'RT@el!-@eA@e-@e"`@ewkP@eâwk@eᰉ@e5Xy@eZ@e@e.2@e:)z@eb@eu!@e [7@e@e%@e>B@e:@es@fGE85@fU2a|@ffA@fZ@f
qiC@f?@f~"@f*bM@f=@f?6z@f9&@f.L_@f(E@f"I^5@f6G{@f?5Xy>@f1S&@f-(@f.L_@f(E@f8C\@fC`A7L@f8C\@f9&@f<m8@f;
=p@fG	@fH쿱[W@fJPH@fF%1@f?4J@fGeO@fT1&y@fd2X@fZ	k@fRT@f\\N<@f`+J@fT_o @f@ᰊ@fGݗ@fF$xG@fO@fRS&@fK[W>@fO@fTn@fUiDg8@fG&@f6]cf@f<j~#@f@*1@fK[W>@fZe@fNxl"h
@f?1@f1O
M@f.+J@f9n.@f?0
)@f<iB@f<iB@fHx@f<iB@f8?@f=5Xy@f5xF]@f4zG@f=5Xy@f@Fs@fNwkP@fRaf@fC[W>6@f8?@fD
(@fJL/{J@fD
(@f?/V@f8>BZc@fJL/{J@fHfB@fGM:@fGM:@fGM:@fF ě@fF ě@fGM:@fD<64@fCY|@f8=p
@f;o i@f@S&@fGM:@fK1@fGM:@f/>BZ@f'@f2O
M@f1KƧ@f2O
M@f@N;@fG@f;@f6+@f1J#9@f8;5X@f<fffff@f-	@f"F]d@f#eں@fI^5?@f(!-w@f;:@f#eں@f*VϪ@f'o@f'o@f5sPH@f1H˒:@f1H˒:@f/e@f/e@f1Gz@f$@@fH@frGE@f*Vu@f@qj@f.IQ@fU=@f'/@f'/@f" ѷY@fr Ĝ@f"     @f#x@f9XbN@f
cA \@f
+I@fy@f4m@f#x@f
+I@f 6z@f#x@f
+I@fy@f
+I@f	 hۋ@e!R@fA [@fp
=@f$tT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?C\?D?$/?a@N?`A7K?U=?xF?)_?t?D*0?)y?/V?ȴ9Xb?#?u?ԕ*1?ڹY?E?W'?73?73?$?^5?|?rGE9?K]c?!.H?*0U?L/{J#?^5?|?#9?rGE9? hۋq?ᰉ'R?{?u%F?+?Gz?+?n.?C\?74?ǀ4m9?҈p;?t?Ov_?ʈp:?z?1&x?;dZ?σ{J#9?b}?+jf?4m8?֫6z?oiDg8?)^	? ěT?C\?\(\?Xy=c?rGE?Z?&IR?hۋq
?iB?cA [? hۋq?,?m\?~$?Z?ⲕᰊ?^?|?>BZ?)y?ߤ??As?S&?ݗ+j?C,zx?ݼn.?n.?Vt?L_?C,zxl?VϪ?F]c?بTɅ?֩?@NU??Zc	?Хzxl"h?*0?:S?y=b?NT?
L/{?́$/?Ƨ-?iB?4֡a?
=p
?āo hی?Õ$/?D?0U2a|?©?j~"?E84֡?ƃ%2??<64??9XbN??vȴ9?H?5?|h?s?!-w2?W>6z?0
(??8YJ?ݗ+?C,z?=K^?Xy=?eڹ?5Xy>?~$t?C,?`A7L?Z?ȴ9Xb?D*?a@N??PH?g	?u!?)_?kP|?#wk?Xy=?eڹ?W>6z?Ϫ͞?2a|Q?JM??#wk?u%?l!-w?L_?A?Q_p?5?|h?bM?*0?Ϫ͞?$/?Ϫ͞?ᰉ'?W>6z?MjOv?tj?c	?@NU?wkP?IQ?
=p
?+j?bM?tj?u!?$?nOv_ح?UL_?,<?Ϫ͞?e+?,<?u!?C,zxl?*0?Xe?},<?u"?tj?%2?sg?tj~?:)y?*0?)^	?2a|Q?tzG{?fOv_خ?}H˒?,<?$tSM?ᰉ'?ᰉ'?vȴ9XZ6C-?zvȴ9?N;5?n?Ϫ͞?O
MXtj~?`A7L?4J?4J?*0?tj~?a4J?u"?u%?wkP?W>6z?Sٿ3*0U2a?~Q?usgZ6C-?hr Ĝo!-w1?S&?fA?4J?Q?n/?%2??R<64?5?|h?U=?Ϫ͞?ZXtj~?x*0
?}}H˒?kP{v+Iku%F?{u%F?}Z?,<쿱?nO;?zvȴ9?tzG{?)^	?{u%F?*0U2?wXe+?sg?{u%F?-
qv?Ov_ح?v?v+I?sg?N;5?p)^	PbM?<64?䎊q?QfOv_خ?s*0U2a?)^	?Zݘ?ᰉ'?2a|Q?o!-w1?n?sg?np)^	usg?g?`A7L?xtj~?S&?l?~Ov_ح?{Q_?l?@NU?v?:)y?䎊q?u"?=K^?kP{?xtj~F?F?htj~C*0U2a?usg?}Z?	 ?vOv_خ_!-w1?sPH?sPH?*0U2a?҈?+?=K^??_o?ᰉ'?Ϫ͞?ɅoiD?S?}Z?Xtj~?c*0U2a?*0?bM?v?tZ?bM?T`d?},<?4Jhtj~rn/?rnO;?n?+j?zG{?p:?Z?_o?*0
*6C-?bsPH?u!?Z?fA?U=K??$/?N;5X?htj~g?@NU?s*0U2arnO;?!-w1ſUL_?C,zxl?*0?Z6C-v+I?_!-w1?	 ?,<쿱?W>6z?U=K?+I?Q?ye+aq4JrnO;bsPH?bM?wkP?S*0U2a?4J?:6C-?kQ_?|??Q_?!-w1?zG{?%2?_o ?L_?L_??x*0
fOv_خ?n/?n?ݗ+j?!-w1ſ]}H˒?4J?4J?{u%F?xtj~?zvȴ9?%2?=K^?@NUrn/?6C-?ie+a?C*0U2a?䎊q޿Rn/?? ěT?tj?L_?!-w1?T`d?$/?u"?s*0U2arsPH?sPH?,<?_o ?-
qv?!-w1?*0?T`d?|1&y?vǿg?҈?E?O
M*6C-?H?$tSM?:6C-?+jg?Ϫ͞?Ϫ͞?{Q_?{Q_?-
qv?q4J?:6C-?nO;?~Ov_ح?!-w1?bM?Mj?w?{Q_UL_?vȴ9X?2a|Q?zG{FǿtzG{?Rn/?~Ov_ح?)^	?fOv_خ?ie+a?T`d?},<?$/?u"eL_?n/?nO;?S&?bMJ6C-?ae?U=?u%F?},<?_!-w1ſv+I?PbM?_o ?L_?ᰉ'?@NU?wXe+ԿtZdzG{?@NU?u"?y_o ?{Q_?T`d?$tSM?Q?+jg?{u%F?y_o ?g?@bM?u"?,<?1&?}}H˒??cA \?ɅoiD?*0U2a?~Ov_ح?ݗ?*0
?e+?_Ft?q4J?L_?u%?:)y?y=b?=K^?	 ?tj~?8YJ?vȴ9?tj~?)^	?|C,zxlj6C-?{        ?tZ?kP{?|??	 ?U=K?Z?C,zxl?Ϫ͞??Xe+?*0?Ϫ͞?fA?Ϫ͞?R<64?N;6?bM?҈?:)y?v+I?kP{?a4J?N;5X?ku%F?dzG{?sPH?-
qv?},<?Fs?=K]?zG{?	 ???@?O;dZ?fA?fA?_o?vȴ9X?=K^?*0U2?xPH?a@N?S?ݗ+j?Z?{Q_?4J?u!?e+a?`A7L?!-w1?`A7L*6C-?o䎊q?vOv_خ?sg?$/?A?Z?&?6C-?rsPH?>BZc?PH?O;dZ?wkP?䎊q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ??????????????????????????????????????????ə?ə???????????????ə???????????ə?ə?ə??ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?ə?ə?ə?ə?333333?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə????ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????ə?ə?ə?ə????????ə?ə?ə?ə?ə?ə?ə?ə?ə???????ə?ə??ə?ə??ə??ə?ə??ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?????ə?ə????????ə????????????ə???????????????????????????????????????????????????????????????????????????ə?ə?ə?ə?ə?ə?ə?ə?ə?ə??ə?ə?????ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?ə?ə?333333?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?ə?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?333333?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    &&gB)@e3: ׀32                                      1                                       