CDF       
      time      pressure     latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        43     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:22.819942Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_043 (43) * LATITUDE: 41.010000 * LONGITUDE: 2.070000 * DATE/TIME: 2016-08-27T00:00:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @@        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC        '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        C(   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*eS   data_max      @:f   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC         J0   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        fH   salinity               	long_name         salinity   units         PSS-78     data_min      @C )   data_max      @CHhۋq   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC        mP   salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d        h   oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @f d8   data_max      @pe   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC          p   	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d           CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?$xF   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC           CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d        Ϩ   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ə   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC       ְ   CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d           time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &+   data_max      &+   C_format      %10d           latitude               	long_name         latitude   units         	degrees_N      data_min      @DGz   data_max      @DGz   C_format      %9.4f              	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @ \(   data_max      @ \(   C_format      %9.4f              	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3;   data_max      3;   C_format      %8d            	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min             data_max             C_format      %4d            station                	long_name         STATION    units         unspecified    C_format      %s        (     cast               	long_name         CAST   units         unspecified    C_format      %s        (  @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @:f@:ZW'@9=b@9>BZ@8+@8{J#9@8fl!-@8#,zxl@7e+a@7@7y^5?}@7Y(@7F]cf@7$S@61@6n.@6'@6ꟾvȴ@6*0U2a@62W@6C@6{jf@6k~$@6]qu"@6JC\@6(e+@6p:~@6C-@6*1@5(@5b}V@5fA@5y"`@5yoiD@5}H˒@5/@5eoiDg@5Dj~@5r Ĝ@4	@4x@4=v@4!hr @4P{@3)^	@373@3l"h	@3snP@3$tS@2E@2a@N@2K]d@2C҉@1n@1RT`e@1_\(@1;S@1$SMj@0n.3@0wkP@0Z@0cA [@0TɅ@0
Q_@/k~(@/L!-w@.nO@.ݗ+j@.n.3@.)^@.MM:@.-qu"@-?@-~$@-@-D@-%1@-o͞@-dZ1@-Uᰉ@-?[W>@-*JL@-rG@-$tS@-'ݗ+@-)y@,ԕ*@,D@,Ov_@,q@,g	l@,@,orGE9@,H@,>\N<@,;Q@,49XbN@,$tj@,;dZ@+vȴ9X@+E@+@+2X@+Q@+/w@+յsh@+ɠ'RTa@+1.@+Ďqj@+XbM@+@+#@+Fs@+YJ@+R<6@+C,zx@+O
M@+$tT@+s@+<쿱@+rGE@+x@+xD*@+]IQ@+Rn@+;S@+0bM@+,C@+*L_@++C,z@+*D@+)Dg8~@+(ۋq
@+%F
L0@+!7Kƨ@+$2W@+)y@+*d7@+*W'@+,<쿱@+.zG@+-(@+&'@+u@+kP@+2a|@+,<@+ߤ@+W@+䎊@+Mj@+'/W@+	7KƧ@+'@+ ҈p@* ѷY@*m\@*cA @* ѷY@*E@*|hs@*vȴ9@*|hs@*A@*Y}@*|@*U@*(@*u%@*~@*rG@*Ϫ͟@*[W>@+
fB@+
D@+	B@+
=p@*j~#@*
=p@*8YJ@*Ov_@*zG@*@*N;6@*T`d@*sP@*,<@*%F
L@*$tS@*/V@+ 
qu@+eO@+I^5?@+
:@+
O;dZ@+/{J#@+L_@+\)@+zH@+_o@+]cf@+qj@+\(@+.H@+n.@+-w1@*حV@*?@*?@*䎊r@+ A7K@+ NU@*$t@*C,zx@*0
)@*	k~@*+@*rG@*@*#@*MjO@*s@*4֡a@*ߤ?@*}Vl@*C]@*jf@*xF]@*U=@*P{@*n@*fB@*I^@*C,z@*P{@*xF]@*q@*҈@*1&y@*첕@*>B[@*V@*jOv@*_@*c	@*O;@*c	@*zG@*v@*-
q@*:~ @*:~ @*A [@*s@*[W>6@*[W>6@*GE85@*a@O@*Z@*Y|@*2a|@**0U2@*S&@*H@*'/W@*O;@*Vu@*.2@*!R<@*O
M@**0U@*u@*T`d@*nO@*:)y@*KƧ@*D*@*+j@*E@*Mj@*ᰊ@*u!S@*l@*4J@*X@*-@*zG@*Y}@*Q@*쿱[@*j~#@*64@*6z@*˒:)@+ -
@+ n@+ 'RT`@*䎊r@*?@*	@*BZc @*m\@*!-w1@*IQ@*Xe@*F@*W>6z@*Z@*?@*W>6z@*6C@*#w@*)@*)@*D*@*O;d@*C-@*Ov_@*Xy=@*_ح@*+jg@*Z@*֡a@*Ov_@*ȴ9X@*4K@*Ov_@*sh@*Fs@*33333@*g@*`d@*3@*zG@*,<@*@*@*|@**0U2@*tj~@*@*m8@**0@*D@*񂩓@*u!S@*u@*X@*$tT@*'RT@*rGE9@*(@*C]@*1&y@*ڹY@*k~(@*@*E84@*L/{J@*E84@*m\@*㢜wk@*&IR@*҈p@*ߗ$tS@*ݲ-V@*Q@*wkP@*~$@*XbM@*z@*9XbN@*g@*ӎMj@*ҽ<64@*hr @*@*oiDg8@*:~ @*У
=q@*@*о
(@*σ{J#:@*\(@*iDg8@*4֡a@*1@*ξߤ?@*t@*t@*+@*Mj@*v@*4֡a@*v@*'/W@*As@*v_ح@*Ϸr@*rGE9@* ě@*H@*У
=q@*[W>6@*2W@*n@*GE85@*҈p:@*䎊q@*tj~@*a@O@*ݗ+k@*@*J@*9XbN@*ԯO
M@*ԯO
M@*m8@*m8@*Լj~@*Ʌoi@*E@*Վ!R@*Ov_@*8YJ@*8YJ@*Ov_@*ըXy=@*ըXy=@*Ϫ͞@*4K@*8YJ@*_ح@*z@*և+J@*և+J@*z@*z@*_ح@*R<6@*l!-@*l!-@*R<6@*E@*+jg@*8YJ@*+jg@*Ov_@*ᰉ@*\(@*Y|@*?|h@*Y|@*֡a@*ԯO
M@*ԯO
M@*ԯO
M@*ݗ+k@*Z@*@N@*@N@*@N@*33333@*m@*2W@*[W>6@*4J@*а{@*H@*@*ξߤ?@*.2@*͸@*˟U=@*P{@*P{@*I^@*fB@*'/@*I^@*fB@*fB@*fB@*fB@*͞&@*n@*ʦL/{@*ʦL/{@*ʦL/{@*ʙ0
@*ʌL_@*~"@*qiC@*=p
@*ԕ*@*ɺ^5?}@**0U2a@*#@*lC@*_o@*ƀIQ@*oiDg@*+a@*o i@*Õ$@*`A@*`A@* ѷ@*@*¶}Vm@*@4@*u%F
@*M@*@4n@*M@*M@*Zc@*h	ԕ@*@4n@*3@*3@*e@*:S@*.H@*҈p;@*Q@*iB@*H˒@*!.H@*N;@*]ce@*n.@*S@*S@*5Xy@*5Xy@*m]@*S@*~$@*J#9@*"`B@*~@*S&@*@*|@*b}@*XbM@*PH@*@@*tj@*YJ@*Q@*D*@*73@*&@*Xe,@*Xe@*Ϫ͟@*Fs@*z@*t@*Xy=@*fA@*?|h@*%F
L@*%F
L@*֡a@*m8@*#@*O
M@*Ʌoi@*Ʌoi@*Z@*Z@*֡a@*3@**1@*zG@*,<@*J@*@*9XbN@*9XbN@*Fs@**1@*@*g	l@*&@*m\@*m\@*m\@*m\@*S&@*n@*N;6@*2W@*2W@*l@*@*hr @*&x@*)^@*
=q@*bM@*@*-V@*'/W@*
M;@*ߤ?@*p:~@*;5X@*.2@*(@*zG@*!R<@*@*\@*zxl"@*cA \@*"h	ԕ@*L_@*1&y@*1&y@*҈@*a@@*Ƨ@*6z@*D@*ڹY@*ڹY@*͞&@*ڹY@*ڹY@*ڹY@*͞&@*0
@*#9@*k~(@*7KƧ@* ѷ@*TɅ@*@*$xG@*	ԕ+@*#@*-@*#@*@*fA@*&@*_o@*Fs@*'@*&I@*A@*A@*IQ@*L/{J@*1.@*@*
L/@*ڹ@*ڹ@*@*S&@*u@*u@*Q@*o i@*Z@*S@*C,@*`A@* ѷ@*@*h	ԕ@*3@*&IR@*&IR@*&IR@*s@*.H@*s@*o@*R<6@*o hی@*TɅo@*Gz@*C@*d8@*u!@*'RT`@*䎊r@*حV@*|hs@*U=@*@*ߤ?@*҈p;@*ߤ?@*҈p;@*BZc @*IQ@*!.H@*>@*u"@*u"@*wkP@*(\@*m]@*~$@*)_@*"`@*b}@*0
)@*e+a@*JE@*e+@*D*@*@*sPH@*>6z@*@*Ϫ͟@*l!-@*+jg@*Ov_@*+jg@*!.@*Xy=@*L_@*Ʌoi@*,<@*ݗ+k@*m\@*W@* ě@*{m@*nO@*:)y@*n@*n@*u@*4J@*A [@*4J@*$tT@*{@*@*'RT@*H@*U2a|@*:~ @*:~ @*:~ @**0U@*Vϫ@*@*\(@*As@*'/W@*v@* hۋ@*Vu@*_o @*@*@*U=@*hr!@*w1@*qu"@*@*!-w@*C@*<쿱@*~($@*6z@*͞&@*JL@*^5?}@*@*Q@*TɅ@*r Ĝ@*$xG@*ݗ+@*&@*ݗ+@*8}H@*Fs@*A@*-@*&I@*fffff@*@*F
L0@*u@*o i@**0@*S@*o h@*g8}@*Z1@*M:@*2W@*?@*%1@*wk@*a@N@* ѷ@*3@*s@*o hی@*ae@*C@*ѷX@*ěT@*ěT@*IQ@*A7K@*     @*	@*Ft@*!-w1@*Ft@*~6z@*}v@*}Vl!@*}/w@*}[@*}!.H@*|hr@*|쿱[@*|?@*|?@*|wkP@*|]ce@*|C,zx@*|PH@*|j~#@*|j~#@*|j~#@*|wkP@*|]ce@*{5Xy@*{5Xy@*{5Xy@*{dZ@*zvȴ@*y_o@*y~($@*yrGE8@*y+@*x@@*xl"h	@*xbM@*x}H@*xbM@*wrG@*w4m@*vR<6@*uᰉ@*u=K@*usg@*u*0@*tɅoi@*t,<@*sZ@*r ě@*rS&@*r ě@*rnO@*qX@*qhr @*q[W>6@*qu!S@*qN;5@*p$tT@*p{@*p$tT@*p`A7@*p{@*pU2a|@*pU2a|@*oVϫ@*o{J#:@*n+@*nH@*m8Y@*mB@*l[W?@*k~($@*jL_@*ilD@*irGE@*fIQ@*f
L/@*eS@*lI^5?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @C$t@Cfffff@Cn.3@Cݘ@C@C
=p@C
b@CC@CC%@C	oiD@C
C,@CwkP@CɅoi@C
S&@CS@CbM@C-V@Csg@Cn.@C"`@C hۋ@CR<6@Caf@C%@CA@C
ڹ@C
@C
%@C
\@CFs@C	lD@Cᰊ@C )@C|Q@Cq@C}H@C
1'@Ce+@C	k@C@C;dZ@C*0@C@C@C/V@CXe,@C;dZ@CRT`e@C	iB@C&@CcA \@Ct@C
M;@C@C7Kƨ@CC,zx@C1@C>6z@Cv@C@CM:@Cce@C@CR<6@C_ح@CFt@C_o@Cȴ9X@C?@COv_خ@CFs@Cߤ?@C,@C$xG@CK]c@CU@C@@C@N@C-@Cn@C\N@CS@CO
@C+J@C"C,@C$64@C"W@C"nO@C#5Xy@C$Q@C$!-w2@C$?@C$@C%o i@C%@C&+J@C&O;@C&Ϫ͟@C&Q@C&%@C&t@C'
M;@C(U2a|@C(ěT@C)rGE@C)'RTa@C*	 @C*,<@C*W@C*͞&@C+	@C+6z@C+33333@C+&@C+,zxl@C+6z@C+҈@C,֡a@C-S@C.c	@C.L/{J@C.!R<@C-ڹZ@C,@C,`d@C+q@C+@N@C+9@C+dZ@C+wk@C+A [@C,L_@C,]ce@C,TɆ@C,Z@C-?|h@C.8YJ@C.l!-@C.Fs@C/)^@C//V@C0F]d@C/@C/?@C/|hs@C/vȴ9@C/حV@C0$xG@C0bM@C0@C0{@C04֡b@C0@C0\)@C0e+@C1	k~@C1ae@C1u@C1N;6@C1.H@C23@C26C@C2C\@C2䎊@C26C@C2M@C2u%F
@C2G{@C3	@C3Z@C3q@C3g@C5'0@C6YJ@C6iB@C6YJ@C6L/{J@C6+jg@C6zG@C6u@C65?|@C6BZc @C6l!-@C6m\@C6@C7Ft@C7>6z@C7y@C7/V@C8eO@C94J@C:d7@C;I^@C;,zxl@C;m]@C;҈@C;@C<n.@C<<쿱@C<PH@C<VϪ@C<Z1@C<cA \@C<q@C<?@C<*1@C<Ʌoi@C<!-w@C=K]@C=(@C=B@C=ڹZ@C=U=@C=U=@C=H˒@C=oiDg@C>@C>$/@C>5?|@C>?@C>8YJ@C>1.@C>BZc @C>H@C>_ح@C>&I@C>ߤ?@C>x@C>!.I@C?!-w1@C?E84@C?\(@C?eں@C?lC@C?sPH@C?v_ح@C?4m@C?O;d@C?/V@C@F]d@C@ ě@C@[6@C@'RT@C@IQ@C@e+@C@e+@C@@C@@CA [7@CA=b@CA^@CAae@CA@CAԕ*@CAe@CA@CBu%F@CBQ_@CB\(@CB<64@CB,<@CB ѷ@CBsP@CB`A@CB ѷ@CB䎊q@CB䎊q@CBm@CC/V@CC~$@CCU=@CCƧ@CCQ@CC%2@CCs@CDtSM@CD_@CD3@CD@CD1&@CDTɆ@CDO
M@CDɅoi@CDE@CE!.H@CE+a@CEw1@CEoiDg@CFu@CF$/@CF.2@CF8YJ@CFqi@CF-@CF@CF&I@CF&I@CF&I@CFȴ9X@CFm\@CF@CF҈p;@CFC-@CFߤ?@CF,<@CFm\@CF"@CGv@CG,@CG@CG
=p@CG
M;@CG@CGv@CG@CG
=p@CG
=p@CG
=p@CG
M;@CG!-w1@CG.H@CG$tS@CG+I@CGRT`e@CGeں@CGiDg8@CGlC@CGo@CGb}V@CG\(@CG	@CGkP@CG&@CG&@CG͞@CG[W>@CGzH@CG[W>@CGr@CGvȴ9@CG@CG@@CG䎊r@CGrGE9@CG@@CG@@CG-@CG䎊r@CGVϫ@CG䎊r@CGVϫ@CGحV@CG˒:)@CG;dZ@CGfA@CG˒:)@CGo @CG/V@CG/V@CG@CGo @CG3@CG?@CGݗ+@CG{J#:@CGb}V@CGU=@CGXe,@CGKƧ@CG+I@CG
M;@CF쿱[W@CFx@CF@CF1@CF]cf@CF]cf@CFϪ͟@CF+@CFߤ?@CF쿱[W@CF@CF1@CF1@CF1@CF1@CFx@CFx@CF@CFMj@CF"@CG hۋ@CGFt@CG
M;@CG)^@CGv@CG,@CG$tS@CG.H@CG8}H@CG>6z@CGE84@CGRT`e@CGiDg8@CGo@CGy@CG|hs@CG4m@CGݗ+@CG?@CG͞@CGzH@CGzH@CG[W>@CGr@CG˒:)@CG@CG+@CGfA@CGحV@CG@CG@@CG䎊r@CHF]d@CH@CHbM@CH6@CH ě@CH-
q@CH-
q@CH73@CH:~ @CH>BZc@CHA7K@CHD*@CHD*@CHA7K@CHH@CHK]c@CHQ@CHNU@CHQ@CHQ@CHXy=@CHXy=@CH[6@CH[6@CH[6@CHhۋq@CHhۋq@CHeO@CHeO@CHhۋq@CHbM@CHhۋq@CHhۋq@CHeO@CHeO@CHbM@CH_F@CH_F@CH[6@CH[6@CH[6@CHNU@CHNU@CHK]c@CHA7K@CH>BZc@CH73@CH-
q@CH*0@CH$xG@CH
qu@CH	ԕ+@CH@CH     @CH@CH     @CHF]d@CH     @CG#@CH     @CG#@CG#@CG#@CG#@CG#@CG#@CH     @CG#@CGrGE9@CH     @CG#@CGrGE9@CG#@CG#@CG+j@CG䎊r@CG䎊r@CGVϫ@CGrG@CG@@CG;dZ@CGfA@CG@CG@CG+@CG+@CG˒:)@CGK]d@CGK]d@CGK]d@CGo @CGo @CGo @CGo @CG@CG@CG@CG@CGvȴ9@CGr@CG&@CG?@CG	k@CG-V@CGݗ+@CG	@CG{J#:@CG|hs@CGy@CGsPH@CGsPH@CGlC@CGsPH@CGsPH@CGo@CGo@CGlC@CGiDg8@CGeں@CG_o@CGXe,@CGU=@CGU=@CGU=@CGRT`e@CGKƧ@CGH˒:@CGH˒:@CGE84@CGAs@CGAs@CG;dZ@CG8}H@CG4֡a@CG.H@CG.H@CG+I@CG!-w1@CG,@CGv@CGv@CGXe@CG@CG
M;@CG)^@CGXe@CG@CGXe@CGXe@CGXe@CG)^@CG@CG)^@CG
M;@CG
=p@CG
=p@CG
=p@CG
=p@CG
M;@CG
=p@CG@CGv@CGXe@CG)^@CG
=p@CGFt@CGFt@CGFt@CG@CF!.I@CFFs@CFFs@CF"@CFMj@CF@CF@CF쿱[W@CFx@CFC-@CFC-@CF]cf@CF]cf@CF҈p;@CFt@CFA@CFȴ9X@CF&I@CFߤ?@CF@CF@CFߤ?@CF@CF@CF2X@CF6z@CF-@CF-@CFT@CFaf@CFaf@CFaf@CF@CF,<@CFO;@CFFs@CF@CFqi@CF@CFqi@CFqi@CF+J@CF+J@CF%@CF}Vl@CFs@CFl!-@CFl!-@CFiB@CFc	@CF_ح@CF\N<@CFYJ@CFYJ@CFVu@CFYJ@CFOv_خ@CFOv_خ@CFL/{J@CFH@CFE@CFBZc @CFBZc @CF?@CF;5X@CF;5X@CF8YJ@CF5?|@CF1.@CF1.@CF1.@CF.2@CF($x@CF$/@CF!R<@CF!R<@CFOv_@CF
L/@CFt@CFt@CF ѷY@CEڹ@CEC\@CE!.@CEE@CEoiDg@CEoiDg@CEoiDg@CEᰉ@CEᰉ@CE,=@CES@CE
qv@CE
qv@CEb@CEb@CE8YK@CEϪ͞@CEcA @CE8Y@CE\(@CEn/@CEn/@CE@CE-V@CE1@CEU=@CEU=@CEXy=@CE%@CEO
@CE!R@CEڹZ@CEڹZ@CEݗ@CEݗ@CE}H@CEzxl"h@CEsg@CEfA@CEY|@CEVl!@CEO;dZ@CES&@CES&@CEIQ@CE?|h@CE<64@CE2a|@CE+a@CE(@CE!.H@CEqu"@CEqu"@CE*0@CE*0@CEu@CE'0@CEo i@CDE@CD!-w@CDhr@CDu"@CD/@CD>B[@CD֡a@CDZ@CD@CDɅoi@CDɅoi@CD7@CDj~@CDj~@CDj~@CD?@CDO
M@CD@CDO
M@CDzxl"@CDzxl"@CDzxl"@CD3@CD3@CDS@CDS@CD_@CD*1@CDN;@CDqj@CDC@CDC@CD?@CDwkP@CDtSM@CDtSM@CDq@CDq@CDj~#@CDcA \@CDcA \@CD`d@CD]ce@CDSMj@CDI^5?@CDFs@CD<쿱@CD64@CD/{J#@CD,<@CD%1@CDQ@CDtj@CDߤ@@CD1&y@CD1&y@CDJ@CC\N@CC\N@CC$@CC$@CCA [@CCg@CC%2@CCݗ+k@CC
=p@CC
=p@CCa@@CC@CC@CCƧ@CCa@O@CCa@O@CC6@CC6@CC6@CCE@CCm]@CC*0U2@CCߤ@CCA@CC:)z@CC:)z@CCq@CCQ@CCQ@CC@CC@CC~$@CCtj~@CCn.3@CCdZ@CCdZ@CCa@N@CC]cA@CCMjO@CCF]c@CCC%@CCC%@CC@N@CC9@CC6z@CC6z@CC33333@CC,zxl@CC)^	@CC,zxl@CC)^	@CC)^	@CC&@CC&@CC&@CC"`B@CC	@CCC,z@CCPH@CCnP@CCu%@CB74@CBD@CBm@CBC,@CBfB@CBG{@CBڹY@CBsP@CBsP@CB,<@CB͞&@CBY@CB}Vm@CB ě@CB>B@CB@CBvȴ@CB0
@CBp:@CB@4@CB{m@CB~"@CBu%F
@CBnO@CBd7@CBd7@CBd7@CBa|Q@CBZc@CBW'@CBW'@CBW'@CBQ_@CBJL@CBJL@CB@4n@CB:)y@CB0U2a|@CB&IR@CBe+@CBOv`@CB	 @CAlD@CAe@CAiB@CA_o@CAB@CAn.@CAu@CAs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @iq@jNFs@jzG@k`hۋq@kq@kuݗ+k@k-
@kAb}V@k,zG@kaR@k9Xb@k*0@k&\(@kP
qu@kQ@k`@4n@kI5Xy@kB@km]@k&@kwO
M@kf_F@kIQ@kᰊ@khr!@kFs@k>6z@kC@kɼn/@kȴ9X@l&>@lU@lݘ@l҈p;@lqݗ@lxZc@lB@l6C@m"1&@mF*1@m͞@mtj~@mOv`@mȴ9X@m҈p@m6@m°{@n8YK@nk,@nv@n+@oE84@o8C@ot@p\(@p?@pe@p*0U@p^%F
L@p4M@o;dZ@ozxl"h@pJM@p@ooiDg8@oD@oY|@oXd7@o-w1@nrGE8@n)@nOv_خ@nL_@n1'@nxJM@n.H@nqfA@nH4K@n*A@n-$/@n&m8@m2a|@mܕᰊ@na(@nJE@mZ@m<m8@m9XbN@m| ě@mO'RTa@mᰊ@mKO
M@mu@lYa@N@lY|@k!.H@kd[W?@k9XbN@jU=@k9ݗ@kOv_@lK@m
M;@l$@l{ߤ@k+j@k@k@k쿱[W@kBu"@k"u"@kK%F
L@k_C\@keeO@k(fffff@jC/w@i4K@iD@i[@N@imPH@iG{@il@j5_p@j+a@jŀ4m@j2W@j@k*sP@k.$tT@k
=p@k
]cf@kJE@jdZ@k\(@kڹY@k
Ʌoi@jA@jg	@kFt@kg8}@j@jjf@jb@jF]c@j-@j]cf@jڹY@j́@jQ@j@jM@jg	l@jaC,z@j>`d@j@4n@ju!S@j&Y@j%S&@j_ح@j"@j)x@j0kP|@jO
@jaf@iU=@io h@iD@iA@jO;dZ@i?@iqj@i@iFt@j)W>6z@j@Mj@j	dZ@iڹZ@i
=q@iaf@ilg8}@iaJ#9@id@i[r@iLl"h	@i;6@iEx@iLhۋq@iK@iW@iD@i*0@j 1@j e+@iX@i\(@iQ@iJE@i1&@i6@i@i
L/@i33333@i&@iߤ?@iaf@iu@iVu@i8YJ@ia@@iD*@it|@iuݗ+k@icA @itu!@iNMj@i.$tT@iu@hDg8~@hn.3@hiB@hy@h釓ݗ@h/V@h۠	k@in@i_p@h3@h3@hO;@hK]@h{@he@ht@hv_ح@hS&@hfB@hfB@h@hI^@h9XbN@h@ha@N@hQ@h@h?@hK]@h&@h-@h!.@hZc@h-
@h\)@hsXe,@hb1&@hw4m@hmƧ@h:cA \@hl@hZ@h5?|@h+Xe@h3jf@hAMjO@hft@hh-
q@hi@hj!-w@h_
=p@h8{@h73@h	X@hSMj@gXy=@gL_@gS&@gZ4m@g1@gKo hی@gT@g/V@h"}Vl@hA:S@h>r Ĝ@h7b}@h;Xy=@h~($x@gƧ@go@g
=p@g.:)y@gA͞@g:Q@g8}H@fC,z@fb}@fF
L0@gS&@g(@g
6@gL_@f@g&x@gQ@g+k~(@gC$/@g M@g \N<@fNU@fJM@gH˒@gcA @g..2@g<4K@g.-
q@g.-
q@g/@g3/V@gEK]d@g<@g#rGE@g0{@g=qu!@g7S@gQ@gA [@g(,<@g'7KƧ@gG{@g+a@N@ge+@f`d@fD*@f}Vm@f'RT`@f|@fݗ+j@f_ح@f\(@f@fPH@f&@f	ԕ+@fhr@f+@fۋq
@fj~#@f-V@fᰊ@f-V@fxl"h
@f?|h@fe@ft@fYJ@f%@fĐ$t@f:S@fW>6z@fsPH@f@fs@f֛S@fE84@f(@gڹZ@g3(@g6l!-@g 4m9@g0҈p@gWD@gZc@gS&@gݗ+@ghr @gKƧ@g~af@g{b@g}=K^@g}=K^@gzu!@gzu%F
@gyu@g~쿱[@g-V@g@4@gɅoi@g,<@gȴ9X@gwq@gmE@gi@ggI^@gasPH@gk+a@gk+a@g`ߤ@@g[%2@gOdZ@g=Vl!@gI8YK@gR*0@g,1&@g@g!Mj@g%~($@g$Vu@gdZ@gY@g:@f,@f@fH@f
=p@f+jg@f ѷY@fVl!@f䎊r@f݀4m@f֎qj@f+I@fU=@f hۋ@f ѷY@fd7@fH@f#x@f9XbN@fC,z@fS@fwkQ@f|GE85@f|GE85@f|GE85@ffA@fy4m@fyb}@fzC-@fr@fq*0U2a@fhF@f`˒:*@fj8YJ@f\U2a|@fX*0@fX)y@fHZ@fFQ@fNq@fR,<@f=Ƨ@f*U2a|@f84֡@f$)_@fZ@fu@f@fQ@f d8@foiDg@f(@f ,<@f4m@f@f ,<@f5o hی@f9@fG|Q@fJC,zx@fU_o@fk+j@fn^5?|@fl>@f]|@fSC\@f\Ov_خ@f\Ov_خ@f\Ov_خ@fYeO@f_+@fgk~(@fdT@fdT@fj2W@fcA [@f\Ov_خ@f\Ov_خ@fOϪ͞@fH ѷ@fH ѷ@fJA7K@fGzxl"h@fMu%@fNkP|@fQ2a|@fU\@fNkP|@fH]cf@fJ?@fAᰉ@fQ0
)@fZx@fUZ@fX!R<@fht@f$@f ѷ@fnXy=@fon/@fnXy=@fs,=@flD@fj-
q@fs,=@fuJ#9@fj-
q@frn@fuJ#9@fvU@fytj~@fnXy=@flD@fr@4@fqQ@f+a@f\(@fH@f)_@fƧ@fTɅo@fa@@fe+@f@f\N@fȚ,<@fȚ,<@fbM@f)^	@fE@f~$@fe+@fE@f@fE@foiDg8@fa|Q@f-@fD*@fD*@f`A7L@f@fș0
@fϊڹZ@f#@fQ@f|@fc	@f`A7L@f5Xy>@f;dZ@f+j@f;dZ@fQ_@f&IR@fӴ3@f&IR@f*0@fQ_@flD@f쿱[W@fȘ_@f'@f(@fm8@f5?|@fѷX@f5?|@fC]@f|Q@f4J@f|@f
L/@f@fsh@f3@f'/W@fnR<6@fkq@fhěT@fxxF@f|5?|@f~PH@fC]@f}A@fj($x@flc	@fg`A7L@fd0
@fj'RT`@fr|@fuC%@fr|@fr|@flc	@fqPH@fx	ԕ+@fr{m@fXe+@f_
=p@fq*0@fh7@flhr@fym\@fs;dZ@fnQ_@fx	ԕ+@fuB@fd_@f`m8@fvzxl"@f|3@frzG@fh&I@fnPH@fes@f\BZc @fX@fUP{@fnPH@f]ce@fuAs@fh&I@fg^@fa|@fk7Kƨ@fvT@fk7Kƨ@fa|@f_	k~@fdO;@fuA [@fvT@fuA [@fom]@f`l"h	@fg]cA@fom]@fnOv_خ@fnOv_خ@fkeO@fzA@fzp:@fo-V@f|1.@f#w@f}$@fnOv_خ@fkeO@fnNU@fyjf@f+J@fN;5@fs?@fx_o @f}$@f~	k@f}$@fu@N@fs?@fyjf@f|1.@fqs@fu?|h@f}O
@fyjOv@fx@f}O
@fu?|h@frxl"h
@fvS&@fh[W?@flJM@fyjOv@frxl"h
@fz͞&@fx@fq[@fz͞&@fyjOv@fx@frxl"h
@fnM@fz͞&@fvS&@fs@frxl"h
@fu>6z@f ě@fL_@fu>6z@fk&@fs@fq[@fg[W>6@fs"`@fvȴ9@fݘ@fxn@fs"`@f~e@f|0U2a|@fyiDg8@flx@fs"`@f@f|/{J#@fzt@f}@fzt@f@f>BZ@fs@f~Fs@fKƧ@f@f|/{J#@frvȴ9X@fj!R<@fsQ@fzt@f~Fs@f?@fZ@fzt@f}:)z@fZ@fu!S@f}Vl@fYJ@fZ@flC@f}Vl@f [7@f}:)z@flC@fu!S@fYJ@fz)^@f}Vl@f4K@flC@fu!S@f ѷ@fD@f@fJE@fu!S@f~\)@f|.2@fXy=@f	@fU@ftj~@fn@fU@f-w1@f-w1@ffffff@fU@f	@fD@ffffff@f ѷ@ffffff@f@f`A7@fXbM@f-
@fU@f%@f@fe+a@f~($@fn.@fMj@f
=p@f8YK@f~($@f@f{@f+jg@fH@f%2@f~($@f@f ѷY@fdZ@fIQ@f@f%2@f9XbN@f{@f9@f~($@fGz@f@f~($@fMj@f~($@f8YJ@fF]c@fU2a|@f$tT@fa@@fA [@f˒:*@fS@f8YJ@fƧ@fc	@fm\@fe+@fu@f=K@foiDg@fm\@foiDg@f7KƧ@fȌ@fa@@f@fȌ@f8Y@fm\@f73@f)^	@fu@f̷4m@fȌ@foiDg@f̷4m@fȌ@fө*0U2@fө*0U2@f($x@f@foiDg@f8Y@fa@N@fE@f@fa@N@fښu%F@fa@N@f($x@f҉@f6z@fR<6@f($x@f@fڹ@f|@f5Xy>@fc	@fn.3@f|@f|@f@fA@f;dZ@fsh@f
qv@fѷX@fm\@f@fڙ0
@f#@f{m@f*0@f_F@f+j@fm\@f+j@f9Xb@f+j@fm\@fhr@f_F@f_F@f9Xb@g @f	ԕ+@f*0@fm\@f@fO;dZ@f%F
L@f>@f^5?|@f&                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ??4J?A?y(??,?#x?u%F?9XbN?fA?E?C?'RT`?@4?^5?|?eڹ?xl"h	? ѷX?>BZc ?6z?BZc?4m8?kP{?+J? hۋq?-w1?2W?	 ѷ?I^5?âwkQ?n?/Vϫ?u%?;dZ?lC?@N?l?ݗ+j?ߤ??θQ?мj~#?oiDg8?ь~($x?B?MjO?l?ӆ&I?ԝIQ?JL?ԑN;6?GzH?x?;dZ?҈p;?+a@?	 ѷ?8YK?e+a?ۯr?6C-? ѷ?
L/{?qiB?{m]?+I^??2W?x?ڸQ?Fs?1.?O
M;?H˒:*?~$t?ܓtj~?ܹ#w?rGE85?݊ڹY??҈p?lC?m\?PH?sg?
L/{?$xF?sP?|?S?C,zx?C]?hr ?ᧆ&?O;d?$tSM?޸Q?L_?#x?{m]?Կ[W>?ҩ?
qu?ffffff?6C?=b?%1?fA?!-w1?JM?MjOv?Ov_?'?)_?1.?ۋq?˒:)?@?}H˒?6z?eO
?
(?n.3?"`A?-V?'?D*0?_o ?_F?~"?E?}H?oiDg8?+?n?F]cf?{m?N;5X?lD?n.2?`A7L?S??S?W>6z?6C?Q?u"?fA?kP|?JM?}Vl?$tSM?ceO?Y}?1&y?-
qv?E?vȴ9X?3?䎊q?)_?kP{?W>6z???Xe+?ݗ?_o?5?|h?حU??|hs?T`d?u!?(\)?=K]?Xe+?"`A?Zݘ?w?|?҈?$?>BZc?u"??R<64?fA?*0
?b}V?PH?Ϫ͞?$tSM?zG{?N;5?`d8?E?Z?L_?Ov_خo!-w1?tZ?<64?Ϫ͞?u%F
?-V?y=b?W>6z?D*0?L_?|1&yhtj~?Xtj~M}H˒?tj~?Fs?䎊rc*0U2a?)^	?tn?nO;PbM?fOv_خbsPH?!-w1?nO;?H?Y}?Zݘ?},<?{Q_?_Ft?Q_?Z?Xe?sg?,<?C*0U2a?a@N?O
M?=K^?>B?zG{?N;5X?4J?H?S&?|C,zxl?,<?O
M?>6z?߿rnO;6C-?쿱[W?J6C-?ɅoiD?*0U2a?ᰉ'?+J?rn/?tn?v?ye+a?Xe?O
M?쿱[W??Fs?ߤ??$tSM?-V?w?+jg?bM?v?{qu!S?usg?UL_rn/?@NU?n?:)y?|??@NUku%F?tj~?*0?2a|Q?`d8?vȴ9?ku%F?4J?e+auL_y_o ?bsPH?vOv_خ?T`d?hr ĜrsPHz6C-6C-?eL_?rsPH?ye+a?s*0U2a3*0U2a?ye+a?,<?ku%F?ku%FFǿl1&y?䎊q?$/?Mj?v+I?rsPH?xPH?vOv_خ?4Jc*0U2aFsz6C-?PbM?=K]?ɅoiD?tnC*0U2a?tzG{?UL__!-w1ſrnO;?w?rn/?tzG{?j6C-?{u%F?-
qv?Xe?p)^	~Q?o!-w1ſrn/?vȴ9X?rsPHku%F?҈?rsPH6C-?Ov_ح?a4JbsPH?*0?vȴ9?tn?:)y?wkPx*0
wXe+?grnO;?{Q_?ݗ+j?=K^?*0?v+I?T`d?*0?o䎊q?{Q_?ߤ??rn/?bsPH?htj~?kQ_?s*0U2a?s*0U2a?wXe+?!-w1?n?,<쿱fOv_خ?u%htj~?sg??C,zxl?L_?qu"PbM?tzG{?y_o ?p)^	?	 ?n?<64?~Ov_ح?2a|Q?>BZc?!-w1?O
M?6C-?~Q?|??tj~?u"?pbMUL_a4J?O;dZ?n/`bM?UL_?PbM?Z?PH?rnO;?o!-w1?D*0?u"?{Q_?l?Fs?tj~ۿye+a{u%Fz6C-z6C-c*0U2a?]}H˒~Ov_ح?[Q_?R<64?bsPH?Z?N;5X?rnO;]}H˒?kP{?u"?wXe+?$tS?2a|Q?tj~?%2?_o ?{Q_?1&y?N;5vOv_خUL_?{u%FM}H˒}H˒?`A7L]}H˒?m}H˒fOv_خ?nOv_حpbMz6C-₿s*0U2a?S*0U2a?tzG{?1&y?ɅoiD?L_?n?쿱[W??s*0U2a?҈?{ſie+a?{qu!S?n/?tn?f?{qu!Sf?V?vOv_خ?wXe+?x*0
?bsPH?@bM{u%FXtj~?%2?&?c*0U2atn?p:?x*0
kQ_?T`d?qu!S??O;dZ?}Z?_Ft?nOv_حs@NU?{qu!S?n?R<64tZs*0U2az6C-q4J?a@N?-
qvtZtZ?N;5?fA?@NU?tj?}}H˒y_o F?xPH?ie+a?kP{?{?xPH?v?usg?v+I?p)^	?y_o ?usg?{u%F?tZ?_o?䎊q޿nOv_ح?+I?*0
?,<?@??p:?s@NU?tj~??s@NUdzG{?`A7L?pbM?v?rnO;?䎊r?{u%F?m}H˒?pbM?wXe+ԿXtj~?Z6C-?u%F
?e+a?ᰉ'?-
qv?@NU?IQtzG{?xtj~?rn/?s*0U2a?:)yc*0U2abM?UL_?ku%F?J6C-?`bM?dzG{?q4JRn/hr Ĝv+I?eL_?s@NU?hr Ĝ?b}V?o!-w1ſ$tSusg?4Jm}H˒䎊q޿usg?ie+absPH?Ov_خ?`d8?*0?a4Jye+a?:)y?_Ft?pbM?nOv_ح?{u%F?l?qu!Sw?o䎊q?tZ?u"`bM?*0
fOv_خ?htj~?},<?ie+a?_!-w1?s*0U2a?q4J?z6C-?nOv_ح?zvȴ9?wXe+?q4JbsPH?䎊q?`d8?p:v?Z6C-?|??*0U2a?S&?Ov_خ?p)^	UL_?*6C-?U=K?JD?u%F??쿱[W??rnO;?c*0U2adzG{?+?tj~?xPH{Q_z6C-Xtj~?ߤ??S&?*0U2a?*0
?6C-?n/a4J?w?҈?N;5X?z6C-?x*0
?tzG{?fOv_خhr Ĝ?Ov_خ?Z?`d8[Q_!-w1ſy_o ?tzG{?<64?rsPHo!-w1?dzG{?kQ_?3*0U2akQ_?zvȴ9?>BZc?kP{?v?usg?q4J?s*0U2a?n/?~Q?s*0U2a?tZPbMye+a?rnO;?L_?1&y?xtj~?҈?sPHC*0U2a?҈?wXe+ԿuL_)^	|1&y?C*0U2a}Z?tj~?s*0U2aRn/?tzG{?1&y?tj~?u%F
?l1&y?p)^	?PbM{Q_?$tSku%F?*0U2m}H˒?wkP?zG{?ݗ+j?䎊q޿|1&yrsPH?$tSM?{qu!Sa4J?zvȴ9?`bMeL_?*0U2a?u"?eL_!-w1ſu"?a4J?rn/?䎊q޿3*0U2a?	 ?},<?o䎊q?ݗ+j?$/?a4J6C-x*0
?j6C-?eL_?uL_?_o?v?nOv_ح?pbM?`A7Lie+a|1&y?Ov_خ?M}H˒zvȴ9!-w1ſpbM?l1&y??+?Q?o!-w1?{qu!S?sPH?|1&y?|?zvȴ9?htj~tZ?%2?&?ᰉ'?Q_?pbM?F??Q?Z?%2?!-w1?+?,<쿱?*0?u"?uL_?usg??o!-w1ſv+I?g?bn/?3*0U2a?Z?},<}Z@bM?vOv_خv?[Q_?htj~?o!-w1ſ6C-bM4J?c*0U2a??eL_?Q_?Xe+?qu"?rn/?-Vf?H?rn/?`bMo!-w1ſku%FPbM?0
(?A?Ϫ͞?usgy_o ?s*0U2a?n?zG{?zG{?*0?ɅoiD?ie+a?$/UL_?vȴ9x*0
?rnO;?1&yf?htj~?pbM?kQ_eL_?,<?JD?hr Ĝ??ku%F?f?kQ_?Xtj~?fǿo䎊q?:6C-?)^	w?Rn/|1&y?V?zG{?O
M?PH?S&?s@NU?Z6C-{u%F?tj~?:)y`bMku%F҈ο)^	?Ov_خ?},<?j6C-htj~?>6z??uL_?U=KtZ?u%F
?|C,zxl?vOv_خS*0U2a?wXe+?u%FFǿ@bM?A?}}H˒                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ?????????????????????????????????????????????????????????????????????????????????????ə?ə?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????ə????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   &+B$
=@z3;  43                                      1                                       