CDF       
      time      pressure     latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        35     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:21.657424Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_035 (35) * LATITUDE: 40.200000 * LONGITUDE: 2.640000 * DATE/TIME: 2016-08-26T21:54:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @          data_max      @@        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      6H  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
  ]X   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*?$tS   data_max      @:Z   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       6H  j   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
  4   salinity               	long_name         salinity   units         PSS-78     data_min      @B٠'RTa   data_max      @CKjf   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      6H     salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
     oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @e[x   data_max      @qd$tS   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        6H     	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
 (   CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?䶮}Vl   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      6H 6   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
 l   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     6H z\   CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d      
    time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &+   data_max      &+   C_format      %10d       8   latitude               	long_name         latitude   units         	degrees_N      data_min      @D   data_max      @D   C_format      %9.4f          <   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @Q   data_max      @Q   C_format      %9.4f          @   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3:   data_max      3:   C_format      %8d        D   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min        j   data_max        j   C_format      %4d        H   station                	long_name         STATION    units         unspecified    C_format      %s        ( L   cast               	long_name         CAST   units         unspecified    C_format      %s        ( t@       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              @:Z@:ҜwkQ@:@:m\@:Ft@:cA \@:x@: ѷ@:)^@:Y|@:]cA@:>@:L/{J@:VϪ@:7Kƨ@:74@:M@:qA [@:d`d@:Sa@O@:*>B@9$xG@9S@9a4J@8Ʌoi@8G
=p@7u%F
@7Ov_خ@7x}H@7Mj@6{xF]@6Z1@5*0@5{jf@4(@4tj@3t@3g	l@3s@3mڹZ@3-M:@2:)z@2`A7L@2PIQ@18}H@1@1_o@1z)y@1Bs@1҈p;@0u%F@0wkP@0|Z@0]\@0@oiDg8@0"C,@/R@/Z@/t!-w2@/LL_@/+Q@.
(@.0
)@.b}@.|j~#@.k:)z@.Ov`@.{m@.:S@.`-
@.$M:@-,@-@N@- ě@-lC@-Z@-|PH@-Q4J@-,C@-L_@-@,hr @,	ԕ+@,حV@,?@,Ƨ-@,@,~"@,xbM@,jW'@,WsPH@,M:@,De@,6Fs@,-@,"74@,S&@,&@+kP|@+	 @+ؓtj@+@+Ȍ@+qu!@+g	l@+x@+qj@+[@+2a|@+
=q@+]cA@+
M;@+@+@+9Xb@+\(@+eO@+{W>6z@+~u@+~u@+z~@+zC\@+zu%F@+wKƧ@+k6z@+`d8@+U?|h@+H˒:*@+Hu%F@+AGz@+;m]@+?䎊r@+I*0U2a@+=ce@+68YJ@+,>B[@+#\N@+#S&@+"\(@+Ft@+1&@+lC@+C\@+4֡b@+1@+ ě@+xF]@+҈@+!R<@+	Q@+$/@+A [@+'R@+ 	k@*Z@*)_@*[@*Z@*#x@*Q@*ݘ@*@*+jg@*D@**0@*sh@*ݗ+k@*SMj@*@*3@*Xe,@*֡a@*_p@*@*{@*+jg@*}H@+\(@+U=@+
g	@*v@*}Vl@*Xe@*!.I@*&@*	k~@*+j@+$/@+.H@*Ov_خ@*)y@*}H@*+J@*L_@*Ʌoi@*@*tj~@*4J@*H@*	 @*@*X@*@N@*{m@*{m@*䎊@*N;6@*@*I^5?@*ᰉ'@*C@*As@*Q@*)^	@*jf@*]cA@*C%@*0U2a|@*C,z@*q@*jOv@*힃%@*@*<쿱@*q@*jf@*jf@*Q@*<쿱@*VϪ@*<쿱@*>B[@*jOv@*w1@*\(@*䎊@*m\@*\(@*C-@*E@*?|h@*?|h@**0@*Ʌoi@*֡a@*?|h@*!R@*Ϫ͞@*!.@*4K@*_ح@*Fs@*}Vl@*C-@*1@*@*73@*)@*m]@+ u!@+wkQ@+7@+\N@+@+o h@+JM@+&@+@+C%@+
(@+t@+ᰊ@+PH@+ݗ+k@+N;5@+l@+ ě@+sg@+%F
L@+-V@+iB@+N;6@+oiDg8@+-
q@+-V@+a@O@+䎊@+<쿱@+]cf@+S@+o h@+s@+
Ov`@+
=p@+73@+)_@+>BZ@+
=p@+@N@+s@+$xG@+M:@+%1@+C,@+o@+e@+&IR@+7@+y@+	Dg8~@+	lD@+'/@+:)z@+/{J#@+_@+@+
(@+
hr!@+
U=@+
@+
(@+_o @+!R<@+c	@+O;@+ߤ?@+Mj@+v@+\(@+v_ح@+r@+-
q@+
=q@+@+o@+-@+s@+ݗ+k@+\(@+%F
L@+֡a@+tj~@+S&@+u@+䎊@+PH@+&x@+oiDg8@+.2@+	k@+&I@+@+
L/@+}Vm@+\(@+&IR@+7Kƨ@+$@+tj@+y@+\)@+C%@+
qu"@+
qu"@+qi@+As@+c	@+ߤ?@+r@+|@+䎊@+Mj@+Y|@+4m@++@+kP@+sPH@+}Vl@+_ح@+R<6@+ᰉ@+!R@+Ʌoi@+ݗ+k@+ݗ+k@+Z@+nO@+$tT@+ hۋ@+T@+C@+
d7@+&@+)^@+Fs@+x@+A@+]cf@+&I@+YJ@+O
@+@+wkQ@+Zc@+e@+s@+I^5@+I^5@+S&@+?@+tSM@+qj@+qj@+@+$/@+@+1@+zxl"h@+o i@+Z1@+`A@+s@+ IQ@*;dZ@*+j@*N;@*>B@*+@*3@*$tS@*ᰉ@*Mj@*䎊q@*4J@*v_ح@*_o @*I^5?@*L_@*)^	@*K]c@*zH@*1.@*F
L0@*JM@*
=p@*⩓@*n@*o@*m\@*
(@*ݿH˒@*ݥv@*ce@*j~#@*c	@*_o@*ؠ-
@*ᰉ@*J@*|@*ө*0U2@*ӎMj@*|@*ө*0U2@*D@*͑hr!@*̋C@*L_@*1&y@*Ƨ@*C%@*n@*ᰉ'@*ɭB@*x@*˒:*@*$xG@*-@*_o@*x@*ƀIQ@*@*Q@**0@*Z1@*\N@*F]c@*nP@*,zxl@*{J#9@*Õ$@*S@* ѷ@*I^5@*@*C@*o@*m\@*($x@*1&@*64@*n.@*$@*qu!@*(@*-
@*@**0@*YJ@*l"h	@*+@*
=p@*ȴ9X@*af@*Fs@*z@*_ح@*Ov_@*ᰉ@*Ϫ͞@*$/@*%F
L@*j~@*|@*@N@*m@*S&@*GE85@*o@*{@*@*'/W@*2X@*Vu@*!R<@*@*B@*q@*s@*҈@*:)z@*Q@*U=@*q@*C%@*0
@*B@*eO@*1&x@*eO@*eO@*K]c@*lC@*$/@*o h@*S@*9@*9@*,zxl@*@4@*'R@*ae@*:S@*C@*-
@*     @*vȴ9@*b}V@*|hs@*$tS@*|hs@*.H@*@*6z@*iB@*Ov_خ@*Ov_خ@*5?|@* ѷY@*E@*v@*}H@*p
=@*IQ@*/w@*/w@*!.H@*hr@*wkP@*64@*n.@*n.@*$@*ߤ@@*lC@*5Xy@*C,zx@*}H@*b@*5?|@*5?|@*
(@*H˒@*[@*S@*u%F@*+@*+@*#w@*~($@*1'@*Q_@*Q_@*#w@*YJ@*bM@*&@*$tS@*z@*8YJ@*E@*!.@*Xy=@*sg@*j~@*a@O@**0U2@*@N@*MjO@*sP@*䎊q@*<64@*ᰊ@*u@*@*rGE9@*iDg8@*2X@*C\@*w1@*:@*@*Ƨ@*I^@*n@*fB@*n@*y@*rGE@*@*Xy=@*/V@*_o@*A@*oiDg@*zxl"h@*JM@**0@*2W@*$@*`A@*h	ԕ@*&IR@*s@*C@*u!@*'RT`@*حV@*Ft@*~҈p;@*~$t@*~u@*}H˒@*}p
=@*}/w@*|>@*|u"@*|?@*|C,zx@*{s@*z~@*z~@*{u%@*z)_@*zQ_@*y>BZ@*y"`@*y"`@*y>BZ@*xe+@*x73@*xbM@*x*0@*xF]d@*w@*w4m@*wsPH@*wkP@*w1@*vȴ9X@*v+jg@*vOv_@*uᰉ@*u=K@*uY|@*tZ@*tzG@*sa@O@*sߤ@*s&@*s33333@*s33333@*s33333@*rsP@*qiB@*qX@*qX@*rs@*q-@*qR@*qR@*qR@*qR@*qu@*qhr @*pD@*p
=q@*p{@*p{@*p-
q@*oo @*o{J#:@*oO
M@*ov@*n+@*n}Vl@*mC\@*m%@*m
qv@*nzG@*n.2@*nVu@*nc	@*nc	@*nH@*n;5X@*n_o @*mU=@*m\@*mqu"@*l_@*lcA \@*l/{J#@*lI^5?@*lq@*lq@*l/{J#@*l1&y@*lL_@*l"h	ԕ@*l/{J#@*kƧ@*kxF]@*k'/@*jfB@*jg	@*jqiC@*j0U2a|@*jOv`@*jOv`@*ilD@*i@*iԕ*@*ioiD@*i^@*i^@*iDg8~@*h\)@*hXy=@*g#@*g@@*g/V@*gy@*glC@*gRT`e@*g@*fYJ@*e1@*e`A7L@*eS&@*eu@*e84֡@*e+a@*eu@*e+a@*eu@*d*0@*dqj@*d2W@*dxF@*c@*ca@N@*cF]c@*cnP@*b74@*b`A@*be+@*a@*ao@*a@*a@*an.@*`ěT@*`6@*`     @*_Ft@*^ߤ?@*^ߤ?@*^6z@*^vȴ9X@*^vȴ9X@*^iB@*^5?|@*^u@*]v@*][@*\쿱[@*\j~#@*\ߤ@@*[m]@*[A@*[q@*[qu!@*[J#9@*Z~@*ZkP|@*Y"`@*YD@*YrGE8@*X4֡b@*XbM@*W&@*WO;d@*WKƧ@*V@*V+J@*VOv_@*U?@*UϪ͞@*U\(@*UXy=@*U!R@*Usg@*U!R@*UY|@*U*0@*T#@*T9XbN@*T!-w2@*T@*SE@*SZ@*S33333@*R<64@*R ě@*R ě@*R{m@*RGE85@*R䎊@*Q-@*QR@*QiB@*QN;6@*Q@*Q[W>6@*QN;5@*Q_p@*Q@*Q@*Q&x@*Q_p@*P$tT@*P$tT@*P`A7@*P`A7@*PD@*P
(@*P'RT@*PoiDg8@*P*0U@*Oo @*Or@*Or@*O͞@*O@*O'/W@*NMj@*O hۋ@*O
M;@*N}Vl@*N}Vl@*Nt@*N+@*NMj@*O
M;@*N1@*NVu@*N_o @*M@*M5Xy>@*L@*Lzxl"@*L_@*LI^5?@*L"h	ԕ@*Ks@*Ka@@*K~($@*Kq@*KQ@*Kjf@*KC,z@*JD@*Jg	@*JW'@*J#9@*I^5?}@*IoiD@*I@*IoiD@*Ix@*Ix@*IDg8~@*Hu%F@*H>BZc@*G@@*G@@*GK]d@*GK]d@*GK]d@*GfA@*G@@*H	ԕ+@*G#@*Gݗ+@*Gݗ+@*G&@*G&@*GlC@*GRT`e@*GE84@*G,@*Fx@*FA@*F@*FL/{J@*F?@*FL/{J@*F1.@*F1.@*F1.@*F1.@*F?@*F$/@*F@*EoiDg@*En/@*EO
@*Em\@*EQ@*DS@*DTɆ@*Dqj@*Dqj@*DS@*Do h@*Dg8}@*DM:@*D?@*D%1@*C\N@*CA [@*C
=p@*C
=p@*C@*C{J#9@*CF]c@*CS@*CF]c@*CF]c@*C9@*C,zxl@*C,zxl@*C	@*BC,@*B}Vm@*B@*B}Vm@*B@*B@*B@*B@4@*BZc@*BZc@*Bh	ԕ@*Bu%F
@*Bh	ԕ@*B&IR@*A.H@*As@*Ao@*Ao@*A@*Ao@*A@*Ao hی@*Aae@*A:S@*A [7@*A@N@*A-w1@*A [7@*@҈p@*@҈p@*@C@*A$/@*A@N@*A@N@*A [7@*ATɅo@*Aae@*AGz@*A:S@*A:S@*ATɅo@*ATɅo@*AGz@*A:S@*A:S@*A-w1@*A$/@*@	k@*@҈p@*@C@*@C@*@	k@*@	k@*@	k@*@C@*@4m@*@d8@*@d8@*@IQ@*@-
@*@NU@*@6@*@6@*?䎊r@*@     @*@     @*@
qu@*@     @*@
qu@*@
qu@*@
qu@*@6@*@6@*@'RT`@*@4m9@*@A7K@*@4m9@*@4m9@*@A7K@*@A7K@*@NU@*@NU@*@[6@*@NU@*@A7K@*@A7K@*@NU@*@NU@*@A7K@*@'RT`@*?@*?حV@*?حV@*?˒:)@*?˒:)@*?حV@*?vȴ9@*?[W>@*??@*?[W>@*?˒:)@*?˒:)@*?˒:)@*?˒:)@*?vȴ9@*?[W>@*?vȴ9@*?vȴ9@*?vȴ9@*??@*?$tS@*??@*??@*?˒:)@*?˒:)@*?vȴ9@*?vȴ9@*?˒:)@*?˒:)@*?˒:)@*?˒:)@*?[W>@*?vȴ9@*?vȴ9@*?حV@*?䎊r@*@
qu@*@
qu@*@
qu@*@     @*@     @*?䎊r@*?䎊r@*?䎊r@*@     @*@     @*?䎊r@*?@*?@*?䎊r@*@     @*@     @*@     @*@     @*@     @*@
qu@*@'RT`@*@4m9@*@'RT`@*@4m9@*@A7K@*@4m9@*@4m9@*@4m9@*@4m9@*@A7K@*@4m9@*@A7K@*@A7K@*@[6@*@u!@*@-
@*@IQ@*@IQ@*@d8@*@d8@*@4m@*@ěT@*@ěT@*@4m@*@ěT@*@ѷX@*@҈p@*@	k@*A$/@*A@N@*A$/@*A$/@*A@N@*A-w1@*A:S@*AGz@*ATɅo@*Aae@*A|Q@*A|Q@*A7Kƨ@*AR<6@*AR<6@*An.@*A'R@*A'R@*A'R@*A@*Ao@*Ao@*A@*Ae@*As@*A.H@*BI^5@*Be+@*B&IR@*B3@*B@4n@*B@4n@*BZc@*BZc@*BM@*BZc@*BZc@*Bh	ԕ@*Bh	ԕ@*Bu%F
@*Bu%F
@*Bu%F
@*B@4@*B\(@*BwkQ@*B@*B}Vm@*B`A@*B`A@*B ѷ@*B ѷ@*B74@*BC,@*B74@*BC,@*B74@*CS&@*CS&@*CS&@*CS&@*CS&@*CS&@*CnP@*C,zxl@*C,zxl@*C9@*CF]c@*CS@*Ca@N@*Ca@N@*Cn.3@*Cn.3@*Cn.3@*C{J#9@*CeO@*CeO@*C{J#9@*C$@*C$@*C@*C@*C
=p@*CA [@*D%1@*D2W@*DM:@*DZ1@*Dg8}@*DtSM@*Do h@*Do h@*Do h@*Do h@*DS@*DS@*DS@*DTɆ@*DTɆ@*DS@*Dqj@*DTɆ@*DTɆ@*D7@*D*0@*D/@*Eo i@*EF
L0@*E`A7L@*E`A7L@*E`A7L@*Eݗ@*E@*E@*E8YK@*E@*E@*En/@*E1@*E1@*En/@*En/@*En/@*En/@*E@*E8YK@*E8YK@*E8YK@*ES@*Eڹ@*F
L/@*F@*F@*F@*F1.@*F?@*FYJ@*FIQ@*F@*F-@*F-@*F'@*F'@*FA@*FA@*F]cf@*Fx@*Fx@*Fx@*Fx@*Fx@*G@*G,@*G)^@*G,@*G+I@*G,@*G8}H@*G+I@*GRT`e@*G_o@*GlC@*G&@*Gݗ+@*G	k@*G/V@*G/V@*GK]d@*GK]d@*GzH@*G/V@*G@@*H@*H1&x@*H@*H@*H$xG@*H@*H>BZc@*HK]c@*Hr Ĝ@*H˒:*@*Hu%F@*Hu%F@*HTɅ@*Hp:@*H@*H\)@*H@*H@*H\)@*H\)@*I ѷ@*I ѷ@*I ѷ@*I ѷ@*H@*H\)@*H\)@*H@*H\)@*H\)@*I ѷ@*I ѷ@*I@*I7KƧ@*I*0U2a@*I7KƧ@*IDg8~@*Ik~(@*Ix@*Ix@*I@*IB@*I'RTa@*IB@*I^5?}@*Iy@*Iԕ*@*Iᰉ'@*I@*IlD@*J	 @*J	 @*IlD@*IlD@*IlD@*JOv`@*JOv`@*J#9@*JJL@*Jd7@*JqiC@*J~"@*JL_@*JL_@*J0
@*Jn@*Jg	@*Jn@*J͞&@*Jn@*Jn@*Jn@*J͞&@*JڹY@*Jn@*J͞&@*J͞&@*Jn@*Jn@*J͞&@*JfB@*J͞&@*J͞&@*JfB@*JfB@*JfB@*JD@*KI^@*KC,z@*K6z@*KC%@*K]cA@*K]cA@*Kjf@*KQ@*K:)z@*KU=@*K~($@*KƧ@*KƧ@*Ka@@*K҈@*KC]@*KC]@*Ks@*L1&y@*LL_@*L"h	ԕ@*LL_@*L/{J#@*LVϪ@*LVϪ@*LcA \@*Lq@*Lq@*LC@*Lzxl"@*L@*L@*Lzxl"@*L@*L[W?@*L@*L>B[@*L@*M:@*MV@*Mqu"@*Mqu"@*M(@*M(@*M5Xy>@*MO;dZ@*M\@*Mw1@*Mw1@*Mhr!@*Mhr!@*MU=@*M8Y@*M
qv@*M
qv@*M(@*M(@*N_o @*N!R<@*N!R<@*N!R<@*N.2@*NH@*NH@*Nc	@*Nc	@*Nc	@*N}Vl@*Nqi@*NT@*Nߤ?@*Nt@*Nt@*N+@*Nt@*N+@*NMj@*O hۋ@*O
M;@*O4֡a@*OAs@*O\(@*OiDg8@*Ov_ح@*O{J#:@*O-V@*O͞@*O͞@*Or@*Oo @*O;dZ@*OVϫ@*OrGE9@*P@*P*0U@*P ě@*P:~ @*P:~ @*PH@*PU2a|@*PbM@*P|@*P|@*P'RT@*P'RT@*P@*P
=q@*P{@*P
(@*P)^@*P`A7@*P{@*P$tT@*Q@*Q&x@*Q4J@*QA [@*QA [@*QA [@*QN;5@*Qhr @*Qu!S@*Q@*Qo@*Qu@*QX@*Q2W@*Q2W@*QN;6@*QR@*QR@*Q-@*Rn@*Q-@*Rs@*R䎊@*R-V@*R:)y@*RGE85@*RT`d@*RnO@*Ra|Q@*Ra|Q@*R{m@*R{m@*R{m@*Rp:@*Rᰊ@*RS&@*R ě@*R ě@*RsP@*Rm@*Rm@*Rm\@*S҉@*SPH@*S&@*S@N@*SMjO@*SMjO@*Sg	l@*Sg	l@*S@*SMj@*Sߤ@*S*0U2@*Sa@O@*Sa@O@*Sݗ+k@*S@*T@*T@*T,<@*T9XbN@*TFs@*TSMj@*Tm8@*TzG@*T#@*T*1@*TO
M@*TO
M@*TɅoi@*T֡a@*TD@*U'0@*U*0@*U%F
L@*U?|h@*UL_@*UfA@*U$/@*U!R@*U=K@*UXy=@*U\(@*U?@*Uᰉ@*Vt@*V4K@*VOv_@*V+jg@*VE@*VE@*Vz@*Vz@*Vz@*V+J@*Vaf@*V}Vl@*Vȴ9X@*VC-@*V@*V!.I@*WXe@*WXe@*W$tS@*W1@*W>6z@*WXe,@*WsPH@*W4m@*WO;d@*W&@*W@*W+@*WrG@*WrG@*W+j@*XbM@*X}H@*X*0@*X73@*XD*@*X_F@*X_F@*Xl"h	@*Xy=c@*Xtj@*Xtj@*Xtj@*X-
@*XU@*X@@*XF@*X4֡b@*XPH@*Y	k~@*Y0
)@*Y=b@*YXbM@*Ye+a@*YXbM@*Ye+a@*Yb}@*Yb}@*Yb}@*Y@*YD@*YD@*Y_o@*Y>BZ@*Y"`@*Y"`@*Y>BZ@*YY}@*Zu%F@*Z1'@*Z6C@*ZC\@*Z^5?|@*ZkP|@*Zݘ@*ZS&@*Z>B@*Z)_@*Z,<@*Zc	@*[u%@*[s@*["`B@*[=K^@*[W>6z@*[qu!@*[~$@*[A@*[m]@*[6@*[Q@*[lC@*\n.@*\Q@*\(\@*\C,zx@*\]ce@*\j~#@*\?@*\N;@*\1&@*\?@*\u"@*\>@*]K]@*]!.H@*]<64@*]IQ@*]Vl!@*]p
=@*]}H@*]H˒                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @B٠'RTa@BZ@Bs@B齥@B6C@B@4@BY@Bs@Bs@BPH@C ě@C)_@Ct@C"@Cv@C@CH@Czxl"h@C!.H@C(\@C-@CoiDg8@C	@CQ@Cd8@Cvȴ9X@C҈p;@Cy@Cd8@CYJ@Cr@C
/w@C@Cg8}@Cߤ?@CIQ@CxF]@C
ᰊ@C
Q_@CJ@C$tS@Cݗ+@CW@CC%@CɅoi@C֡a@C@C\(@C'0@Cqu"@Csg@CSMj@C`A@Cԕ*@C\)@CrGE9@C\N<@C5Xy>@CZ@C%2@Cn.3@C@CW>6z@CJ@Ctj@C
M;@C9@C>6z@C!|@C!~($@C {@C!@C"n@C!e+a@C!XbM@C"n@C#9@C"͞&@C" ѷ@C#,zxl@C#q@C$<쿱@C$<쿱@C$9XbN@C$@C#$@C$Fs@C$cA \@C$q@C$O
M@C$hr@C$@C$S@C$/@C%[@C%+a@C%m\@C%v@C%Xy=@C&($x@C&c	@C&u@C%cA @C%U=@C%S@C%\(@C&Ov_خ@C&t@C&@C'E84@C'KƧ@C($xG@C(:~ @C)^@C)'RTa@C)iB@C*d7@C*d7@C+nP@C+U=@C,!-w2@C,]ce@C,@C-F
L0@C,hr@C,?@C,,<@C+Ƨ@C,/{J#@C,@C,<쿱@C,?@C-E@C-ڹZ@C-Ϫ͞@C-\(@C-Ϫ͞@C-Ϫ͞@C-@C--V@C-H˒@C-n/@C-H˒@C-(@C.
L/@C.L/{J@C.vȴ9X@C.x@C/O
M@C/lC@C/o@C/kP@C/@C0F]d@C/+@C/K]d@C0	ԕ+@C0>BZc@C0YJ@C0-
@C0u%F@C0)@C0ěT@C0p:@C0҈p@C0{@C1-w1@C1b}@C1u!S@C17Kƨ@C1@C1.H@C2s@C2䎊@C2M@C2 ѷ@C3@C4g8}@C5p
=@C5zxl"h@C4>@C4Ʌoi@C4@C55Xy>@C5fA@C5@C6+J@C7!-w1@C7U=@C7E84@C7RT`e@C7lC@C7|hs@C7͞@C7K]d@C7rG@C8}H@C8*0@C8NU@C8>BZc@C8d8@C9=b@C9rGE8@C9o@C9D@C9@C9Y}@C:e+@C9lD@C:@C:\(@C:,<@C:ڹY@C;nP@C;/V@C;33333@C;/V@C;a@N@C;:)z@C;Ƨ@C;$@C<Q@C<<쿱@C<?@C<<쿱@C<j~#@C<o h@C<qj@C<TɆ@C<j~@C<j~@C<>B[@C=K]@C=o i@C=}H@C=(@C>1.@C>t@C? hۋ@C?,@C?4֡a@C?U=@C?iDg8@C?O;d@C?o @C@@C@D*@C@hۋq@C@˒:*@C@IQ@C@TɅ@C@ѷX@C@D@C@C@CA+@CAhr @CAoiD@CAR<6@CAlD@CB\(@CBW@CC҉@CCs@CC"`B@CC=K^@CCP{@CCA@CC5Xy@CD!-w2@CDZ1@CD_@CE:@CE*0@CE5Xy>@CE*0@CE<64@CEp
=@CE8YK@CE
qv@CE@CE@CE8YK@CE8YK@CE
qv@CFzG@CF1.@CF$/@CEE@CEn/@CEv@CEXy=@CE8YK@CF($x@CG
M;@CG$tS@CG\(@CG_o@CGRT`e@CG;dZ@CFMj@CFA@CFQ@CF2X@CF}Vl@CF'@CFQ@CFm\@CGXe@CGsPH@CG&@CGvȴ9@CG#@CH6@CH:~ @CHNU@CH_F@CHn@CH@CH-
@CH
=q@CH
=q@CHU@CHU@CH4m@CH
(@CHěT@CH)^@CHѷX@CHѷX@CHF@CHۋq
@CH{@CI_p@CI&x@CI=b@CIJE@CIQ@CI@CI_o@CIo@CIo@CI@CI_o@CI2W@CIe@CIY}@CIᰉ'@CI@CI'R@CI^@CI[W>6@CI@CIk~(@CIA [@CIA [@CIGz@CIJE@CI@CIo@CI"`@CIs@CJ)y@CJT`d@CJT`d@CJu%F
@CJ@4@CJ~"@CJL_@CJS&@CJn@CJm@CKnP@CK=K^@CKdZ@CKg	l@CKjf@CKg	l@CKa@N@CK]cA@CK]cA@CKZ@CKS@CKJ#9@CK@N@CKC%@CK=K^@CK/V@CK"`B@CKnP@CK҉@CJD@CJ ѷ@CJ)_@CJ<64@CJY@CJY@CJ}Vm@CJ}Vm@CJ ě@CJ>B@CJS&@CJS&@CJp:@CJ@4@CJ@4@CJ@4@CJ@4@CJ@4@CJwkQ@CJ}Vm@CJn@CJ<64@CJ<64@CJڹY@CJ䎊q@CJG{@CJG{@CJ ѷ@CJsP@CJ͞&@CJY@CJ ě@CJvȴ@CJ\(@CJ~"@CJh	ԕ@CJT`d@CJ=p
@CJ-V@CJ#9@CJ@CI-@CI@CIԕ*@CID@CI'R@CIu@CI@CI@CIe+a@CIXbM@CIA [@CI7KƧ@CI0
)@CI [7@CIrGE@CH	k@CH4֡b@CH@CHe+@CH҈p@CHۋq
@CHF@CH@@CH4m@CH@CH-
@CHr Ĝ@CHXy=@CHNU@CHNU@CHK]c@CHK]c@CHH@CH}H@CG#@CG-@CG@CG@CG@CGfA@CG+@CGo @CGo @CGo @CG/V@CGr@CG3@CG͞@CG?@CG-V@CG$tS@CG	@CG&@CG4m@CG|hs@CGv_ح@CGsPH@CGv_ح@CG4m@CG{J#:@CG|hs@CGv_ح@CGo@CGo@CGb}V@CGU=@CGKƧ@CGE84@CG1@CG'/W@CG!-w1@CG'/W@CGv@CG@CF"@CF@CF"@CF!.I@CF"@CF@CF1@CF1@CFC-@CFߤ?@CF]cf@CF]cf@CFϪ͟@CF+@CF҈p;@CFt@CFȴ9X@CFm\@CFQ@CF'@CF}Vl@CF}Vl@CFT@CF,<@CFFs@CFqi@CFIQ@CFz@CFvȴ9X@CFs@CFl!-@CFfffff@CF_ح@CFYJ@CFR<6@CFR<6@CFOv_خ@CFL/{J@CFL/{J@CFE@CF?@CF5?|@CF$/@CF!R<@CF+jg@CF+jg@CF($x@CFOv_@CF
L/@CE!.@CE,=@CES@CES@CE?@CE8YK@CEcA @CE@CE\(@CEn/@CE@CE1@CEU=@CEXy=@CEXy=@CEv@CEXy=@CE@CE%@CE+j@CEO
@CEhr!@CEhr!@CEhr!@CEڹZ@CEݗ@CEݗ@CEݗ@CE$/@CE$/@CE}H@CE}H@CEzxl"h@CEsg@CEsg@CEm\@CEjOv@CEjOv@CEjOv@CEjOv@CEjOv@CEce@CEp
=@CEڹZ@CE!R@CEO
@CEO
@CEhr!@CE!R@CEM:@CEjOv@CEVl!@CEF
L0@CEB@CEB@CES&@CE`A7L@CEce@CEce@CES&@CEL_@CEIQ@CE?|h@CE<64@CE2a|@CE/w@CE/w@CE+a@CE!.H@CEQ@CE[@CEK]@CEo i@CDE@CDE@CDe@CDe@CD!-w@CDD@CDZ@CDZ@CD*0@CD?@CD#x@CDO
M@CDTɆ@CDzxl"@CDS@CDN;@CD?@CD~($x@CD~($x@CDzG@CDm8@CD`d@CDZ1@CDSMj@CDFs@CDC,zx@CD64@CD,<@CD"h	ԕ@CDtj@CDtj@CDߤ@@CDn.@CC@CCA [@CCg@CClC@CCa@@CC5Xy@CC5Xy@CCƧ@CC~($@CCm]@CC@CC*0U2@CCwk@CCߤ@CC$@CC$@CCMj@CCMj@CCQ@CC~$@CCxF]@CCqu!@CCtj~@CCn.3@CCg	l@CCdZ@CCg	l@CCjf@CCg	l@CC]cA@CCS@CCMjO@CCMjO@CCMjO@CCF]c@CCC%@CC@N@CCC%@CC=K^@CC6z@CC/V@CC,zxl@CC&@CC"`B@CCC,z@CCnP@CC҉@CCI^@CBm\@CB74@CBD@CBm@CBm@CBC,@CB ѷ@CBڹY@CBڹY@CB ѷ@CBڹY@CBsP@CBsP@CB,<@CB`A@CB`A@CBW@CBn@CBn@CB<64@CBY@CB}Vm@CB ě@CB@CBL/{@CBS&@CBwkQ@CBS&@CB\(@CBp:@CBL_@CBL_@CB\(@CB\(@CBL_@CBL_@CB\(@CBp:@CB@4@CB~"@CBxl"h
@CBu%F
@CBqiC@CBh	ԕ@CBd7@CBd7@CBd7@CBh	ԕ@CB^5?|@CBZc@CB^5?|@CBZc@CBa|Q@CBW'@CBT`d@CBM@CBJL@CBJL@CB@4n@CB@4n@CB:)y@CB:)y@CB:)y@CB6C@CB3@CB0U2a|@CB-V@CB)y@CB&IR@CB&IR@CBe+@CBOv`@CB@CBI^5@CB	 @CB	 @CBu%F@CAlD@CAY}@CAR@CAe@CAe@CAiB@CAiB@CAiB@CA@CA@CA@CAԕ*@CA_o@CA2W@CAD@CA@CA^5?}@CA|@CA|@CAB@CA(@CAn.@CA@CA@CA@CAR<6@CA@CA7Kƨ@CA|Q@CAx@CAk~(@CAe+a@CAhr @CAae@CAae@CA^@CA^@CAXbM@CAXbM@CAN;5@CAGz@CAA [@CA=b@CA4J@CA-w1@CA*0U2a@CA0
)@CA&x@CA&x@CA [7@CA@N@CA@CA	k~@CA$/@C@$tT@C@C@C@@C@`A7@C@e+@C@D@C@ѷX@C@p:@C@@@C@@@C@TɅ@C@TɅ@C@
(@C@)@C@)@C@4m@C@U@C@@C@
=q@C@-
@C@-
@C@@C@tj@C@-
@C@YJ@C@YJ@C@YJ@C@n@C@|@C@y=c@C@u!@C@u!@C@r Ĝ@C@oiDg8@C@l"h	@C@eO@C@eO@C@_F@C@_F@C@[6@C@[6@C@[6@C@[6@C@Xy=@C@Xy=@C@Xy=@C@U2a|@C@Q@C@K]c@C@K]c@C@D*@C@>BZc@C@>BZc@C@:~ @C@:~ @C@73@C@-
q@C@*0@C@*0@C@*0@C@$xG@C@$xG@C@'RT`@C@*0@C@'RT`@C@'RT`@C@$xG@C@}H@C@@C@@C@	ԕ+@C@@C@F]d@C@     @C?rGE9@C?+j@C?+j@C?-@C?-@C?rG@C?@C?@@C?;dZ@C?@C?fA@C?fA@C?+@C?K]d@C?@C?@C?vȴ9@C?vȴ9@C?/V@C?[W>@C?͞@C?&@C?-V@C?-V@C?-V@C?-V@C?kP@C?kP@C?kP@C?$tS@C?$tS@C?ݗ+@C?O;d@C?O;d@C?	@C?	@C?&@C?O;d@C?4m@C?|hs@C?|hs@C?v_ح@C?sPH@C?o@C?sPH@C?o@C?iDg8@C?lC@C?lC@C?lC@C?iDg8@C?eں@C?b}V@C?_o@C?\(@C?Xe,@C?U=@C?O
M@C?KƧ@C?KƧ@C?H˒:@C?E84@C?E84@C?As@C?>6z@C?>6z@C?>6z@C?4֡a@C?4֡a@C?1@C?1@C?1@C?+I@C?+I@C?$tS@C?'/W@C?$tS@C?$tS@C?!-w1@C?!-w1@C?,@C?v@C?Xe@C?Xe@C?@C?@C?)^@C?)^@C?
=p@C?
=p@C?
M;@C?
=p@C?Ft@C?@C?Ft@C? hۋ@C>!.I@C>Fs@C>"@C>"@C>Fs@C>Fs@C>Mj@C>@C>쿱[W@C>x@C>1@C>1@C>x@C>1@C>C-@C>C-@C>C-@C>ߤ?@C>C-@C>ߤ?@C>ߤ?@C>C-@C>ߤ?@C>]cf@C>]cf@C>+@C>+@C>+@C>Ϫ͟@C>+@C>҈p;@C>҈p;@C>҈p;@C>A@C>t@C>A@C>t@C>A@C>ȴ9X@C>ȴ9X@C>m\@C>m\@C>&I@C>&I@C>ߤ?@C>@C>Q@C>'@C>'@C>2X@C>2X@C>'@C>'@C>2X@C>2X@C>2X@C>2X@C>}Vl@C>2X@C>}Vl@C>}Vl@C>}Vl@C>6z@C>6z@C>6z@C>6z@C>6z@C>T@C>-@C>T@C>T@C>-@C>T@C>af@C>af@C>@C>@C>,<@C>,<@C>,<@C>Fs@C>O;@C>Fs@C>Fs@C>Fs@C>$t@C>$t@C>$t@C>$t@C>@C>$t@C>$t@C>@C>@C>qi@C>qi@C>+J@C>qi@C>+J@C>+J@C>+J@C>+J@C>+J@C>+J@C>+J@C>%@C>%@C>%@C>%@C>IQ@C>IQ@C>IQ@C>%@C>IQ@C>IQ@C>IQ@C>}Vl@C>}Vl@C>}Vl@C>z@C>z@C>}Vl@C>}Vl@C>vȴ9X@C>z@C>vȴ9X@C>z@C>vȴ9X@C>vȴ9X@C>vȴ9X@C>z@C>vȴ9X@C>vȴ9X@C>s@C>s@C>vȴ9X@C>s@C>s@C>s@C>s@C>s@C>p:~@C>l!-@C>p:~@C>p:~@C>s@C>p:~@C>p:~@C>p:~@C>p:~@C>s@C>p:~@C>p:~@C>p:~@C>p:~@C>p:~@C>p:~@C>l!-@C>l!-@C>l!-@C>l!-@C>l!-@C>l!-@C>p:~@C>l!-@C>l!-@C>l!-@C>l!-@C>l!-@C>l!-@C>iB@C>iB@C>fffff@C>iB@C>iB@C>iB@C>iB@C>iB@C>iB@C>iB@C>iB@C>iB@C>fffff@C>iB@C>iB@C>iB@C>iB@C>iB@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>iB@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>fffff@C>c	@C>fffff@C>c	@C>c	@C>c	@C>c	@C>c	@C>c	@C>c	@C>c	@C>c	@C>c	@C>c	@C>_ح@C>c	@C>c	@C>_ح@C>_ح@C>\N<@C>_ح@C>_ح@C>\N<@C>_ح@C>_ح@C>\N<@C>\N<@C>_ح@C>\N<@C>_ح@C>\N<@C>\N<@C>\N<@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>\N<@C>YJ@C>YJ@C>\N<@C>\N<@C>\N<@C>_ح@C>\N<@C>_ح@C>_ح@C>\N<@C>YJ@C>YJ@C>YJ@C>YJ@C>Vu@C>YJ@C>YJ@C>Vu@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>R<6@C>Vu@C>Vu@C>\N<@C>\N<@C>\N<@C>YJ@C>YJ@C>\N<@C>\N<@C>_ح@C>YJ@C>\N<@C>YJ@C>YJ@C>YJ@C>YJ@C>YJ@C>Vu@C>Vu@C>YJ@C>Vu@C>Vu@C>R<6@C>R<6@C>Vu@C>Vu@C>Vu@C>R<6@C>Vu@C>Vu@C>Vu@C>YJ@C>Vu@C>Vu@C>R<6@C>Vu@C>Vu@C>Vu@C>R<6@C>Vu@C>R<6@C>Vu@C>Vu@C>R<6@C>R<6@C>Ov_خ@C>R<6@C>R<6@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>L/{J@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>L/{J@C>L/{J@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>H@C>H@C>L/{J@C>L/{J@C>Ov_خ@C>Ov_خ@C>R<6@C>Ov_خ@C>L/{J@C>Ov_خ@C>H@C>Ov_خ@C>Ov_خ@C>L/{J@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>Ov_خ@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>H@C>E@C>E@C>E@C>H@C>E@C>BZc @C>BZc @C>E@C>BZc @C>BZc @C>E@C>E@C>BZc @C>BZc @C>?@C>BZc @C>BZc @C>BZc @C>BZc @C>E@C>BZc @C>BZc @C>BZc @C>BZc @C>?@C>?@C>BZc @C>?@C>?@C>;5X@C>;5X@C>;5X@C>;5X@C>;5X@C>;5X@C>?@C>?@C>;5X@C>;5X@C>;5X@C>?@C>?@C>?@C>;5X@C>;5X@C>;5X@C>;5X@C>;5X@C>;5X@C>8YJ@C>5?|@C>8YJ@C>8YJ@C>5?|@C>5?|@C>5?|@C>5?|@C>1.@C>.2@C>1.@C>.2@C>.2@C>.2@C>1.@C>.2@C>1.@C>1.@C>.2@C>.2@C>1.@C>.2@C>1.@C>.2@C>.2@C>1.@C>1.@C>1.@C>+jg@C>.2@C>.2@C>1.@C>.2@C>1.@C>.2@C>.2@C>.2@C>.2@C>.2@C>1.@C>.2@C>.2@C>1.@C>+jg@C>1.@C>.2@C>+jg@C>.2@C>.2@C>+jg@C>+jg@C>+jg@C>+jg@C>+jg@C>.2@C>+jg@C>+jg@C>+jg@C>($x@C>($x@C>($x@C>$/@C>($x@C>+jg@C>$/@C>($x@C>($x@C>+jg@C>$/@C>$/@C>($x@C>($x@C>$/@C>!R<@C>$/@C>($x@C>($x@C>$/@C>($x@C>Ov_@C>$/@C>$/@C>$/@C>$/@C>$/@C>$/@C>!R<@C>!R<@C>$/@C>$/@C>$/@C>!R<@C>!R<@C>!R<@C>Ov_@C>!R<@C>!R<@C>!R<@C>$/@C>$/@C>!R<@C>!R<@C>!R<@C>$/@C>!R<@C>!R<@C>!R<@C>!R<@C>!R<@C>!R<@C>Ov_@C>!R<@C>!R<@C>!R<@C>Ov_@C>Ov_@C>!R<@C>u@C>u@C>Ov_@C>Ov_@C>u@C>u@C>Ov_@C>u@C>u@C>u@C>u@C>u@C>u@C>u@C>Ov_@C>@C>@C>u@C>@C>@C>@C>zG@C>@C>u@C>@C>u@C>@C>@C>@C>@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>zG@C>4K@C>4K@C>4K@C>
(@C>4K@C>4K@C>4K@C>4K@C>
(@C>4K@C>4K@C>4K@C>
(@C>
(@C>
(@C>
(@C>4K@C>4K@C>
(@C>4K@C>
(@C>
(@C>4K@C>4K@C>4K@C>
(@C>
(@C>4K@C>4K@C>
(@C>
(@C>4K@C>4K@C>4K@C>zG@C>
(@C>
(@C>
(@C>4K@C>4K@C>
(@C>
(@C>4K@C>zG@C>4K@C>4K@C>4K@C>4K@C>4K@C>
(@C>4K@C>zG@C>4K@C>4K@C>4K@C>4K@C>zG@C>zG@C>4K@C>4K@C>
(@C>
(@C>
(@C>4K@C>4K@C>zG@C>zG@C>4K@C>zG@C>zG@C>zG@C>4K@C>zG@C>zG@C>4K@C>4K@C>4K@C>4K@C>zG@C>zG@C>zG@C>
(@C>zG@C>zG@C>4K@C>zG@C>zG@C>4K@C>4K@C>zG@C>4K@C>4K@C>4K@C>4K@C>
(@C>4K@C>4K@C>
(@C>4K@C>4K@C>
(@C>
(@C>4K@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>4K@C>
(@C>4K@C>
(@C>4K@C>4K@C>
(@C>4K@C>4K@C>
(@C>4K@C>
L/@C>
(@C>
(@C>
(@C>
(@C>
(@C>
L/@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>4K@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
L/@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>4K@C>4K@C>4K@C>4K@C>
L/                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @iE>6z@iY*0U2@ig=b@ipc	@iwQ@iP@@iR$/@ibۋq
@iORT`e@iF
L0@iR<6@i@il@i@i&x@iۋq
@in@iGE85@j-U=@j[;dZ@jȴ9X@k$tT@kZ@l3[W>6@l~"@mu%F@mwe+a@mg	l@nT1'@n:-V@n1s@nJM@nbM@oAs@p>+a@p4Vl!@pHJL@pq+a@p@pPH@pVϪ@p9@p$/@pjf@p'/W@p|@qMϪ͞@qd$tS@q7C-@qqiC@p
=q@pXbM@p9XbN@p;dZ@pO
M@p+jg@plC@p˒:)@pW>6z@p#9@pqiC@pI^5@p͞@pU[W?@pw1@pa@O@pS&@pN;5@pU=@p`_F@p/T@pG#9@pK:~ @p)iB@p +jg@oy{J#:@o1&@n+J@n@oC\@o2X@o*$tT@o3MjO@o@n?@nd1.@mt@mWحV@m<     @m%r@mC,@le+@lwE@l9ae@kv@kA [@k}3@kAC]@jqi@jD@jo@ke@k5=K^@kD|@k(1&@jְ ě@j@j}H@jZMj@jSs@jl74@j|9XbN@jvTɆ@j]U=@jl ѷ@jhr!@jbM@j?|h@jp{@j^ ѷ@jU@j@C\@j*_o @j,?@jkC%@jxl"h
@jТ3@jɪ͞@j|Q@jOv`@j8YK@j@j=b@j)@jl"h	@jԟvȴ@j
qv@js@jl!-@jOv_خ@j"h	ԕ@j!R<@j<쿱@j@@j)^	@j$xG@js@jئL/{@j_o@j;5X@ju@j|@jxl"h
@jJ@ju%F
@j-
@jY@jFs@jlD@jl!-@j
=q@j䎊@jzbM@jn{@ju@jsC,z@j7_o@j
[W>@jS&@jS&@j
@j
q@jS@j
*0U2@iA@i/@iN;@iߤ@@iڹZ@i_@i[W>6@iu%F
@iB@ic	@iE84@iiv@iZZ1@iLr Ĝ@iaF]c@iaE84@i=%F
L@i7O
@i;@i:W'@i0IQ@i@iPH@izG@i6@ifA@he@hS@h-@hPH@h3@h\N<@hа{@hޒS&@h@hQ@h64@hPH@hɲ-V@hhۋq@h%@hu!S@h¼j~@hd7@hm@h
M;@h@h#@hBZc @hv@hu%@h0
)@htj@h!-w1@hO
M@h@hlC@h4K@hsPH@h}:S@hzp:~@hia@O@h]As@h`J@hR䎊@hT`A7@hHcA \@hK*0U2a@htZ@htѷX@hd$/@hWn.@hE@h>-
@hFD@h@n.@h@ ѷY@hL˒:*@hKC,z@h>S@h(a|Q@h_o@hBZc @gB@gzG@g6@g$xG@g[W?@g=@gLfB@g?o i@g*.2@g@fD@fW@f)^@fu-V@fb+jg@fc!R@fvm\@f|@fr҈p;@fTC\@fMP{@fyD@f[W>@fwkP@f!-w1@fb@fv_ح@fju!@fg1@fB@ffA@fL_@f@foiDg8@fe+@f+A [@en.@e'/@e'/@eQ@fCڹZ@frTɅ@fhۋq@fĮ}Vl@f@f`A7@fف$/@fcA \@f@fIQ@f     @fT*0@fFFs@f;*0U2a@f46C@f0xF@f6PH@f?P{@f5+j@f)Xe@f TɅ@f33333@f TɅ@fv@f n@f2p:@f1jf@f$C,@fR@fᰊ@f$JM@f_o@f\(@f*1@fg@e[W>@e@e3@e?@e@eѓ@e.2@eYJ@eD@eռn/@eu%F@eܬ1&@e{@e{@eܪd8@ec	@eb}V@f`d@fE@e@fڹZ@f\(@f
B@eO;@e]cA@e^5?|@ePH@eTɅ@e@ezG@e|@eiB@em]@eT@ez@eA7K@eO
M@eO
M@e~1.@ex
=q@ee1@e[x@ee1@ebj~#@ei\(@el#9@ej[W?@emoiD@ejߤ?@ei[W>6@efFs@enx@es@N@etvȴ9X@e@ex-
@ezt@e4K@etj~@e!-w@eo@eMj@esPH@e\(@e-V@eH˒:@ee@e{e+a@ex@e%2@e$tT@e%2@equ!@ec	@e$tT@eߤ@e{ce@exwkQ@eT`d@e,<@eoiDg@e@@e|?@eT`d@eSMj@eE84@eL_@ekP@eI^5@eDg8~@e4֡b@e`d@e_@em8@e4J@e	k~@e'RT@e9Xb@el!-@e+@eNU@e+@e-V@e@exl"h
@eJM@e74@erG@eZc@e*0U@eZ1@e>6z@eZ1@e!-w1@e<쿱@e.H@e-w1@e-w1@e;5X@e,=@e՟U=@eォ@e`A7@eW>6z@e@er Ĝ@e+jg@e@@eIQ@e9@e8YK@eH@eIQ@er@e?@eb}V@e)y@eO;d@e)y@equ"@eT`d@e~($x@fkP@fkP@fI^5@eᰉ'@f64@fC@f҈p;@e}Vl@f@f@f҈p;@f҈p;@fa@O@f'@f
&x@fS@f
&x@f'@f|@f(@fP{@f	k~@fϪ͞@f@f ѷ@f2a|@f?@f2a|@f+@f2a|@f2a|@f$[W?@f'&@f *1@f1@f'&@f!-@f&#9@f(x@f#[W>6@f Fs@f(x@f$ߤ?@f.wkP@f+'R@f80U2a|@fMo i@fFs@f6t@f5Xy@f!!.@f?!-w1@fK'RTa@fJ<쿱@f@%@f@%@fAlC@f@%@f=n/@f?	@fJ;5X@fGtj~@fDU@fGsg@fK%@fJ:~ @fMI^@fUW>6z@fV)@fQ,zxl@f9hr!@fHsP@fX}H@fS䎊r@f]U=@fdIQ@fa8YK@fc9@fS䎊r@fX1'@fdwkQ@faԕ*@fV#x@f]͞@fj)y@for@fe.H@f_
M;@fZC-@fc8}H@fj)y@fgb}V@fgb}V@fhm\@fgae@fdS@f`q@fl@fc7KƧ@faa@@fqv@fr~($x@fhm\@foX@fgae@fj(\@fsᰉ'@fe\N@fj(\@fs҈@fqv@fr}Vl@fs҈@fv-@f~!.I@f~!.I@fq_p@foE@f'/W@f2W@fnR<6@fr}Vl@fyo hی@f}A@fv@foE@fa@O@f&x@f|5?|@fqPH@fosh@f|5?|@f_F@f~~@f|5?|@fx	ԕ+@f'RT@f&@fl"h	@fl"h	@fVϫ@f~>@fO;dZ@fp:@fOv`@fz*0@f}$tS@fݗ@f-V@fkP|@f+@fkP|@fkP|@fkP|@f/@f@f1@f?@f\(@fJM@f-@fFt@f#9@fZc@f!.H@f3@fn@f>6z@f5Xy@f0
)@f"`@f>BZ@f>BZ@f!-w1@ft@f/{J#@fZ1@fs@f	k@fs@fs@f<쿱@fu!S@fJE@f@fo@f䎊@f@fXe,@fȑN;@fσ{J#:@fu%F@fI^5?@f1@fӭB@fӭB@f1@f@f@fӭB@f;dZ@fu%F@fu%F@fڞ쿱[@fȴ9X@fn.@fn.@fn.@fe+a@fڞ@fVϪ@fo@f{@f
=p@f{@frGE8@f$tT@frGE8@f@@f幌~($@f{@f+jg@f+jg@f+jg@fMj@f@@fƧ@fQ@f帺@fm@f˒:*@f8YJ@gC-@fQ@fƧ@fC,z@f8YJ@gC-@fA [@fƧ@f4m@f)^	@f8Y@g@g	a@@fߤ@f8Y@g*0U2@gE@g@ge+@g u@g~$@g@gSMj@g
\N@g($x@gp:~@ga@N@g($x@g	a@@g	a@@gR<6@gDg8~@g($x@g~$@goiDg8@gG{@gE@gěT@g xF@gE@g u@gG{@g_p@g}Vl@g4֡b@g4֡b@g6z@g҉@g	@gq@g4֡b@gR<6@g4֡b@gq@gڹZ@g
ڹ@gc	@g,qi@g0'@g@g'RT`@g`A7L@g0
@gPH@g
qv@gC%@gc	@g@g!n.3@g(_F@g"ѷX@g@g|@g2@g+&@g$4m9@g*0@g7@g 	ԕ+@g)\(@g+&@g09Xb@g6A7K@g,'RT@g(_F@g,'RT@g(_F@g-(@g4҈p@g3zxl"h@g9u%@g7v@g09Xb@g3zxl"h@g=33333@g2@g(^5?|@g(^5?|@g>@gBTɅ@g>@gBTɅ@gEeO@g9u%@g)@g=33333@g?rGE9@g;+@g=2a|@gI-V@gR_o @gI-V@g:kP|@g>ᰊ@gHNU@gI-V@gP
=q@gX74@gR_o @gI-V@g>ᰊ@g,#@gD$xG@gdzG@g]"`B@g[H˒@g^YJ@gX74@gR@gPS&@gaL_@g^YJ@gV1&x@gWݗ+@gd*0U@gd*0U@gi@go/V@gi@gkS&@gkS&@gmcA @gkS&@gmcA @g_rG@gT@g]!.H@gd*0U@gfڹY@gt
(@g~u!@gb@gq+j@gko i@gt<64@gxfB@gpS&@g_>BZ@gq+j@gzK]c@gwM:@gwM:@gxfB@gwM:@gwM:@go/w@g{1@g}u@gm˒:)@gm˒:)@gحV@gXy=@g~u!@gpS&@gt<64@gF]d@g	@gF]d@g<64@g}u@g<64@gzJL@gحV@gF]d@g}u@gw{J#:@g	@gXy=@gfA@ghr!@g-
q@ghr!@gD@g-
q@gfA@gW@g@4@gvȴ@gzJL@g}u@g@4@geO@g%@gsg@g%@g-V@g>B@g@4@g!-w@gW'@gbM@g1&@gsg@g>B@gIQ@g֡a@g+a@gK]d@g:)y@g:)y@gd7@gK]d@g+a@gK]d@g\(@gVl!@g䎊r@gr Ĝ@gwkQ@gr Ĝ@g$/@g䎊r@g+a@g}H@g4m@g}H@g䎊q@gce@g!R@g$/@gGE85@gfA@gwkQ@g!R@gGE85@g}H@gwkQ@g*0@g84֡@g     @gqiC@g84֡@g*0@g@g@g!R@gce@gV@gwkQ@gce@g     @gr@gce@g@@g͛=K@gr@gr@gF
L0@g8Y@g,<@gT`d@g84֡@g.H@gD@gqu"@gqu"@gr@g73@g
qu@gp
=@ga|Q@g8Y@gƩ@gqu"@g͛=K@g73@gF
L0@gm\@g@g6@g͚kP@g}H@g@gěT@g(@g(@g6@gߨXy=@goiDg8@gG{@g6@gE@gԌL_@gu%F@gD*@g-@gض}Vm@g}H@g0
@gC\@gG{@g}H@gߧ&@g'RT`@g
qv@gPH@gsh@g'RT`@g'RT`@g#@g@gc	@gC\@g@g@g@g@gڹZ@g@gsh@g@g'RT`@g`A7L@g0
@g`A7L@gsh@h ~@gѷX@gsh@g@gc	@g
L/@gPH@g'RT`@g{m@gB@g{m@gB@g+j@h ~@g{m@g	ԕ+@g+j@h ~@h\(@h	O;dZ@h_F@h_F@h	O;dZ@h ~@h'RT@h
g	@h'RT@h ~@h
g	@h	O;dZ@h\(@g+j@hVϫ@h@h
{J#9@hϪ͞@hϪ͞@hp:@hVϫ@h
g	@h	O;dZ@h
g	@h
g	@hA7K@h	O;dZ@h	O;dZ@h%F
L@h33333@h"NU@h%s@h"NU@hᰊ@hu%@hu%@hu%@h^5?|@h	O;dZ@h$xG@h%s@h$xG@hK]@h C,@h&y=c@h)@N@h'?@hn@h/@h+@h$xG@hݗ@h$xG@h&y=c@h1O
@h)@N@hݗ@h*S&@h&y=c@hݗ@hݗ@hn@h C,@hݗ@hᰊ@h'@h01&x@h-jOv@h274@h01&x@h)?|h@h)?|h@h;MjO@h274@h"M@h)?|h@h.͞&@h01&x@h1O
@h274@h-jOv@h&xl"h
@h9ᰉ@h;MjO@h< ě@h5H˒@h,@h01&x@hB>BZc@h@ڹY@hFhۋq@hK!.@hI/V@hES&@hES&@h< ě@h,@h;L_@hB>BZc@h5vȴ9@h2e@h?w1@hU1@hN<64@hES&@hGcA @hN
(@hES&@h00U2a|@h5vȴ9@hC@h< ě@hB=p
@hGcA @hN<64@hG˒:)@hB>BZc@hC@hC@h< ě@h9rG@hES&@hP ě@hU1@hG˒:)@h< ě@hMY|@hQM:@h>s@h<O
M@hFh	ԕ@hQM:@hB=p
@hP ě@hb-
q@h_fA@hJS&@hP ě@hN<64@hG˒:)@hK+j@hWnP@hYحV@hEo i@hG˒:)@hYحV@hdD@hfXy=@hYحV@hWu@hb-
q@h^F]d@h\vȴ@hYحV@hXu%F
@hb-
q@hi	@hchr!@h\vȴ@hUzH@hP䎊@hWu@hgn/@h`W@hR@hXu%F
@h[<64@hWu@hQ{J#:@h_fA@h`W@hR@hXu%F
@hb-V@hfW'@hfW'@hmIQ@hfW'@hUzH@hKY}@hUzH@hYحV@hXu%F
@hWu@hg/V@hmIQ@hwI^@hd!-w@h\쿱[@hk@hrsP@hd!-w@hiQ@h_eں@hiQ@hfW'@hg/V@hk@hiQ@hmIQ@h[;dZ@hW)^@h\쿱[@h^u%F@hc@h_eں@hfW'@hpbM@hn>B@hmIQ@hiQ@hj@4@hiQ@hmIQ@hw:@h{+a@hxd7@hg/V@h_eں@h^u%F@hg/V@hke@hqsPH@hqsPH@hjo h@hp@hw:@hxd7@hw:@hr֡a@hr֡a@ht:)y@hke@h`ȴ9X@hb,<@hW)^@hW)^@hke@hi,@hi,@ht:)y@hw:@hke@hmH˒:@ht:)y@hn1&@hmH˒:@ht:)y@h1'@h|qj@hjo h@hmH˒:@hxd7@huu@h{+I@hU=@hyy@hn1&@hi,@hqsPH@hw hۋ@hw hۋ@hxcA \@h#x@h}s@hi,@hfVϪ@hke@hmGz@hp@hp@hGE85@hGE85@h1'@hw hۋ@hU=@h|qj@hmGz@hw hۋ@hqiC@hZ@hGE85@hq@hU=@hn6z@h|qj@h͞@h4m@hC-@h#x@hFs@h#x@hFs@h#x@huu@huu@h}A [@hC-@ht9XbN@hn6z@hqrGE8@hFs@hC-@hC-@hQ@hrϪ͟@hw hۋ@h|@hxcA \@hpߤ@@hxc	@h|@h|@hC-@h}A [@h}A [@h}A [@h}A [@h{*0U2a@hyƧ@hxc	@ht8YJ@h{*0U2a@hFs@hC-@hb}@h8}H@hFs@huߤ@hmF]c@hTɅo@hQ@h}A [@hxc	@hyƧ@hTɅo@hq@hC-@ht8YJ@hnd8@hp
(@hFs@h(\@h7KƧ@h,<@h\N@hFs@h|@huߤ@hyƧ@hE@hb}@ht8YJ@huߤ@h~$@h7KƧ@ha@@hS@hu@h(\@hX@h@h{*0U2a@hS@hp:~@ha@@h4m@h}oiDg@h~$@h@hae@h~$@h{)^	@ha@@h@hae@hp:~@hu@he+@h@hE@h{)^	@h{)^	@hS@ha@@hp:~@hp:~@ha@@hp:~@h*0U2@hS@hS@hE@h~$@h~$@he+@h4m@h*0U2@hD*@h҉@h6z@hoiDg8@hoiDg8@hE@hu%F@hoiDg8@h6z@h҉@hXy=@h҉@hoiDg8@h6z@h6z@h4m@h{)^	@h6z@hڹ@hXy=@hu%F@hS@h҉@hXy=@hG{@h6z@hR<6@hoiDg8@hG{@hu%F@h4֡b@h@h@h}H@hXy=@h҈@hE@hq@hD*@hG{@hڹ@hu%F@h}Vm@hS&@hڹ@hěT@hG{@hXy=@h@hěT@hq@h6z@hG{@h҉@hD*@h}Vm@h}-@hG{@hq@hěT@h@h@h}H@hD*@hoiDg8@h@h҉@h($x@hq@hoiDg8@hD*@hڹ@hsh@hڹ@hG{@hD*@hsh@h($x@hoiDg8@h6z@hXy=@h}Vm@h}H@hXy=@h@h6@h҉@h`A7L@hu%F@hoiDg8@h@ha@N@hu%F@h6@hXy=@h`A7L@h@h5Xy>@hnO@hG{@h}-@h6@hD*@hsh@h0
@h|L_@h5Xy>@hڹZ@hG{@h0
@h5Xy>@hu"@hnO@hC\@h'0@h@h@h5Xy>@h&@h'0@h5Xy>@hnO@hyo @h}@hC\@hڹZ@hc	@hQ@h@h|@h	ԕ+@h@hnO@h0
@h0
@h`A7L@h|hs@hC\@h@h?@h|C@h{'/W@h}@h5Xy>@h@h&@h|hs@hy2W@h}@hC\@h@hC\@ht64@hXp:~@hXp:~@h\,<@h[7KƧ@hfSMj@hu@he+@h}@h{'/W@h&@h&IR@h;dZ@hL/{@h;dZ@hlD@h|C@hRT`e@h;dZ@h7@h#@h0
@h7@h*0@h7@hlD@h_o@h
=p@h4֡a@h_@hC,zx@hC\@h_@h;dZ@h	@hlD@he+@hlD@hߤ?@hm8@h
=p@hRT`e@h
=p@h*0@hm8@h_@h_@htj@h'@hlD@hhr@hN;6@h
=p@hlD@h	@h4֡a@htj@hߤ?@hlD@hQ@hC,zx@h&IR@h_o@h7@h_@hlD@hߤ?@hN;6@hm8@h(@htj@hlD@hm8@h_@hiB@h4֡a@h_@hx_ح@hC,zx@hs@ht5?|@hmC%@hgsh@hj|@hqn.3@hqn.3@hx_ح@h|qi@h{&x@h|qi@h|Q@h'@h|qi@h|qi@h|qi@hx_ح@huA@hya@O@hj|@hrѷX@hya@O@hm8@ht5?|@ht5?|@h|qi@hx_ح@hk
qv@hx_ح@hya@O@h|qi@h'@hqn.3@ht5?|@hya@O@htj@hvPH@hm8@h|qi@h'@hrѷX@ht5?|@hp
L/@h}C]@hp
L/@hrѷX@huA@h'                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ?q?%2?"`?7KƧ?.H?C,z?333333?҈?h	ԕ+?U=K? [6?S&?*0?/V?/V?F]c?L/{J?c	?$xF?ڹY?/Vϫ?L/{J?0
)?qu!?1&x?d7?\(\?c	?c	?73?° ě?5Xy>?üZ?9XbM?ceO??|hs?ߤ??cA \?xF?6z?n.2?A [7?sPH?7KƧ?JM?ή}Vl?? hۋq?K]cA? [6?E?b}?l"h	ԕ?вᰊ?_حV?As?VϪ͟?@?+? ěT?ӅQ?-
?8YJ?b}V?#wk?+a@?u%F
?_o? ěT?րIQ?;dZ?D?e?H?&x?@N?;dZ???زᰊ?XbM?ف$/?إzxl"h?ڱ2W?ڶ}Vl?ffffff?
M:?xl"h	?[?S&?9D? ěT?\(?䶮}Vl?/V?hۋq
?s?~($x?
M:?߮zG?:~?ׯr?n?!-w2?Ӫ͞&?ߤ??M:?+jf?I^5?}?C\?6C?u%F
L?g	?n?TɅo?쿱[W??Ĭ1&y???u!?\(?]ce?:)y?TɅoi?vȴ9X?C\?~$t?zG?($xG?e+?fA?_o?!R<?JL?nO?2W??:~?҈p:?H?XbM?N;5?Fs?A?$/?PH?,<??|??$?=K]?Ov_خ?l?},<?z6C-?*0
?_Ft?;dZ?1&y?*0?=K^?Z?Z?N;5?n?Ϫ͞?u%?حU??sg?l!-w?ݗ+j?O
M?U=K?tj~?e+a?sg?ceO?~$???sg?`d8?n?҈?8YJ?&x?e+?u%F?c	?*0?H?W'?'RTa?m\?ߤ??_Ft?u%?Q_p?b}V?_o?4J?Y|?	 ?Fs?tj~?S???"`A??tj?8YJ?g	k?IQ?_Ft? ѷX?iB?%2?Z?+jg?JM?*0?S&?*0?Q_?ߤ??R<64?=K]?Q_?Z?u%?C,zxl?2a|Q?fA?ᰉ'?ᰉ'?&?~Ov_ح?E?IQ?>6z?S?[Q_?ku%F6C-??*0?{u%F?@bM?y_o ?l1&yS*0U2a?A?쿱[W?p)^	_!-w1?Z?$/?ᰉ'?Ϫ͞?O
M?n`bM?q4J?~Ov_ح?z6C-?rn/?xPH?ye+a?q4J?w?C,zxl?҈p:?aes*0U2atnZ6C-?Mj?$/?nO;?a@N?*0?z6C-??$/?2a|Q?|1&y?Xtj~?{u%F?bsPH@bM?pbM[Q_?)^	?{u%F?zvȴ9V?<64?U=K?Q?ae?fA?u!?,<?hr Ĝ?Q?U=K?,<?Ϫ͞?Z?_o Rn/??҈?}Z?bM?nO;ie+a?xtj~?N;6?Xe+ԿZ6C-?dzG{?|1&y??-V?u!?S?L_?R<64?|1&y?=K]?}H˒S*0U2a?n?*0?<64??zvȴ9?sg?Y}?:)y?|1&y?}}H˒?!-w1?},<Z6C-?qu"?䎊q?{qu!S?%2?,<?rsPH?O;dZ?Ϫ͞?ᰉ'?E??-
qv?{Q_?~Ov_ح?*0U2a?},<?4J?a@N?$/?M}H˒?qu!S?e+aeL_bn/?vOv_خ?~Q?xPH?ie+a?6C-?nOv_ح?PbM?`d8?L_?qu!SS*0U2a?v+I?:)y?hr Ĝ?vOv_خ?v+I?|C,zxl?|??zvȴ9?Xtj~?j6C-*6C-??ceO?Ϫ͞?|?l1&yie+a?xtj~kQ_?҈?2a|Q?O
M??rnO;?0
(?a4J?bsPH?䎊q?ߤ??*0
?6C-?@NU?Ϫ͞?$tS?bsPH?bMZ6C-?|1&y?Fs?2a|QUL_?vOv_خ?}Z?!-w1?-
qv?Fs?a@N?eL_?zvȴ9?)^	?	 ??nO;?-VpbM?zvȴ9?N;5?)^	?S&?ᰉ'?-
qv?Xe?ku%F?S&?x*0
hr Ĝ?{Q_?*0?6C-?Z6C-?
=p
?u%?`d8?}Z?hr Ĝ?cA \?R<64?tj?5?|h?e+a?Q?sg?zvȴ9?UL_?C*0U2aM}H˒?UL_Rn/??fA??Q_pgf?_o?ᰉ'?Zݘ?$/?nO;?Ϫ͞?_o @bM?ie+a?Z6C-?]}H˒?tj~?u%?_!-w1?a@N?wkP]}H˒?Mj?n?u"?{qu!S?@NU?u"?|??l1&y?`bM?,<?_Ft?]}H˒*6C-?	 ??fA?䎊q޿j6C-kQ_?},<?{Q_?ye+a?rsPH?xPH?ye+a?zvȴ9?xPH?bM?qu!S?{qu!S?V?F?+I?_o V?qu"nOv_حa4J?`d8?ɅoiD?n/?{qu!S?N;5?`A7L?sg?O;dZ?6C-?*6C-?-
qv?a4JZ6C-?[Q_Xtj~?$tS?bM?xtj~?wXe+?:)y?n?2a|Q?Y}?>6z?Fs??`d8?e+a?ye+a?PbM?x*0
?vȴ9X?y_o ?䎊q?)^	?}Z?!-w1?*0U2a?ݗ+j?*0U2a?)^	?|C,zxlPbM?*0U2a?n/?u"?IQ?ߤ??u%?_o?ae??sg?*0?Z?p:dzG{?o!-w1ſj6C-q4J?%2?usgf?Z?6C-?ku%Fbn/s@NU?}}H˒?n/V?c*0U2a?O
M?}H˒?6C-f?4J?N;5?Fs?`d8?҈?4J?{Q_?nO;?2a|Q??zvȴ96C-?*6C-?|1&y?䎊q?}Z?kP{?qu!S?U=KkQ_c*0U2a?vOv_خ?rn/vOv_خ|1&y{u%F?pbM?vOv_خ?bM?*0
?qu!S?*0?n?z6C-?sg?Xe+ԿZ6C-?{u%F?tzG{]}H˒?y_o ??҈        ?rsPH?~Q?@?C,zxl]}H˒?S*0U2a?S?Ov_ح?|C,zxl?Z6C-dzG{?}Z?_oҿg?w?y_o ?uL_?rnO;?v+Ihtj~q4J?u%F
?u%F
?S&?a4J?6C-?PbM?C*0U2a?Xe+?ߤ??Xtj~?Hc*0U2a?}}H˒?|C,zxlj6C-?qu"ie+a?x*0
?:)y?m}H˒u%F
?tn?tnV?x*0
?uL_?gfOv_خ?Xtj~c*0U2a?	 ?u"?Ϫ͞?Y}UL_?w?{Q_?{qu!S?PbMpbM?IQ?hr Ĝ??vȴ9X?},<?{u%FJ6C-䎊q޿o䎊q?zvȴ9?}}H˒?{u%F?O
M?*0J6C-?g??2a|Q?nOv_ح?ie+a?fOv_خ6C-?x*0
?y_o ?usgZ6C-?~Q?~Ov_ح?v+Il1&y?z6C-?Zݘ?(\)?sg?|1&y?}Z?|1&y?{qu!S?F?Rn/?	 ?j6C-?6C-???},<?{u%F?tn?wXe+?xtj~vOv_خ?pbM?4J?$tS?Z6C-usg?F?v+I?x*0
?|C,zxl?{Q_?,<?Z?}}H˒?zG{?hr Ĝ?tn?s@NU?vOv_خv+I?bsPHnOv_ح?Mj?Aie+a{u%FXtj~?3*0U2a?|1&y?8YJ?{u%F?~Q?j6C-tZusgpbM?}}H˒?}}H˒?tzG{c*0U2av+I?Q_?zG{?bn/?C*0U2a?dzG{Vǿ},<~Ov_حtzG{?Rn/?*0?`d8?	 ?y_o ?!-w1?~Q?@NU?@NU?vȴ9X?Z6C-?Xe+Կku%FbM?Q_?fA?|?Z@bM?a4J?Ϫ͞?wkP?*0U2a?},<?rnO;?{qu!S?v?x*0
??Q?$tSM?u"?@V?dzG{?}H˒?u%F?~Ov_ح?*6C-?UL_?Xtj~?C*0U2a?z6C-?bn/o䎊q޿q4JdzG{?<64?䎊q?@NU?ye+a?qu"?}Z?tnl1&y|C,zxl{Q_?}Z?~Ov_حusgnOv_ح?6C-?:6C-?Xtj~?f?$tSM`bM?)^	?ݗ+j?䎊q޿_!-w1ſku%F?pbMS*0U2a??U=?e+a?u%F?sg?Ov_ح?}}H˒?u"?2a|Q?4Jv+I?z6C-?N;5ie+a?vOv_خ?kP{?O;dZ?~Ov_حUL_?ᰉ'?Ϫ͞?S&¿wXe+?q4J?A3*0U2a?+?bMpbM?ie+apbM?u"?zG{?sPH?$/?fA?Ϫ͞?fA?e+a?!-w1?}Z?y_o ?j6C-?ie+a?ߤ?ye+ao䎊q?qu"tn?wXe+?nO;Z6C-?Z6C-v+I?[Q_ku%F:6C-?V?usg?₿pbM?rnO;?R<64?u%F
?Zݘ?o!-w1ſhtj~?	 ?,<쿱???*0U2a?|1&y?!-w1?vȴ9X?|C,zxl?u"?쿱[W??6C-?6C-?$/?Xec*0U2a?y_o ?N;5?䎊q?	 ҿie+arnO;?qu"?+I?!-w1?|C,zxl?vȴ9X?nusgS*0U2a?{qu!S?tnbsPH?~Q?rn/nOv_ح?u"?>B@bMuL_uL_        PbM?J6C-?xtj~?ye+a?w?{Q_?tj~?+J?xPH?bn/?tZ?	 ?}}H˒q4J?kQ_?usg?a4J?x*0
?ye+a?|1&y?*0?Z?dzG{o䎊q޿s*0U2aq4Jie+a??T`dUL_?䎊q?l6C-?kQ_qu"?S*0U2a?}}H˒?}}H˒?!-w1?tj?ᰉ'?vȴ9X?bsPHws*0U2a?q4JZ6C-?bM?"`A?@NU?}}H˒?:)y?+I?H??u%?,<?-
qv?bn/kQ_o䎊q޿c*0U2a?z6C-?y_o ?-
qvfOv_خ?x*0
fǿuL_?u!?PH?+I?!-w1?bM?~Qrn/?Rn/?tj~?tj?n/?|1&y?uL_?y_o tzG{l1&y?p)^	?u"fOv_خqu"o䎊q?R<64?$/?bMrn/?tZ?zG{?6C-_!-w1?+jg?b}V?	 ?~Ov_ح?x*0
Z6C-?҈?n/fOv_خpbM?Q?f?m}H˒?u"?`A7L?+jg?N;5?`d8???$/_!-w1?)^	?|C,zxl?S&?)^	?S&¿ku%FkQ_?~Ov_ح??4J?rn/?tj~?u%?~Q?	 ?bsPHS*0U2a?_Ft?qu!StZUL_?@NU?$tS?{qu!SfOv_خ??$tSM@bM?@?rnO;?UL_?Ov_ح?IQ?o!-w1?*6C-?-
qv?Z?_o?M}H˒?1&y?nO;rn/p)^	?zvȴ9?xPH?-
qv?!-w1?҈?,<쿱?,<쿱?g?zvȴ9?=K^?6C-dzG{?tn]}H˒?y_o ?}Z?{Q_?Zݘ:6C-?Z?Xe+?|1&y?~Q?Xe?=K]?-
qv?fOv_خ:6C-?)^	?$tS??҈?$tS?}}H˒?{u%Fj6C-?        ?s@NU?H?Ϫ͞??bM?T`d?+?fOv_خ[Q_?|C,zxl?Z?T`d?v+I?|1&y?-
qv?|C,zxl?nO;?ݗ+j?ye+a?xtj~?{u%F?4J?	 ?1&y?v?PH?L_?*0?ݗ+j?4J?}}H˒?}}H˒?ye+a?wXe+??҈?L_htj~w?$tSM?}H˒?-
qv?kQ_?v?tj?usg?Z6C-?XeUL_?nO;?4J?xPHc*0U2a䎊q޿uL_?PbM?|C,zxl?}Z?zvȴ9?uL_?FǿnOv_ح        ?usgs@NUm}H˒?$tS?<64ku%F?tzG{fǿkQ_?usg?|??e+a?*0U2?|C,zxl?usg?L_?U=K?s*0U2a?O
M?2a|Q?$/?p:?zvȴ9?wuL_?ku%F?uL_?hr Ĝ?bn/?htj~?wkP?`bM[Q_?zvȴ9?bn/Z6C-?j6C-F?҈?hr Ĝ??}Z]}H˒?rn/?xPH?N;5?]}H˒?o䎊q?|C,zxl@bMq4JJ6C-?	 ?bsPH?M}H˒?~Q?dzG{xtj~tzG{|C,zxltzG{?{u%F?n?fA?*0?e+a`bMuL_?ᰉ'?{qu!Sy_o ?p)^	?Q?*6C-bMzG{usg?usg?|C,zxl?v+I?tj~?Z?=K^?*0@bM?ku%F?zvȴ9S*0U2a??f?kQ_?}Z?$tS?{u%F?y_o ?nOv_حXtj~?y_o ?bM?E?Zݘ?}}H˒_!-w1?v?$tS?}}H˒?sPH?ZdzG{tZ:6C-?J6C-?@bM?{u%F?dzG{v+I?`bM?}H˒F?T`do!-w1ſx*0
?g?vOv_خ?wXe+ԿfOv_خ?$tSM?rnO;xtj~?@bM?{Q_@bM[Q_?dzG{_!-w1?!-w1?nO;?p:ie+a?)^	?:)y?},<?ݗ?0
(?)^	?J6C-?`bM?e+a?S&        ?|1&y?xtj~?|C,zxl?o!-w1ſZ6C-?bMfOv_خ?v+Io!-w1?l1&ybsPH?o䎊q?|1&y?}Z?C*0U2a?*6C-?vȴ9?fA?4J?~Q?tzG{M}H˒?tj~?Fs?	 ?xPH?},<?!-w1?l?sPHZ6C-?+I?!-w1?V?u%F?ᰉ'o!-w1ſRn/?bM??N;5?ye+ahtj~?xPH?uL_o!-w1?o䎊q޿S*0U2ahtj~o䎊q?bn/?$tS?}H˒?=K^?-
qv?},<?~Ov_ح?qu"rsPH?ye+a?ye+apbMrn/?uL_Z6C-rsPH?ku%F?S*0U2anOv_ح?a4J?u%?@m}H˒a4J?!-w1?)^	?s@NUhtj~?vOv_خs@NUku%F?tnZ6C-?_Ft?qu!S?,<?hr Ĝ?4J?sg?bM?$tSM?!-w1?rnO;?@NU?N;5C*0U2a?+jg?*0U2a?xtj~?{u%F?䎊r?*0?l1&yqu"s*0U2a?g??}Z?zvȴ9?xPH?$tS?~QV?Zݘ?Z?ݗ+j?N;5grsPHrn/?V?!-w1?:)y?䎊q?c*0U2aC*0U2a?O;dZ?ɅoiD?u!g??u"?xtj~Xtj~?N;5X?Fs?v+IrnO;?PbM?|C,zxl?y_o 3*0U2a*6C-?$tSM?_FtJ6C-?hr Ĝo䎊q?{Q_?䎊r?n/?S&?nO;?n/?6C-?eL_?IQ?Z?~Ov_ح?$tSM?%2S*0U2a?}}H˒?@NU?hr Ĝ?rnO;[Q_?xtj~eL_?|1&y?}}H˒?~Ov_حJ6C-tn?]}H˒?!-w1?E?Fs?s@NU??C,zxl?fOv_خvǿtnuL_uL_o䎊q??-
qv?ye+absPH?|C,zxlc*0U2a?2a|Q?bM?}}H˒?`bM?htj~?Z?$/?Fso!-w1?s*0U2a`bM?,<y_o tZ?xtj~v?Xtj~?*0U2?e+a?o䎊q?Xe+?쿱[W??bn/@bM?{u%F?{qu!S?zG{?4J?bn/?@NU?v+I?,<g?U=K?hr Ĝ?=K]?UL_?4J?4J?ߤ??҈?sPH??bM?Xe+?usgM}H˒?V?bM?gl1&y?J6C-?v+I?uL_*6C-?g?ߤ??Xtj~?fA?p)^	?`A7L?htj~?*0
V?ߤ??L_?tn?Q_?ye+a?ku%F?V?}}H˒?bMo!-w1?Xtj~?{Q_?~Ov_ح?-
qv?M}H˒??ᰉ'?Q?-V?wnOv_ح?x*0
?:)y?!-w1?usgf?6C-rsPH?w?	 ?sPH?@bM?u"?%2?6C-?n/?=K^bn/?Z?~Q?~Ov_ح?4J?H?usg?0
(?<64?Q?ߤ??u%F?~Ov_ح?},<?}Z?-
qv?kP{?e+a?*0?3*0U2a?Xtj~?dzG{?Q?pbMbsPH?{u%F?{?Xe+?ᰉ'?*0
?u"?v?~Q?bsPH?hr Ĝ?usg                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         &+B @(3:j35                                      1                                       