CDF       
      time      pressure     latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        14     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:18.450526Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_014 (14) * LATITUDE: 42.120000 * LONGITUDE: 9.900000 * DATE/TIME: 2016-08-21T21:52:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @          data_max      @(        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC        '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        ?    temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @+*L_   data_max      @:Dg8}   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC         D   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        \   salinity               	long_name         salinity   units         PSS-78     data_min      @C
=q   data_max      @C]'0   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC        b   salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d        z   oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @d#w   data_max      @p|Q   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC             	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d           CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      *6C-   data_max      ?4m8   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC           CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d           	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ə   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC          CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d        Ԝ   time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &   data_max      &   C_format      %10d        ژ   latitude               	long_name         latitude   units         	degrees_N      data_min      @E\(   data_max      @E\(   C_format      %9.4f           ڜ   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @#   data_max      @#   C_format      %9.4f           ڠ   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      35   data_max      35   C_format      %8d         ڤ   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min        h   data_max        h   C_format      %4d         ڨ   station                	long_name         STATION    units         unspecified    C_format      %s        (  ڬ   cast               	long_name         CAST   units         unspecified    C_format      %s        (  @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @:Dg8}@:)y@9rGE9@9ߤ@9u@9te@9Ae@9tj@8K]@8ٺ^5?}@8	@8S&@8JJL@873@8C,@7	 @7g@7fA@7xQ@7V@6
qv@6|@5zG@5Y|@4PH@4SS@3щ7Kƨ@3N1@36@2dZ@2w1@2c	@2Vϫ@2ix@2;$@2iB@1ܘ_@1S@1`oiDg8@1.Q@08}H@0bM@0}U=@0he+@0R-V@00bM@0@4@/{m@/ڹY@/Q@/]+j@/VϪ͟@/I^5?}@/'	k@/	ԕ+@.{@.n.@.?@.Ϫ͞@.Z@.r-V@.eݗ@.V+jg@.F
L/@.7rG@..c	@.')^@.b@.!.@.O
M@.u@.C,@-vȴ9X@-^5?}@-)y@-I^5?@-\N<@-+j@-{@-q@-Z1@-$t@-b}@-O
M@-&x@-@-d7@-@-A7K@-{J#9@-tSMj@-rT`d@-p`A7@-k]cA@-g@-fIQ@-g+I@-gݗ+@-gK]d@-hۋq
@-h@-g@@-g-@-glC@-g@-fx@-dM:@-b74@-ae@-aGz@-a-w1@-`	k@-`u!@-`NU@-_䎊r@-\?@-RT`d@-FA@-LVϪ@-P|@-Or@-L/{J#@-AR<6@-@hۋq@-Ao hی@-;A@-:,<@-DxF@-Em\@-EQ@-EQ@-E@-D%1@-A@-As@-:Q_@-9+@-8bM@-6_ح@-4,<@-)^5?}@-$tS@-쿱[W@- d8@-" ѷ@-&1.@-(TɅ@-+:)z@-*~"@-$7@-#S@-$o h@-%+a@-&s@-(@-)rGE@-(r Ĝ@-'lC@-&s@-&1.@-&]cf@-'E84@-'ݗ+@-(>BZc@-)ᰉ'@-+xF]@-/-V@-.O;@-+'/@-)lD@-(\)@-)'RTa@-,I^5?@-+C%@-+q@-+]cA@-vȴ9X@-Q_@-ߤ@@-U=@-쿱[@-~$@-$tS@-$Z1@-#x@-5Xy@-S&@-,<@-$TɆ@-%84֡@-"`A@-b}V@-3@-}Vl@-
JL@-m\@-_o@-$/@-wk@-&IR@-ae@,[W>@,E@,ڹZ@,iB@,;dZ@,vȴ9@,N;@,PH@,v@- IQ@-n.@-o@-o@-/@-1&x@-$xG@-x@-@-s@-#@-fA@-]cA@-As@-r@-O;@-q@-n.3@,/w@,C\@,ȴ9X@,sh@,`A7@,TɆ@,@,74@,6@,:)y@,H@,:)y@,ϝ-V@,r Ĝ@,ěS@,҈p;@,$tS@,
=p@,F@,+j@,tj@,YJ@,+j@,+J@,@,_o @, ѷ@,eO@,S&@,n.@,d8@,
(@,@,!.@,X@, hۋ@,s@,^@,>BZc@,_o@,m\@,S@,d8@,}}H@,xF@,vȴ9X@,u%F
L@,rS&@,rS&@,rp:@,qX@,q2W@,t3@,xPH@,zQ_@,|?@,}b@,},=@,}-V@,|u"@,|]ce@,|]ce@,|64@,|쿱[@,|?@,|wkP@,|]ce@,|wkP@,|?@,|N;@,|PH@,{$@,{lC@,{m]@,z,<@,z@,v@,v+J@,u\(@,tD@,r<64@,rGE85@,qu@,p`A7@,ka@@,kC,z@,l@,mhr!@,m5Xy>@,i@,eo i@,d7@,hXy=@,iᰉ'@,iԕ*@,ilD@,jqiC@,`ѷX@,\u"@,\hr@,\쿱[@,]IQ@,\PH@,[u%@,ZkP|@,[J#9@,_$tS@,_vȴ9@,\hr@,XQ@,W3@,XF]d@,X73@,X_F@,X73@,W4m@,V_ح@,T3@,RGE85@,N.2@,GE84@,A$/@,9>BZ@,7@,6Ϫ͟@,4zG@,3E@,2m@,2p:@,2GE85@,2GE85@,2{m@,2ᰊ@,2 ě@,2W@,2sP@,2m\@,3Z@,3*0U2@,4m8@,4Z@,4E@,5\(@,7KƧ@,7$tS@,873@,84֡b@,9rGE8@,9D@,9Y}@,:xl"h
@,;q@,<Q@,<64@,<Q@,:)_@,:)y@,9_o@,9Y}@,:S&@,9"`@,9_o@,9=b@,9b}@,:Q_@,:xl"h
@,:@,9_o@,9#w@,7kP@,6@,74m@,8l"h	@,9rGE8@,8F@,9+@,9e+a@,8YJ@,7eں@,73@,8F]d@,9>BZ@,;J#9@,;W>6z@,:vȴ@,9Y}@,9_o@,9|@,9rGE8@,8@@,7rG@,8l"h	@,8}H@,8*0@,8YJ@,8y=c@,8_F@,873@,7+@,7KƧ@,5!.@,4֡a@,0$tT@,/rGE9@,/v_ح@,/v@,.1@,.p:~@,-@,-V@,-(@,-(@,-5Xy>@,,zxl"@,,VϪ@,,"h	ԕ@,+U=@,+]cA@,+~($@,-5Xy>@,-jOv@,/
M;@,0*0U@,0
=q@,0H@,/iDg8@,.zG@,-5Xy>@,,C@,,@,,~($x@,+Q@,)x@,'lC@,#,zxl@,!R<6@, hۋq@,6z@,IQ@,qu!@,@,_o@,XbM@,=b@,l"h	@,O;d@,Xe@,Fs@,af@,E@,sg@,Z@,3@,zG@,,<@,sP@,@,{@,bM@, ě@, ě@,rGE9@,o @, hۋ@,}Vl@,c	@,Vu@,c	@,zG@,
@,
\@,
V@,@,_@,L_@,'/@,
0
@,
~"@,
qiC@,	y@,	oiD@,	^@,eO@,$xG@,zH@,zH@,_o@,YJ@,S@,84֡@,u@,?@,\N@,@,{J#9@,S&@,@,\(@,u%F
@,@,h	ԕ@,Gz@, 4m@+䎊r@+m\@++j@+K]@+?@+]ce@+$@+6@+G{@+xl"h
@+xl"h
@+>BZ@+PH@+@+$tS@+
=p@+@+E@+!R@+O
M@+#@+SMj@+*0U2@+䎊@+u@+@+{@+H@+H@+@+͞@+'/W@+qi@+C\@+M:@+V@+<쿱@+Ƨ@+q@+jf@+͞&@+qiC@+lD@+x@+TɅ@+/V@+RT`e@+'@+`A7L@+7@+7@+2W@+n.3@+C,@+e+@+ὥ@+ᰉ'R@+|Q@+d8@+4m9@+߱[W>@+!-w1@+ސ$t@+cA @+K]@+j~#@+"`B@+kP|@+1'@+=b@+e+@+@@+rG@+Xe@+z@+R<6@+E@+R<6@+_ح@+Ov_@+?|h@+Ʌoi@+Fs@+sP@+a|Q@+GE85@+ѩl@+{@+Ж@+*0U@+ϐ@+4֡a@+;5X@+(@+s@+ڹY@+~"@+=p
@+ԕ*@+ɠ'RTa@+7KƧ@+rGE@+rGE@+@+Xy=@+8}H@+@+
=p@+@+䎊r@+Ft@+v@+C,zx@+S@+q@+J#9@+,<@+^5?|@+C\@+(@+@@+F]d@++@+
=p@++jg@+$/@+Z@+ߤ@+䎊@+\(@+.2@+q@+0
@+fA@+RT`e@+E84@+,@+x@+-@+M:@+xF@+Z1@+
=p@+TɅo@+.H@+N;@+s@+"`@+Q@+sg@+tj~@+sP@+{@+ߤ?@+@+M:@+!-w@+@+/{J#@+W'@+zH@+8YK@+S@+C,@+I^5@+~BZc @+z1'@+w+@+v!.I@+w$tS@+vR<6@+t,<@+rS&@+s@+r:)y@+qu!S@+q[W>6@+q@+m\@+kU=@+j~"@+i7KƧ@+h@+g-@+ffffff@+e@+dS@+dtSM@+c\N@+c	@+b@+bI^5@+`C@+]v@+\>@+\1&@+\?@+Z~@+X@@+Xy=c@+X73@+W+j@+W4m@+W1@+VϪ͟@+Vz@+Vz@+Ush@+UfA@+TɅoi@+Sa@O@+P*0U@+Lq@+Lzxl"@+LcA \@+Hr Ĝ@+Eo i@+C@+@4m@+?[W>@+?Ft@+>
(@+;5Xy@+73@+/o @+.1@+/\(@+.1@+-
qv@+,C@+,_@++a@@+*fB@+*L_@++]cA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              @C2m@C1	k~@C/͞@C.H@C-%F
L@C+ߤ@C)7Kƨ@C(	ԕ+@C')^@C'䎊r@C(F@C'[W>@C&.2@C$hr@C tj@C$u"@C$?@C$!-w@C$(\@C$ߤ@@C 	ԕ+@C/@C0U2a|@C4m@C-
@C1&x@C	k@CAs@C-
q@CzH@C[W>@C_o@C@Cz@C=K@CJM@C?|h@CS@CL_@Cm@COv`@Cs@Cԕ*@C|@CDg8~@CPH@C
=q@CD@C@C [7@Chr @CoiD@C[W>6@CN;6@Ce+@C(@CTɅo@C@C	k@C+@Co hی@Cԕ*@Cxl"h
@C/V@CVϪ@C5Xy>@COv_خ@C?@CE@COv_خ@C'/W@Co @C[W>@C@C*0U2a@CJE@Cb}@C"`@CS&@CY@Cqu!@C@C]ce@Ce@C?|h@CY|@C ѷY@C.H@C\(@Cr@C )^@C!-w1@C!k~(@C"}Vm@C$2W@C$?@C%ݗ@C%@C&l!-@C'4֡a@C'b}V@C'#@C(l"h	@C(p:@C)&x@C)o hی@C+g	l@C,?@C.,<@C/˒:)@C0U2a|@C09Xb@C1 ѷ@C1Gz@C1@C2䎊@C1s@C2n@C3a@O@C4*0@C4!-w@C4D@C4Ʌoi@C5[@C5@C6 ѷY@C62X@C8:~ @C9@C:u%F@C:Ov`@C:T`d@C;=K^@C<hr@C=@C>Ov_@C>4K@C>;5X@C>Ϫ͟@C>m\@C>_ح@C=ᰉ@C>R<6@C>-@C?Ft@C?@C@҈p@CATɅo@CA@CAu@CA.H@CCu%@CDSMj@CDɅoi@CE?|h@CE,=@CFs@CF&I@CFx@CG_o@CHH@CH@CH\)@CI|Q@CJs@CJ@CK*0U2@CKa@@CK%2@CLߤ@@CLVϪ@CLtSM@CM+a@CMݗ@CM(@CNzG@CMڹZ@CMp
=@CM+j@CMS@CM
qv@CMC\@CNT@CO;dZ@COH˒:@CO/V@CPF]d@CPQ@CQs@CRM@CRGE85@CR6C@CRn@CQlD@CR	 @CROv`@CRu%F
@CR{m@CR<64@CR74@CS'/@CRm\@CSI^@CS@N@CSQ@CSQ@CT(\@CT?@CT>B[@CU*0@CU!R@CUn/@CU8Y@CU?@CV$t@CWFt@CW!-w1@CWAs@CWRT`e@CWiDg8@CW#@CXQ@CX`A7@CYXbM@CY@CY7Kƨ@CYu!S@CY*0U2a@CYrGE@CX	k@CXe+@CXD@CXIQ@CX|@CX)@CX@CX@@CX'RT`@CX@CXA7K@CX4m9@CW-@CW@CW&@CWO
M@CW_o@CWy@CW&@CWzH@CW;dZ@CWVϫ@CW@@CWzH@CWݗ+@CWiDg8@CWkP@CW@CW[W>@CW͞@CWkP@CW4m@CWeں@CWRT`e@CW;dZ@CW$tS@CW!-w1@CW>6z@CWO
M@CWXe,@CWO
M@CWAs@CW>6z@CW$tS@CWv@CW$tS@CW+I@CWH˒:@CWRT`e@CWH˒:@CW\(@CW͞@CX ě@CXbM@CX
(@CX$tT@CYrGE@CY@CY@N@CY#w@CY7KƧ@CYA [@CYTɅo@CYe+a@CYk~(@CYrGE8@CYu!S@CY|Q@CYb}@CY~($@CY'R@CY2W@CY"`@CYY}@CY@CY"`@CYiB@CY>BZ@CYs@CY>BZ@CY>BZ@CYiB@CY@CY'RTa@CY(@CYy@CY@CY"`@CY^5?}@CY@CY@CYlD@CZ#9@CZ-V@CZ6C@CZGE85@CY_o@CY@CYe@CZ@CZ1'@CZs@CZI^5@CZn@CZ-V@CZ0
@CZ0
@CZ@4@CZd7@CZnO@CZnO@CZu%F
@CZ{m@CZ@4@CZ@4@CZ{m@CZh	ԕ@CZQ_@CZ1'@CY-@CY^5?}@CYe+a@CYN;5@CYA [@CY4J@CY-w1@CY*0U2a@CY&x@CY-w1@CYA [@CYDg8~@CYQ@CYXbM@CYk~(@CY@CY~($@CY(@CY|@CYiB@CYs@CYlD@CZ@CZJL@CZM@CZu%F
@CZ@4@CZS&@CZvȴ@CZS&@CZ ě@CZ,<@CZfB@CZ74@CZD@CZ䎊q@CZfB@CZ䎊q@CZD@C[u%@C[҉@C[)^	@C[/V@C[F]c@C[]cA@C[g	l@C[a@N@C[]cA@C[]cA@C[MjO@C[P{@C[jf@C[Mj@C[@C[*0U2@C[a@O@C[
=p@C[
=p@C[ݗ+k@C[A [@C[\N@C\9XbN@C\cA \@C\tSM@C\wkP@C\tSM@C\tSM@C\o h@C\#@C\C@C\*1@C\O
M@C\#x@C\?@C\@C\@C\@C\@C\@C\?@C\j~@C\zxl"@C\?@C\?@C\#@C\C@C\?@C\~($x@C\q@C\q@C\q@C\tSM@C\zG@C\tSM@C\tSM@C\tSM@C\tSM@C\wkP@C\o h@C\O
M@C\j~@C\Z@C\E@C]'0@C]K]@C]:@C\JM@C\Z@C\>B[@C\u"@C\>B[@C\*0@C\#x@C\zxl"@C\zG@C\j~#@C\Z1@C\?@C\/{J#@C\!-w2@C\L_@C\@C\ߤ@@C\xF@C\xF@C\xF@C\1&y@C\1&y@C\1&y@C\1&y@C\J@C\1&y@C[\N@C[\N@C[\N@C[A [@C[C]@C[g@C[g@C[g@C[%2@C[lC@C[lC@C[lC@C[lC@C[lC@C[%2@C[%2@C[%2@C[҈@C[҈@C[ݗ+k@C[Q@C[Q@C[
=p@C[|@C[5Xy@C[@C[@C[@C[a@O@C[6@C[Z@C[Z@C[~($@C[~($@C[E@C[q@C[q@C[*0U2@C[*0U2@C[wk@C[wk@C[U=@C[U=@C[ߤ@C[A@C[$@C[$@C[A@C[$@C[q@C[Q@C[@C[tj~@C[n.3@C[dZ@C[dZ@C[]cA@C[a@N@C[Z@C[S@C[MjO@C[J#9@C[F]c@C[=K^@C[33333@C[,zxl@C[,zxl@C[)^	@C[&@C["`B@C[C,z@C[PH@C[PH@C[҉@CZm\@CZ74@CZD@CZm@CZc	@CZC,@CZ䎊q@CZG{@CZڹY@CZsP@CZ͞&@CZW@CZ@CZ<64@CZg	@CZ}Vm@CZ ě@CZ@CZL/{@CZwkQ@CZ0
@CZᰊ@CZL_@CZݘ@CZ~"@CZqiC@CZkP|@CZh	ԕ@CZd7@CZZc@CZT`d@CZM@CZC\@CZC\@CZ=p
@CZ3@CZ3@CZ)y@CZ#9@CZ1'@CZ@CZI^5@CZu%F@CYY}@CY@CY>BZ@CYiB@CY"`@CYԕ*@CYy@CY@CYX@CY'R@CY'R@CY'R@CY'R@CYl@CYn.@CY@CY@CY7Kƨ@CY@CYb}@CYu!S@CYk~(@CYhr @CYae@CY[W>6@CYTɅo@CYGz@CY:S@CY-w1@CY [7@CY_p@CY@N@CY@CY@CX$tT@CY ѷ@CY ѷ@CX$tT@CX\)@CXe+@CXF@CX4m@CX-
@CX'RT@CX|@CXeO@CXU2a|@CXH@CXD*@CX>BZc@CX4m9@CX1&x@CX-
q@CX$xG@CX@CXbM@CX	ԕ+@CW#@CW-@CW@CW;dZ@CW˒:)@CW3@CWkP@CW	@CWlC@CWRT`e@CW+I@CW'/W@CW!-w1@CW,@CWXe@CW@CVFs@CVMj@CVFs@CV@CVA@CV2X@CV$t@CVz@CViB@CVR<6@CV+jg@CV4K@CV_o @CU,=@CUcA @CUH˒@CUsh@CUXy=@CUv@CU%@CU}H@CU\@CUB@CUQ@CUQ@CU'0@CT֡a@CTS@CT~($x@CTq@CTtSM@CT`d@CT<쿱@CT%1@CT(\@CTߤ@@CT1&y@CTJ@CS\N@CS@CSm]@CSU=@CSeO@CS@CStj~@CS]cA@CSS@CSC%@CS@N@CS6z@CS)^	@CS"`B@CSnP@CSI^@CRsP@CRW@CR@CRn@CRL/{@CRL_@CR@4@CR{m@CRu%F
@CRnO@CRd7@CR^5?|@CRT`d@CRW'@CRJL@CRC\@CR:)y@CR&IR@CQ@CQ2W@CQ2W@CQ@CQ|Q@CQN;5@CQ7KƧ@CQ	k~@CP	k@CPC@CPD@CP9Xb@CPu!@CP@COrGE9@CO#@CO䎊r@CO;dZ@COK]d@COo @COr@CO&@CO-V@CO	k                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              @i@)@ioiD@i䎊@j#@jBj~@jA%F
L@jD$tT@jUrGE8@jn6C@jz-
@jlcA \@jJ@kdZ@k2L/{@k}ߤ@kvF]d@kz_o @k͞@ka@@l6U@m]cA@n=K@n}%@nԕ*@oAJE@on/@oTYJ@o0
@o
L/@o}H@o@o!-w1@oeO@o?@oe+@pO
M@pM1&y@p|Q@pqj~#@pQE84@p>/{J#@p2@pC]@oFs@o힃%@oF@onP@ox:~ @o1'/W@o$nO@oL@oPY@o7q@o(>BZc@o4J@n2W@nC#@nxF@nQ@m/V@m1&@mԕ*@mؑN;@mʕᰊ@ms@m4m@mҮ}Vl@mx@mD@mJM@mq@mN|@mG&@m!(@lّhr!@lB@lm[@lk&@lfxF@lX ě@lR<6@ko i@kdϪ͟@k9@k;+@kQ@jGE85@jݘ@jD@jTɅ@j}%2@jm2a|@j8bM@i ѷY@iL_@iU2a|@i0
)@i<쿱@i(@iFs@i$/@iO
M@i}Vl@iuO;d@id/@i+S@i@ioiD@hԕ*@h     @h5?|@iN;5@hu%F@h+jg@i |@i u!@iGz@i!6@hfB@h`A@hVϫ@im]@i}Vl@i E@hwkP@h8}H@hJL@hݗ+k@h(@h@hv_ح@hU=@hS&@hXe,@h	 @h@h@h*0U2a@h@hᰉ@h;5X@hU2a|@hA7K@h?@hM:@hF@hk	@hoH˒:@hv6C@hfC,@h^$t@hLy=c@hE{J#9@h8e@h)q@h+
=p@h-˒:)@hLW'@hT6z@hBO;@h/@h0~"@h"@h@h%U=@h&9Xb@htSM@h+jg@hC\@g@h ě@gg	l@gFs@gP{@g߾vȴ9@g [7@gƸQ@g6C@g6@gڹ@g7@gy@g>B[@gbM@gtj@gL_@g>B@gS@gO
M@g֡a@gqj@goiDg@g{J#9@g}Vl@gVu@g#@gtp:@gn	k@gl-
q@gfwkQ@g|,<@gsv@g\u"@gq|@gtxl"h
@gbh	ԕ@gf-
@g`PH@gI\(@g.e@g4n@g<sP@gJ@g?-V@g*@g!u%@g0Ov_خ@g*ߤ?@g>BZ@g+@gqu!@g64@gk~(@gxl"h
@g/V@f=p
@g$@g+jg@gu%F@gm8@g ѷ@g33333@g C,@gϪ͟@g	Dg8~@g
L/{@g	As@g"`B@gL_@gL/{J@fY}@grGE@g
IQ@gq@ftj@f\(@f9Xb@fzxl"h@f@f{@fݘ@fFs@f-
q@fW>6z@fs@f@f\@fy=c@f-@f@fu!S@f-
@f hۋ@fꍸ@f(@fa@O@f	 @fz@f[@f=b@fK]c@fխB@f+I@fF@fD*@fN;6@f{J#9@fեv@fO;dZ@f1&y@f#9@f$/@fKƧ@f|@fuK]d@fr Ĝ@fVu@fqiC@f~Q@f~$@frE@fbR<6@fw'/W@f'0@fqA@fg
qv@fua@O@f{P{@fn`A@f`C@fes@f`JM@fY!.@fW/w@f`@fj쿱[@ferGE@fi9@fi84֡@ffqiC@f_b}@f_b}@ffp:~@f`G{@f_}H@fMo hی@fMo hی@f_|Q@fcv@f_zxl"h@f@C,@f9-@fFxl"h
@f9@f>"h	ԕ@fP.2@f>}H@f>}H@f.F@f%C,z@f073@f2m\@fJu%F@f&}Vl@e-@eE@ePH@e$tS@f@4n@f@4n@f@4n@f
x@f	N;5@fzG@fwk@f#@f0.2@f7 [7@f, ѷY@f7qu"@fN?@fMQ@fN'@fP@fI%F
L@fB3@f>	 @f+C\@fOv`@fR@fR@f#?@fg@f	?|h@fxl"h
@e@eH˒@evȴ9X@es@e'RTa@eߒ:)z@e؟vȴ@e@efffff@e͂@esP@eQ@ebM@eIQ@eH˒:@e^5?}@eIQ@e+jg@e ѷY@e1'@e84֡@eF
L0@eT`d@e*0U2@e-@e'/W@eDg8~@e
qv@e~Q@es5Xy>@ez'RT`@ex7@em(@epl!-@epl"h	@eqϪ͞@ew\@e{ݗ@ez#9@emwk@ea"`B@e_vȴ9@e[@eXt@eT-
@eVF]d@eVu%F@eI@ePs@eS:S@eLH@eMU=@ePqiC@eETɅo@e?Ƨ@eO@eZ($x@eQ@eES&@eH6@e<E@e?o @eO'0@e4-@e/_p@eH@eI{J#9@e<>@e4zxl"@e6	 @eA%F
L@eEO;dZ@e>]ce@e<"@eEO
M@e61&y@e0z@e"ᰊ@e--V@eA#w@e?H˒@e4S&@en.@e?@e8t@e;@e0vȴ9X@e)Q@e)M:@e	k@e	k@e#+j@e&<64@e1b@e&j~@e%@e
D@e	@e
Mj@eH˒:@e	o@e@e ѷY@e*0@e
m@e
@e
m@e8}H@eS@e
@e
@e7KƧ@e(\@e	q@e	q@eěT@dXy=@dC\@e0
@e&IR@e&IR@e4J@e4J@e	7Kƨ@e4J@d|@du%@e33333@e	eO@eOv_خ@e@d@4n@d/@e$xG@e@e
-V@d/@e1@e\(@d?@d#w@dwk@e@eFs@dwk@d@e/V@e!.@e
(@e!.@e/w@do i@eJL@eu%F
@e.H@du!S@d'RTa@d@e!-w2@e$t@dU@dtj~@dD@d ѷ@eW>6z@eE@e-
@e\(@e䎊r@d:@du@e#x@eGE85@eqiC@eԕ*@eq@e@dd8@dƧ@ea@@e
*0U2@e@eE@e@eq@e
&@e0
@e@e#@e7@e4֡a@e	@e7@elD@e&IR@e	@e!Xe@e4J@e
S@e
S@eBZc @d~@e
v@e]cA@e33333@em]@e%A [@e]cA@eC\@e%@N@e#?@e![@e[W?@e-@e(n@e'R@e*1@eM:@e%>6z@e!@e*t@e4?@e!@N@e0
)@e/V@e"vȴ9X@e0Z1@e:@e)g	l@e&-
@e%=K^@eM:@e!u@e0Xy=@e7J#9@e%<64@e(u%F@e-hr!@e&쿱[@e1/V@e?%@e4@4@e-@e.!-w@e-@e4@4@eBd7@e<֡a@e:@e<Ϫ͟@e?u@e7Gz@e,+jg@e;rGE8@eE+I@e:ߤ@@eBc	@e@$tT@eCƧ@eGA [@eBc	@eE)^	@eJ4m@eQ*0U2@eTp:~@eE)^	@eGoiDg@eJ4m@e@m\@e@m\@eM}H@eIS&@eQXy=@e_ڹZ@e_ڹZ@eQ(@eLtj@eQ(@eUN;6@eUN;6@e_	@e^&IR@e\7@eS
=p@eYs@e`쿱[W@eYs@eXO;@e[^@eXO;@e[^@ecm]@el1&y@eUϪ͞@ebOv_خ@ej
=q@euH˒@exF]@euH˒@en͞&@efwkP@en@eyrG@ere@eg@eln@etZc@euvȴ9@etZc@e|O
M@e~@elt@e{JE@e!-w2@e@e`A7@eE@eeO@e%@e+a@e@@e ѷY@eU=@e}H@e:)y@e:)y@eU=@e     @e
M;@eb}V@e?@el@ep:~@eڹ@e4֡b@exF@e!.I@e($x@e($x@eDg8~@eDg8~@e'/W@e!.I@eDg8~@e($x@ec	@eC]@eA@eѷX@e&@eǥS@e~@e*0@e`A@e{m@e@e'RT@e~@ezxl"h@eu%@ezxl"h@e>@e@ezxl"h@e\@e/@eK]@e@ey@eO
M@eK]@eK]@e@4n@e@4n@eK]@eΕᰊ@eٱ[W>@e#9@eiB@eL_@e"h	ԕ@eٰ'R@eՅQ@e@N@e/{J#@e=b@et@eQ@ehr @e.2@eJ#9@eF]d@ehr!@en@ehr!@e	@efA@eD@eu%F
@ehr!@e-
q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ?qu!S?l"h	ԕ?*0?GE84?[W>6z?tj~?ěS?U=K?}H?A7Kƨ?BZc?SMj??TɅoi?$?
(?u!R?9D?xF]?'0?d7?r ě?ݗ+?ae?S&?qu!S?Vu?C\N?y(?ݗ+k?_Ft?-V?Xy=c?%?n?hr ?+J?xF?cA [?\(\?0
(?͞&?C?H˒:*?F]c?\N;?!-w1?_o?]cA ?64K?6?h	ԕ+?5Xy>?64K?(\)???/{J#:?Ǥ??ƻA?Ʈ}Vl?+jg?Ȱ{?|Q?^5?|?Ȍ?*0
?a@N?ݗ+j?wkP?8YJ?+?sPH?[?*0?Vu? [6?4֡a???E?ȴ9Xb?vȴ?Vu?!.H?lC?۴3?.H?!.I?PH?݂?m?4m8?޳g	l?ۃ{J#9?ې?rGE85?\(\?+???׍O;dZ?,<?1o?١o?.2X?؝IQ?xF]d?oiDg8?l"h	ԕ?Ӝߤ@?ӗ$tS?Fs?k~($?Қ,<?ҀIQ?"`B?S?kP{?1&x?-
qv?u!?И_F?Ov_ح?]ce?u%F
?˅Q?ˋq?F]cf?Fs?c	?S?#x?.2X?˒:)?eں?m\?}H˒?A [?é*0U2a?Á?5Xy>?lC?cA [?K]d?C,zxl?ݗ?u!.??
qu"?Vl!-?D?BZc?-
qv?fA?֡af?Xe,?m8Y?As?fA?֡af?'/?n?cA \?Ov_ح?a@N?m\?u!R?l?8YJ?_Ft?<64?8YJ?sg?Z?nO;?nO;?)^	?xPH?x*0
?v?Q_??tj~?D*0?>B?$/?*0?-V?q4J?vOv_خ?xtj~?Mj?Fs?u%F
?ɅoiD?u"F?UL_?wkP?u!?n/?cA \?bM@bM        ?nO;?~Q??v+I?y_o ?	 ?zG{?ᰉ'?qu!S?C,zxl?n/?6?N;6?+I?L_?fA?*0U2?xPH?s*0U2a?$/?n/?ku%F?zvȴ9?+ItZ?tZ?},<?},<?hr Ĝ?$tSM?v+I?u%?JD?IQ?*0?_!-w1?x*0
??},<?{Q_?bM?Z?Zݘ?}Z?Mj?=K^?$tSM?U=?nOv_ح?j6C-?%2?ɅoiD?u%F?6C-?tn?)^	?dzG{_!-w1?xPH?|C,zxl?tzG{?rsPH`bM?҈?4J?}}H˒?vȴ9X?$/?vOv_خ?u%?_o ?6C-?dzG{?Z?|C,zxl?u"?-
qv?n/??usgl1&yrnO;l1&y?tzG{?$tS?sgZ6C-?vȴ9X?e+a?eL_?Z6C-?dzG{p)^	?bsPH?Mj?|1&y?䎊r?C,zxl?wkP?ݗ+j?v?}Z?vOv_خbsPH?o!-w1?}Z?6C-?Z?1&y?N;5?-
qv?q4Jqu"?p)^	?sg?sPH?䎊q޿bn/x*0
tZ?nOv_ح?D*0?zG{?xtj~m}H˒?ku%F?z6C-??sg?fA??vȴ9X?=K]?vOv_خ?{Q_?1&y?$tSM?qu!S?N;5X?@NU?vȴ9X?!-w1?|1&y?~Ov_ح?Fs?zG{?bM?Mj?bM?+?sg?Mj?qu!S?ye+a?s@NU?v+I??=K^?Ϫ͞?Ov_ح?_o ?$/?&?|C,zxl?{u%F?<64?4J?}Z?p)^	?v+I?kP{?j6C-?V?m}H˒?tzG{?rnO;?sPH?u%F?rnO;?bM?lXtj~?rnO;?bM?MjZ6C-?bn/?ye+anOv_حj6C-?c*0U2a?H?+jg?,<?usg?$tS?vȴ9o䎊q?4J?Z?+a4J?u%?=K^?,<쿱ku%F?qu"`bM3*0U2a?F?:6C-?htj~?M}H˒?@?u%F[Q_?{Q_?q4JZ6C-?,<쿱?,<쿱?zvȴ9p)^	?!-w1?u"?1&?z6C-?$tS?C,zxl?%2?pbM?UL_?ie+a_!-w1?*0
? ѷX?>BZc?Zo䎊q޿p)^	?-VF?v?$?_o c*0U2a?f?ߤ??tzG{?S&?0
(?`A7L?{qu!S?_!-w1ſrn/V?ɅoiD?fA?Mjj6C-p)^	?N;5?*0U2a?-
qv?s@NU?m}H˒?s@NU?tzG{?g?zG{?-V?usg?v+I?A?*0U2v+I?gf?tj~?nO;?x*0
?vȴ9?e+?*0
?n?v?v?bM?sg?u%FJ6C-?~Ov_ح?v+I?[Q_qu"?rsPH?tj?sPH?vOv_خ?v?_o ?!-w1ſa4JF?fA?e+?sg?࿀₿htj~?pbM?dzG{?s*0U2agrsPH?ye+a?u"?ݗ+j?䎊q?v+I*6C-?m}H˒?m}H˒?v?tn?nOv_ح?nOv_ح?u!?e+a?PbMku%F?JD?E?p:?wXe+?x*0
?xtj~?rsPH?pbM?u"?sPH?3*0U2a?	 ?₿c*0U2a?R<64?$/?ᰉ'?$/?sPH?:)y?+?n?|C,zxl?vOv_خ?n/?ɅoiD?Rn/?J6C-?xtj~?x*0
?Z6C-tzG{?p)^	?qu!S?O
M?ɅoiD?f?g?wXe+?usg?vOv_خ?_o?$tS?o䎊q?)^	?FseL_wXe+?`bM?,<?vȴ9?rnO;?$tSM?ye+azvȴ9䎊q޿v+I?s*0U2a?A?hr Ĝ?o䎊q?wXe+?usg?{qu!S?w?nOv_ح?}}H˒?Xe?L_?@?s@NUp)^	?6C-?rsPH?o!-w1?bM?nO;?x*0
?UL_},<xPH?%2q4JtzG{?m}H˒?hr Ĝ?hr Ĝ?xPHfOv_خs@NU-
qvC*0U2a?*6C-?`bM?IQ?c*0U2a?*0?L_?*0?tj~?y=b?ݗ+j?v+I?vOv_خ?v?H?@?:6C-?3*0U2a?m}H˒?tzG{?xPH?n?n?)^	g?䎊rie+a?U=Kqu"??4J?zvȴ9?H?ku%F?O
M?wkP?S*0U2a?usg?vȴ9X?gRn/?n?S&?~Q?sPH?$tS?v?|1&ypbM?0
(?O
M?v+I?U=K?$/?Ϫ͞?,<?Rn/?C*0U2a?sPH?tzG{?V?0
(q4J?tZ?v+I?vȴ9X?$/?Aj6C-?S*0U2a?s*0U2a?q4JPbM?j6C-?bM?1&y?qu"?o䎊q?|C,zxl?䎊q?kP{?y_o xtj~?usg?m}H˒?S&¿tZ?s*0U2a?,<?n/?Xe+?qu"?Z?|1&y?xtj~?0
(ie+a?pbM?u!?s*0U2a]}H˒V?w?xtj~3*0U2a?,<쿱?Ϫ͞?UL_?Q_?{Q_?Av+I?nOv_حrnO;S*0U2a?v+I?{Q_?:6C-?u"?F?}Z?S&?2a|Q?%2?,<a4J?tzG{?xPH?!-w1?|1&y?Rn/?쿱[W??!-w1?{qu!S?z6C-?ɅoiD?	 ?bsPH?_o?{qu!S                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ???????????????????????????????????????????????????????????????????????????????????????????ə????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????ə?ə??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              &B(zAff35h14                                      1                                       