CDF       
      time      pressure     latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        11     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:17.913223Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_011 (11) * LATITUDE: 41.380000 * LONGITUDE: 10.250000 * DATE/TIME: 2016-08-21T13:25:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
   WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @          data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      (  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
8  O   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*;5X   data_max      @8m]   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       (  Z(   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
8     salinity               	long_name         salinity   units         PSS-78     data_min      @C(A7K   data_max      @C\S   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      (  @   salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
8      oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @d˒:*   data_max      @qI^5?   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        (  X   	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
8  8   CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?)   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      (  p   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
8 P   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?ə   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     ( &   CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d      
8 Oh   time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &   data_max      &   C_format      %10d       Y   latitude               	long_name         latitude   units         	degrees_N      data_min      @D
=q   data_max      @D
=q   C_format      %9.4f          Y   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @$        data_max      @$        C_format      %9.4f          Y   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      35   data_max      35   C_format      %8d        Y   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min        -   data_max        -   C_format      %4d        Y   station                	long_name         STATION    units         unspecified    C_format      %s        ( Y   cast               	long_name         CAST   units         unspecified    C_format      %s        ( Y@       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @8m]@8BZc @7}Vl@7ᰉ'@7Ov`@7o hی@7XbM@7P-
@73S&@6I^5?@64m9@6$@52m@4Q@2ěT@1ȧ@1V,<@1
M;@0C\@0iDg8@0"a|Q@/zG@/`A7@/|PH@/Z@/ u!@.ۋq@.ĨTɆ@.ݗ+k@.s@._@.8e+@-⩓@-|hs@-`A@-t*1@-l@-dM:@-_$tS@-TzG@-Hu%F@-F@-A@-=v@-=ڹZ@-C9@-RS&@-e+a@-t֡a@-R<6@-lC@-a@@-L/{@-+a@-{6@-]!.H@-PH@-@4m9@-8@@-7eں@-0)^@-$xF@-73@-s@-	 ѷ@,=b@,t@,	 @,r Ĝ@,ڹ@,.H@,
qu@,;dZ@,iB@,(\@,@,_ح@,ڹY@,@,oiDg@,x@,qiC@,jf@,6z@,I^@,ڹY@,]cA@,U=@,E84@,M@,[@,Љ'RT@,I^@,ȧ@,F]c@,vȴ9@,$/@,d8@,n@,-
@,C@,'R@,9@,?@,:S@,IQ@,e@,K]c@,ѷX@,cA \@,Ȍ@,>BZc@,Ǡ	k@,x@,Ƨ-@,,@,ĵ?@,-
@,ڹZ@,qu!@,*0@,rG@,&@,Ϫ͟@,4K@,Ϫ͞@,%F
L@,`d@,䎊q@,Q@,A@,+jg@,!-w2@,<64@,X@,H@,v@,v@,v@,O;@,H@,(@,C@,͞&@,L/{@,_o@,Z@,,zxl@,,<@,@,L_@,C]@,O;dZ@,s@,ۋq
@,rGE@,B@,rGE@,ۋq
@,@,r Ĝ@,K]c@,?@,ݗ@,\N@,{J#9@,S&@,s@,-w1@,d8@,
qu@,vȴ9@,~m\@,{m]@,z^5?|@,v+J@,sߤ@,rGE85@,q_p@,o
M;@,mU=@,n+@,o@,o@,p ě@,oVϫ@,mM:@,l@,mqu"@,n;5X@,nT@,o hۋ@,o'/W@,o-V@,o;dZ@,p:~ @,p{@,qo@,rᰊ@,tm8@,u!.@,vFs@,w
=p@,w$tS@,wrG@,xtj@,yb}@,zvȴ@,{qu!@,{S@,zvȴ@,y|@,x*0@,v@,tE@,s@N@,p
=q@,p@,p*0U@,m\@,kP{@,kC,z@,jg	@,iB@,h@,g	k@,f?@,eQ@,d%1@,c	@,bu%F
@,`u!@,_|hs@,^ߤ?@,]b@,[S@,Y"`@,WKƧ@,Stj~@,NH@,M5Xy>@,L@,L@,L[W?@,L[W?@,Lzxl"@,Lzxl"@,L_@,LC@,Lzxl"@,L_@,L~($x@,L@,MV@,MO;dZ@,Mhr!@,M8Y@,N;5X@,M@,L/{J#@,JL_@,I^5?}@,Hr Ĝ@,Gݗ+@,Ffffff@,E@,C%2@,BC,@,B}Vm@,B@,Bu%F
@,A'R@,Ao hی@,@C@,@4m9@,?|hs@,?Ft@,>쿱[W@,>҈p;@,> ѷY@,<#x@,<C,zx@,;S@,:kP|@,9~($@,7@,5sg@,3MjO@,2<64@,1hr @,0oiDg8@,0H@,0*0U@,0 ě@,0*0U@,/o @,/\(@,.Vu@,,!-w@,+Ƨ@,+jf@,+P{@,+C%@,+P{@,+)^	@,+'/@,+6z@,+P{@,+]cA@,+Q@,+U=@,+~($@,+҈@,,L_@,,I^5?@,,~($x@,,~($x@,,cA \@,,VϪ@,,L_@,+jf@,)ᰉ'@,(	ԕ+@,'	k@,'ݗ+@,'_o@,'ݗ+@,'&@,'E84@,')^@,&?@,%ڹ@,&1.@,&]cf@,%zxl"h@,%@,%@,&1.@,&fffff@,&@,%ڹ@,%@,%m\@,%`A7L@,%ڹ@,&1.@,&YJ@,&?@,%S&@,#$@,"}Vm@,!e@,      @,u@,#x@,N;@,?@,PH@,n.@,m]@,dZ@,J#9@,/V@,u%@,u%@,/V@,/V@,J#9@,W>6z@,W>6z@,W>6z@,~@,c	@,c	@,~@,s@,s@,>B@,vȴ@,"`@,|@,*0@,!R@,֡a@,R@,)^@,{@,bM@,-V@,O
M@,\(@,@,@,
M;@,
w1@,:)z@,
d7@,	ᰉ'@,	ᰉ'@,	y@,@,@,Z@,@,$/@, 'RT`@, 6@+˒:)@+?@+o@+"@+m\@+,=@++j@+ڹZ@+Vl!@+?@+j~#@+ߤ@@+n.@+S@+q@+~$@+~@+C\@+~($@+)@+_F@++@+kP@+O;d@+O;d@+4m@+eں@+!.I@+z@+t@+?|h@+j~@+*1@+O
M@+j~@+,<@+䎊q@+hr @+U2a|@+v@+zxl"@+Ƨ@+jf@+=p
@+@+B@+B@+'RTa@+@+@+TɅ@+Xy=@+fA@+@+x@+@+Fs@+x@+s@+84֡@+䎊qj@+Z1@+2W@+\N@+eO@+S&@+S&@+ ѷ@+@4n@+R<6@+|Q@+ae@+C@+A7K@+     @+ߤ?@+ߤ?@+b}V@+@+쿱[W@+m\@+iB@+IQ@+ܑN;@+wkP@+C,zx@+PH@+]ce@+۲m]@+ڬ>B@+ٙ@+PH@+F]d@+׀4m@+1@+z@+t@+!.@+!.@+!.@+ᰉ@+Ϫ͞@+՛=K@+sg@+2a|@+֡a@+ӎMj@+Ұ ě@+T`d@+n@+iB@+@+H@+σ{J#:@+v@+
M;@+ξߤ?@+zG@+
qv@+͞%@+͞%@+͑hr!@+w1@+5Xy>@+V@+̥zxl"@+L_@+L_@+҈@+ˬq@+)^	@+0U2a|@+*0U2a@+ ѷ@+TɅ@+@+RT`e@+@+Ƶ'@+ƀIQ@+/@+%1@+{J#9@+@4@+n.@+A7K@+
qu@+?@+˒:)@+vȴ9X@+(\@+=K^@+)_@+ݘ@+Q_@+#w@+}H@+&@+KƧ@+Ϫ͟@+$/@+SMj@+*0U2@+Z@+ ě@+l@+D@+v_ح@+5Xy>@+"h	ԕ@+:)z@+jf@+]cA@+D@+g	@+d7@+Q@+@@+ݗ+@++I@+&I@+YJ@+fffff@+oiDg@+zxl"h@+o i@+TɆ@+S@+o h@+@+@+@4n@+|Q@+Gz@+'RT`@+҈p;@+}H@+#x@+(\@+qu!@+C\@+rGE8@+73@+kP@+sPH@+
=p@+l!-@+sh@+Ʌoi@+`d@+m@+:)y@+N;6@+bM@+Vϫ@+o @+-V@+qi@+zG@+%@+(@+@+C@+<쿱@+1&y@+҈@+Q@+6z@+L/{@+d7@+^@+@+-@+#@+fA@+$/@+m\@+7@+M:@+{J#9@+S&@+74@+s@+NU@+~쿱[W@+~m\@+~iB@+}/w@+|?@+{Q@+zY@+yJE@+xD*@+wrG@+w4m@+w1@+vȴ9X@+vaf@+vz@+vR<6@+uXy=@+vOv_@+uᰉ@+uY|@+u2a|@+u2a|@+u?|h@+tZ@+sE@+sPH@+s@N@+sZ@+sZ@+s&@+rsP@+rs@+q&x@+pD@+p'RT@+poiDg8@+o@+oAs@+nMj@+n;5X@+m(@+m@+m\@+l!-w@+l@+jfB@+iQ@+i@+irGE@+g@+en/@+eu@+d/@+d?@+dM:@+dtj@+cA [@+cwk@+c9@+c9@+cnP@+bZc@+a7Kƨ@+`҈p@+`4m@+`4m@+`-
@+`u!@+`hۋq@+`     @+_?@+_|hs@+_!-w1@+^Q@+^$t@+^Ov_خ@+]b@+\n.@+[lC@+Z~@+YJE@+X*0@+W@+W@+WO;d@+W4m@+WO;d@+WO;d@+W4m@+WKƧ@+U!.@+U!.@+U2a|@+TzG@+SZ@+RT`d@+Qu@+Q@+P@+O@+O\(@+O͞@+O'/W@+N}Vl@+NT@+N+@+Nߤ?@+N;5X@+MC\@+NzG@+M8Y@+MjOv@+MU=@+Mhr!@+MU=@+M@+MB@+L!-w@+L_@+Lq@+LVϪ@+L1&y@+K҈@+K:)z@+K6z@+Jg	@+Jd7@+JL_@+JL_@+Jd7@+JqiC@+JL_@+J0
@+Jg	@+JD@+KC,z@+K~($@+L1&y@+LVϪ@+Lq@+L_@+L~($x@+LVϪ@+LVϪ@+Lq@+K]cA@+K'/@+JD@+JfB@+JL_@+JJL@+JOv`@+Iᰉ'@+I^@+H@+HeO@+H$xG@+H$xG@+G#@+GK]d@+GlC@+G&@+G	k@+G)^@+F'@+F,<@+EoiDg@+E1@+EQ@+D*0@+D2W@+C@+B@+Bh	ԕ@+BM@+B&IR@+B&IR@+Be+@+A.H@+As@+BI^5@+A@+@d8@+@6@+??@+?|hs@+?.H@+>ߤ?@+>$t@+=E@+=ce@+=p
=@+=+j@+=ڹZ@+=IQ@+=<64@+=<64@+=[@+<j~#@+<Q@+<n.@+;lC@+;s@+:u%F@+9Y}@+:@+9~($@+8F@+8@@+8)@+8D*@+7
=p@+6C-@+7
=p@+68YJ@+64K@+5$/@+5%F
L@+52a|@+5Y|@+5%F
L@+5%F
L@+4J@+3E@+3g	l@+3MjO@+3@+3Z@+2p:@+12W@+1_p@+0'RT@+0bM@+0|@+/{J#:@+.O;@+-
qv@+-
qv@+-@+-jOv@++҈@++Ƨ@++a@@++҈@++҈@++~($@++C,z@+*D@+*D@+*ڹY@+*0
@+*~"@+*0
@+*~"@+*W'@+*Ov`@+*0U2a|@+*=p
@+*JL@+*0U2a|@+*	 @+)y@+)@+)Dg8~@+)Dg8~@+)Dg8~@+)*0U2a@+(@+'K]d@+'lC@+'RT`e@+'8}H@+&x@+&,<@+&'@+&'@+&&I@+&'@+&-@+%ڹ@+%1@+%zxl"h@+$e@+$xF@+#$@+#a@N@+#{J#9@+#F]c@+#S&@+"`A@+"\(@+!.H@+!@+!R<6@+ C@+@+|hs@+;dZ@+"@+!-w1@+.H@+.H@+.H@+҈p;@+6z@+iB@+\N<@+,=@+/w@+?@+$@+u%@+c	@+,<@+Y@+ݘ@+|@+_F@+@+1@+z@++jg@+!R@+E@+m8@+`d@+J@+a@O@+tj~@+PH@+䎊q@+䎊q@+n@+o@+D@+)^@+{@+H@+ hۋ@+p:~@+H@+!R<@+
8Y@+
jOv@+a@@+C,z@+
W'@+
d7@+
=p
@+	lD@+	ᰉ'@+	^5?}@+	Dg8~@+r Ĝ@+@+-@+zH@+K]d@+&@+8}H@+,@+x@+x@+&I@+s@+fffff@+s@+IQ@+,<@+s@+
L/@+oiDg@+S@+ݗ@+Q@+/@+e@+TɆ@+Z1@+tj@+xF@+@+
=p@+
=p@+wk@+$@+wk@+Z@+@+
=p@+
=p@+@+@+S@+wkQ@+'R@+n.@+TɅo@+@N@+@N@+@N@+Gz@+ae@+:S@+ ѷX@*䎊r@*[W>@*|hs@*	@*|hs@*@*%@*iB@*u@*IQ@*[@*>@*u"@*?@*?@*?@*64@*m]@*6@*q@*~$@*~$@*J#9@*=K^@*=K^@*ݘ@*@*@@*Q@*+j@*kP@*@*+J@*z@*z@*af@*}Vl@*@*@*!.@*sg@*?|h@*3@*m8@*SMj@*9XbN@*9XbN@*,<@*9XbN@*!-w2@*Mj@*33333@*m@*҉@*sP@*p:@*n@*n@*iB@*iB@*2W@*X@*X@*u@*o@*u!S@*񂩓@*u!S@*{@*|@*'RT@*bM@*-
q@*Vϫ@*'/W@*v@*
M;@*+@*
qv@*8Y@*
qv@*@*
qv@*(@*_o @*(@*hr!@*w1@*M:@*(@*쿱[W?@*VϪ@*q@*Q@*C,z@*͞&@*g	@*g	@*g	@*͞&@*JL@*Ov`@*Ov`@*#9@*Ov`@*Ov`@*^5?}@*Q@*Dg8~@*7KƧ@* ѷ@**0U2a@*ۋq
@*@*9Xb@*1&x@*_o@*+I@*Fs@*Fs@*Fs@*E84@*	k@*/V@*zH@*_o@*x@*,<@*捸@*'@*A@*]cf@*Fs@*E84@*Fs@*YJ@*?@*@*@*@*zxl"h@*u@**0@*䎊qj@*o h@*Z1@*g8}@*xF@*㕁$@* ѷ@*ⶮ}Vm@*u%F
@*M@*M@*e+@*R<6@*TɅo@*C@*ව4m@*n@*u!@*n@*4m9@*˒:)@*҈p;@*ޫ6z@*ރ%@*ސ$t@*ރ%@*iB@*BZc @*Ov_خ@*BZc @*BZc @*5?|@*\N<@*iB@*ߤ?@*ޞ@*Ov_خ@*҈p;@*ސ$t@*ܑN;@*ܬ1&@*wkP@*Q@*W>6z@*ڟvȴ@*6C@*>BZ@*_o@*ٌ~($@*#w@*0
)@*+@*+@*	k~@*PH@*Q@*׀4m@*KƧ@*sPH@*׍O;d@*KƧ@*Xe,@*KƧ@*KƧ@*>6z@*C-@*Ϫ͟@*Ov_@*4K@*Ov_@*8YJ@*E@*_ح@*l!-@*և+J@*և+J@*Ϫ͞@*Ձ$/@*L_@*D@*%F
L@**0@**0@*`d@*!-w2@*ݗ+k@*ݗ+k@*a@O@*ө*0U2@*a@O@*|@*Z@*m\@*ҽ<64@*ҕᰊ@*{m@*R@*яo@*&x@*`A7@*о
(@*)^@*Ж@*Љ'RT@*H@*v_ح@*ΤT@*;5X@*                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @C:{m@C<m8@C<Fs@C;a@@C:m@C:Ov`@C9^5?}@C<xF@C=ce@C?,@C?@C>Fs@C9^5?}@C6!.I@C4#@C5ڹZ@C5oiDg@C58Y@C3~$@C/@C,I^5?@C)	k~@C(ѷX@C(A7K@C({@C)#w@C) [7@C(
(@C)+@C)s@C+{J#9@C*D@C+A@C,D@C-H˒@C.&I@C."@C0p:@C2:)y@C2}Vm@C4?@C5Vl!@C5-V@C58Y@C5
qv@C6x@C: ѷ@C=,=@C@-
q@CA>BZ@CBY@CC:)z@CDN;@CD@CE+a@CEϪ͞@CF$/@CF@CG.H@CGo@CH	ԕ+@CHYJ@CI_p@CIA [@CIN;5@CI(@CJnO@CK,zxl@CK]cA@CK@CLQ@CL2W@CL/{J#@CL,<@CL?@CL_@CMV@CN?@CN1@CP@CPu%F@CP{@CQk~(@CQx@CQR<6@CQo@CR3@CRkP|@CRC\@CR=p
@CRe+@CQN;6@CQ|@CQn.@CQ~($@CQs@CR6C@CR=p
@CRT`d@CR~"@CR<64@CRm\@CS@N@CSeO@CS҈@CT3@CUB@CUcA @CVߤ?@CVFs@CV,<@CV@CVO;@CVFs@CV,<@CV@CVT@CVqi@CV+J@CVz@CVl!-@CVz@CV@CV$t@CV+J@CV+J@CV}Vl@CVz@CVs@CV!R<@CUcA @CVt@CV$/@CV5?|@CV;5X@CVOv_خ@CViB@CVfffff@CViB@CVs@CVvȴ9X@CVz@CV}Vl@CV$t@CV2X@CV}Vl@CV}Vl@CVQ@CW1@CW4m@CW&@CWrG@CX:~ @CXK]c@CXA7K@CXl"h	@CX˒:*@CX˒:*@CX|@CXy=c@CXy=c@CXu!@CXoiDg8@CXy=c@CXYJ@CX@CXIQ@CX-
@CX@CXd8@CX{@CXU@CXd8@CXd8@CX-
@CX'RT@CXu!@CXy=c@CXy=c@CX|@CXYJ@CXTɅ@CX҈p@CX`A7@CY ѷ@CY [7@CY_p@CY&x@CYDg8~@CY@CY(@CY@CYD@CYԕ*@CYe@CYlD@CZs@CZGE85@CZ{m@CZ@CZc	@C[S&@C[C,z@C[&@C[J#9@C[xF]@C[$@C[m]@C[Ƨ@C[Q@C[$@C[@C[@C[lC@C[
=p@C[5Xy@C[@C\n.@C\1&y@C\xF@C\1&y@C\J@C\n.@C[s@C[@C[@C[$@C[A [@C[g@C[g@C[%2@C[
=p@C[5Xy@C[@C[Ƨ@C[~($@C[q@C[U=@C[~$@C[a@N@C[]cA@C[W>6z@C[S@C[P{@C[S@C[S@C[S@C[W>6z@C[a@N@C[q@C[6@C[҈@C[lC@C[@C[\N@C\n.@C\J@C\ߤ@@C\!-w2@C\(\@C\,<@C\,<@C\%1@C\!-w2@C\tj@C\@C\1&y@C[\N@C[\N@C[s@C[@C[$@C[$@C[A [@C[A [@C[@C[s@C[\N@C\J@C[\N@C[@C[C]@C[g@C[ݗ+k@C[|@C[6@C[|@C[
=p@C[a@@C[Ƨ@C[a@O@C[6@C[a@O@C[a@O@C[a@O@C[6@C[Z@C[Z@C[Z@C[Z@C[Z@C[6@C[a@O@C[6@C[Ƨ@C[|@C[|@C[|@C[
=p@C[a@@C[
=p@C[
=p@C[%2@C[A [@C[\N@C\J@C\ߤ@@C\Q@C\tj@C\Q@C\tj@C\L_@C\@C\L_@C\L_@C\tj@C\L_@C\L_@C\@C\ߤ@@C\xF@C\ߤ@@C\"h	ԕ@C\2W@C\(\@C\?@C\SMj@C\tSM@C\zG@C\wkP@C\tSM@C\tSM@C\wkP@C\~($x@C\N;@C\*1@C\_@C\S@C\N;@C\o h@C\~($x@C\q@C\`d@C\SMj@C\I^5?@C\I^5?@C\Fs@C\C,zx@C\C,zx@C\?@C\<쿱@C\<쿱@C\<쿱@C\C,zx@C\Fs@C\C,zx@C\C,zx@C\C,zx@C\C,zx@C\Fs@C\C,zx@C\M:@C\SMj@C\Z1@C\Z1@C\`d@C\tSM@C\zG@C\~($x@C\zG@C\tSM@C\cA \@C\Fs@C\<쿱@C\tj@C\xF@C\xF@C\xF@C\J@C\n.@C\1&y@C\ߤ@@C\ߤ@@C\xF@C[s@C[lC@C[҈@C[Q@C[Q@C[
=p@C[@C[Z@C[@C[q@C[S@C[U=@C[ߤ@C[ߤ@C[ߤ@C[A@C[ߤ@C[A@C[$@C[Mj@C[q@C[Mj@C[Q@C[eO@C[eO@C[@C[@C[~$@C[~$@C[xF]@C[qu!@C[qu!@C[g	l@C[dZ@C[dZ@C[]cA@C[]cA@C[]cA@C[Z@C[W>6z@C[W>6z@C[P{@C[J#9@C[J#9@C[C%@C[F]c@C[J#9@C[F]c@C[C%@C[=K^@C[,zxl@C[&@C[PH@C[S&@CZm\@CZm\@CZ74@CZD@CZD@CZD@CZc	@CZfB@CZ䎊q@CZG{@CZڹY@CZsP@CZ`A@CZ`A@CZ͞&@CZ`A@CZ`A@CZ)_@CZ<64@CZ}Vm@CZ ě@CZ ě@CZ>B@CZ@CZS&@CZS&@CZvȴ@CZ0
@CZ\(@CZ\(@CZp:@CZp:@CZ~"@CZxl"h
@CZu%F
@CZu%F
@CZnO@CZkP|@CZkP|@CZh	ԕ@CZa|Q@CZQ_@CZGE85@CZGE85@CZ@4n@CZ@4n@CZ@4n@CZ:)y@CZ-V@CZ#9@CZe+@CZ@CZ	 @CZ	 @CY.H@CY-@CYY}@CYY}@CYY}@CYs@CY@CY@CYR@CY>BZ@CYe@CY@CY_o@CYy@CYy@CYD@CY|@CYB@CYn.@CYu@CYu@CY@CYo@CY~($@CY~($@CY7Kƨ@CYoiD@CYb}@CYb}@CY|Q@CYx@CYrGE8@CYu!S@CYrGE8@CYrGE8@CYhr @CY^@CYQ@CYQ@CYN;5@CYDg8~@CY=b@CY7KƧ@CY4J@CY-w1@CY_p@CY@N@CY ѷ@CX	k@CXC@CXe+@CXۋq
@CXF@CXF@CXTɅ@CXU@CXu%F@CX@CX-
@CX@CXy=c@CXr Ĝ@CXhۋq@CXeO@CX_F@CXK]c@CX:~ @CX4m9@CX*0@CX$xG@CX@CX	ԕ+@CW+j@CW@CW˒:)@CWo @CW@CW/V@CW3@CW[W>@CW?@CWkP@CW&@CW{J#:@CW|hs@CWsPH@CWo@CWo@CWiDg8@CWb}V@CWXe,@CWU=@CWRT`e@CWO
M@CWAs@CW8}H@CW.H@CW!-w1@CW!-w1@CW
M;@CV!.I@CVMj@CV1@CV+@CVt@CV@CV}Vl@CV@CVO;@CV$t@CVqi@CVIQ@CVs@CViB@CVc	@CVL/{J@CVBZc @CV;5X@CV$/@CVOv_@CVu@CV@CV_o @CV ѷY@CU!.@CUoiDg@CU(@CUS@CUS@CU?@CU8YK@CUϪ͞@CUcA @CU\(@CUH˒@CU1@CU%@CU=K@CU+j@CUO
@CUzxl"h@CUsg@CUjOv@CU\@CUVl!@CUL_@CUIQ@CU84֡@CUQ@CU'0@CUV@CU:@CThr@CTZ@CTZ@CT7@CT1&@CT쿱[@CT_@CTN;@CTqj@CT?@CTo h@CT~($x@CTwkP@CTq@CTq@CTm8@CTcA \@CTcA \@CT`d@CT`d@CTVϪ@CTI^5?@CTC,zx@CTC,zx@CT?@CT?@CT<쿱@CT9XbN@CT,<@CTQ@CTtj@CT@CTߤ@@CTn.@CSs@CSA [@CSlC@CS҈@CSݗ+k@CS
=p@CS5Xy@CS@CS@CSU=@CS$@CS:)z@CSqu!@CSa@N@CSW>6z@CSS@CSP{@CSF]c@CSC%@CS=K^@CS6z@CS/V@CS/V@CS,zxl@CS"`B@CSnP@CS҉@CSu%@CSu%@CRm\@CRm\@CSI^@CRD@CRc	@CRC,@CRfB@CR ѷ@CRڹY@CR,<@CR)_@CR ě@CR ě@CRvȴ@CRp:@CRu%F
@CRnO@CRkP|@CRd7@CRd7@CRa|Q@CR^5?|@CRa|Q@CRZc@CRGE85@CR@4n@CR:)y@CR)y@CRe+@CR	 @CRu%F@CQlD@CQR@CQiB@CQ@CQiB@CQN;6@CQy@CQy@CQy@CQy@CQD@CQX@CQX@CQB@CQl@CQB@CQl@CQl@CQl@CQn.@CQu@CQR<6@CQ@CQo@CQ7Kƨ@CQ@CQ@CQx@CQo hی@CQo hی@CQrGE8@CQk~(@CQk~(@CQk~(@CQk~(@CQk~(@CQo hی@CQo hی@CQu!S@CQ@CQoiD@CQ~($@CQo@CQo@CQo@CQ~($@CQ7Kƨ@CQ~($@CQ|Q@CQx@CQrGE8@CQrGE8@CQk~(@CQe+a@CQae@CQ^@CQXbM@CQJE@CQDg8~@CQA [@CQ=b@CQ=b@CQ4J@CQ0
)@CQ0
)@CQ0
)@CQ&x@CQ#w@CQ_p@CQ+@CQrGE@CQ ѷ@CQ ѷ@CP	k@CPC@CPۋq
@CPD@CPѷX@CPp:@CP)^@CP@@CPěT@CPTɅ@CPTɅ@CP
(@CPU@CP
=q@CPu%F@CPu%F@CP@CP'RT@CPn@CPu!@CPr Ĝ@CPoiDg8@CPr Ĝ@CPoiDg8@CPeO@CPhۋq@CP_F@CP_F@CPQ@CPQ@CPK]c@CPH@CP>BZc@CP-
q@CP*0@CP*0@CP}H@CP*0U@CP*0U@CPbM@CP@CO䎊r@CO䎊r@CO䎊r@CO;dZ@CO;dZ@CO@CO+@CO˒:)@CO˒:)@CO˒:)@COK]d@COr@CO[W>@COzH@CO͞@CO&@CO	k@COkP@CO@CO4m@COv_ح@COsPH@COsPH@CO_o@COU=@COH˒:@COH˒:@COE84@CO;dZ@CO$tS@CO,@CO,@CO,@CO,@COv@CO
M;@CO
M;@CO
M;@CO@CO hۋ@CO hۋ@CO hۋ@CN!.I@CN"@CNMj@CN@CNMj@CN@CN@CN쿱[W@CN1@CNC-@CN]cf@CN+@CN+@CNϪ͟@CNȴ9X@CN@CN'@CN2X@CN}Vl@CN6z@CNT@CN-@CNT@CNaf@CN@CN@CNFs@CN@CN+J@CN}Vl@CNp:~@CNiB@CNiB@CNfffff@CNc	@CNYJ@CNVu@CNOv_خ@CNE@CNBZc @CN;5X@CN1.@CNOv_@CN@CN4K@CN
(@CN
(@CN4K@CN
L/@CN
L/@CNt@CN ѷY@CM!.@CME@CME@CMS@CMb@CMϪ͞@CMH˒@CMn/@CM@CMn/@CM-V@CM%@CMڹZ@CMzxl"h@CMp
=@CMce@CM`A7L@CMVl!@CML_@CMB@CM?|h@CM5Xy>@CM/w@CM+a@CM%F
L@CM!.H@CMQ@CMu@CM'0@CL>@CLe@CL!-w@CLJM@CL>B[@CL*0@CLɅoi@CL?@CL7@CL#x@CL쿱[@CLN;@CL#@CL?@CLo h@CLwkP@CLwkP@CLq@CLg8}@CL]ce@CLSMj@CLSMj@CLM:@CLI^5?@CLI^5?@CL?@CL<쿱@CL64@CL2W@CL/{J#@CL,<@CL(\@CL(\@CL%1@CL%1@CL%1@CLQ@CLL_@CLtj@CLߤ@@CL1&y@CLJ@CLn.@CK\N@CK$@CKA [@CKC]@CKC]@CKlC@CKlC@CK҈@CKݗ+k@CK҈@CKݗ+k@CKݗ+k@CKݗ+k@CKݗ+k@CKQ@CK
=p@CK5Xy@CKa@O@CKE@CKm]@CKq@CKS@CKS@CKwk@CKS@CKS@CKU=@CKߤ@CKMj@CKq@CK@CKQ@CK~$@CKxF]@CKn.3@CKjf@CKdZ@CKW>6z@CKS@CKP{@CKP{@CKMjO@CKJ#9@CKF]c@CK=K^@CK6z@CK33333@CK/V@CK,zxl@CK,zxl@CK&@CK"`B@CK"`B@CKPH@CK'/@CJ~@CJc	@CJfB@CJG{@CJsP@CJ,<@CJ͞&@CJ͞&@CJW@CJ͞&@CJ͞&@CJW@CJ<64@CJg	@CJ ě@CJS&@CJwkQ@CJvȴ@CJ0
@CJ0
@CJᰊ@CJᰊ@CJS&@CJݘ@CJ@4@CJ{m@CJ{m@CJxl"h
@CJnO@CJh	ԕ@CJh	ԕ@CJd7@CJ^5?|@CJ^5?|@CJZc@CJW'@CJW'@CJT`d@CJM@CJQ_@CJQ_@CJGE85@CJ=p
@CJ:)y@CJ6C@CJ3@CJ0U2a|@CJ䎊@CJ䎊@CJe+@CJe+@CJ	 @CJ	 @CJn@CJn@CJu%F@CJu%F@CJu%F@CI.H@CI-@CIs@CIY}@CIR@CI>BZ@CI"`@CIN;6@CI_o@CI2W@CID@CID@CI@CI^5?}@CI^5?}@CI'R@CIl@CIB@CIl@CIl@CI(@CIu@CI@CIR<6@CIo@CI~($@CI~($@CIoiD@CI7Kƨ@CIoiD@CIx@CIk~(@CIhr @CIe+a@CI^@CI^@CIe+a@CIe+a@CIhr @CIae@CI[W>6@CITɅo@CIN;5@CIJE@CIQ@CIN;5@CIJE@CIN;5@CITɅo@CIJE@CIA [@CI=b@CI:S@CI4J@CI4J@CI*0U2a@CI#w@CI [7@CI_p@CI_p@CI+@CI@N@CI@CH$tT@CH	k@CH\)@CH4֡b@CHC@CH@CH҈p@CHF@CHѷX@CHp:@CHěT@CHTɅ@CHTɅ@CH
(@CH4m@CH{@CH-
@CHu%F@CHu%F@CHtj@CH-
@CH-
@CH@CH@CHYJ@CHYJ@CHn@CHn@CH˒:*@CHYJ@CHn@CH˒:*@CHn@CHy=c@CH_F@CH[6@CH[6@CHNU@CHD*@CH73@CH-
q@CH*0@CH$xG@CH}H@CH@CH*0U@CH*0U@CHbM@CH
qu@CHbM@CG#@CG䎊r@CG-@CG-@CG-@CGrG@CGrG@CG@CG@CG@@CG;dZ@CGfA@CG˒:)@CG˒:)@CG˒:)@CG˒:)@CGK]d@CGK]d@CG˒:)@CGK]d@CGo @CGr@CG3@CGzH@CG&@CG&@CG&@CG?@CGkP@CGݗ+@CG@CG	@CG&@CG{J#:@CG&@CG{J#:@CGy@CGv_ح@CGlC@CGiDg8@CGiDg8@CG\(@CGU=@CGKƧ@CGH˒:@CGAs@CGAs@CG;dZ@CG8}H@CG4֡a@CG$tS@CGXe@CG
=p@CG\(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @g]ce@jA [@j[6@jq@j֢3@jR<6@kEp
=@kc	@kZ@l@miB@oF)_@p:)y@qlu%F
@qI^5?@q@q{J#9@qBZc @qv_ح@pE@p]eO@pE[@pW#x@pk'RT`@pAbM@p8Y@op
=@o@@p($x@o
=p@n@mXD@l;dZ@ka@N@koiDg8@kKƧ@kv@kj)^@jhr @jxc	@j!O;dZ@i2W@iQ@jS@jB\(@jeں@kH˒:@l(@m$/@mpW'@mbM@maS&@mj~@leO@k4J@kr@j&@jX"h	ԕ@jm8@j
=q@jaD@i'RTa@iq@iCx@hz1&y@g@gSrGE8@gI@g[/V@gaE84@gSZ@g[zH@gbvȴ@gT@g?S@gQR@gqb@gw_o@g@N@g^5?}@gF
L0@g{m@g"h	ԕ@g[W>6@gJ@gI^5?@gsv@gf0
@gn쿱[W@gw?|h@gzt@g@@g5?|@gPH@g[W>@g9@g
M;@gqkP@g[a@N@g^&IR@gU+@g@e@g5b@g&-
@g-|hs@g#Z@g'/@ga@@g7@g#m]@g"h	ԕ@g
 ě@g?@gs@g	k@g;5X@g/V@gϪ͟@g D@fD*@f(@f7@g
zxl"@gR<6@gz@f+@fݗ@gs@g@g?@g'o @g-MjO@gnP@g
$t@g:S@gGE85@g@gp:~@ga@@gXy=@ge+@g'0@g
P{@gR<6@fjOv@fZ@g/V@g ȴ9X@fю!R@fbM@fE@fʙ0
@f|@f
=q@fᰉ@fJ@f<64@f)^@f-
@fYJ@fà'RTa@f [7@f1@f
=p@fZ@f$tT@f
M;@fD*@fXy=@fe+@fC]@fN;6@f_o@fs@f_o @f!.H@fJE@fǼn/@fIQ@f%2@f     @f@f,<@f@f@f'@f$tS@fR<6@fݗ@f?@fw!.H@fp/{J#@f~s@f|}Vl@fr\)@fxn@fe)^@fYE@f[U=@fP8YJ@f;b}V@f?~($@fRE@fU2W@fJ@f0C,zx@f-{J#9@f*9Xb@f >@f#@f 	k@fM@f&ݘ@f7/w@f#@ft@f@f m@f#@f#X@f#@f&@fC\@f
|Q@fߤ?@f4J@f33333@eR<6@ez@f#w@fg@fzG@f>BZc@f>BZc@f@fZ@ehr!@eu%F@f {@e8}H@e,<@e\N@e\N@e*0U2@e(\@e(\@e~$@eXy=@e궮}Vm@eѷX@eѳ|@eOv_خ@e]cA@e͇ݗ@e_o @e?@e?@e$xG@en.@eڹY@eʽ<64@e̓{J#:@e$@eƐ$t@eeO@eW'@eMj@eH˒:@e,<@en.@e@eIQ@e ѷY@er Ĝ@e!R@eO;d@eS@e
M;@e~$@e\N@e-@e(@e҉@e0
@e&@e|4֡b@eo	k~@eurGE9@es2a|@e~NU@e@eu-@ef2X@el?@ez#9@ez"h	ԕ@eo$/@ecᰉ@eS>6z@e[@eQb@eZ.2@eo@eh@eWg	l@eOu@eQحV@eVF]d@eWfA@ePu%F
@eOu@e[hr!@ec@eS;dZ@eMB@eLI^5?@eXȴ9X@eX@@eHOv_@eLH@eB\(@e= hۋ@e3F]c@e:73@e/qu"@eԕ*@e4@e3F
L0@e,T`d@e-r@e;kP@e?o @e#\N@eoiDg8@e%a@N@e*c	@e-3@e3As@e1iB@e3As@e7lC@e&TɅ@el"h	@e/+@e6_o @e*C,@e*C,@e1?@eOv`@e1.@e?@e2X@e5Xy@ehۋq@eZ1@d@dL/{J@ehr @e	k@e=p
@e!-w1@eZ1@e [7@e [7@eg	l@dK]c@d ě@eg	l@e%@e	:)z@e@e4K@e	hr!@eW@e
/V@e>B@e@esPH@eVϪ@e
{@eVu@e
~($@ece@e*0@e8}H@dA [@d˒:*@dc	@d*0U2@doiDg@d@dbM@d~$@d}H@dkP@dTɆ@d陙@d?@d'/W@d`d@d|Q@dv@dO;dZ@dR<6@d2X@e*1@d_o@dۋq
@d?@d$/@dzG@dzG@dhۋq@dS&@d!.H@d ě@d˒:)@d>BZ@d=p
@d=p
@dhr @dQ@ds@eN;@d@d [7@d\)@dJ#9@dhr!@dJ#9@dU=@d,=@dD@e$@dD@dQ@d@4@deO@d֡a@d,<@do@d:@e+a@d hۋ@drGE8@dd8@d
(@d,<@da|Q@e6@eC@d64@dR<6@d2W@e5Xy>@e?@ee+@e0
@ee+@eQ@dPH@eQ@eN;6@elD@es@e
=p@e(@e'RT@eP{@e
҈p@e9Xb@eP{@d`A@d$tS@el"h	@e@d>@eVϫ@e
v@eK]@e+@e
?@ekP|@e+@eO
M@e$tS@eO
M@e
/@e	y@ej~#@eFt@eN;5@e
n.@e&@e
]cf@eg@e_o@e	xF]@dH˒@e	xF]@e$/@eS&@d[6@erG@e/V@e!@N@eL/{J@ehۋq@e/V@e
ڹY@e!.@e
(@e<64@e!nP@e(F]d@e"u%F
@eN;@e䎊@eJL@e@e"u%F
@e"u%F
@e*Ʌoi@e#@e!)^@e@e#@e.!-w@e!)^@eB@e&쿱[@e!)^@e@e!)^@eH@e%:S@e1^5?}@e0VϪ@e86z@e5%2@e4IQ@eJQ@e?ߤ@e3C,z@e7F]c@eBc	@eGA [@eE*0U2a@e:
qu@e-!R@e.D@e1r@e@E@eCo @eCo @eE(@eL6@eS'0@eQ&@eTnO@e[`A7L@eU@eM|hs@eNߤ?@e\7@eNߤ?@eM|Q@ejzxl"@eeXe@eU|@eS	k~@e[^@ebOv_خ@ejT@egݗ+k@eYC\@e[\@ep1.@eg?@ebNU@ec-V@e[\@eX@ebNU@en͞&@emjOv@ep1&x@ew"`B@emjOv@e`JM@ejS&@er74@eqO
@en͞&@emjOv@er74@e| ě@eڹY@etZc@ere@ep0U2a|@exݘ@e~s@ew!-w1@ex?@e~s@e|O
M@e+@eN;@e~@eu!S@eo@eylC@ew [7@eU=@e{J#9@e ѷ@e$t@e-w1@efffff@ey,=@eI^@en.@eH@e,zxl@eOv_@eH@eeO@e%@eI^@esP@e-
@eH@e@eH@e+jg@eY@e\(@e:@ed7@e}H@eIQ@em@eU2a|@eV@e͞@e84֡@efA@e84֡@eV@efA@e?@eԕ*@eq@e@eQ@eFs@eq@eb}V@e@eᰉ'@e@eae@e,<@eI^5@e,<@e*0U2@ep:~@e\N@e@e~($@e7KƧ@e,<@em\@e7KƧ@ea@@e\N@e@ea@@e}Vl@e4֡b@eěT@eE@eDg8~@eo hی@e҉@eD*@eDg8~@e҈p;@e}Vl@e($x@eE@e-@e-@e҈p;@e@eQ@e@e
L/@e'@e_ح@e~@e_F@e&@e&@e+j@e\(@e'RT@e\(@e(@e_F@e	ԕ+@e4m9@e'RT@eϪ͞@eu%@eǥv@e~@e~@eg	@e ѷ@eg	@eǥv@eg	@e@elC@e>@eVϫ@en@e$xG@e2a|@e\@eK]@e2W@e	 @e#@e@e#@e	 @elC@e#@e+@ekP|@ekP|@en@erGE9@e1@e]cf@e@ej~#@eΕ*1@eٱ[W>@eJM@ej~#@eٱ[W>@eM@eΕ*1@e]cf@e?@e1@eM@eՆ&@eҿ[W?@ej~#@e]cf@e_o@e-@eٱ[W>@e@eٰ'R@eٰ'R@e#9@eJM@e#9@e?@ej~#@e\(@e"h	ԕ@eٰ'R@e3@eՅoiD@e@eΔFs@eiB@e3@e0U2a|@en@eJ@eFs@e뽥@e/{J#@eZ1@e!-w1@e@N@e=b@e?@e@eaf@ehr @eaf@ehr @e/{J#@e뽥@e}Vl@e+@e<쿱@e@e'RTa@e [7@elC@e@e@e.2@e)^@e [7@e+@eo@e}Vl@e}Vl@eu!S@e\)@e:)z@etj~@e4K@etj~@eD@e򭫟U@e\)@etj~@etj~@eJE@e@eU=@e4K@etj~@eU=@e;5X@eU=@eD@en@efffff@fXbM@f$@etj~@efffff@eU=@e	@f $t@e ѷ@eXy=@etj~@e ѷ@e@f -
@eeO@eI^@e,zxl@eU=@e򭫟U@eW@en@f)@fs@f`A7@fE@f
rGE@fOv_@e%@f`A7@f:S@f)@e@f@f
H@e,zxl@f)@f
H@eeO@f`A7@fdZ@ed7@f}H@f
'/@fr Ĝ@f$/@f䎊q@fIQ@f9@f9@f9@f@@f)_@f$/@e@e֡a@f
H@fU2a|@fU2a|@fce@f!R@f@f)_@fce@f     @f84֡@f*0@f!R@f*0@f!R@f ѷY@fVl!@ffA@fm@f)_@fm@f$d8@f$d8@f$d8@fC,z@fU2a|@f
V@f)_@f!R@fU2a|@f#F]c@fce@f@f#F]c@fU2a|@fm@f!S@f&
(@f ˒:*@f ˒:*@fce@fm@fqu"@fC,z@fU2a|@f$@f(,<@f'p
=@f,m\@f@f@f*73@f,m\@fr@fO;d@f#F
L0@f&
qu@f*73@f*73@f*73@f(,<@f ~"@f/8Y@f.bM@f3oiDg@f/8Y@f&
qu@f ~"@f$@f!@@f ~"@f*6C@f!@@f$@f,m\@f.bM@f,m\@f,m\@f/o @f,E@fr@f$TɆ@f(Z@f*6C@f<D*@fA@f5S&@f1(@f3-@f<D*@f/o @f2L_@f9}H@f3-@f<D*@f@oiDg8@f2L_@f3-@fE#@f:u"@fD0
@fKڹZ@f:u"@f<C\@f<C\@f:u"@f:u"@fA@f:u"@f5S&@f:u"@f6?@fE#@fNQ@fC5Xy>@fH@f<C\@f<C\@fJ'RT`@fKڹZ@f<C\@f:u"@f:u"@f:u"@f?'0@fJ'RT`@fJ'RT`@fE#@fC5Xy>@f:u"@f<C\@fJ'RT`@fS;dZ@fE#@fH@fQPH@fQPH@fLc	@f:u"@f1'/W@f@nO@fC5Xy>@fE#@fJ'RT`@fH@fE#@fD0
@f9|hs@f@nO@fX
L/@fYn.3@fNQ@fR{m@fJ'RT`@fA@fG`A7L@fD0
@fG`A7L@fD0
@fKڹZ@fVL/{@fG`A7L@fK	@fAN;6@fH@fS;dZ@fNQ_@fR{m@fR{m@fVL/{@fS;dZ@fVL/{@fj@f]+j@fQ*0@fS;dZ@fYm\@fVL/{@fS;dZ@fNQ_@fR{m@feVϫ@fc&@fX	ԕ+@fS;dZ@fUB@f\4m9@fX	ԕ+@f]+j@f^>@fYm\@fX	ԕ+@f`^5?|@frl"h	@fsϪ͞@fdp:@fdp:@fYlC@fdp:@feVϫ@feVϫ@fhg	@fgO;dZ@fnA7K@fl ѷ@fov@fgO;dZ@fa@fdp:@fkzxl"h@fl ѷ@feVϫ@fhg	@fnA7K@fnA7K@fhg	@fhg	@fdp:@fc%F
L@fhg	@fgO;dZ@fgO;dZ@fov@fnA7K@fa@f`^5?|@fu2a|@fNU@fov@fa@fgO;dZ@fj@fqu%@fqu%@fgO;dZ@fn@4n@fl ѷ@fs+@fl ѷ@fX	 @f\3@fn@4n@f|$xG@fu2a|@fky@fn@4n@f}ݗ@f~C,@fy\@f}ݗ@f}ݗ@fu2a|@fs+@fs+@fo?@fn@4n@fy\@fy\@fjOv`@fwrGE9@f?@f~C,@fzn@fu2a|@fqK]@fo?@fgO
M@frkP|@f}ݗ@fy=c@fzn@fu2a|@fo?@fwrGE9@fy\@f|$xG@f-V@fy=c@f?@f~C,@f}ݗ@fNU@fy=c@fs@f}ݗ@fzn@f-V@fs@fs@fNU@f}ݗ@fwrGE9@fy=c@f_o @fs@fzn@fvᰊ@f~C,@f~C,@fs+@fs+@f|$xG@fzn@fS&@fᰉ@f74@fS&@fS&@f͞&@f?|h@f|$xG@f1&x@fS&@f@f[W>@fxl"h
@fNU@f-V@fS&@f74@fS&@f?|h@f1&x@f@f@f74@fH˒@f1&x@f"`B@f?|h@f~C,@f1&x@fxF]@fzG@fᰉ@f"`B@fO
@f[6@fMjO@fYJ@fYJ@fxF]@fxF]@fۋq
@fO
@fMjO@f{@f{@fᰉ@f{@fH˒@f/V@fYJ@fۋq
@fMjO@fYJ@f"`B@f[6@fwk@f!.@fۋq
@fzG@fwk@fۋq
@f$/@fᰉ@fH˒@f!R<@fYJ@f74@fxF]@fwk@f?@fzG@fᰉ@f/V@f5Xy@fiB@fS&@f5Xy@f$/@f@f!.@fxF]@f{@f$/@fۋq
@f0
)@ftj@fQ@f/V@fxF]@f0
)@f0
)@f?@f5Xy@fvȴ9X@fzG@f5Xy@f@f/V@f/V@fwk@f!R<@f@ftj@fiB@fFs@f5Xy@fL/{J@f!.@fiB@fFs@f"`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ?=b?TɅoi?TɅoi?[W>6z?D*?IQ?-w1?
qu"?kP{?u?8YJ?A [7?\N<?tSMj?&?~"?Y}?!-w2?bM?+?o hۋ?䎊r?C,z?,<쿱?H˒:*?n?͞%?-V?̯O
M?x?+J?3ߤ?֣S&?n?ۋq?;dZ?PH?NT?sPH?靲-V?{J#9?eڹ??2W?l!-w?&?
=p
?lC?)?kP{?E?cA \?S&?u?fA?ɅoiD?$tT?#?>BZc ?[W>6?o?ȴ9Xb?ᰉ?S??/V?⒣S&?ᕁ$/?D?SMj?I^5?F]c?*0
?U2a|?Fs?D?U2a|?K]d?Ů1?E?ßU=?e+?7KƧ?4J?%2?^5?|?~$?JD?3?(\)?Mj?!-w1?tj?ᰉ'?Ϫ͞?Q?y=b?$tSM?tj?$tS??tj~?73?$?a@N?쿱[W?ݗ?H?>6z?c	?)^	?L_?E?q?b}V?%2?>BZc?6C-?1&?=K^?ᰉ'?}H˒?Ov_خ?S?>6z?,<?Mj?|C,zxlku%F?-V?fA?$/?=K^?usg?},<?ߤ??|C,zxl?z6C-?)^	?҈?nO;?Z?҈?tZx*0
xPH?htj~?v?Xe?fA?H?$tSM?$/?Ϫ͞?*0?!-w1?uL_?Rn/q4J?~Ov_ح?sPHo!-w1??Ϫ͞?2a|Q?O
M?S&?vOv_خ?IQ?Zݘ?Z?E?S?}}H˒?v+I?o!-w1?wXe+?m}H˒v+I?nOv_ح?xtj~ie+a?v+I?},<Rn/?0
(?L_?+I?IQ?PH?C*0U2a`bM?4J?p:?Z?$tSM?JD?v?tZl1&y?p)^	?@NU??*0?U=K?U=?O
M?tn?O
M?*0U2?*0??|1&y?hr Ĝ?},<xPHtzG{?tn?nOv_ح?ie+a?u%?fA?qu!S?+jg?䎊q޿htj~?e+a?tj~?R<64?sPH?D*0?|C,zxlusg?`A7LdzG{?qu"?Q?$tS?wXe+ԿbsPH?_!-w1?vȴ9?ye+aPbM?Q?*0wXe+Կ[Q_?E?ᰉ'?ɅoiD?n/?{u%F?o!-w1?{qu!S?!-w1ſpbM?IQ?O
M??D*0:6C-?@bM?o!-w1ſ`bM?s@NU?tj~?N;5Xtn?|1&y?Xern/s*0U2a?htj~?{qu!S?~Q?bM?uL_?[Q_*6C-y_o         ?s*0U2aXtj~??	 ?z6C-a4J?Q_p?Ϫ͞?$/?C,zxl?0
(?T`d?q?zG{?f?qu"?bM?qu!S?tj?Ϫ͞?n?n/?z6C-?|1&y?v+Io䎊q?g?s*0U2aj6C-?sg?,<?C,zxl?sg?=K^?6C-?{Q_?*0U2a?*0?nO;?	 ?Fs?zG{?~Q?wXe+?zvȴ9?Zݘ?y_o ?rsPH?{qu!S?!-w1ſ_!-w1?M}H˒Rn/?҈?L_??䎊q?Z?0
(?Z6C-?Z?p:?S&?p:?xPH?s@NU?}Z?z6C-bn/?`A7L??>BZc?g?bn/?wXe+?u%?䎊r?=K]?䎊q?PbM?V?{?eL_x*0
?uL_?v?c	?@NU?ye+a?N;5?bn/?,<?S?JD?y=b?l?tn?C*0U2aS*0U2a?`d8?IQg?v+I?~Q?}Z?䎊r?tj~?ᰉ'?2a|Q?*0
fOv_خ?[Q_?{u%F?qu!S?u!?y_o ?v?Xe+?4J?-
qv?n/?Ϫ͞?cA \?,<쿱??}}H˒?:)y?n?Xe+?Xe+?A?xtj~?{u%F?@?*0U2?Z?u!fOv_خ?hr Ĝ?E?Mj?$tS?Z?*0?N;5?$tS?~Q?p)^	?m}H˒?vOv_خ?wXe+?n/?ߤ??Ov_خ?bn/},<?M}H˒?Q?vOv_خ?kQ_?䎊r?҈?*0U2a?Z?~Q?{u%F?xPH?uL_o!-w1ſvOv_خ:6C-?R<64?vȴ9X?q4J?[Q_?j6C-kQ_?H?y_o ?Fs?}H˒?l!-w?Ϫ͞?Fsj6C-|1&yc*0U2a@bM?-
qv?쿱[W??*0
?`A7L?}}H˒?vȴ9?ᰉ'?ݗ+j?{Q_?kQ_rn/?s@NU?~Ov_ح?wXe+?qu"c*0U2ausgvOv_خ?UL_?htj~@bM?xPHF?UL_?䎊r?w??{Q_?xPH?{qu!S?vOv_خ?)^	?	 ?PH?IQ?C,zxl?>BZc?n/?:6C-?$tSM?N;5X?fOv_خbsPH?4J?Ϫ͞?}H˒?
=p
?nO;?rn/?}}H˒?{Q_?o!-w1?e+a?Ov_خ?ᰉ'?Mj?x*0
?|??oiDg8?Ov_خ?ɅoiD?䎊rc*0U2a?},<?}Z?z6C-?tzG{?|C,zxlp)^	{qu!SxPHM}H˒?{Q_?䎊q?Q_?sPH6C-?!-w1?nO;?sPH?)^	?q4JeL_?@NU?$tS?|??sPH?~Ov_حPbM?@?Xe+?rsPH?nO;?u%F?o䎊q޿usgn?$tSM?쿱[W??xPH?_o?zvȴ9?sPH?2a|Q?sg?Ov_خ?U=K?*0U2a?:)y?4J]}H˒6C-?u%F
?|C,zxl?zG{?ߤ??l?Z?	 ?hr Ĝ?O
M?ᰉ'?ᰉ'?a@N?!-w1?z6C-j6C-?ku%Fq4J?j6C-?nO;?fA?2a|Q?Z?xtj~pbM?J6C-?M}H˒`bM?bM?+jg?ɅoiD?2a|Q?leL_?{qu!S?},<?ݗ+j?$/?*0?ku%FtZ?{qu!S?ߤ??}H˒?*0U2a?u"?=K]?R<64?uL_?rnO;?p)^	?rsPH?tzG{?s*0U2a?|??ZeL_wXe+ԿvOv_خ?n/?{qu!S        ?)^	?kP{?R<64?"`A?y_o nOv_ح?)^	o!-w1??:)y?&?sPH??N;5?!-w1?hr Ĝ?ye+a?ߤ??H?0
(?tj~?|1&y?}Z?R<64?nO;?{u%F?n/?ye+ao䎊q?,<?*0?rn/v?Z?$/?}H˒?A?n?n??bn/?xtj~?sPH?{u%F?l?C*0U2a?*6C-htj~?rsPH?`A7L?R<64?kP{?_Ft?x*0
?4J?_Fthtj~?$/?䎊q?v+I?U=KusgxPH?wXe+?N;5rsPH?vȴ9Xbn/{u%F?PbM??L_?ᰉ'?,<:6C-eL_?pbM?*6C-?u"?bM?bMm}H˒?q4J?rnO;?$tS?|?Q?!-w1?Ov_خ?Z?usg?S??{qu!S?bM?zG{?*0?n?Ϫ͞?ɅoiD?S&?y_o ?)^	?tj~?:)y?xtj~tzG{?_o?_o?~Ov_ح?_o ?Ov_ح?{qu!S?dzG{o!-w1?:)y?,<쿱?`d8?u%F
?#wk?R<64?)^	?p:?ᰉ'?ᰉ'?$/?Z??_o ??:)y?kP{?nOv_ح?3*0U2a?l?$tS?uL_?|C,zxl?!-w1?&?sPH??0
(?1&y?,<쿱?sg?y_o ?$/?䎊q?qu"fOv_خ?{u%F?v+I?u"?nO;?Mj?z6C-q4Jxtj~?IQ?sg?O
M?uL_        w?n?0
(bn/?L_?2a|Q?ᰉ'?4J?6C-?U=Kp)^	?O;dZ?Xe+?4J?n/?ye+a?x*0
?Zݘ?,<?pbM?=K^?$/?sg?U=K?x*0
?ye+a?zvȴ9?rsPHpbM?o!-w1?o!-w1ſj6C-?ZݘJ6C-?l1&ys@NU?hr Ĝ?2a|Q?}}H˒?`A7L?bn/?o䎊q޿3*0U2av+Io!-w1?q4J?rn/bsPH?bsPH?Ov_خ?p:?y_o ?nO;?nO;?m}H˒?쿱[W??|C,zxl?u"?҈?ye+a?wkP?O;dZ?x*0
?uL_?rnO;?kQ_?v+IXtj~nOv_ح?p:?*0U2a?pbM?@NU?Zݘ?v+I?u"?p)^	?eL_?IQ?sg?ߤ??{u%FF?C*0U2a?ߤ??pbM?v+I?vȴ9X}Z}Z?`bM?{u%F?v?sg?ku%FPbM?pbM?bsPH?nOv_حF?tZ?IQ?tzG{?hr Ĝ?bMfOv_خ?pbM?䎊q?|C,zxl?*0U2a?+?sPH?{qu!SV?+jg?ɅoiD?u%F?S*0U2a?J6C-?z6C-?$tS??l1&yie+a?q4Jku%F??O
M?Q_p?vǿp)^	tZ?:6C-PbM?sPH?*0?-
qv??$/??s*0U2a?_!-w1?F?|??eL_?a4J{qu!S?bsPH?Fs??2a|Q?*0?4J?Fs?o䎊q޿_!-w1?uL_?tzG{?*0
?+Ia4J?qu"?rsPH?pbM?Q?)^	?tj~?+?pbM?rnO;?,<?E?|?-V?htj~?rsPHXtj~?qu"?IQ?Fs?O
M?2a|Q?E?:)y?_o?q?ᰉ'?ݗ+j?E?$tSM??u%F?v+I?ye+a?Z?Qw?}Z?}H˒n/wXe+?qu"?q4J?@NU?Z?S&¿@bM?J6C-?},<?R<64?tj~?L_?Q?}Z?bsPHf?ie+a?o!-w1ſusg?rnO;??S&?o䎊q?vOv_خ?}H˒?Zݘ?y=b?
=p
?*0?L_?|??q4J?tZ?w?p:?uL_?:)yS*0U2a?l?bM?$tS?rn/?M}H˒?,<?$/?u!?Ov_خ?$/??W>6z?tj?*0?sPH?rn/?Zݘ?Z?Ov_خ?H?+J?8YJ?eL_*6C-?ߤ??E?1&y?dzG{s*0U2arsPHl1&y?ku%F?wXe+?}}H˒?O;dZ?$tSM?nO;?n?`d8?*0
?,<?vȴ9?R<64?zG{?,<?Q_?tj?:)y?c*0U2a?e+?}}H˒?*0U2a?Q?fǿusg?N;5?FsC*0U2a?)^	?C,zxl?8YJ?Z?$tSM?-V?ݗ+j?C,zxlc*0U2a?4J?ɅoiD??fǿRn/?U=eL_?pbMrsPH?fOv_خj6C-rsPH?hr Ĝ?*0?qu!S@bMj6C-C*0U2a?pbM?Mj?-
qv?$tS?Y}?qu!S?O;dZ?ye+a?j6C-?_o?E?L_?0
(?%2?rnO;?tzG{?Rn/]}H˒?&?*0U2a?n/?sPH?Mj?|1&y?tn?ye+a?!-w1?wXe+?!-w1?:)y?[Q_?Ov_ح?Z?$tSM?JD?Fs?+?bM?l1&ypbM?hr Ĝ?S&?uL_?]}H˒?usg?xtj~?nO;?PH?+ItZ?ᰉ'?O;dZ?0
(?a@N?Zݘqu"?bsPH?}Z?,<쿱?`d8htj~?f?o!-w1?~Ov_ح?`A7L?E?,<?v+I?o䎊q޿3*0U2a?_!-w1?p:?!-w1?n/?zG{?`d8S*0U2a?JD?2a|QUL_?UL_?}Z?	 ?xtj~?C,zxl?Ϫ͞?S?UL_Z6C-?,<쿱?ɅoiD?zG{?ᰉ'?E?Fs?:)y?Xe?u"?s@NU?_o?@??vȴ9X?Z?S&?Z?v+I?kP{?v?*0
?R<64?:)y?쿱[W??o䎊q?bM?{??q4J?{qu!S?},<?Zݘ?䎊q?ᰉ'?`A7L?zvȴ9?&?&?J6C-?,<?-
qv?fǿvOv_خ        ?rsPH[Q_?wkP?䎊q?|C,zxl?},<?>6z?A?bM?wXe+?xPH?-
qv?	 ?!-w1?usg?-
qv?rnO;eL_?{Q_?y_o ?{u%F?@bM?ie+a?{Q_?tj~?,<?sg?n?xtj~?*0U2a?O;dZ[Q_?vȴ9?u"?D*0?usg?Q_?{qu!S?z6C-?,<?ߤ??ݗ+j?+I?ku%F                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ??????????????????????????????????????ə?ə?ə?ə?ə?ə??ə?ə?ə?ə?ə?ə?ə?ə???ə?ə?ə??ə?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????ə??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????ə??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            &B%A$  35-11                                      1                                       