CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P17    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:48.193201Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @J        data_max      @J        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     <  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @ffffff   data_max      @bfffff   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      <  j   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d             temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?
qu"   data_max      @L_   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       <  @   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d            salinity                	long_name         salinity   units         PSS-78     data_min      @@XU   data_max      @AK   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      <    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d        >`   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @&         data_max      @sP        C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        < M   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d            CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?QR   data_max      @5?|h   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      <     CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d        ՠ   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       <    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d        !@   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @M@        data_max      @Q         C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     < 0`   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d        l   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( |    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( |(   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d       |P   latitude               	long_name         latitude   units         	degrees_N      data_min      @Hם
gb   data_max      @Hם
gb   C_format      %9.4f          |T   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `VE   data_max      `VE   C_format      %9.4f          |X   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        |\   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        |`@J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @J     @ffffff@      @ffffff@      @"ffffff@$      @&      @'@*      @,      @.      @0      @2      @2@4@5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C@C33333@D     @E      @E     @F      @F     @G      @G     @H      @Hs33333@H33333@I     @J      @J     @K      @K@L@L     @M      @M     @N      @N     @O      @O@P33333@P@     @P     @P     @Q      @Q@     @Qfffff@Q@Q@R@     @R     @R     @S      @S@     @Sfffff@S     @S@T@     @T     @T     @U      @U@     @U     @U     @V      @V9@V     @V     @W      @W333333@W     @W     @X      @X@     @X     @X     @Y      @Y9@Y     @Y     @Z      @Z@     @Z     @Zfffff@Zfffff@[S33333@[     @[     @\      @\@     @\y@\ٙ@]      @]@     @]     @]     @^      @^`     @^fffff@^     @_      @_@     @_     @_fffff@`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @cfffff@d&fffff@d@     @d`     @d     @d33333@d33333@d@e      @e      @e@     @e`     @e33333@e@e     @e     @f      @f      @fC33333@f`     @f     @f     @f     @f     @g      @g      @gC33333@g`     @g     @g     @g     @g33333@h33333@h      @h@     @h`     @h     @h     @h     @ifffff@i      @i@     @i`     @iy@i     @i     @i     @j      @j      @jI@j`     @j     @j     @j     @j33333@j33333@k&fffff@k@     @k`     @k     @k     @k     @k     @l      @l      @lC33333@l`     @l     @l     @l     @l     @m      @m      @m9@m`     @m     @m     @m     @m     @n      @n      @nC33333@n`     @n     @n     @n     @n     @n@o,@o@     @o`     @o     @o     @o     @o@p@p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @qfffff@q     @q     @q     @r@r@r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r@r     @r     @r     @s      @s     @s      @s0     @s>fffff@sQ@s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tNfffff@t`     @tp     @t     @t     @t     @t     @t     @t     @tfffff@t񙙙@u      @u     @u      @u0     @uD@uP     @u`     @up     @u     @u     @ufffff@u33333@u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @vx     @vfffff@v     @v     @v     @vљ@v     @v     @w      @w     @w      @w0     @w@     @wQ@wa@wnfffff@w     @w     @w     @w@w33333@w     @w     @w     @x@x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x33333@xfffff@x     @x     @x     @x     @y      @y@y     @y333333@y@     @yP     @y`     @yq@y@y     @y     @y     @y     @y     @y     @y     @z      @z@z!@z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{1@{@     @{P     @{`     @{p     @{     @{     @{     @{     @{@{     @{     @{     @|      @|     @|fffff@|333333@|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~@~љ@~     @~     @~@fffff@      @0     @@     @P     @^fffff@p     @     @@@     @     @     @     @     @fffff@	@     @     @      @(     @0@;33333@?33333@H     @P     @X     @`     @h     @p     @x     @     @     @fffff@     @     @     @33333@     @     @     @љ@     @     @     @񙙙@     @      @     @fffff@      @(     @0     @8     @@     @D     @Rfffff@X     @`     @h     @p     @x@     @fffff@@     @     @     @@@     @     @fffff@     @fffff@     @      @     @@fffff@33333@(     @0     @8     @@     @D     @Rfffff@X     @`     @e@p     @x     @     @     @     @     @     @fffff@@     @     @     @     @     @33333@33333@     @      @     @fffff@ @(     @0     @8     @=@P     @X     @`     @h     @p     @x     @     @     @     @@     @     @33333@     @     @     @     @@33333@     @     @     @      @     @     @     @      @'33333@0     @8     @@     @H     @P     @T@c33333@h     @p     @x     @     @     @     @fffff@     @     @     @     @     @@     @     @     @     @     @     @      @@     @     @      @(     @0     @4     @@@H     @P     @X     @`     @h     @p@x     @     @     @     @     @     @     @@     @     @     @     @     @     @噙@@     @      @     @     @@      @(     @0     @8     @@     @H     @P     @X@`     @h     @p     @x     @     @     @     @     @33333@     @     @     @     @33333@     @@@     @     @     @ @@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @33333@     @     @     @fffff@33333@     @     @     @     @@fffff@     @     @      @     @     @@      @(     @0     @8     @@     @D@P     @X     @`     @h     @p@x     @     @     @     @     @     @33333@33333@     @     @     @fffff@     @     @     @33333@      @     @     @     @      @(     @,@@@H     @P     @T@bfffff@h     @p     @x     @~fffff@     @     @@@@     @     @@33333@fffff@     @     @     @     @      @@33333@     @      @(     @/33333@A@H     @P     @X     @`     @h@l@     @     @     @     @     @33333@     @     @     @     @     @fffff@fffff@     @     @      @     @@@      @(@1@8     @@     @H@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @@@     @     @     @     @     @@񙙙@     @      @     @     @     @ @$     @1@8     @@     @H     @P     @X     @`     @h     @p     @x     @33333@     @     @     @     @33333@     @     @     @     @     @     @     @33333@fffff@      @     @     @@@(@0     @8     @@     @H     @P     @X     @`     @h     @p     @w33333@     @     @     @     @@33333@@     @     @     @     @     @@@fffff@     @      @     @     @     @      @(@8@@     @H     @P     @X     @_33333@g33333@p     @x@     @     @     @     @@33333@fffff@     @     @     @     @     @@@33333@     @      @     @     @33333@      @(     @0@733333@@     @H     @P     @X     @`     @h     @o33333@zfffff@33333@     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @      @fffff@     @     @     @     @     @@!@$     @(     @,     @.@4@8     @<     @@     @D     @G@Pfffff@T     @X     @\     @`     @d     @hfffff@l     @p     @t     @x     @|     @     @     @@     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @Ǚ@     @     @     @     @     @     @fffff@     @     @     @fffff@     @     @      @     @     @     @     @@     @     @      @$     @(     @,     @0     @4fffff@7@<     @@     @D     @H     @Lfffff@P     @T     @X     @\     @`     @d     @hfffff@k@p     @t     @x     @{@@     @     @     @     @@     @     @     @     @     @     @     @     @     @     @fffff@Ù@     @     @     @     @33333@     @     @     @     @     @     @     @     @     @      @     @@@     @     @     @     @ fffff@$     @(     @,     @0     @4     @8     @<     @@     @Dfffff@G@L     @P     @Tfffff@W@\     @`     @d     @hfffff@l@p     @t     @x     @|     @     @     @33333@fffff@     @     @     @     @     @fffff@     @@     @     @     @     @fffff@     @fffff@     @     @     @     @     @     @홙@     @     @     @     @ fffff@
33333@     @     @     @     @      @$fffff@'@,     @0     @4     @8     @<     @@     @Dfffff@H@L     @P     @T     @X     @\     @_@f     @h     @l     @p     @t     @x     @|     @~fffff@33333@     @     @     @     @     @     @@@     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @     @㙙@陙@     @     @     @     @     @      @@fffff@     @     @     @@$@(     @,     @/@533333@7@<     @@     @D     @H     @Lfffff@P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|fffff@     @     @     @     @@@     @     @     @     @fffff@@     @     @fffff@fffff@     @     @     @     @@     @     @     @     @     @fffff@     @     @󙙙@     @     @      @     @fffff@33333@     @     @     @     @      @$     @(     @*fffff@0@4     @8     @<     @@     @C@Pfffff@T     @X     @\     @`     @c@pfffff@t     @x     @{@fffff@     @     @33333@fffff@     @     @     @     @     @33333@     @     @     @fffff@fffff@fffff@ϙ@     @     @     @     @     @fffff@뙙@@     @     @     @      @fffff@@     @     @     @@ fffff@$     @(     @,     @0fffff@333333@8     @<     @?@D     @H     @L     @P     @R@\fffff@`     @d     @h     @l     @o@x     @|     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @Ǚ@     @     @     @     @33333@@     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @533333@8     @<     @@     @D     @H     @L     @P     @Y33333@\     @`     @d     @h     @l     @nfffff@x     @|     @     @     @     @@     @     @     @     @     @     @     @@fffff@     @     @     @     @fffff@33333@ՙ@     @     @     @     @     @@     @     @     @      @fffff@fffff@     @     @     @fffff@ fffff@#@(     @,     @0     @4     @8     @<     @A33333@D     @H     @L     @P     @T     @X     @\     @`     @d     @f@m33333@p     @t     @x     @|     @@@     @     @@     @     @     @     @     @33333@33333@     @     @     @     @     @Ù@fffff@     @     @     @     @     @     @     @     @     @     @     @     @ fffff@@     @     @     @fffff@@     @      @$     @(     @,     @0     @2fffff@8@<     @@     @D     @H     @L     @Nfffff@Xfffff@\     @`     @d     @h     @j@q@t     @x     @|     @     @     @     @@@     @     @     @     @     @@@     @     @     @     @     @     @33333@     @     @     @     @fffff@fffff@噙@     @     @     @     @@     @     @     @     @@@      @$     @(     @,     @.fffff@4fffff@8     @<     @@     @D     @G33333@M@P     @T     @X     @\     @^@hfffff@l     @p     @t     @x     @|     @@     @     @     @     @     @@@     @     @     @     @fffff@     @     @fffff@     @     @@@     @     @     @     @     @fffff@@      @     @     @33333@33333@     @     @     @      @$     @(     @4     @8     @<     @>@H     @L     @P     @T     @X     @\@`     @d     @hfffff@l     @p     @t     @x     @|     @33333@fffff@     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @     @     @י@fffff@     @     @     @     @@@      @     @     @33333@33333@     @     @     @ fffff@#@(     @,     @0fffff@2     @933333@<     @@     @D     @H     @K33333@Q@T     @X     @\     @`     @d     @h     @l@p     @t     @xfffff@{33333@     @     @     @     @fffff@     @33333@     @     @33333@fffff@     @     @@     @     @     @     @fffff@@     @     @     @     @fffff@33333@癙@     @     @     @     @     @@	33333@     @     @     @     @33333@$     @(     @,     @/@4@8     @<     @@     @Dfffff@F@M33333@P     @T     @X     @\     @`     @d     @ffffff@m33333@p     @t     @x     @|     @~@fffff@     @     @     @33333@     @     @@     @     @     @     @     @     @fffff@Ù@     @     @     @     @fffff@     @     @     @     @     @     @     @@     @      @     @33333@
33333@     @     @     @     @      @$fffff@&     @,     @0     @4     @8     @<     @?33333@D     @H     @L     @P     @Tfffff@Xfffff@\     @`     @d     @h     @l     @p     @s33333@x@|     @     @     @     @     @     @     @     @     @     @     @fffff@     @fffff@     @     @     @     @@fffff@     @     @     @     @     @33333@33333@     @     @󙙙@@     @      @     @     @     @@     @     @     @      @"fffff@)@,     @0     @4     @8     @<     @E33333@H     @L     @Nfffff@a@bfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @ڹZ@@&IR@tj@L_@]cA@p:@E84@ݗ+@
L/@	7KƧ@q@)^	@YJ@)y@U2a|@Xe,@K]c@ߊ	@JL@y=c@TɅo@ȴ9X@#w@)^@Ǔݗ+@e@
=p
@g@TzG@+a@rs@B\(@J@@@H@W>6z@x-
@r{m@qA [@p{@n1@ix@c
=p@dtSM@][@VOv_@S*0U2@KƧ@Fs@EoiDg@@IQ@=!.H@0
=q@)ᰉ'@&L/{J@?@#@$@.2@ؓtj@C%@K]c@j~@u%F@?@OAs@<쿱[@3|@R@A [@H@O
@rs@`ěT@VOv_@DJM@:)y@(\)@e+@!R<@u%F
@J@ۋq
@S&@ۋq@ԯO
M@\(@\N@o@qiC@kC,z@_vȴ9@9~($@{@eO@ IQ@eں@fffff@l!-@)^@ˬq@Ƨ-@u%F
@b}V@v@Y}@}Vl@H˒:@ԕ*@ᰉ'@vȴ9X@@4n@zH@#n.3@1[W>6@Jn@lC@ ѷ@lD@*0U@@9XbN@S@_o@Ƨ@'RT`@w1@?|h@6@o@O
M@84֡@@.H@z)y@M:@n1@OrGE9@A [7@49XbN@%+a@cA @@m@zH@m8@9@l!-@L_@b}V@%F
L@wkQ@$tT@p:~@zC\@lzxl"@aGz@_Ft@[qu!@KxF]@#9@`A7@dZ@[6@2W@m]@C-@[W?@TɆ@*0@z~@]cA @G+I@,C@䎊@S&@ n@Y|@I^@e+a@v_ح@Q@8YK@oiDg@#9@©@:~ @$@`A7@҈@o{J#:@XbM@7KƧ@ u!@ߤ@@2a|@
@p:@64@r@0U2a|@$xG@e@u"@;dZ@āo h@}H@@W>6z@^Q@F?@;m]@3MjO@)*0U2a@@>B@-V@u@t@:)y@Ƨ@*0@6@!.H@!.I@C,z@-V@*0@@@}v@qo@glC@W@M:@IQ@G+I@D*0@B ѷ@?H˒:@8-
@,!-w@Y@@N@p:~@L_@
W'@_o@$/@o hی@!.I@0U2a|@F
L0@u@D*@Z@*0U@ʌL_@nP@JL@0
)@&@O
M@R@*0U@+@%@S&@ql@e+a@bh	ԕ@`	k@^Ov_خ@T*1@NMj@B@4n@.c	@S@L_@	oiD@&I@@4n@Q@G{@eں@GE85@"h	ԕ@	ԕ+@,<@7@|Q@U=@qu!@v_ح@F]c@dZ@`A7L@u!@Ov_خ@,=@iB@wkQ@5?|@2a|@qi@s@^5?}@$/@$/@~vȴ9X@|?@vȴ9X@j0
@a|Q@ZY@V+J@U=K@Sa@O@O@L~($x@I7KƧ@C@As@@n@@ѷX@@NU@=E@;m]@9"`@5sg@0
=q@-\@)lD@&@!o@(\@&@
D@ۋq@KƧ@{J#:@ᰊ@#w@'0@a|Q@qj@-w1@oiDg8@\@Vϫ@iDg8@ hۋ@C,z@r Ĝ@c	@@qu"@     @p{@nO;@h\)@de@_o@\C,zx@Zݘ@W@V@Vl!-@VR<6@Vt@U2a|@T`d@RsP@O\(@K'/@F-@EoiDg@EoiDg@En/@Eo i@DS@C@A@?|hs@<?@5\(@0 ě@.c	@-\@,q@+~($@+I^@*JL@)rGE@(r Ĝ@&@"@4@;dZ@JE@+j@&@O;d@@a@O@X@Mj@~($x@)^	@m\@ IQ@H˒:@6z@G{@=b@3@SMj@{m@D@B@r Ĝ@e@TɆ@%1@@4@ěT@U=@ܬ1&@,<@ٙ@ק&@`d@R@̲@ɅoiD@?@ѷX@NU@H˒@~$@~($@=b@=b@F]d@g@zxl"@U=@g	@'@@N@}H@?@S@O;d@l!-@2a|@*0U2@4J@;dZ@:@/{J#@:)z@ڹY@ݗ+@,zxl@u%F
@ [7@~
(@zG{@x)@u\(@oO
M@ilD@gRT`e@fL/{J@eF
L0@be+@`[6@^iB@]}H@]IQ@]/w@\N;@[=K^@Z1'@Y|@YJE@W@Vl!-@TO
M@Q_p@N;5X@MjOv@L@K҈@JD@I@GzH@Em\@B\(@?@:@2{m@.c	@*g	@*d7@'-@&'@%O
@$tSM@#9@"@4@"}Vm@!o@ A7K@Ft@%@]ce@_o@y=c@8YJ@	'RTa@]cf@YJ@
L/@$/@$/@8YK@m\@.H@s@oiDg8@Dg8~@@A@1.@ᰉ'R@ק&@4m@쿱[@3@ᰊ@a|Q@U2a|@
qv@B@
(@U=@0U2a|@RT`e@u@tSM@u@IQ@IQ@tSM@R<6@+J@C%@tj@ql@mC\@kP{@bM@_Ft@`҈p@^iB@S&@P{@64K@,zxl"@u@hr @C\@D@MjO@䎊q@\@ۋq
@C,@W>6z@`d@W'@@ǮzH@s@@vȴ9X@H˒:@YJ@|@-@r@
qv@U=@,@@u@M:@=p
@rs@l!-w@g@bM@VϪ͟@C$@A [7@:~@74m@5sg@0'RT@-U=@%u@O
M@*0U2@nO@Vu@
M:@@҈@&I@
$t@
m]@
Fs@
t@
1.@
ޞ@
b}@
N;5@
o i@
dZ@
B@
^@
[6@
,<@
u%F@
O;d@
sh@
Fs@
u%F@
$/@
sP@
4J@
)^@
qi@
qi@
Vu@
p:@
     @
qiB@
k~($@
["`B@
UfA@
Ov_ح@
L_@
JL_@
F
L/@
@6@
=<64@
9#w@
/O
M@
+jf@
)@
',@
$tSM@
	@
wkP@
@
n@
$tT@
bM@
@
Vu@
C%@
YJ@#@rGE@A@䎊qj@ce@:@Ƨ-@NU@E@{J#:@RT`e@	@@@!R<@=p
@K]d@nP@~"@|Q@o@a'R@\(\@YJE@W>6z@TɅoi@JW'@C@@4m@43@-B@+jf@$xF@Q@@L_@qi@nP@\N<@	k~@@.2@rGE@	@҈p@>BZ@E@Ϫ͞@y@Z@zxl"@&@kP|@@N@bM@Mj@@L_@C%@'RTa@n/@ѷX@˒:)@|Q@o@e@b@4@\]ce@S@Rp:@S@R<64@Rp:@Rp:@R䎊@PH@PH@C$@<Z@9XbM@73@5?|h@0U2a|@+6z@)*0U2a@(Xy=@!R<6@Q@kP|@u%@Ov_@bM@C%@Fs@n/@Q@%2@
˒:)@
m]@
Fs@
!.@
+jg@
:~ @
d8@
ڹY@
y=c@
Z@
_o @
W'@
ʌL_@
ɺ^5?}@
ȴ9Xb@
˒:*@
@
˒:*@
s@
Zc@
 [7@
@
YJ@
Xy=@
2W@
^@
/@
xF@
xF@
1@
zxl"h@
u@
u@
L/{J@
9@
@
o @
Vu@
qu"@
u%F@
nP@
xF@
u%F
L@
sMjO@
sPH@
t#@
sE@
s@
r{m@
o hۋ@
h@
aGz@
_o@
]ce@
Zc	@
Xe+@
W&@
Jn@
@C@
@n@
@6@
>vȴ9X@
;5Xy@
9~($@
9D@
9Y}@
5Xy=@
;dZ@
@4m@
=b@
8}H@
4J@
.zG@
Ov_خ@
-V@
u%@
@
$/@
sh@
ᰉ@
*0@
L_@
Ov_@
:)y@
C%@	ڹZ@	s@	+@	!-w2@	t@	fB@	lC@	䎊qj@	حV@	ݗ+j@	/w@	]ce@	6@	c	@	t@	ҽ<64@	@	s@	[W>@	6@	4m@	NU@	ߤ?@	)@	Q@	H@	1&y@	y@	
=p@	e+a@	҉@	L_@	u%F@	@	?@	ݗ@	@	|#x@	yrGE8@	qiB@	h@	f,<@	dqj@	a|Q@	`
qu@	Yb}@	SMj@	NT@	J#9@	C$@	@C@	;5Xy@	4֡a@	0{@	0U2a|@	-
qv@	,zxl"@	'-@	䎊r@	,=@	u"@	wkP@	ߤ@@	S@	=K^@	0
)@	+J@	tj~@	bM@	ߤ?@	@	~($x@	҈@	q@	
L/{@		'RTa@	JM@	u%F
@.H@\N<@E@H˒@ڹZ@ڹZ@($x@E@J#9@kP@ȴ9X@MjO@ hۋ@Ov`@rGE@rGE@8}H@+a@Z@C,@Gz@?@W>6z@حU@ק&@ԕ*1@а{@ΤT@cA \@@84֡@v@}H@9XbN@33333@&@F
L0@xF@n.3@R<6@ae@h	ԕ@
=p@-w1@=K^@+j@@L_@ݗ+k@tj~@Vu@o h@}E@{m]@xl"h	@rs@fA@ceO@ae@a'R@aGz@`d8@_حV@_;dZ@^@^5?|@]+j@]ce@\N;@_;dZ@_Ft@Z1'@QR@H@B74@B74@@6@5sg@1-@1-@0
(@',@ -
@}H@,<@@sh@*0U2@@
O;dZ@	 ѷ@K]d@	ԕ*@u%F@Q@u%F
@$tS@H˒@s@䎊q@"h	ԕ@ٳ|@|@Ϫ͞@_o @5Xy>@˒:)z@ʌL_@K]c@ěS@,zxl@s@TɅo@C@n@[W>@ߤ?@v@dZ@XbM@YJ@z@-@ ě@
qv@I^@&@TɆ@IQ@@ݗ+k@N;6@@o @ߤ?@xF]@	 @Fs@?@tj@I^5@$tS@{lC@zC\@y=b@vFs@u!.@u%F
L@t#@r ě@o hۋ@jOv`@ceO@^iB@\?@Z1'@XU@YJE@W&@PH@H˒:*@B74@;/V@/O
M@-B@*0
@%S@%F
L0@$tSM@$xF@#S&@"h	ԕ@ -
@}H@u%@@@0
)@*0@Ov_@*0U2@u@4J@qi@҈@+I@@n.@@ hۋq@!.I@SMj@s@(@A@҈p@Ϫ͟@,<@a@O@ӎMj@&@&@ҽ<64@҈p:@m@҈p:@N;5@а{@5Xy>@Ƨ@@˒:*@ǮzH@)^@?@,zxl@s@n@K]@4m@ߤ@W@-V@
(@{J#:@H@1&y@@TɆ@n.3@o@'RT`@!-w1@,=@}H@IQ@}H@+j@S&@(@#@ ѷ@y	k~@qiB@iDg8~@gfA@eO
@_حV@]+j@\]ce@]/w@_;dZ@B74@7KƧ@6}Vl@64K@5Xy=@6}Vl@2-V@-
qv@*d7@$?@ 'RT`@Xe,@zG@L_@L_@'/@eں@%F
L@E@{m@GE85@iDg8@(@A@ΤT@@b@NU@64@)_@Y}@)@}Vl@&x@
(@@wkQ@u%F@@hr @!R<@ݗ+@tj@I^5@~$t@sg@jg	@hۋq
@f1.@a@N@`҈p@`҈p@cS@dZ1@e+a@c	@]/w@UϪ͞@Ov_ح@JD@HK]c@DS@?H˒:@:S&@64K@2W@-B@%u@"wkQ@*0@nO@o @
M:@oiDg@$/@ȴ9X@l@!-w@>BZc@	@Ft@W>6z@c	@Q_@Q_@>BZ@1'@Q_@b}@sPH@䎊@As@+@jOv@˒:*@n@vȴ9X@j~#@)_@sg@ᰊ@o@<쿱@u@-@6z@0
@zxl"h@Fs@@~($x@@n.@$/@˒:)@|Q@y(@rGE85@lVϪ@jg	@iᰉ'@g@bM@bM@ceO@ffffff@h@vFs@|?@}H˒@|PH@z@o@ffffff@d7@bM@a@N@`d8@^҈p;@^5?|@[q@T,<@Ks@H@F]cf@C@:)_@1-@.2X@*0
@&@#9@vȴ@$/@n@4J@$tT@bM@'/W@qi@1&x@I^5@$/@"@~$@Fs@eں@l@O;@8Y@~"@ⶮ}Vm@څݘ@ԕ*1@˒:)z@@ȴ9Xb@)^@2W@Zc@NU@n.@XbM@rG@4K@3@-@L/{J@ěT@IQ@[@ߤ@@+j@Mj@qu"@@C%@=p
@K]d@JM@tj@$tS@zG{@w+@sg@p@n.2@kQ@eڹ@c	@`҈p@`
qu@_حV@^҈p;@^iB@\(\@ZY@TɅoi@P|@PH@H@A@:)y@2ᰊ@/r@/v@0 ě@,q@$tSM@!o@ [6@,=@qu!@$tS@tj~@hr @ߤ?@
O;dZ@$/@$t@~$@eں@Fs@_ح@Y|@j~@E@iB@@C\@Gz@@&@Z@ӎMj@ҽ<64@Z@R@̘_@ɅoiD@˒:*@ǮzH@Ƨ-@o i@a@N@a@N@Zc@ [7@C@C@ߤ?@쿱[@4m@ߤ@{@V@TɅ@'@Xy=@zxl"h@.H@䎊r@[@6C@$tS@Ov_@tj~@sP@ߤ?@k~(@Fs@4m9@~($x@~"@{~$@yrGE8@y	k~@xF@xF]d@xF@v!.I@t#@ql@p@l!-w@glC@a|Q@`A7K@`u!@`
qu@`A7K@`A7K@_;dZ@[$@Z1'@YJE@TE@QN;5@P*0U@LcA \@H@F?@B74@?@?H˒:@=<64@:)_@:)y@9~($@9#w@8)@7KƧ@4J@/O
M@-U=@.H@-w1@-B@*d7@#wk@ [6@,=@kP|@e+a@*0@0
)@$tS@@Mj@p:@%2@$/@F@%F
L@MjO@PH@D@C]@C,z@ᰉ'@1.@e@u!@cA @c	@>6z@l!-@t@m@W'@
L/@,zxl@NU@@A@Y}@}Vl@W@2W@
(@1@1&y@1&y@B@q@6z@'@TɆ@wkQ@o@ae@-
@h	ԕ@ae@ěT@쿱[W@u@,=@,=@,=@wkP@qu!@kP|@@tj@@Ov_@+J@҉@@p:@nP@n.@ѷX@~"@~($x@~\N<@}E@|#x@{J#9@y=b@{J#9@zG{@{s@zC\@v!.I@o4֡a@lVϪ@hr Ĝ@f,<@e+a@dqj@eڹ@d7@d%1@b@4@^@]/w@]+j@]ce@]+j@]+j@]/w@\?@]+j@[$@Yb}@V8YJ@Q@Ov_ح@L_@H9Xb@GzH@Fs@E@BZc@?|hs@=v@74m@43@3|@2m\@2ᰊ@1-@0 ě@.1@-
qv@,>B[@.zG@',@"wkQ@ 	k@쿱[W@}H@-V@qu!@qu!@,<@e+a@+j@+j@Xe,@$tS@ᰉ@$/@*0U2@҉@nO@-
q@~($x@
=p
@	7KƧ@#@oiDg@o h@ ѷ@n.@ ѷX@ $t@ Vl!@ G{@ 73@ ȴ9X@ !.I@ +jg@ D@ s@ oiDg8@  hۋ@ VϪ@ Ov`@ 	k@ ڹ@ 䎊qj@ $@ ԕ*1@ a@O@ ҽ<64@ ѷX@ H@ ;dZ@ т@ *0U@ jOv@ )^	@ ɺ^5?}@ ȴ9Xb@ s@ H˒:@ dZ@ 4m@ z@ U=@ TɅ@ S@ n.3@ `A@ o@ %@ =K^@ @ Ov_@ @ )^@ qu"@ ~($x@ q@ qiC@ =p
@ =p
@ 	 @ +I@ +I@ nP@  ѷ@ u%F
@ b}V@ {lC@ {J#9@ zG{@ xF]d@ uY|@ uY|@ t!-w2@ r䎊q@ rs@ r ě@ r{m@ rGE85@ nt@ m8Y@ l"h	ԕ@ hr Ĝ@ iDg8~@ gfA@ e@ eO
@ e+a@ d7@ cZ@ c	@ `u!@ ^҈p;@ ]ce@ [q@ [6@ Y+@ Sa@O@ QN;5@ P*0U@ M%@ JL_@ H9Xb@ F]cf@ D*0@ B74@ A7Kƨ@ >BZc @ :^5?|@ :S&@ :^5?|@ 9D@ 7KƧ@ 64K@ 5?@ 5'0@ 43@ 4J@ 2ᰊ@ 1[W>6@ /v@ ,1&y@ +I^@ *d7@ )y@ &x@ #
=p@ "3@  -
@  [6@  'RT`@ IQ@ Q@ u%@ u%F@ 0
)@ +j@ O;d@ tj@ @ sh@ *0@ S&@ N;6@ hr @ -
q@ @ 
qu"@ @ ҈@ 	ԕ*@ 	 ѷ@ 	'RTa@ 	'RTa@ 	'RTa@ K]d@ {J#9@ :S?ڹZ?C\?(?Q?ᰉ'?Z?@4?ᰉ'R?ᰉ'R?ߤ??$?]ce?حU?D*?͞%?s?@?C?6?[W>?/V?4m?sg?9XbN?g	l?ᰊ?-V?'RT?r?lD?
=p?-
?U=?쿱[W?-V?u"?S?u%F?R<6?tj~?hr ?Mj?~($x?C%?'RTa?eO?YJ?o hی?|hr?u%F
L?qiB?q?q?qiB?r ě?qiB?p
=q?nO;?iDg8~?hr Ĝ?fA?`d8?_o?W>6z?M?J#9?IQ?IQ?Fs?A7Kƨ?@4m???>BZc ?@NU?>6z?=p
=?=K]?0
(?/Vϫ?0U2a|?0
(?1o?1-?/v?0
(?1&x?/Vϫ?-w1?+jf?-w1?,<쿱?,zxl"?-V?+jf?&x?	?u%?sP?
qu"?
(?
qu"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @@X4m@@X4m@@X9Xb@@X{@@XU@@X4m@@X)@@X9Xb@@X)@@X)@@X{@@X9Xb@@X4m@@XTɅ@@X)^@@Xp:@@X{@@Y ѷ@@X4֡b@@Xۋq
@@Y$/@@Y$/@@X	k@@X\)@@X\)@@X$tT@@Y[W>6@@YlD@@ZGE85@@Zᰊ@@[S@@[q@@[A@@\/{J#@@\C@@\[W?@@]V@@]<64@@]5Xy>@@]?|h@@]L_@@]Y|@@]ce@@]`A7L@@]jOv@@]!R@@]!R@@]O
@@]=K@@]O
@@]=K@@]%@@]v@@]1@@]\(@@]cA @@]S@@],=@@],=@@^t@@^
(@@]C\@@]ᰉ@@]oiDg@@]oiDg@@]ڹ@@^@@^
(@@^zG@@^5?|@@^Vu@@^O;@@^,<@@^YJ@@^;5X@@^\N<@@^+J@@^Fs@@^O;@@^@@^@@_\(@@_͞@@_o @@_@@@`F]d@@`6@@` ě@@`bM@@``A7@@a4J@@a|Q@@a@@bC\@@bL_@@bxl"h
@@b<64@@b͞&@@c6z@@c%2@@dZ@@ece@@eb@@fߤ?@@g3@@hl"h	@@iiB@@l9XbN@@rc	@@uqu"@@z^5?|@@}U=@@~L/{J@@!-w1@@wk      @@L_@@73@@qu"@@s@@6C@@~@@Ov_خ@@@@0U2a|@@C\@@͊ڹZ@@ěT@@@@Y|@@lC@@ڰ ě@@@@/@@fA@@fffff@@:~ @@҈p@@tSM@@}Vl@@o@@艠'RT@@{@@=b@@u@@)y@@䎊q@@/V@@W>6z@@@@m]@@Q@@@@!-w2@@@@Fs@@M:@@Fs@@?@@<쿱@@SMj@@I^5?@@]ce@@q@@웥S@@wkP@@]ce@@C@@C@@웥S@@zxl"@@1&@@_@@m8@@M:@@%1@@L_@@tj@@L_@@g@@a@@@a@O@@Ƨ@@a@O@@
=p@@Q@@64@@?@@C,zx@@,<@@<쿱@@?@@ߤ@@@VϪ@@?@@M:@@`d@@Fs@@<쿱@@9XbN@@M:@@M:@@PH@@Z1@@tSM@@q@@wkP@@`d@@PH@@C,zx@@g8}@@g8}@@`d@@Z1@@M:@@Z1@@wkP@@~($x@@쎊qj@@N;@@N;@@TɆ@@#x@@j~@@?@@Ʌoi@@JM@@K]@@u@@/w@@B@@<64@@L_@@IQ@@sg@@퇓ݗ@@+j@@힃%@@U=@@sh@@b@@_o @@$/@@;5X@@\N<@@vȴ9X@@vȴ9X@@IQ@@}Vl@@+J@@O;@@ȴ9X@@C-@@쿱[W@@"@@@@
M;@@Xe@@.H@@KƧ@@zH@@fA@@حV@@Vϫ@@#@@     @@F]d@@bM@@U2a|@@
(@@@@4֡b@@C@@\)@@ ѷ@@$/@@ [7@@ae@@(@@N;6@@o@@N;6@@	 @@0U2a|@@T`d@@kP|@@xl"h
@@L/{@@`A@@c	@@'/@@	@@/V@@F]c@@*0U2@@m]@@|@@J@@s@@1&y@@L_@@L_@@Fs@@3@@JM@@'0@@*0@@+a@@IQ@@w1@@!R@@%@@Ϫ͞@@_o @@E@@vȴ9X@@+J@@@@T@@Ϫ͟@@쿱[W@@,@@KƧ@@U=@@\(@@o@@sPH@@|hs@@O;d@@kP@@@@;dZ@@@@+j@@	ԕ+@@6@@bM@@4m9@@y=c@@
qu@@|hs@@eں@@|hs@@Vϫ@@'RT`@@eO@@˒:*@@U@@_p@@#w@@Gz@@Dg8~@@ae@@N;5@@'RTa@@n.@@'RTa@@u@@'R@@e@@n@@C\@@u%F
@@@@I^@@33333@@qu!@@{J#9@@:)z@@$@@wk@@q@@m]@@|@@J@@wkP@@hr@@>@@:@@V@@u@@qu"@@2a|@@S&@@m\@@O
@@ᰉ@@+jg@@BZc @@Vu@@}Vl@@,<@@6z@@ߤ?@@]cf@@ߤ?@@As@@sPH@@&@@@A      @A F]d@A 	ԕ+@A @A bM@A 'RT@A d8@A ѷX@A `A7@AA [@AoiD@A^5?}@AiB@Au%F@A1'@A=p
@Au%F
@AL_@A@A`A@A~@A	@A"`B@A/V@A=K^@AP{@Aa@N@A@Awk@A6@A҈@AQ@AZ1@Azxl"@A@A!-w@A2a|@A5Xy>@Aw1@Av@Ash@AϪ͞@AS@Aڹ@A8YJ@AT@A}Vl@A'@A쿱[W@ART`e@A&@A@A$tS@A@A@A@@A#@A@A'RT`@AA7K@AK]c@ANU@A[6@A'RT@A@@Ap:@A`A7@A		k~@A	7KƧ@A	XbM@A	|Q@A	2W@A	-@A
Ov`@A
&IR@A
0U2a|@A
Zc@A
{m@A
ᰊ@A
L/{@A
>B@A
}Vm@A
W@A
c	@AS&@AS&@AnP@A/V@AJ#9@Aa@N@AU=@A@Aa@@A҈@A%2@Ag@An.@A!-w2@A9XbN@AVϪ@Aq@A_@A>B[@A
!.H@A
O;dZ@A
m\@A
!R@A
+j@A
@A
-V@A
sh@A
sh@A
sh@A
H˒@A
Ϫ͞@A
@A

qv@A
E@A@AH@Avȴ9X@AFs@AFt@AFt@A)^@A)^@A)^@A)^@Av@AU=@A\(@AO;d@A	k@A[W>@AK]d@A@AF]d@AU2a|@A-
@A-
@AѷX@Aۋq
@A҈p@A\)@A$/@A ѷ@A	k~@A@N@A@A&x@A-w1@A4J@A:S@A*0U2a@AA [@ADg8~@AQ@A7Kƨ@A'RTa@Aԕ*@A-@Ae+@A)y@Axl"h
@Aᰊ@AڹY@Am@Am\@AS&@A74@A'/@A9@An.3@AZ@AQ@AC]@As@AxF@A!-w2@A9XbN@A`d@AC@A?@A?@AɅoi@AZ@AD@A:@Ao i@A%F
L@A/w@A84֡@AB@AS&@AVl!@AU=@A\(@A!.@A
(@A!R<@A+J@A$t@A-@AQ@AϪ͟@AAs@AE84@A_o@Aeں@Ao@A|hs@A	@A͞@ArG@A䎊r@ArGE9@A
qu@A@A$xG@A-
q@AH@Ahۋq@AeO@A-
@A
=q@AěT@Ae+@A	k@A [7@ATɅo@Au!S@A'RTa@Al@A@A@A-@AlD@An@A.H@AI^5@As@A#9@A#9@A&IR@A)y@Ae+@A=p
@AM@A~"@AwkQ@Avȴ@A`A@AsP@AC,@A~@AnP@A)^	@A9@A@N@AS@A{J#9@A$@Aߤ@AS@AE@A|@AQ@A1&y@A%1@A<쿱@AC,zx@AFs@AM:@AVϪ@AwkP@A[W?@A@A*0@AɅoi@AJM@A(@A5Xy>@AS&@Aw1@A+j@An/@A(@A ѷY@At@A5?|@ABZc @AR<6@AiB@Az@AIQ@AQ@AFs@A@A
=p@AFt@A@A;dZ@AE84@ART`e@A&@AkP@A	k@A/V@A+@AحV@A@@ArGE9@A 'RT`@A 4m9@A D*@A oiDg8@A YJ@A @A 4m@A TɅ@A D@A @A \)@A! ѷ@A!rGE@A!XbM@A!o hی@A!(@A!D@A!y@A!_o@A!N;6@A!@A!@A!@A"u%F@A"e+@A"䎊@A"6C@A"h	ԕ@A"ᰊ@A"wkQ@A"Y@A"͞&@A",<@A"G{@A" ѷ@A" ѷ@A"䎊q@A" ѷ@A" ѷ@A"C,@A#s@A#"`B@A#6z@A#@N@A#F]c@A#W>6z@A#n.3@A#{J#9@A#Q@A#ߤ@A#m]@A#@A#~($@A#
=p@A#lC@A#@A$J@A$xF@A$ߤ@@A$ߤ@@A$%1@A$9XbN@A$M:@A$I^5?@A$M:@A$tSM@A$?@A$7@A$?@A$JM@A$E@A%V@A%K]@A%V@A%Q@A%!.H@A%Q@A%(@A%5Xy>@A%84֡@A%Vl!@A%\@A%@A%n/@A%ᰉ@A&@A&1.@A&1.@A&($x@A&.2@A&5?|@A&1.@A&($x@A&5?|@A&H@A&$t@A&2X@A&2X@A&ߤ?@A&1@A&Fs@A'@A'
=p@A'
=p@A'@A'v@A'v@A'Xe@A'$tS@A'+I@A'4֡a@A'>6z@A'H˒:@A'Xe,@A'iDg8@A'iDg8@A'eں@A'&@A'vȴ9@A'vȴ9@A'/V@A'/V@A'@@A';dZ@A'@@A'-@A'#@A(-
q@A(Xy=@A(hۋq@A(n@A(n@A(@A(YJ@A('RT@A(U@A({@A(U@A(9Xb@A(9Xb@A(4m@A(9Xb@A(4m@A(TɅ@A(F@A({@A(\)@A) ѷ@A)rGE@A)_p@A)*0U2a@A):S@A)Gz@A)e+a@A)x@A)|Q@A)7Kƨ@A)@A)@A)l@A)'R@A)2W@A)@A)lD@A*u%F@A).H@A*	 @A*@A*&IR@A*1'@A*Q_@A*Zc@A*d7@A*~"@A*g	@A*͞&@A*C,@A+I^@A+'/@A+PH@A+s@A+/V@A+P{@A+dZ@A+q@A+S@A+Z@A+Z@A+@A+
=p@A+g@A,n.@A,L_@A,,<@A,VϪ@A,]ce@A,wkP@A,qj@A,_@A,N;@A,쿱[@A,1&@A,Ʌoi@A,D@A,>@A-:@A-o i@A-K]@A-K]@A-o i@A-V@A-Q@A-5Xy>@A-B@A-IQ@A-O;dZ@A-O;dZ@A-S&@A-Vl!@A-ce@A-p
=@A-ݗ@A-!R@A-+j@A-!R@A-=K@A-=K@A-=K@A-@A-@A-Xy=@A-sh@A-\(@A-Ϫ͞@A-
qv@A-E@A. ѷY@A.t@A. ѷY@A._o @A.
(@A.zG@A.Ov_@A.$/@A.;5X@A.;5X@A.H@A.H@A.p:~@A.+J@A.Fs@A.@A.T@A.@A.Ϫ͟@A.C-@A.Fs@A.!.I@A/
=p@A/
=p@A/@A/Ft@A/
M;@A/@A/,@A/,@A/E84@A/\(@A/eں@A/o@A/y@A/4m@A/y@A/kP@A/@A/حV@A/rG@A/rGE9@A0*0U@A0:~ @A0>BZc@A0A7K@A0D*@A0A7K@A0K]c@A0NU@A0U2a|@A0Xy=@A0[6@A0_F@A0_F@A0[6@A0bM@A0_F@A0@A0
=q@A0p:@A0F@A0e+@A04֡b@A1*0U2a@A10
)@A10
)@A17KƧ@A1XbM@A1ae@A1^@A1ae@A1^@A1o hی@A1u!S@A1@A1R<6@A1n.@A1(@A1@A1(@A1l@A1B@A1|@A1X@A12W@A1iB@A1-@A2@4n@A2^5?|@A2^5?|@A2h	ԕ@A2nO@A2u%F
@A2{m@A2@4@A2ᰊ@A2vȴ@A2@A2 ě@A2g	@A2Y@A2Y@A2}Vm@A2@A2͞&@A2 ѷ@A2 ѷ@A2C,@A274@A3S&@A3nP@A3	@A3&@A333333@A3P{@A3g	l@A3tj~@A3xF]@A3{J#9@A3xF]@A3n.3@A3eO@A3q@A3Mj@A3Mj@A3$@A3*0U2@A3~($@A3@A3@A3|@A3ݗ+k@A3ݗ+k@A3҈@A3lC@A3lC@A3A [@A4J@A4"h	ԕ@A42W@A49XbN@A4Fs@A4Fs@A4Fs@A4VϪ@A4m8@A4#@A4qj@A4?@A4@A4D@A4>@A5'0@A5'0@A5*0@A5u@A5*0@A5*0@A5!.H@A5/w@A55Xy>@A584֡@A5B@A5?|h@A5?|h@A5F
L0@A5S&@A5Y|@A5`A7L@A5fA@A5ce@A5zxl"h@A5ݗ@A5ڹZ@A5ݗ@A5M:@A5%@A5@A5U=@A5-V@A5\(@A58YK@A5ڹ@A64K@A6zG@A6@A6@A6u@A6zG@A6@A6Ov_@A6Ov_@A6$/@A6+jg@A61.@A6;5X@A6E@A6?@A6L/{J@A6Vu@A6fffff@A6p:~@A6z@A6@A6,<@A6'@A6Q@A6@A6ߤ?@A6t@A6҈p;@A6]cf@A6ߤ?@A6@A6Mj@A6Fs@A6"@A6!.I@A7@A7@A7
M;@A7Ft@A7Ft@A7,@A7+I@A7As@A7RT`e@A7\(@A7o@A7sPH@A7|hs@A74m@A7|hs@A7v_ح@A7y@A7&@A7@A7/V@A7@A7fA@A7حV@A7حV@A7@A7Vϫ@A7-@A7@A7@A7@@A7rG@A8     @A8
qu@A8*0@A81&x@A8K]c@A8Xy=@A8U2a|@A8U2a|@A8Xy=@A8eO@A8l"h	@A8˒:*@A8)@A8e+@A8@A8e+@A8{@A8@A8`A7@A8C@A8{@A8PH@A8$tT@A8PH@A9+@A9+@A9@A9@N@A9+@A9@A9+@A9	k~@A9@N@A9_p@A9-w1@A90
)@A94J@A9:S@A9ae@A9b}@A9oiD@A9~($@A9u@A9(@A9l@A9l@A9'R@A9@A9D@A9"`@A9@A9e@A9s@A9>BZ@A9lD@A:	 @A:	 @A:0U2a|@A:6C@A:0U2a|@A:0U2a|@A:0U2a|@A:GE85@A:Zc@A:u%F
@A:u%F
@A:@4@A:\(@A:L/{@A: ě@A:}Vm@A:g	@A:Y@A: ě@A:g	@A:g	@A:Y@A:<64@A:@A:,<@A:sP@A:,<@A:sP@A:䎊q@A:~@A;u%@A;S&@A;nP@A;"`B@A;	@A;9@A;@N@A;S@A;a@N@A;xF]@A;Q@A;Q@A;~$@A;@A;eO@A;wk@A;@A;@A;m]@A;6@A;6@A;҈@A;A [@A;A [@A;$@A<n.@A<ߤ@@A<Q@A<!-w2@A<"h	ԕ@A<(\@A<C,zx@A<cA \@A<zG@A<#@A<C@A<@A<?@A<?@A<Ʌoi@A<*0@A<@A<*0@A<*0@A<hr@A<!-w@A=o i@A=K]@A=K]@A=u@A=5Xy>@A=2a|@A=5Xy>@A=<64@A=IQ@A=L_@A=m\@A=p
=@A=m\@A=jOv@A=p
=@A=sg@A=m\@A=p
=@A=$/@A=!R@A=hr!@A=+j@A=%@A=U=@A=n/@A=@A=n/@A=H˒@A=\(@A=8Y@A=?@A=,=@A>t@A>_o @A>
(@A>@A>!R<@A>Ov_@A>+jg@A>BZc @A>Ov_خ@A>R<6@A>YJ@A>YJ@A>YJ@A>+J@A>@A>af@A>,<@A>O;@A>}Vl@A>2X@A>@A>m\@A>ȴ9X@A>ȴ9X@A>A@A>+@A>ߤ?@A>Fs@A>!.I@A?
M;@A?)^@A?@A?+I@A?4֡a@A?KƧ@A?RT`e@A?O
M@A?RT`e@A?iDg8@A?iDg8@A?lC@A?v_ح@A?sPH@A?{J#:@A?	@A??@A?͞@A?[W>@A?K]d@A?حV@A?@A?;dZ@A?rG@A@F]d@A@	ԕ+@A@
qu@A@bM@A@6@A@$xG@A@A7K@A@D*@A@H@A@NU@A@NU@A@r Ĝ@A@YJ@A@@A@@A@@A@'RT@A@@A@@A@tj@A@u%F@A@-
@A@@A@@@A@ۋq
@A@`A7@A@C@A@@A@C@A@@A@\)@AA ѷ@AA	k~@AA@AArGE@AA@N@AA+@AA_p@AA&x@AA&x@AA0
)@AA:S@AAA [@AAN;5@AAJE@AAe+a@AAk~(@AAu!S@AA|Q@AA7Kƨ@AAoiD@AA@AA'RTa@AAu@AAn.@AAn.@AA(@AAl@AAl@AA^5?}@AA_o@AAe@AAe@AAs@AAY}@AA-@ABI^5@ABe+@AB䎊@AB䎊@AB䎊@ABe+@AB䎊@AB-V@AB=p
@ABGE85@ABQ_@ABa|Q@ABkP|@ABL_@ABL_@ABp:@AB~"@AB{m@AB{m@AB@4@ABS&@AB0
@ABwkQ@AB>B@AB ě@ABg	@AB@AB)_@AB`A@ABڹY@ABG{@AB䎊q@ABc	@ABm@AB74@ABD@AB~@AB~@ABm\@AC҉@ACnP@AC҉@ACs@ACnP@AC'/@AC"`B@AC,zxl@AC/V@AC,zxl@AC6z@AC33333@AC/V@AC=K^@AC@N@AC@N@ACS@ACxF]@ACeO@ACMj@ACq@AC*0U2@ACE@ACE@ACƧ@ACݗ+k@ACQ@ACQ@AC҈@AClC@AC$@AC@ADJ@ADxF@ADߤ@@ADtj@AD%1@AD9XbN@AD9XbN@AD?@ADPH@ADVϪ@ADcA \@ADcA \@ADq@AD~($x@AD~($x@ADC@AD*1@AD_@AD*1@AD*1@AD_@AD*1@ADO
M@AD?@AD?@AD#x@AD?@AD?@ADɅoi@ADj~@AD[W?@ADɅoi@AD7@AD[W?@ADj~@ADj~@AD?@ADZ@AD>B[@AD֡a@AD>B[@ADu"@AD>B[@ADZ@AD!-w@ADE@AEV@AE*0@AEQ@AEQ@AE!.H@AE%F
L@AE+a@AE+a@AE/w@AE5Xy>@AE5Xy>@AEF
L0@AE<64@AE<64@AE?|h@AEL_@AEY|@AEfA@AEp
=@AEw1@AEsg@AEp
=@AEw1@AE}H@AEzxl"h@AEM:@AEڹZ@AEhr!@AE!R@AEO
@AEhr!@AEO
@AEO
@AEhr!@AEO
@AE@AEU=@AEsh@AE\(@AE\(@AE8YK@AE
qv@AE?@AES@AE,=@AE,=@AE!.@AF ѷY@AF
(@AF@AF4K@AF@AF@AFu@AF$/@AF+jg@AF.2@AF1.@AF$/@AFL/{J@AFVu@AFVu@AFVu@AF\N<@AFR<6@AFl!-@AFfffff@AFs@AFs@AFvȴ9X@AFp:~@AFiB@AFvȴ9X@AF}Vl@AF}Vl@AFIQ@AFz@AF%@AF@AF,<@AFT@AF6z@AF6z@AF}Vl@AFߤ?@AF&I@AF&I@AF&I@AFt@AFA@AF+@AFC-@AFC-@AF쿱[W@AFx@AF@AFMj@AFFs@AG@AG)^@AG@AGv@AG,@AG+I@AGH˒:@AG\(@AG_o@AG_o@AGb}V@AG_o@AG_o@AGlC@AGlC@AGv_ح@AG|hs@AGy@AGy@AG&@AG͞@AGr@AGvȴ9@AGvȴ9@AG;dZ@AGrG@AGVϫ@AG䎊r@AG䎊r@AG䎊r@AH     @AH
qu@AH@AH6@AH6@AH'RT`@AH4m9@AH:~ @AH>BZc@AH:~ @AH:~ @AHA7K@AHD*@AHH@AHA7K@AHU2a|@AH[6@AH[6@AHoiDg8@AHoiDg8@AHl"h	@AHoiDg8@AHy=c@AH|@AH|@AH|@AH˒:*@AH˒:*@AHn@AH'RT@AH|@AH'RT@AH@AH-
@AH-
@AH
=q@AH-
@AH
=q@AH@AH
=q@AH
=q@AH@AH
=q@AHU@AH4m@AH)@AH)@AH
(@AH@@AHD@AHD@AH҈p@AH@AH	k@AI ѷ@AI@AI@AI_p@AI@N@AI#w@AI-w1@AI0
)@AI-w1@AI-w1@AI:S@AI7KƧ@AIDg8~@AIJE@AIGz@AIGz@AIQ@AIN;5@AIae@AIo hی@AIo hی@AIk~(@AIrGE8@AI@AIo@AI@AI@AIo@AI@AIn.@AI(@AI'R@AI'R@AIX@AI^5?}@AIX@AID@AIo@AIo@AI_o@AIԕ*@AI@AIiB@AIe@AIe@AIR@AIe@AI@AI-@AIY}@AI-@AI.H@AI.H@AJ	 @AJOv`@AJe+@AJe+@AJ1'@AJ6C@AJ:)y@AJ@4n@AJJL@AJC\@AJQ_@AJQ_@AJQ_@AJW'@AJT`d@AJZc@AJZc@AJqiC@AJ{m@AJ~"@AJL_@AJp:@AJL_@AJS&@AJᰊ@AJwkQ@AJwkQ@AJwkQ@AJwkQ@AJS&@AJS&@AJS&@AJ}Vm@AJ<64@AJ@AJn@AJ)_@AJW@AJW@AJW@AJW@AJ,<@AJڹY@AJG{@AJ䎊q@AJfB@AJfB@AJC,@AJfB@AJD@AJ~@AKS&@AKs@AKs@AKs@AKnP@AKs@AKnP@AKPH@AKC,z@AKC,z@AK&@AK	@AK)^	@AK/V@AK6z@AKC%@AKP{@AKMjO@AKP{@AKS@AKW>6z@AK]cA@AKa@N@AKa@N@AK]cA@AKdZ@AKdZ@AKg	l@AKdZ@AKxF]@AKxF]@AK{J#9@AK{J#9@AKqu!@AKqu!@AK{J#9@AK{J#9@AK{J#9@AK~$@AK@AKQ@AKMj@AKQ@AKQ@AKeO@AKQ@AKq@AKS@AKwk@AK*0U2@AK*0U2@AK@AKq                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @s@sfffff@s@s@sfffff@sfffff@sfffff@s@sfffff@s     @s     @sfffff@rfffff@rfffff@rfffff@s     @s@sfffff@s@s@s     @s	@s33333@r@r񙙙@r     @r33333@r@s@s$@s6fffff@sC33333@sH     @sP     @sP     @sI@sI@sD@sC33333@sH     @sK33333@sI@sD@s>fffff@s1@s333333@s4@s6fffff@s4@s0     @s@s     @s@s#33333@s)@s)@s&fffff@s!@s@sfffff@sfffff@s     @sfffff@s33333@r     @r陙@r     @r     @rfffff@r@r@rfffff@r     @r     @r@r@rљ@rљ@r@r     @r     @rfffff@r33333@rfffff@rfffff@r33333@r     @r@rfffff@r@r     @r@r@r33333@r33333@rfffff@rnfffff@rp     @r|@r@r@rfffff@rfffff@q33333@qfffff@q@r@r      @q@p33333@p@p@p33333@q@q           @m     @mfffff@m@n33333@n@ni@i&fffff@hə@h33333@h@     @h	@g@g)@f@fFfffff@f#33333@f33333@e33333@e33333@evfffff@e     @dٙ@dfffff@d@d@d     @d@d33333@dy@dvfffff@dl@dY@dFfffff@d@     @d@     @dC33333@dFfffff@dC33333@d6fffff@c@c     @cfffff@c@cə@c@c33333@cs33333@cp     @cp     @cl@cffffff@cFfffff@c     @bfffff@b陙@b@b33333@b@b33333@b33333@bp     @bi@bc33333@bVfffff@bI@bP     @b\@b`     @b`     @bS33333@b@a     @a     @afffff@b      @b@b     @a@a@a@a@a     @a33333@a@a@a33333@a33333@a333333@a)@a      @a@a@a@a      @`vfffff@`s33333@`c33333@`Vfffff@`@     @`@_fffff@_33333@_fffff@_33333@_     @_Y@_,@^33333@^     @^@^@^@^9@^,@^33333@^      @]fffff@]@]fffff@]Ffffff@]33333@]@]      @]9@]Y@]Y@[33333@[fffff@Z33333@[      @[@[@Z@ZS33333@Z,@Z33333@Z      @Y@Y     @Y33333@Yfffff@Y`     @Yfffff@Xٙ@X     @X33333@X@Xfffff@X@Xfffff@X33333@Wfffff@WS33333@WFfffff@W@     @W@     @WFfffff@W`     @WS33333@W333333@V33333@V     @Vfffff@V     @Vfffff@V`     @U@Ufffff@Ul@U@     @Ufffff@T     @T     @T@T@Tfffff@T33333@Tl@TS33333@Tffffff@TS33333@TS33333@TL@TL@T@     @Sfffff@S&fffff@S33333@Sfffff@R@R     @Rfffff@R@R@Rfffff@Rffffff@R@     @R&fffff@R,@R      @Rfffff@Qٙ@Q     @Q     @Q@Qfffff@Qy@Qffffff@Qffffff@Qs33333@Ql@QS33333@Q,@Q333333@Q333333@Q333333@Q&fffff@Q33333@Q@Q      @Q33333@Qffffff@Q     @Qfffff@Qfffff@Q     @Ql@QS33333@QFfffff@Q&fffff@P33333@Pfffff@Pٙ@P     @Pfffff@P@P     @P33333@Pٙ@P33333@P@P     @Pfffff@Py@PL@P333333@P      @P@P      @O33333@Offfff@Oٙ@O@O@Oٙ@O@O@N     @N33333@N33333@Nfffff@Nfffff@Nfffff@N@Ns33333@N&fffff@N      @N@N@N&fffff@N@M&fffff@Lٙ@Lٙ@L33333@L33333@M      @M@M@M@K33333@Kfffff@K@K@Ks33333@Kffffff@K@Jfffff@JL@J@     @J@J      @Ifffff@Iٙ@Ifffff@Ifffff@Is33333@IY@IL@I333333@I&fffff@H33333@H33333@H     @HL@H@     @H@H      @Gfffff@G     @G     @Gfffff@Gfffff@Gs33333@G333333@F33333@F     @Ffffff@Ffffff@Fٙ@Ffffff@F33333@F      @E33333@F      @F@F@Eٙ@EL@E333333@D33333@D     @D@D     @D     @Ds33333@DY@DL@D@     @D&fffff@D@D      @C33333@D      @D@Cfffff@C@Cfffff@Cs33333@Cs33333@Cffffff@C&fffff@C@C@C@B33333@B     @Bfffff@B@Bffffff@B@     @B333333@B&fffff@B      @Afffff@A@Aٙ@A33333@A33333@Aٙ@A     @A@A     @AL@@33333@A      @A      @A      @@33333@@ٙ@@33333@@@@@@Y@@333333@?fffff@?@@@@@?@?333333@?333333@?L@?333333@?333333@?     @?@?      @>fffff@>@>@>L@=fffff@=@=L@=     @=     @=ffffff@=ffffff@=L@=333333@=333333@=@=333333@=@<@<@<33333@<     @;fffff@<@<@<@<@;     @;     @;@;33333@;33333@;33333@;ffffff@;L@;L@;ffffff@;L@;ffffff@;      @;      @;@;@;333333@;333333@;L@;      @;      @:fffff@:@9fffff@9@9@9@9@9@9fffff@933333@933333@933333@933333@9@9@9L@9L@9333333@9@8@833333@8@8@8ffffff@8     @8     @8     @8L@8333333@8333333@8333333@8ffffff@8     @8ffffff@7@733333@7@7fffff@7fffff@7333333@7L@7333333@7ffffff@7ffffff@6@6@6ffffff@6     @6ffffff@6ffffff@6L@6L@6L@6333333@6@6      @5fffff@5fffff@6      @6      @6      @5fffff@5     @5@5ffffff@5ffffff@5333333@5L@5333333@5@5333333@5      @5      @5      @5@5@5333333@5L@5      @5      @4fffff@4fffff@4fffff@5      @5@433333@433333@4fffff@433333@433333@4@4@4@4@4     @4     @4ffffff@4@4ffffff@4L@4333333@4L@4L@4L@4L@4L@3@3@3@333333@3@3@3@3     @3L@3@3@3ffffff@3     @3ffffff@3L@3333333@3@3      @3@3@3@3      @2@2@2@2@233333@2@2     @2@2     @2     @2@2     @2     @2ffffff@2ffffff@2L@2333333@2L@2L@2L@2L@2333333@2333333@2333333@2      @2@1fffff@1fffff@2@1@1fffff@1fffff@1fffff@1fffff@1fffff@1@133333@1@1@1@1     @1@1     @1@1@1ffffff@1     @1ffffff@1ffffff@1     @1ffffff@1333333@1333333@1@1333333@1L@1      @1      @1@1333333@1L@1333333@0fffff@1      @0@1      @0fffff@0fffff@0@0@0@0@0@0@0@0@0@0@0     @0     @0@0     @0     @0     @0     @0@0L@0ffffff@0L@0L@0L@0L@0333333@/@0@0@0      @0      @0@/@/@0@0L@/@0      @/@/@.@.@/333333@.@.@.@.@.@.ffffff@.ffffff@.ffffff@.ffffff@.@.ffffff@-@-@.      @-@-@.      @.      @-@-@-@-@-@-@-@-ffffff@-ffffff@-@-@-@-333333@-ffffff@-@-333333@-333333@,@-      @-      @,@,@-      @,@,@,@,@,@,@,ffffff@,333333@,ffffff@,@,333333@,ffffff@,ffffff@,ffffff@,ffffff@,ffffff@,      @,ffffff@,      @,      @,      @,      @+@+@+@+@+@+@+@+@+@+@+@+@+333333@+333333@+333333@+333333@+ffffff@+ffffff@+333333@+ffffff@*@*@*ffffff@*333333@*ffffff@*333333@*333333@*      @*      @*      @*      @)@)@)@)@)@)333333@)ffffff@)ffffff@)ffffff@)333333@)333333@)@)@(@(@)333333@)      @)      @)333333@(@(@(ffffff@(@(@(ffffff@(@(@(ffffff@(ffffff@(333333@(ffffff@(ffffff@(ffffff@(333333@(ffffff@(333333@(      @(      @(      @(      @(      @(      @(333333@(ffffff@(      @(      @(      @'@(      @'@'@(      @'ffffff@'ffffff@'@'@'@'@'@'@'ffffff@'@'@'@'@'ffffff@'@'333333@'333333@'333333@'333333@'ffffff@'333333@'ffffff@'@'ffffff@'ffffff@'@'ffffff@'333333@'ffffff@'333333@'333333@'ffffff@'      @&@'      @'      @'      @'      @'      @'      @&@&@&@&@&ffffff@&@&@&@&ffffff@&@&@&@&@&@&@&@&@&@&@&ffffff@&@&@&ffffff@&@&@&333333@&ffffff@&333333@&      @&@&ffffff@&@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&@&ffffff@&333333@&333333@&ffffff@&@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&@&@&ffffff@&@&@&@&@&@&@&@&@&ffffff@&ffffff@&@&@&@&@&@&ffffff@&ffffff@&@&@&ffffff@&@&@&ffffff@&ffffff@&@&@&ffffff@&@&@&@&@&ffffff@&ffffff@&@&@&@&@&ffffff@&@&@&ffffff@&@&@&@&@&@&@&@&@&@&@&@&@&@&@&@&@&@&@&@'      @'      @&@'      @&@&@'333333@'ffffff@'      @'      @'333333@&@&@'ffffff@'333333@'      @'333333@'333333@'      @'333333@'333333@'      @'ffffff@'333333@'333333@'333333@'333333@'ffffff@'ffffff@'333333@'@'ffffff@'@'@'@'@'@'@'ffffff@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@'@(      @(      @(333333@(      @'@'@(ffffff@(333333@(333333@(ffffff@(      @(      @(333333@(ffffff@(333333@(@(ffffff@(ffffff@(333333@(ffffff@(333333@)333333@(@(@)      @)      @(@(@)333333@)ffffff@)ffffff@)ffffff@)333333@)      @)333333@)ffffff@)ffffff@)ffffff@)@)@)@)@*      @)@*      @*      @*333333@*      @)@*@*@*ffffff@*@*@*ffffff@*ffffff@*@+      @*@+333333@+      @*@*@+333333@+333333@+@,      @+@+@+@+@+ffffff@,      @,      @,      @,      @,333333@,ffffff@,      @,333333@,333333@,333333@,333333@,333333@,ffffff@,@,@,ffffff@,ffffff@-333333@-      @,@,@,@,@,@,@-333333@,@-      @-333333@-333333@-@-ffffff@-@-@-@-@.333333@-@-@.      @.      @.      @.      @.      @.      @.      @.333333@.333333@.ffffff@.333333@.ffffff@.@.@.@.@.@.@.@.@/333333@/333333@.@/333333@/333333@/@/ffffff@/ffffff@/@0@0333333@0@/@0@0@0333333@0L@0L@0L@0L@0     @0     @0333333@0L@0L@0L@0@0L@0ffffff@0@0@033333@033333@033333@0@0@0     @0ffffff@0@0fffff@0fffff@0fffff@0@033333@1333333@1333333@1333333@1      @0fffff@1      @1333333@1L@1ffffff@1333333@1     @1     @1ffffff@1L@1@1fffff@133333@1@1     @1@133333@1fffff@1@1fffff@1fffff@133333@2333333@2L@2ffffff@2     @2ffffff@2ffffff@2@2ffffff@2     @233333@233333@233333@233333@233333@2@3@3      @3@3@3333333@3@333333@3     @3ffffff@3@3@3@3@3fffff@3fffff@3fffff@3fffff@4@3@4L@4     @4@4ffffff@4L@4333333@433333@433333@433333@4@4     @4     @4@5ffffff@5L@5333333@5333333@5333333@5      @4fffff@5fffff@533333@5     @5     @5ffffff@5ffffff@533333@5fffff@6      @6      @5fffff@5fffff@6     @6     @6     @6@6@6@633333@633333@633333@6@7      @7@7L@7333333@7L@7L@7     @7ffffff@7333333@733333@733333@733333@7@7@733333@733333@7@8@8@7fffff@7fffff@8      @7fffff@7fffff@8L@8ffffff@8     @8     @8333333@8333333@833333@8@833333@8fffff@9@8@8fffff@8@9     @9@933333@9@9ffffff@9333333@9@9@9fffff@9@9fffff@9fffff@9fffff@:333333@:L@:L@:L@:333333@:333333@9fffff@:@:@:@:33333@:@:fffff@:fffff@;333333@;333333@;@;333333@;@;ffffff@;     @;33333@;33333@;@;@;@;@;@;@;@;fffff@;fffff@<@<333333@<@<@<333333@<333333@<ffffff@<     @<33333@<@<@<33333@<     @<     @=333333@=L@=L@=333333@=      @=@<@=@=@>      @>      @>L@>333333@>L@>333333@>     @>@>@>@>@>33333@?      @?333333@?L@?333333@?L@?ffffff@?33333@?fffff@?@?@?@?     @?@@@@@@@@&fffff@@@@@?fffff@@Y@@@     @@@     @@333333@@@     @@@     @@ffffff@@Y@@ffffff@@ffffff@@ffffff@@ffffff@@ffffff@@Y@@     @@     @@s33333@@@@     @@s33333@@@@fffff@@     @@@@fffff@@ٙ@@fffff@@fffff@@fffff@A      @@fffff@@33333@@33333@A      @A      @A@A      @A@A&fffff@A@A@AY@A@     @A333333@A333333@A@     @Affffff@As33333@Affffff@As33333@As33333@As33333@A@A@Afffff@A@A@As33333@A33333@Afffff@Afffff@A     @Afffff@A@A33333@Afffff@Afffff@Afffff@A33333@Afffff@B&fffff@B@     @BL@B@     @BL@B333333@B&fffff@Bs33333@BL@BY@Bffffff@Bffffff@Bffffff@B@Bfffff@B33333@B33333@B@B@B@B@B@B     @B@B@B     @Bfffff@Bfffff@Bfffff@Bfffff@Bfffff@C&fffff@C@C333333@C333333@C@C@C@C@     @CL@C333333@C@Cs33333@C     @Cs33333@Cs33333@Cs33333@C@C@Cfffff@C     @C     @C     @Cٙ@Cfffff@C     @C     @D&fffff@D@     @D@     @DL@D@     @DL@D&fffff@D&fffff@Ds33333@Dffffff@DY@DY@Ds33333@Dffffff@D     @D     @D@D@Dfffff@E@E@     @E@     @E333333@E@E@E@Es33333@E     @E@EY@E33333@E33333@E     @Eٙ@E33333@E@Efffff@Eٙ@E@Eٙ@F@F@F      @E33333@F      @F@F&fffff@F333333@FL@F333333@F@     @F333333@F@     @FL@FL@FL@FL@FL@Fffffff@F@F@F     @Fs33333@FY@F@F@F@F@F33333@F33333@F33333@Ffffff@Fٙ@Ffffff@F@Ffffff@Ffffff@G@G&fffff@G333333@G@     @G333333@G333333@G@     @GY@G     @G     @G     @G     @Gs33333@GY@G33333@G33333@G@Gfffff@Gfffff@G@Gٙ@Gٙ@Gٙ@Gٙ@H      @H&fffff@H@H      @H@H      @HY@H@     @HY@HY@H@     @HY@HY@H@     @H     @H     @H     @H     @Hs33333@Hffffff@H33333@H33333@H33333@Hfffff@H33333@Hٙ@H@H33333@Hfffff@I      @I      @I      @I@I@I@I@     @I333333@IL@IY@Is33333@IL@I@I     @Is33333@Is33333@I     @Ifffff@Ifffff@I@I     @I33333@I@Iٙ@I33333@I33333@J@J      @J      @I33333@J      @J      @JY@J@     @J@     @J@     @J@J&fffff@J@     @Jffffff@Js33333@Jffffff@Jffffff@Js33333@J     @J@Jfffff@J@J@J@J     @Jٙ@Jٙ@J33333@Jfffff@Jfffff@Jٙ@J     @Jfffff@K@K      @J33333@K      @K      @J33333@K@     @K333333@K@     @K333333@K333333@K333333@Kffffff@K     @K     @Ks33333@Ks33333@K@K     @K@Ks33333@K     @K33333@K33333@K     @K     @K33333@Kfffff@K33333@K     @K@K@K33333@Kfffff@Kfffff@Kfffff@Kٙ@K@Kٙ@K@K     @L@L&fffff@L@L@L      @L                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ?1&?+?+?nO?x?~"?Q?Vu?M?n?Vt?Q? ě?"`?E?\(?Q?S?(\)?Q?KƧ?\(?\(?l?|hr?O;dZ?zG?7KƧ?      ?vȴ9@ tj~@ nP@ m@5?|h@ ěS?E?S?tj?\(\? ě?KƧ?333333?Vu?
=p?333333?&x?S?XbM?7KƧ?A7Kƨ?tj?Q?$/?lC?I^5?+I?Z1'?"`A?nO;?S?-?bM?vȴ9X?I^5??zG?E?;dZ?"`?$/?lD?
=p?C$?1&x?n?C%?S?Q?S?$/?Q?I^5??n?tj?tj~?1&x?߾vȴ9X?KƧ?$/?j~#?܋C%?O;dZ?+?hr Ĝ?GzH?l?dZ1?dZ1?7KƧ?lC?      ?ם-V?
=p
?\(\?ҏ\(?Ƨ-?~"?9XbM?ӅQ?ղ-V?У
=p?r ě?QR?Ѻ^5?|?GzH?"`B?=p
=?7KƧ?E?5?|h?p
=q?|hr?|hr?"`B?̋C%?ǮzG?ȓtj~?-V?7KƧ?KƧ?lC??|hs?Ł$/?
=p?$/?zG{?nO;?I^5??nO?Õ$/?Q?
=p?ěS?j~"?vȴ9X?|hr? ěT?GzH?-V?`A7L?I^5??
=p?-V?ěS?`A7L?-V?-V?;dZ?hr Ĝ?lD?nP?&x?GzH?vȴ9X?Q?A7Kƨ?lD?vȴ9X?&x?Q?`A7?A7Kƨ?A7Kƨ?;dZ?      ?ěS?GzH?E?      ?&x?M?E?-V?M?&x?I^5??Q?vȴ9?ěS?&x?&x?nP?lD?E?A7Kƨ?\(?1&y?nP?M?|hr?lD?Q?
=p?"`?j~"?      ?
=p?Q?hr!?vȴ9X?A7Kƨ?/v?Q?`A7L?lD?ěS?I^5??$/?
=p?M?GzH?vȴ9X?ěS?bM?"`?° ě? ěT?nO;?GzH?I^5??j~"?^5?|?
=p?lD?`A7?Q?n?(\)?n?|hr?vȴ9X?-V?bM?-V?-V?E?bM?+?tj~?hr Ĝ?-V?-V?GzH?hr Ĝ?7KƧ?333333?
=p?nO?tj~?I^5??tj~?$/?`A7L?A7Kƨ?nO;?l?A7Kƨ?Q?nO?nP?S?hr Ĝ?|hr?Õ$/?-V?Q?`A7?hr Ĝ?nO;?Q?Õ$/?7KƧ?-V?tj~?nP?nO;?`A7?M?`A7?9XbM?`A7L?M?-V?&x?\(?-V?Q?Q?n?-V?&x?ěS?\(?+?5?|h?GzH?7KƧ?GzH?° ě?S?S?+?`A7?$/?
=p?ěS?`A7?hr Ĝ?GzH?\(?`A7?° ě?GzH?M?vȴ9X?l?° ě?° ě?&x?&x?9XbM?tj~?
=p?lD?Q?l?I^5??lD?nO;?Q?hr Ĝ?&x?`A7L?hr Ĝ?GzH?hr Ĝ?I^5?? ěT?M?7KƧ?\(?nO;?M?+?-V?-V?`A7L?
=p?9XbM?M?333333?
=p?M?öE?\(?öE?l?n?öE?nO?&x?-V?Q?° ě?&x?nP?M?nO?333333?n?° ě?$/?ļj~#?-V?I^5??`A7?`A7L?l?-V?° ě?nO? ěT?I^5??$/?5?|h?° ě?333333?tj?`A7K?nO;?nO;?`A7?$/?;dZ?S?7KƧ?ěS?$/?bM?l?A7Kƨ?hr Ĝ?|hr?`A7?° ě?° ě?\(?hr Ĝ?9XbM?`A7?Q?GzH?Q?+?+?lD?l?tj~?n?I^5??&x?n?7KƧ?&x?GzH?° ě?`A7?+?nO?\(?° ě?nO;?n?7KƧ?hr Ĝ?$/?Q?S?
=p?`A7L?-V?Q?nO;?nO?GzH?° ě?`A7L?\(?/w?M?S?
=p?I^5??$/?GzH?-V?&x?$/?hr Ĝ?\(?tj~?ěS?tj~?zG{?l?-V?      ?7KƧ?hr Ĝ?`A7?° ě?
=p?S?° ě?ěS?Õ$/?Q?&x?Z1'?7KƧ?GzH?lD?E?hr Ĝ?+?Õ$/?GzH?S?`A7?+?+?tj~?S?Õ$/?I^5??l?$/?Õ$/?šo?zG{?GzH?A7Kƨ?-V?&x?$/?`A7L?`A7L?\(?$/?\(?öE?E?hr Ĝ?7KƧ?Q?;dZ?lD?hr Ĝ?I^5??lD?n?tj~?S?nO;?\(?lD?tj?&x?+?M?tj~?Õ$/?M?`A7?-V?$/?|hr?nP?+?tj~?\(?nO?`A7?zG{?\(?`A7L?lD?ěS?tj~?-V?nO;?\(?S?hr Ĝ?tj?333333?Z1'?l?M?\(?n?ěS?ļj~#?-V?GzH?Z1'?-V?$/?öE?ěS?
=p?n?Õ$/?GzH?7KƧ?S?n?öE?-V?° ě?+?bM?
=p?|hr?nO?GzH?A7Kƨ?      ?l?I^5??ěS?&x?ěS?Q?Z1'?E?7KƧ?333333?GzH?`A7?ļj~#?Õ$/?ěS?\(?Õ$/?öE?`A7?9XbM?+?lD?S?I^5??Q?+I^?E?nO?`A7?\(?tj~?-V?333333?/w?7KƧ?l?l?I^5??`A7?hr Ĝ?+?9XbM?šo?° ě?vȴ9X?
=p?333333?`A7?A7Kƨ?7KƧ?+?+?tj?\(?\(?tj?Q?nP?Q?S?-V?nO;?\(?lD?`A7L?° ě?7KƧ?-V?° ě?-V?333333?$/?`A7?Õ$/?+?$/?`A7?E?ěS?`A7L?333333?nO;?öE?-V?
=p?zG{?I^5??7KƧ?l?Q?333333?M?\(?l?$/?I^5??I^5??A7Kƨ?$/?9XbM?M?A7Kƨ?`A7L?hr Ĝ?l?`A7?
=p?`A7L?333333?tj?hr Ĝ?I^5??tj~?Õ$/?lD?° ě?Q?S?ěS?`A7?333333?° ě?l?9XbM?nP?tj?nO?Q?
=p?tj~?tj~?GzH?
=p?lD?Z1'?9XbM?\(?bM?-V?hr Ĝ?öE?Q?ěS?9XbM?° ě?Q?nO;?° ě?`A7?I^5??M?\(?Õ$/?-V?+?öE?° ě?° ě?lD?&x?$/?GzH?333333?S?öE?lD?9XbM?9XbM?nO;?° ě?I^5??tj?Q?l?333333?° ě?nO?l?
=p?ěS?7KƧ?ěS?nO?I^5??S?nO?M?n?l?Q?Õ$/?ěS?S?7KƧ?šo?öE?$/?n?A7Kƨ?A7Kƨ?+?ļj~#?Q?nO;?S?-V?nO?vȴ9X?      ?Q?333333?öE?° ě?\(?7KƧ?hr Ĝ?7KƧ?-V?
=p?hr Ĝ?-V?`A7?° ě??|hs?-V?`A7?-V?tj~?333333?`A7L?/w?`A7?-V?nP?`A7?7KƧ?öE?A7Kƨ?tj~?333333?\(?nO;?M?lD?nP?n?M?E?tj?+?`A7?`A7?lD?° ě?° ě?333333?/w?nO?      ?9XbM?° ě?+?Õ$/?šo?Õ$/?l?9XbM?öE?lD?9XbM?tj~?n?šo?`A7?7KƧ?
=p?n?S?l?E?333333?`A7?9XbM?öE?9XbM?tj~?l?tj?+?Q?zG{?`A7?l?\(?M?Z1'?7KƧ?S?Õ$/?+?ěS?7KƧ?l?Õ$/?$/?-V?n?l?+?nO?`A7K?° ě?S?ěS?zG{?M?-V?Õ$/?ěS?
=p?&x?Õ$/?° ě?nO?öE?° ě?° ě?333333?nO?bM?tj~?lD?tj?Z1'?\(?`A7L?öE?Õ$/?Q?l?° ě?ěS?+?-V?S?7KƧ?333333?l?° ě?$/?ļj~#?GzH?hr Ĝ?`A7?&x?nO?lD?333333??|hs?9XbM?l?M?tj~?;dZ?S?l?M?9XbM?+?7KƧ?-V?° ě?\(??|hs?l?öE?lD?9XbM?
=p?I^5??tj~?Q?-V?M?tj~?+?Z1'?S??|hs?nO?I^5??zG{?Q?+?nO;?° ě?M?° ě?Q?hr Ĝ?nP?Q?\(?Z1'?-V?° ě?lD?7KƧ?ěS?/w?-V?S?9XbM?Q?lD?Q??|hs?\(?tj?A7Kƨ? ěT?Ł$/??|hs?
=p?7KƧ?+?n?Z1'?ěS?lD?/v?/w?9XbM?`A7K?9XbM?ěS?lD?l?
=p?nO?-V?Õ$/?Õ$/?nO?zG{?nO?l?tj~?tj~?tj~?`A7?öE?° ě?tj~?° ě?\(?l?nO?° ě?
=p?n?$/?9XbM?öE?333333?Q?nO;?333333?9XbM?S?      ?Q?-V?&x?hr Ĝ?nO?S?-V?S?I^5??$/?tj~?Q?hr Ĝ?ļj~#?7KƧ?`A7L?M?zG{?\(?° ě?-V?Q?I^5??\(?I^5??+?lD?Õ$/?333333?l?ěS?\(?`A7?nO?öE?\(?Ł$/?nO?9XbM?Õ$/?° ě?+?ļj~#?M?nO;?nO;?`A7?+?tj?nO?9XbM?GzH?
=p?tj~?ěS?n?S?
=p?$/?Q?9XbM?öE?GzH?M?tj?n?-V?-V?333333?tj?\(?$/?zG{?Z1'?tj~?Õ$/?l??|hs?öE?lD?M?tj?° ě?nO;?S?Õ$/?Q?öE?Q?7KƧ?-V?-V?7KƧ?333333?ěS?nO?S?n?      ?+?S?tj?S?S?GzH?`A7L?öE?nO?nO?nO;?-V?
=p?7KƧ?GzH?E?9XbM?ļj~#?`A7?-V?hr Ĝ?
=p?öE?° ě?333333?/w?tj~?333333?333333?n?l?l?nO;?l?-V?ļj~#?+?-V?Q?\(?S?ěS? ěT?-V?`A7?n?Õ$/?9XbM?Q?S?`A7K?tj?\(?-V?nO;??|hs?Ł$/?tj~?ļj~#?nO;?ěS?
=p?lD?S?S?öE?l?l?nO?`A7K?zG{?ļj~#?öE?l?9XbM?333333?I^5??nO;?\(?S?-V?-V?\(?
=p?lD?lD?`A7K?šo?&x?\(?-V?&x?Q?QR?tj~?n?Q?I^5??tj~?-V?$/?Q?öE?öE?M?-V?-V?9XbM?Q?-V?
=p?l?333333?° ě?tj?333333?° ě?° ě?$/?Q?-V?-V?`A7?`A7?`A7?$/?-V?l?\(?Õ$/?9XbM?nO;?nO?l?S?bM?nO;?nO?"`?
=p?l?S?l?S?nO;?Q?GzH?l?7KƧ?n?&x?A7Kƨ?-V?/w?nO;?nO?nO?nO;?+?-V?ěS?° ě?+?l?
=p?`A7?+?l?
=p?&x?$/?nO?-V?S?tj~?-V?+?-V?l?`A7K?tj?zG{?n?\(?l?\(?-V?bM?hr Ĝ? ěT?l?° ě?tj~?333333?l?$/?333333?
=p?Õ$/?ěS?Q?tj?\(?9XbM?-V?-V?öE?-V?GzH?ěS?hr Ĝ?tj~? ěT?GzH?Q?M?E?S?S?I^5??l?&x?öE?I^5??ěS?nO?+?° ě?öE?`A7K? ěT?$/?-V?bM?\(?-V?$/?tj~?-V?-V?Õ$/?tj?lD?A7Kƨ?vȴ9X?A7Kƨ?-V?GzH?-V?9XbM?öE?/w?-V?hr Ĝ?\(?tj?tj~?333333?n?zG{?M?Q?\(?l?\(?nP?n?Õ$/?nO;?`A7L?\(?-V?Q?° ě?hr Ĝ?-V?\(?S?M?lD?333333?° ě?
=p?\(?Õ$/?-V?n?A7Kƨ?\(?lD?&x?S?-V?I^5??° ě?hr Ĝ?nO?öE?A7Kƨ?GzH?S?l?tj~?bM?`A7L?7KƧ?tj~?`A7?-V?9XbM?I^5??Q?-V?-V?
=p?tj~?GzH?/w?Q?333333?l?M?tj?nO;?Q?9XbM?nO?Õ$/?Õ$/?nO;?nO;?\(?M?GzH?A7Kƨ?° ě?I^5??
=p?9XbM?|hr?tj?GzH?hr Ĝ?nO;?° ě?n?;dZ?S?I^5??° ě?&x?ěS?
=p?Q?tj~?j~"?nO;?tj~?GzH?
=p?7KƧ?l?Q?|hr?333333?&x?A7Kƨ?nO;?tj~?&x?nP?n?9XbM?Q?tj~?
=p?nO?M?I^5??7KƧ?7KƧ?vȴ9X?7KƧ?I^5??Q?`A7?I^5??1&y?I^5??7KƧ?$/?\(?nO?hr Ĝ?hr Ĝ?ěS?Õ$/?+?|hr?j~"?S?E?Q?nO;?Q?Q?hr Ĝ?lD?-V?7KƧ? ěT?`A7K?E?\(?lD?Q?n?7KƧ?hr Ĝ?&x?Q?n?A7Kƨ?tj?° ě?$/?`A7L?A7Kƨ?      ?$/?
=p?-V?Z1'? ěT?nP?`A7L?I^5??I^5??333333?Q?tj~?-V?tj~?\(?l?nO;?M?\(?9XbM?-V?nP?5?|h?&x?lD?nO;?
=p?Q?lD?333333?"`?nP?M?lD?öE?&x?-V?tj~?7KƧ?&x?Õ$/?9XbM?I^5??hr Ĝ?hr Ĝ?nP?&x?$/?$/?-V?n?lD?tj~?
=p?9XbM?333333?vȴ9X?&x?tj~?
=p?Q?`A7L?lD?Q?l?I^5??Q?p
=q?
=p?-V?lD?;dZ?-V?-V?&x?`A7?`A7L? ěT?nO?nO;?l?nO?
=p? ěT?A7Kƨ?n?hr Ĝ?nO;?-V?+?n?M?7KƧ?hr Ĝ?-V?bM?hr Ĝ?7KƧ?hr Ĝ?nO?7KƧ?Q?hr Ĝ?tj~?      ?bM?`A7?
=p?
=p?I^5??ěS?;dZ?-V?`A7L?`A7?`A7L?öE?n?
=p?° ě?;dZ? ěT?lD?"`A?n?`A7L?bM?\(?
=p?-V?"`?bM?GzH?I^5??-V?M? ěT?° ě?333333?hr Ĝ?-V?333333?nP?j~"?-V?&x?nP?
=p?vȴ9X?GzH?-V? ěT?M?ěS?&x?E?`A7?$/?1&y?7KƧ?A7Kƨ?-V?n?;dZ?&x?\(?-V?&x?ěS?Q?Q? ěT?$/?lD?I^5??E?M?-V?Õ$/?° ě?M?hr Ĝ?5?|h?lD?vȴ9X?nO;?° ě?lD?n?Õ$/?ěS?-V?;dZ?-V?+?QR?&x?° ě?
=p?\(?`A7?S?nO;?/w?;dZ?I^5??$/?A7Kƨ?S?333333?l?&x?GzH?n?lD?I^5??tj~?
=p?lD?A7Kƨ?I^5??I^5??Q?\(?bM?/v?nP?A7Kƨ?-V?nO?bM?
=p?lD?"`?7KƧ?hr Ĝ?GzH?nP?ěS?
=p?`A7L?nP?GzH?M?nP?A7Kƨ?7KƧ?nP?`A7L?öE?° ě?\(?
=p?A7Kƨ?GzH?`A7L?7KƧ?"`?1&y?
=p?M?&x? ěT?5?|h?M?A7Kƨ?p
=q?nP?&x?`A7L?&x?nO?hr Ĝ?öE?"`?"`?hr Ĝ?I^5??lD?lD?GzH?+J?A7Kƨ?`A7L?&x?ěS?j~"?j~"?nO;?nP?
=p?"`?ěS?-V?n?nP?7KƧ?n?-V?ěS?/v?ěS?"`?`A7?vȴ9X?M?bM?ěS?lD?-V?-V?j~"?Q?hr Ĝ?/v?A7Kƨ?E? ěT?E?ěS?vȴ9X?`A7L?GzH?I^5??"`?E?Q?hr Ĝ?-V?-V?öE?Q?1&?bM?A7Kƨ?j~"?$/?j~"?QR?+J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@M     @M@     @M@M@M@M@M@M     @M     @M     @Ms33333@M     @M@Mfffff@Mfffff@M@M     @Mffffff@M@M@M@M@M@M@Ms33333@Ms33333@Ms33333@Mffffff@ML@MY@M@     @M@     @MY@Mffffff@Mfffff@Mfffff@M@N      @N333333@Ns33333@Ns33333@N     @N@Nfffff@N@     @Ns33333@Nٙ@Nfffff@O      @O@O&fffff@O333333@O333333@O@     @O@     @OY@Offffff@O     @O     @O@O@Offfff@O33333@O33333@Pfffff@P33333@P,@P,@P333333@P&fffff@P333333@PFfffff@PS33333@PS33333@PS33333@PS33333@PS33333@PS33333@PS33333@PY@PY@P`     @P`     @Pl@Pl@Pl@Pl@Pl@Pl@Pl@Ps33333@Py@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P33333@P33333@Pfffff@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P@P@P@P@P@P     @P     @P     @P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P33333@P@P@P33333@P@P@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P33333@P@P@P@P33333@P@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@Ps33333@P@P@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P33333@Pfffff@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P33333@P@P33333@P@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P@P@P@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @P@P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P@P@P     @Pfffff@P@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P@P@P@P@P@Pfffff@P     @P     @P@P@P@Pfffff@P@P@P@P@P@P@P@Pfffff@P@P33333@P33333@P@P33333@P33333@P@P@P33333@P33333@Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@Pٙ@Pٙ@P33333@P@P@P33333@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P@P@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pٙ@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P@Pfffff@P@P@P@Pfffff@P@P@P@P@Pfffff@P33333@Pfffff@P@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pٙ@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@P@P@P@P@P@P@P@Pfffff@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P33333@P     @Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P33333@P@P@P@P33333@P@P@P@P@P@P@P33333@P@P@P@P@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P@P33333@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P33333@P33333@P33333@Pٙ@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P33333@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @P@P@P@P@P@P@P@Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @P@Q      @P@P@Q      @P@P@Q      @Q      @P@P@P@Q      @P@P@Q      @P@Q      @P@P@P@P@P@P@P@Q      @P@P@P@P@P@Q      @P@P@P@Q      @Q      @P@P@Q      @P@P@Q      @Q      @Q      @P@P@P@P@P@P@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                P17                                     1                                       BEf3