CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P12    CAST_NUMBER       4      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:48.064622Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @A         data_max      @A         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     >p  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @ffffff   data_max      @D        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      >p  l   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d            temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?%F
L0   data_max      @"m\   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       >p     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@S҈   data_max      @AKeO   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      >p    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       G   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @%         data_max      @r        C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        >p V   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       $   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?vȴ9   data_max      ?S   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      >p    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       0   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       >p    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       1<   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @N   data_max      @P   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     >p @   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       H   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      
   data_max      
   C_format      %10d       4   latitude               	long_name         latitude   units         	degrees_N      data_min      @H|3 )   data_max      @H|3 )   C_format      %9.4f          8   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `UQCrq   data_max      `UQCrq   C_format      %9.4f          <   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        @   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        D@A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @A      @ffffff@      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @@33333@A     @B      @B     @C      @C@Cfffff@D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d@d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g33333@g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @o@p     @p      @p0     @p@     @pP     @p`     @pnfffff@p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @rљ@rfffff@r     @s@s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|@|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @33333@     @     @      @'33333@0     @8     @@     @H     @P@X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @@33333@     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H@O33333@X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@@G33333@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @@33333@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @      @     @     @33333@      @(     @0     @8@@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x@     @     @     @     @     @     @33333@     @     @     @@     @     @     @     @     @      @33333@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @&fffff@/33333@8     @@     @H     @P@X     @`     @h     @p     @x     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @ @33333@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p@y@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @@33333@     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @Ù@     @     @     @fffff@י@     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @Dfffff@G@L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @fffff@@     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @+33333@0     @4fffff@8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @fffff@@     @     @     @      @fffff@     @     @     @     @fffff@@      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@     @     @     @fffff@33333@      @$     @(     @,     @0     @4     @8     @<     @@     @D     @I@L     @P     @T     @X     @\     @`fffff@d     @h     @l     @p     @t     @v@|fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @ fffff@#@(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @Dfffff@H     @L     @O@T     @X     @\     @`     @d     @h     @l     @p     @tfffff@w@|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @dfffff@g@l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|fffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @xfffff@{@     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @ fffff@     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @fffff@      @$     @(     @,     @0     @4fffff@7@<     @@     @D     @H     @K@Pfffff@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @ fffff@@     @     @     @     @     @     @      @$     @(     @,     @0fffff@3@8     @<     @@     @D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @"_p@"{@"`A7@"
(@"_p@"4J@"hr @"l@")^@"{@"`A7@"$tT@"
(@"@"$tT@")^@";dZ@"p:@"m\@"a|Q@"s@"R@"D@"T`d@";5X@"	@"	 ѷ@"	ԕ+@"$xG@"y@"@".H@!c	@!_F@!!.I@!p:@!/V@!E@!E@!2W@!	^5?}@ OiDg8@ J@ M:@s@Ʌoi@+j@YJE@.t@$/@%@&@s@n.3@_@M@9D@S&@8Y@As@!.I@҈p@+@d7@Y>BZ@Sa@O@>\N<@(\)@"`B@/{J#@Vϫ@Q_@C@\@bM@q@E@~"@)^	@@@ n@u"@Fs@!.I@E@\(@ ě@RT`e@e@	k@A7K@Ov_خ@Ж@\(@+@1'@@׍O;d@!-w1@A7K@U=@o@Q@#Z@BI^5@BZc@=K]@64K@L/{J#@jOv`@wXe@˒:)@M:@S@2W@?@u%F@M:@c	@'@V@j~@64@ĵ?@&@o@SMj@ 4m9@eO@1'@?@_o@_o@1'@vȴ@"`B@qu!@]ce@҈p;@ 	k@$xF@$%1@ ěT@ce@1&@_o@b}@ 
qu@$?@'	k@/@.H@.1@,<쿱@%@IQ@ߤ@@(>BZc@tj@&1.@;5X@!R@\@g	@x@$xG@h	ԕ@jOv@Xe@:~ @Q@B@<n.@+~($@fA@-
q@R@qi@o h@֡a@޸Q@As@ڹ@@|쿱[@kC,z@f,<@eڹ@eO
@f@ceO@c9@b@4@VϪ͟@Oo @&@V@3@@m\@Fs@'0@jf@`A7L@o@Q@/w@`d@o @D@@y"`@r ě@e@/iDg8@ߤ?@@A [@ᰉ'R@ce@Q_@hr @&I@,zxl@u%F
@@^ ѷY@I@N;@
O;dZ@_o@Z@!-w2@H@ۋq
@1'@_p@~($x@vȴ9X@S&@|j~#@ZkP|@?.H@8}H@1u!S@!|Q@Y@Vu@I^@ɺ^5?}@-@e@~($x@x)@xl"h	@w3@v!.I@xF]d@v+jg@mhr!@[Q@H˒:*@>$t@2䎊q@.}Vl@kP|@O
M@zH@iB@	k@%1@[@ҽ<64@ɺ^5?}@쿱[@S@Z@'/W@@n@S@}v@vȴ9X@mhr!@kU=@jOv`@iDg8~@dtSM@E@JE@v_ح@q@Zc@!.I@e@JE@Õ$@/V@@ȴ9X@RT`e@)^@o i@|n.@s@Z6C@Qhr @P|@Oo @O'/W@L@DJM@9Y}@'&@%@#A [@cA @*0@bM@K]c@D@C,zx@a@O@cA \@)^@m8@@B@x@.H@ߤ@@PH@Z@eO@o i@IQ@}b@z@w1@tj~@r䎊q@q[W>6@lVϪ@g-@cS@[u%@Xy=c@S@N@=b@-\@)Dg8~@#A [@҈p;@(\@4J@~$@H@Xy=@u@?@Z@Ft@PH@zG@̘_@#@ĵ?@:S@&IR@.H@
(@@6z@-
@%F
L@33333@VϪ@A7K@@)^@p:~@5Xy>@L_@'/@W'@@=p
@=p
@+I@7Kƨ@$/@~ߤ?@|PH@xYJ@v_ح@sg@nzG@gfA@g&@_!-w1@RnO@=Vl!@2m\@/v@'&@'lC@*͞&@5'0@73@4֡a@3@-\@@}H@-V@[@]ce@q@(\@N;@q@bM@sh@tj~@'/W@
L_@)^@I^5@BZc @/V@-V@~"@Ft@u@!-w1@حU@H@Ƨ@6@C-@m8@g	l@a|Q@
(@.2@(@!-w@VϪ@~($@JL@@x@(\@ݗ+k@:)y@_p@H@͞@jOv@]cA@$/@IQ@NU@ѷX@4m@IQ@4m@~ߤ?@}E@}K]@{lC@z^5?|@y	k~@xF]d@v!.I@v4K@s33333@rGE85@nc	@irGE@eڹ@a|Q@Y>BZ@T`d@M(@Jn@GzH@E8YK@Dg8}@B@A7Kƨ@=ڹZ@3MjO@-\@+6z@)B@(Xy=@',@&L/{J@%F
L0@$qj@#S@vȴ9@1'@JE@JE@U@D*@Xe,@Ov_@=K@R@
jOv@q@	^5?}@eO@S@
(@Q@֡a@GE85@
(@ ě@c	@$xG@U=@8YJ@Z@o @͞%@W'@s@I^5@b}V@H˒:@ڹZ@73@C-@Fs@j~@-@@1@VϪ@tSM@҈p;@W>6z@1'@Mj@%@W'@Fs@JM@{J#9@ [7@~6z@|쿱[@{~$@z@y#w@y	k~@wkP@vȴ9X@sPH@nO;@lC@j0
@ezxl"h@ae@^Q@\wkP@Y>BZ@S*0U2@P@K:)z@Iԕ*@Ik~(@H9Xb@H1&x@FFs@@NU@>ߤ?@>\N<@>vȴ9X@<Z@9XbM@7eں@0:~ @.zG@-w1@-V@-(@,q@&,<@8YJ@)^	@	 ѷ@n/@@@4n@o hی@TɅo@s@kP@j~@	ԕ+@W>6z@_p@As@̘_@o i@<64@^5?|@Q@KƧ@m8@{J#:@jf@IQ@u@`A@3@S&@ae@R<6@sh@R<6@nO@bM@-
q@\(@tj@JM@ݗ@     @}ڹZ@~m\@@	 @nP@z@xF@kC]@]ce@YJE@A7Kƨ@3g	l@*͞&@'RT`e@"`A@$tSM@'RT`e@+6z@)y@'/V@&@%u@ 	k@vȴ9@tj@*0U2@u@n@#@>B@73@-V@8Y@fA@Z@u!@ԕ*1@Ƨ@ɅoiD@@ěS@5Xy@D@E@g	l@'RT@6z@@qu!@O
M@Vu@O;dZ@qi@qi@'RTa@1&x@Fs@JM@ ѷ@˒:)@|?@nt@\(\@YJE@U2a|@S&@O͞@M@IoiD@E84֡@@4m@<64@74m@1[W>6@ 	k@,<@:)y@I^5?@@
@
B@
W>6z@
jOv@
]cA@
˒:*@
a@N@
BZc @
)_@
XbM@
KƧ@
KƧ@
4K@
0U2a|@
h	ԕ@
Q@
e+a@
Xe,@
R<6@
@
tj~@
@
!R<@
o h@
m\@
_;dZ@
\(\@
ZY@
Z1'@
Xy=c@
Xy=c@
Sa@O@
RT`d@
O͞@
M@
K]cA@
G@@
Em\@
ATɅo@
?@
>ߤ?@
=K]@
9D@
7KƧ@
6C-@
8}H@
5?|h@
0 ě@
,>B[@
',@
U=@
zG@
qi@
u%F@
I^5@E@C\@@kP@#@@.2@,<@|Q@ce@1'@Ϫ͟@R@Ϫ͞@ΤT@s@ʌL_@?@@^5?|@|@O
M@V@U=@lD@TɆ@Ov_خ@@@@}E@{J#9@v_ح@tj~@r{m@nt@l[W?@hr Ĝ@dqj@bC,@`u!@\N;@Y+@T`d@L/{J#@F
L/@?|hs@:)_@5'0@/v@-U=@-w1@,>B[@,1&y@(@!ae@C,zx@@Ov_@nO@
ڹY@$tS@Q@lC@G{@=b@-
@_ح@:~ @lC@حV@ۋq@Ϫ͟@@ʌL_@[W>@D@XbM@3@9XbN@}Vl@`A@@tj~@N;6@$tT@M:@Q@xF]d@sg@nc	@ix@g@de@_?@TɅoi@SZ@NT@A@2ᰊ@,<쿱@(Xy=@"`A@!-w1@S@@O
M@~($x@+I@
H˒@
(@
"`@
G{@
s@
Q@
!.H@
H˒@
#x@
"`@
!R@
{m@
@
hr!@
\@
\@
\@
쿱[W?@
fB@
A@
M@
;dZ@
>@
e+@
Ϫ͟@
fA@
;dZ@
̘_@
@@
84֡@
\N@
,zxl@
BZc @
Y}@
3@
?|h@
{@
w1@
jf@
y@
,@
L/{J@
-w1@
!-w1@
Ov_خ@
,=@
-V@
}H@
u"@
1&@
wkP@
=K^@
e+a@
@
@
'/@
 ѷ@
oiDg@
@
o hی@
y(@
qA [@
jJL@
d%1@
cZ@
a'R@
`d8@
_حV@
\]ce@
ZY@
YJE@
Vl!-@
UfA@
QN;5@
KƧ@
E@
B74@
@4m@
>ߤ?@
>
(@
<j~#@
<쿱[@
9XbM@
5?@
2m\@
0'RT@
-w1@
#n.3@
!.H@
!.H@
"3@
!.H@
 ěT@
쿱[W@
쿱[W@
vȴ9@
 'RT`@
 [6@
䎊r@
vȴ9@
	@
,=@
,<@
$tS@
tj~@
'/W@
I^5?@

qiC@
	k~(@
#@
ݗ@
{J#9@
$/@	=b@	@	4֡a@	Q@	@	حV@	֡af@	`d@	&@	т@	K]c@	C@	[W>@	vȴ9X@	쿱[@	)y@	sg@	O
M@	/V@	IQ@	1@	F
L0@	F
L0@	zxl"h@	wk@	_o@	nO@	qi@	_o@	.H@	r ě@	kP{@	iDg8~@	h>BZc@	ffffff@	d%1@	c	@	_o@	\>@	Zc	@	VϪ͟@	SMj@	P*0U@	JL_@	;5Xy@	5?|h@	/{J#:@	+6z@	(TɅ@	#
=p@		@	%@	u"@	*0@	Xe,@	$/@	n@	L_@		 ѷ@	@4n@	k~@D@@MjO@ ě@l@oiDg8@@t@\@fB@B@r Ĝ@@o@]ce@
M;@84֡@&IR@7Kƨ@H˒:@쿱[@5Xy@#w@m\@
(@U=@w1@6z@tSM@}H@,=@-V@u"@Ov_@@N@o @(@L_@k~(@eO@Q@y=b@kC]@iDg8~@cA [@XD*@W
=p@UϪ͞@SMj@Rp:@Q@Q_p@PH@LcA \@H@Gy@B\(@8}H@5Xy=@4֡a@43@2m\@/v@&@"h	ԕ@vȴ9@@@:)y@$tT@ߤ?@
M:@
L/{@@ڹZ@hr@eں@:~ @!-w@ᰉ'@8}H@Z1@ⶮ}Vm@cA @حU@@Q_@ԕ*1@H@Ƨ@ǮzH@š@84֡@ěS@@a@N@74@64@Y}@#w@XbM@'0@}Vl@@7Kƨ@BZc @BZc @,zxl@J@@hۋq@|Q@{J#9@zC\@y(@wkP@r䎊q@p
=q@eO
@Y>BZ@Vt@TɅoi@T,<@QX@O
M;@M:@K]cA@Jn@JL_@F-@A7Kƨ@<Z@7KƧ@6z@5sg@4֡a@3ߤ@1-@.H@+I^@(Xy=@!-w1@%@u"@@@$/@*0@*0@ݗ+k@n@@
	 @Q@!.H@eں@s@"h	ԕ@ۋq
@+a@u!@/w@+@֡af@_p@5Xy>@K]c@8YK@a@N@TɅo@S&@-V@&x@{J#:@6z@'RT`@L_@u@@'/W@!R<@?@4m9@˒:)@˒:)@$tS@|Q@wkP@u!R@q@nO;@mhr!@j~"@h>BZc@a'R@^ ѷY@R䎊@DS@>BZc @=K]@;5Xy@9#w@6E@2-V@&x@"`A@!ae@u@S@,<@*0@*0@ߤ?@
M:@@I^5?@@
O;dZ@
@~($x@҈@L_@L_@
O;dZ@I^5?@I^5?@q@
L/{@
(@'/W@-
q@-
q@\(@
qu"@
qu"@Vu@\(@)^@'/W@@@L_@
	 @	7KƧ@	 ѷ@Fs@ݗ@oiDg@ݗ@$/@JM@@?@{J#9@@4n@$tS@Q@eں@1@F]d@	k~@D@>B@oiDg@oiDg8@W>6z@̘_@]cf@74@6@š@Ƨ@sPH@ٳ|@՛=K@ΤT@E84@vȴ9X@64@5Xy@&IR@E84@n@D@3@{@@9@vȴ9@Q@zG@&I@u%F
@$tS@z>B@y"`@vȴ9X@de@\(\@Xe+@Vaf@W
=p@VϪ͟@U=K@TE@SZ@E@6C-@)@&IQ@%1@%S@%u@%u@"wkQ@ߤ@@sP@@eO@m\@m]@@73@!R@"h	ԕ@"h	ԕ@"h	ԕ@hr!@.2@t@ hۋ@t@.2@\@VϪ@Q@ⶮ}Vm@+@Ʌoi@Ʌoi@a@O@҈p:@N;5@v_ح@s@#9@
L/@74@|hs@Y}@|@^@vȴ9@Q@@$/@Vu@ ѷ@~m\@x-
@r䎊q@nO;@jg	@j~"@ix@glC@\N;@B@9~($@7rG@8)@8)@84֡b@8)@73@7rG@7rG@6C-@/Vϫ@.1@.}Vl@.zG@,>B[@+6z@*0
@(\)@&L/{J@!-w1@Xe,@sP@qi@
=p
@%F
L@x@唯O
@>BZ@|@@]cA@ɺ^5?}@@K]c@]cf@m\@TɅo@~($@9XbN@1@wkQ@R<6@-
@wkP@@-
q@p:@IQ@o hی@~"@~"@~$t@~"@b}V@}ڹZ@u%F
L@r{m@rs@poiDg8@mC\@jg	@eO
@^҈p;@[6@U=K@QR@Ov_ح@O
M;@Np:~@Np:~@Y>BZ@YJE@W
=p@SZ@P*0U@H˒:*@?[W>@43@%zxl"h@-V@[@u%F@zG@@
ڹY@p:@_o@@{J#9@ ѷX@Vl!@s@S@Ft@ۋq@ٳ|@D*@t@v_ح@@@š@@6z@K]@5Xy@)@Xe@|@W@2W@Vϫ@r@O
M@}Vl@V@jf@TɅ@TɆ@'RT`@S@@Z@N;6@@hr @N;6@@O
M@sP@O;dZ@I^5?@4J@Q@u@u%F@Ov_خ@tSM@xF@TɆ@u@u@ěT@ݗ+k@@~($x@ڹY@n/@y	k~@v+jg@u\(@zC\@|hr@{lC@y=b@r ě@p
=q@qA [@sPH@w+@w+@ql@p
=q@lVϪ@cZ@XbM@W@W>6z@R䎊@Vaf@Vaf@Vaf@UfA@UϪ͞@P*0U@C,zxl@=v@<쿱[@<n.@8Q@:^5?|@;5Xy@8YJ@3|@0
(@/r@-B@+a@@+jf@'/V@$/@#
=p@ [6@[@*0@@@@)^@L_@	k~(@ݗ+@_o@?@@@4n@ ѷ@F]c@I^5@$t@@1@MjO@@.2@C\@C\@C\@.2@C\@빌~($@fB@Ov`@x@>BZc@1.@	@M@u!@cA @fA@͞%@#9@@]cf@*0@s@ [7@C@C@vȴ9X@n.@)y@KƧ@ᰊ@V@TɆ@䎊r@Q@u"@,<@@@*0U2@tj~@$tT@(@O;dZ@@qu"@I^5?@qiC@Q@n.@}H˒@{m]@zG{@y"`@y=b@y	k~@weں@r{m@nt@hr Ĝ@e+a@ceO@b}Vm@ae@aGz@`d8@^5?|@Zݘ@SZ@PH@M@L_@JL_@IQ@F]cf@E84֡@C@As@@NU@>vȴ9X@=p
=@<Z@;/V@8)@3g	l@2W@0'RT@*͞&@!ae@IQ@ߤ@@,<@*0@҉@Vu@1&x@oiDg@$/@oiDg@Q@tj@@4n@ 4m9@ ($x@ ڹZ@ ~$@ -
@ %F
L@ E@ iDg8@ c	@ hr!@ !-w@ rGE@ eO@  ѷY@ څݘ@ t@ `d@ ,<@ ӎMj@ ѷX@ H@ Ϫ͞@ s@ Q@ E84@ Õ$@ C@ 6z@ K]@ dZ@ )_@ )y@ 4K@ zG@ I^@ d7@ \)@ /V@ x@ @ 1@ zxl"h@ /@ 3@ ae@ [6@ 쿱[W@ kP|@ PH@ _F@ O;d@ Xe,@ Xe,@ $tS@ Xe,@ O;d@ @ O;d@ Xe,@ +J@ ᰉ@ $/@ Fs@ *0U2@ S&@ 4J@ @ @ Vu@ @ L/{@ 'RTa@ p:@ 1&x@ n/@ nP@  ѷ@ hۋq@ b}V@ b}V@ b}V@ $tS@ }H˒@ |hr@ |?@ {~$@ {m]@ zC\@ xF]d@ uY|@ tj~@ tD@ tj~@ sMjO@ m(@ jg	@ h	ԕ+@ fA@ ceO@ ae@ `҈p@ _حV@ _?@ _Ft@ ]ce@ Y>BZ@ YJE@ XbM@ VϪ͟@ U=K@ Rm@ P{@ Ks@ K:)z@ JW'@ GzH@ F-@ F
L/@ E84֡@ D*0@ B@ ?|hs@ ;5Xy@ 73@ 5sg@ 3|@ /Vϫ@ /v@ .2X@ .2X@ .}Vl@ .}Vl@ .zG@ ,>B[@ )*0U2a@ $/@ #S&@ "`A@ "`A@  -
@  [6@  ěT@  	k@  [6@ 䎊r@ [@ _F@ $/@ n@ bM@ @ @ !R<@ ~($x@ ҈@ xF]@ '/@ 
=p
@ 	 ѷ@ eO@ JM@ @ $/?E?~$?	k~?!.I?!-w2?{m?D?t?hr!?g	?>BZc?fA?lC??`A7L?e?`A7L?Z?%1?S?@4?u!?҈p;???b}?D*?ѷX??^5?|?)?4m?Q???ᰊ?[W>6?1?1&y?Xy=?3?%?-V?=K^?u%F??R<6?tj~?eO?Q?oiDg??4m9?b}V?$/?$/?IQ?|??{m]?{J#9?xF?v_ح?sg?q?o?m\?iB?hۋq
?g8}H?c	?`A7K?`A7K?^5?|?Xy=c?RT`d?O
M;?O;dZ?M?M:?M?M:?KƧ?GE84?F
L/?D*0?Dg8}?B?@NU?>6z?;dZ?7KƧ?5Xy=?64K?64K?4J?4J?1-?/v?,zxl"?+a@?)^?%F
L0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              @@S҈@@Sg@@Sg@@SC]@@Sg@@SC]@@SA [@@SA [@@SA [@@S$@@SC]@@S$@@S$@@S@@S$@@S$@@Ss@@S@@Ss@@S\N@@S\N@@S\N@@Tn.@@Ss@@Tߤ@@@TL_@@TL_@@TL_@@T@@TL_@@TQ@@T(\@@T?@@T9XbN@@T9XbN@@T9XbN@@TFs@@Tg8}@@T3@@Uqu"@@UH˒@@V($x@@UoiDg@@Ush@@Uv@@U\(@@UE@@U!.@@V
(@@Ub@@UE@@U
qv@@VR<6@@W1@@WfA@@WzH@@W@@W+@@W@@W/V@@W	k@@W$tS@@W?@@Wr@@W;dZ@@W+j@@X4m9@@X@@Y+@@Y^@@Y7Kƨ@@YD@@YiB@@YiB@@Yᰉ'@@X@@X*0@@Xl"h	@@X@@Y+@@[E@@_$tS@@bp:@@dVϪ@@d~($x@@dj~@@efA@@g$tS@@hoiDg8@@k,zxl@@lm8@@n
(@@p	k@@sm]@@uݗ@@vt@@w[W>@@x
(@@y>BZ@@zS&@@{=K^@@{5Xy@@~Ϫ͟@@Mj@@E@@?@@+I@@hr @@Ov`@@0U2a|@@B@@ߤ?@@\(@@v_ح@@v_ح@@@@H@@	k~@@I^@@Z@@ᰉ@@)^@@*0@@ae@@*0U2@@E@@ [7@@$@@2a|@@ƤT@@qu"@@䎊r@@eO@@Ъd8@@XbM@@_o@@-V@@ҳg	@@҉@@ӼZ@@իU=@@ٙ@@|@@݁$/@@+jg@@ߐ@@TɅo@@g	@@҈@@>B[@@@@qi@@$t@@%@@l!-@@af@@-
q@@u@@JL@@1&@@S@@qi@@2X@@@@ߤ?@@&I@@]cf@@Xe@@E84@@Xe,@@ﴢ3@@ݗ+@@˒:)@@˒:*@@K]c@@@@{@@ۋq
@@@@PH@@+@@TɅo@@Q@@&x@@	k~@@{@@e+@@@@`A7@@{@@@@@@4֡b@@`A7@@C@@PH@@4m@@𭫟U@@n@@l"h	@@bM@@bM@@Xy=@@K]c@@D*@@>BZc@@>BZc@@*0@@@@
qu@@;dZ@@حV@@o @@/V@@?@@o@@\(@@U=@@8}H@@.H@@1@@4֡a@@.H@@'/W@@$tS@@1@@;dZ@@>6z@@'/W@@ hۋ@@"@@@@Mj@@@@Fs@@Fs@@쿱[W@@@@Mj@@"@@쿱[W@@@@1@@Ϫ͟@@Ϫ͟@@A@@m\@@Ϫ͟@@!.I@@]cf@@C-@@ȴ9X@@t@@t@@t@@t@@A@@t@@t@@҈p;@@]cf@@]cf@@A@@t@@&I@@&I@@Q@@t@@ߤ?@@@@}Vl@@Q@@'@@ȴ9X@@A@@Mj@@1@@]cf@@+@@+@@C-@@@@@@
=p@@Ft@@
M;@@@@8}H@@y@@y@@_o@@eں@@o@@sPH@@&@@&@@vȴ9@@[W>@@[W>@@o @@#@@*0@@73@@D*@@[6@@tj@@tj@@tj@@𖻘@@𖻘@@-
@@{@@D@@PH@@	k@@$/@@_p@@4J@@A [@@XbM@@o@@>BZ@@.H@@s@@䎊@@nO@@p:@@p:@@L_@@ ě@@Y@@)_@@ ѷ@@I^@@S&@@'/@@PH@@"`B@@)^	@@33333@@=K^@@C%@@Z@@dZ@@qu!@@:)z@@$@@q@@@@?@@I^5?@@Z1@@j~#@@zG@@?@@[@@84֡@@F
L0@@S&@@Y|@@Y|@@w1@@+j@@sh@@S@@C\@@_o @@?@@IQ@@O;@@6z@@Mj@@v@@,@@$tS@@;dZ@@E84@@eں@@&@@/V@@@@rG@@-@@     @@
qu@@@@K]c@@YJ@@TɅ@@҈p@@rGE@@oiD@@B@@_o@@@@e@@Ov`@@^5?|@@{m@@m@@C%@@n.3@@dZ@@tj~@@q@@5Xy@@$@@SMj@@wkP@@*1@@1&@@/@@+a@@@@8YK@@?@@?@@ᰉ@@Ov_@@($x@@;5X@@fffff@@z@@+J@@}Vl@@&I@@t@@ߤ?@@Ft@@As@@Xe,@@U=@@Xe,@@3@A @A hۋq@A y=c@A @A )^@A 	k@A $tT@A $tT@A$/@A@N@A&x@A-w1@A*0U2a@A0
)@A7KƧ@ADg8~@AJE@AXbM@A@AR@AR@AR@AY}@A.H@As@A#9@AZc@AS&@AwkQ@AS&@AS&@AS&@AS&@A<64@A)_@A,<@AC,@Am\@A'/@AC,z@A"`B@A)^	@AJ#9@A]cA@A:)z@A6@A5Xy@AA [@A<쿱@AC@AZ@AE@A*0@A84֡@AB@AS&@A`A7L@AڹZ@A(@A
(@AzG@A!R<@A_ح@A}Vl@A҈p;@AC-@Ax@A!.I@A;dZ@Av_ح@A|hs@A|hs@A4m@A4m@A	@A-V@AzH@A@@A
qu@AbM@A$xG@A1&x@ANU@A_F@AA7K@A>BZc@A[6@A|@A-
@A҈p@A	0
)@A	x@A	@A	R<6@A	^5?}@A	"`@A	-@A
1'@A
@4n@A
GE85@A
@4n@A
Q_@A
{m@A
ݘ@A
0
@A
g	@A
`A@A
C,@A
c	@AI^@A/V@An.3@A$@A6@A1&y@A2W@APH@Aq@Ao h@A_@ATɆ@A[W?@A֡a@A@A
:@A
'0@A
'0@A
Q@A
(@A
Vl!@A
!R@A
v@A
n/@A
!.@A!R<@AH@Ac	@A%@AA@A쿱[W@A+I@A8}H@AAs@ART`e@A_o@Ao@Avȴ9@A+@AfA@A@A@@AF]d@AbM@ANU@AbM@AeO@Al"h	@Ahۋq@AoiDg8@A@A{@A [7@A-w1@AQ@ArGE8@A|Q@A@A7Kƨ@AR<6@A@AB@A^5?}@A|@A@A_o@AiB@AI^5@A=p
@AM@AnO@A0
@Ag	@A`A@A䎊q@A"`B@A9@A@N@AF]c@AW>6z@AeO@Awk@A%2@A1&y@AQ@AC,zx@APH@AcA \@A~($x@A쿱[@A1&@Aj~@Aj~@A/@AJM@A2a|@AڹZ@A-V@Ash@AE@A+jg@A5?|@AR<6@Ac	@A}Vl@AFs@A@A}Vl@Aߤ?@AA@AC-@AMj@A
M;@A$tS@A.H@A.H@A1@A1@A8}H@AKƧ@A\(@Ay@A&@AVϫ@A     @A}H@A'RT`@A4m9@AeO@A|@Ay=c@An@A'RT@A-
@A'RT@Atj@A@A-
@A)@A@@Ae+@A{@A$/@A@A_p@A [7@A*0U2a@A-w1@A0
)@A-w1@A7KƧ@A:S@AGz@A^@Ax@AoiD@Au@A'R@AD@A_o@As@AI^5@A#9@A:)y@AT`d@AnO@Aᰊ@AS&@Avȴ@AS&@AW@Ac	@A'/@AZ@A$@AA@AS@AƧ@A҈@AC]@A@An.@An.@AxF@AFs@A]ce@AzG@A?@Aqj@A*1@AS@A3@A@A#x@AZ@AO;dZ@AڹZ@A%@A@A@AU=@AXy=@A@A
qv@AC\@A_o @AOv_@A;5X@AR<6@Al!-@Avȴ9X@Az@A}Vl@A$t@AT@Aaf@A-@Aߤ?@AϪ͟@A@A)^@A1@AiDg8@Ay@A$tS@A/V@A+@A@A@A@A-@A @A 6@A A7K@A Q@A bM@A l"h	@A ˒:*@A tj@A IQ@A @A 9Xb@A TɅ@A F@A 4֡b@A!$/@A!&x@A!:S@A!A [@A!Gz@A!Gz@A!e+a@A!@A!'RTa@A!@A!.H@A"I^5@A"1'@A"0U2a|@A":)y@A"GE85@A"W'@A"d7@A"xl"h
@A"p:@A"\(@A"0
@A"g	@A"n@A"ڹY@A"m\@A#PH@A#9@A#P{@A#qu!@A#q@A#Mj@A#q@A#Mj@A#A@A#S@A#Ƨ@A#ݗ+k@A#lC@A#@A$ߤ@@A$<쿱@A$wkP@A$zG@A$~($x@A$~($x@A$#@A$qj@A$zxl"@A$?@A$!-w@A%qu"@A%+a@A%IQ@A%sg@A%}H@A%-V@A%cA @A%@A%b@A%(@A& ѷY@A&?@A&z@A&+J@A&@A&qi@A&,<@A&t@A' hۋ@A'
M;@A',@A'.H@A'8}H@A'As@A'\(@A'4m@A'4m@A'O;d@A'K]d@A'rGE9@A(
qu@A( ě@A(4m9@A(>BZc@A(bM@A(oiDg8@A(YJ@A(@A(4m@A(҈p@A(\)@A) ѷ@A)	k~@A)	k~@A)@A)rGE@A)_p@A)u@A)D@A)>BZ@A*n@A*e+@A*&IR@A*&IR@A*-V@A*0U2a|@A*:)y@A*@4n@A*Zc@A*{m@A*\(@A*wkQ@A*>B@A* ě@A*Y@A* ѷ@A*c	@A+I^@A+s@A+PH@A+C,z@A+/V@A+F]c@A+S@A+dZ@A+{J#9@A+:)z@A+A@A+U=@A+q@A+m]@A+5Xy@A+a@@A+Q@A+
=p@A+
=p@A+
=p@A+ݗ+k@A+%2@A+%2@A+g@A+$@A,xF@A,,<@A,/{J#@A,<쿱@A,PH@A,VϪ@A,]ce@A,q@A,zG@A,#@A,qj@A,C@A,N;@A,N;@A,_@A,1&@A,@A,#x@A,[W?@A,Ʌoi@A,@A,!-w@A-o i@A-u@A-[@A-*0@A-Q@A-+a@A-/w@A-?|h@A-IQ@A-O;dZ@A-Y|@A-p
=@A-%@A-%@A-%@A-%@A-v@A-U=@A-1@A-1@A-Xy=@A-1@A-1@A-1@A-1@A--V@A-@A-8Y@A-8YK@A-
qv@A-E@A-!.@A-ڹ@A.t@A.
L/@A.@A.u@A.Ov_@A.;5X@A.Vu@A._ح@A.p:~@A.}Vl@A.Fs@A.2X@A.Q@A.@A.m\@A.x@A."@A.!.I@A.!.I@A/Ft@A/)^@A/$tS@A/8}H@A/RT`e@A/RT`e@A/RT`e@A/RT`e@A/U=@A/\(@A/b}V@A/|hs@A/@A/?@A/vȴ9@A/حV@A/#@A0*0U@A0*0U@A0@A06@A0*0@A0-
q@A0>BZc@A0K]c@A0Q@A0_F@A0eO@A0oiDg8@A0n@A0
=q@A0)@A0)^@A0@@A0ѷX@A0@A0\)@A0$tT@A1$/@A1rGE@A1@N@A1_p@A1#w@A1=b@A1Gz@A1ae@A1|Q@A1@A1@A1@A17Kƨ@A17Kƨ@A1o@A1@A1R<6@A1u@A1'RTa@A1'RTa@A1(@A1'R@A1y@A1N;6@A1-@A2s@A2䎊@A2&IR@A2-V@A26C@A20U2a|@A2=p
@A2Q_@A2^5?|@A2h	ԕ@A2kP|@A2u%F
@A2p:@A2wkQ@A20
@A2wkQ@A2vȴ@A2g	@A2Y@A2@A2͞&@A2`A@A2 ѷ@A2G{@A2~@A3&@A3C%@A3=K^@A3S@A3~$@A3@A3eO@A3q@A3eO@A3Mj@A3:)z@A3$@A3q@A3~($@A3~($@A3Ƨ@A3%2@A4n.@A4J@A4J@A4xF@A4Q@A42W@A4<쿱@A4PH@A4`d@A4g8}@A4g8}@A4q@A4wkP@A4~($x@A4N;@A4zxl"@A4?@A4O
M@A4֡a@A4JM@A4D@A4>@A5:@A5:@A5V@A5!.H@A5<64@A5B@A5w1@A5!R@A5+j@A5+j@A5v@A5U=@A5-V@A5sh@A5n/@A5@A5n/@A5cA @A58YK@A58YK@A5S@A5E@A6
(@A6E@A6fffff@A6@A6af@A6&I@A6&I@A6O;@A6@A6T@A6-@A6}Vl@A6@A6A@A6Ϫ͟@A61@A6Mj@A6Fs@A6"@A6"@A6!.I@A7 hۋ@A7@A7@A7
=p@A7
M;@A7
M;@A7@A7Xe@A7!-w1@A74֡a@A74֡a@A78}H@A78}H@A7;dZ@A7KƧ@A7U=@A7b}V@A7iDg8@A7|hs@A7{J#:@A7O;d@A7kP@A7&@A7&@A7&@A7zH@A7[W>@A7[W>@A7vȴ9@A7@A7;dZ@A7#@A8     @A8*0U@A8-
q@A873@A8:~ @A8K]c@A8D*@A8[6@A8eO@A8oiDg8@A8r Ĝ@A8y=c@A8˒:*@A8'RT@A8tj@A8d8@A8
(@A8TɅ@A8TɅ@A8p:@A84֡b@A9 ѷ@A9@A9rGE@A9rGE@A9rGE@A9-w1@A97KƧ@A9:S@A9=b@A9A [@A9JE@A9TɅo@A9[W>6@A9hr @A9k~(@A9rGE8@A9rGE8@A9rGE8@A9|Q@A97Kƨ@A9n.@A9D@A9_o@A9_o@A9N;6@A9@A9"`@A9@A:@A:e+@A:䎊@A:)y@A:0U2a|@A:3@A:=p
@A:GE85@A:W'@A:T`d@A:Zc@A:d7@A:kP|@A:nO@A:nO@A:xl"h
@A:ݘ@A:S&@A:S&@A: ě@A:}Vm@A:Y@A:Y@A:)_@A:m@A:74@A;u%@A;nP@A;s@A;nP@A;C,z@A;/V@A;6z@A;dZ@A;xF]@A;q@A;Mj@A;A@A;wk@A;wk@A;wk@A;*0U2@A;q@A;m]@A;~($@A;Z@A;Ƨ@A;@A;Ƨ@A;Ƨ@A;a@O@A;5Xy@A;ݗ+k@A;%2@A;A [@A<n.@A<ߤ@@A<C,zx@A<m8@A<TɆ@A<*1@A<]ce@A<SMj@A<`d@A<C@A<*1@A<3@A<@A<֡a@A<>@A<E@A=o i@A=K]@A='0@A=qu"@A=2a|@A=IQ@A=w1@A=}H@A=ݗ@A=+j@A=1@A=sh@A=Ϫ͞@A=cA @A=@A=b@A=?@A=ᰉ@A=ڹ@A>zG@A>@A>1.@A>fffff@A>fffff@A>iB@A>iB@A>c	@A>fffff@A>iB@A>iB@A>p:~@A>s@A>Fs@A>T@A>6z@A>}Vl@A>ߤ?@A>ȴ9X@A>m\@A>Ϫ͟@A>+@A>]cf@A>+@A>҈p;@A>A@A>Ϫ͟@A>Fs@A? hۋ@A?Ft@A? hۋ@A>!.I@A? hۋ@A?@A?Ft@A?Ft@A?
=p@A?
M;@A?
M;@A?@A?@A?v@A?,@A?!-w1@A?'/W@A?+I@A?'/W@A?'/W@A?'/W@A?+I@A?4֡a@A?;dZ@A?;dZ@A?As@A?O
M@A?U=@A?eں@A?sPH@A?y@A?sPH@A?v_ح@A?y@A?y@A?v_ح@A?_o@A?\(@A?\(@A?Xe,@A?\(@A?\(@A?_o@A?eں@A?|hs@A?|hs@A?|hs@A?|hs@A?|hs@A?y@A?|hs@A?y@A?|hs@A?|hs@A?4m@A?{J#:@A?ݗ+@A?ݗ+@A?@A?ݗ+@A?kP@A?	k@A?-V@A??@A?&@A?r@A?@A?o @A?˒:)@A?حV@A?䎊r@A?rGE9@A@     @A@6@A@*0@A@*0@A@*0@A@'RT`@A@-
q@A@-
q@A@73@A@73@A@H@A@[6@A@[6@A@'RT@A@d8@A@d8@A@ěT@A@ѷX@A@F@A@F@A@F@A@C@AArGE@AA [7@AA#w@AA0
)@AA:S@AAA [@AAA [@AA[W>6@AAXbM@AAXbM@AA^@AAe+a@AAae@AAk~(@AAo hی@AAk~(@AArGE8@AAx@AA|Q@AAoiD@AAo@AAu@AA-@ABu%F@AB	 @AB@ABOv`@AB䎊@AB)y@AB&IR@ABs@ABI^5@AB@AB@AB#9@AB-V@AB3@AB:)y@AB=p
@ABM@ABT`d@ABZc@ABZc@ABZc@ABW'@ABT`d@ABd7@ABa|Q@AB^5?|@ABkP|@ABu%F
@AB{m@AB@4@ABp:@ABL_@ABS&@ABᰊ@ABvȴ@ABS&@AB>B@AB ě@AB ě@ABg	@AB ě@AB}Vm@AB<64@ABn@AB@ABW@ABڹY@ABfB@AB74@ACI^@ACS&@ACu%@AC҉@AC'/@ACnP@ACs@AC"`B@AC/V@AC/V@AC,zxl@ACC%@ACjf@ACqu!@ACg	l@ACjf@ACeO@AC:)z@AC:)z@AC$@AC$@ACߤ@ACA@AC$@ACA@ACߤ@AC$@ACQ@AC{J#9@ACeO@ACMj@ACA@ACߤ@ACU=@AC$@ACA@ACU=@ACS@ACm]@ACa@O@AC6@ACa@O@ACa@O@AC5Xy@ACݗ+k@ACQ@ACQ@AC5Xy@ACa@@ACa@@AC5Xy@AC5Xy@AC|@ACQ@ACݗ+k@AC҈@AClC@AClC@ADn.@ADߤ@@AD%1@AD(\@AD!-w2@AD"h	ԕ@AD"h	ԕ@AD"h	ԕ@ADtj@AD!-w2@AD%1@AD,<@AD,<@AD/{J#@AD<쿱@ADFs@ADM:@ADg8}@ADtSM@ADtSM@ADzG@ADC@AD*1@AD_@ADzxl"@ADO
M@AD@AD?@AD#x@AD7@AD@AD֡a@ADZ@ADD@AD>@ADE@AD>@ADE@AD>@AE:@AEo i@AEK]@AEo i@AE'0@AEK]@AEK]@AEu@AE[@AE*0@AE*0@AEQ@AE2a|@AE5Xy>@AE84֡@AE84֡@AE84֡@AE?|h@AEB@AEF
L0@AEF
L0@AEB@AEL_@AEO;dZ@AES&@AEVl!@AE\@AEjOv@AE$/@AEݗ@AEݗ@AE!R@AEO
@AE=K@AE@AEv@AEU=@AE-V@AEn/@AE@AEsh@AEn/@AEH˒@AE8Y@AEϪ͞@AEb@AE,=@AE,=@AEᰉ@AEᰉ@AEoiDg@AEoiDg@AE!.@AFt@AF
L/@AF!R<@AF($x@AF.2@AF5?|@AF8YJ@AF;5X@AF5?|@AF?@AFL/{J@AF_ح@AFfffff@AFiB@AFs@AFz@AFz@AFIQ@AF+J@AFqi@AF@AF$t@AF,<@AF@AF@AFT@AF6z@AF'@AF'@AFߤ?@AF҈p;@AF쿱[W@AFFs@AFFs@AFMj@AG hۋ@AG@AG,@AG.H@AG1@AG.H@AG1@AG4֡a@AG>6z@AG>6z@AGH˒:@AGH˒:@AGH˒:@AGO
M@AG_o@AGeں@AGiDg8@AGv_ح@AGv_ح@AGv_ح@AG|hs@AG	@AGkP@AG&@AG[W>@AGr@AGvȴ9@AG@AGo @AGK]d@AGK]d@AG˒:)@AGحV@AG@@AG@AG䎊r@AG+j@AH     @AHF]d@AH@AHF]d@AH	ԕ+@AH}H@AH1&x@AH4m9@AH73@AH:~ @AHD*@AHA7K@AHH@AHD*@AHH@AHK]c@AHU2a|@AHU2a|@AHXy=@AH_F@AHhۋq@AHoiDg8@AHoiDg8@AHr Ĝ@AHr Ĝ@AHu!@AHu!@AHu!@AHr Ĝ@AHr Ĝ@AHu!@AHy=c@AH|@AHy=c@AH˒:*@AH˒:*@AH˒:*@AHYJ@AH@AH@AH-
@AHtj@AH@AH-
@AH-
@AH
=q@AH-
@AHU@AH{@AH9Xb@AH)@AH4m@AH
(@AH)@AHěT@AH@@AHěT@AHěT@AH@@AH)^@AHѷX@AHD@AHe+@AHe+@AH҈p@AHe+@AH@AHPH@AI$/@AI	k~@AI	k~@AI+@AI_p@AI@AI [7@AI#w@AI#w@AI*0U2a@AI0
)@AI7KƧ@AI:S@AI:S@AIA [@AIJE@AITɅo@AI[W>6@AI[W>6@AIae@AIhr @AIk~(@AIhr @AIk~(@AIu!S@AI|Q@AI7Kƨ@AI~($@AIu@AI@AIn.@AIB@AIB@AI'R@AI'R@AI'R@AI|@AIX@AIX@AIy@AIN;6@AIԕ*@AIN;6@AIԕ*@AI"`@AIiB@AIᰉ'@AIiB@AIᰉ'@AIe@AI@AIY}@AI.H@AJI^5@AJI^5@AJ@AJs@AJOv`@AJe+@AJe+@AJ䎊@AJ䎊@AJ#9@AJ#9@AJ&IR@AJ0U2a|@AJ6C@AJ:)y@AJC\@AJGE85@AJJL@AJM@AJQ_@AJM@AJQ_@AJW'@AJZc@AJa|Q@AJd7@AJd7@AJd7@AJa|Q@AJh	ԕ@AJh	ԕ@AJkP|@AJnO@AJkP|@AJkP|@AJnO@AJqiC@AJqiC@AJxl"h
@AJ{m@AJxl"h
@AJݘ@AJS&@AJ@AJ@AJ@AJL/{@AJ@AJg	@AJg	@AJY@AJn@AJn@AJW@AJ`A@AJ`A@AJ,<@AJ,<@AJ,<@AJڹY@AJG{@AJC,@AJD@AJD@AJm\@AJ~@AJ~@AJ74@AJm\@AJm\@AKI^@AKS&@AKI^@AKI^@AK҉@AK'/@AKPH@AKs@AKC,z@AK	@AK"`B@AK&@AK,zxl@AK/V@AK)^	@AK/V@AK@N@AKF]c@AKJ#9@AKC%@AKMjO@AKMjO@AKMjO@AKMjO@AKMjO@AKS@AKS@AKS@AKW>6z@AKa@N@AKa@N@AKdZ@AKn.3@AKjf@AKqu!@AKqu!@AKtj~@AKxF]@AKxF]@AKxF]@AK{J#9@AK@AKQ@AKeO@AKQ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              @r`     @ra@rd@r`     @r`     @ri@ri@ra@rd@rffffff@rh     @rh     @ri@rh     @rffffff@rd@rd@rc33333@ri@rk33333@rffffff@rh     @rd@ra@ra@rh     @ri@rh     @rffffff@rffffff@ri@ri@rl@rnfffff@rk33333@r\@rA@r333333@r`     @r~fffff@r@r@r     @r@r@r33333@rfffff@r@r     @r33333@r33333@r     @r@r@rfffff@r     @r33333@r33333@rfffff@r     @r@rfffff@r~fffff@rx     @rq@rl@rk33333@rk33333@rd@r^fffff@r[33333@r[33333@rq@r33333@r33333@r33333@r@rt@r9@r@q@q񙙙@q     @q陙@qfffff@q     @q@qfffff@q@qs33333@q[33333@qA@q0     @q$@q@q     @q      @p     @p     @p@p     @pnfffff@p8     @p      @pfffff@o     @o	@n@nL@n,@n#33333@n      @n@n33333@n33333@m33333@m@m@m     @mi@mVfffff@m333333@l@l     @l     @lL@k@j陙@j\@j0     @j      @jfffff@j	@ifffff@ifffff@iٙ@ifffff@ivfffff@i@hfffff@hfffff@h@hp     @h6fffff@h	@g     @g33333@g     @gfffff@g@g@g     @g33333@gl@gY@gC33333@gfffff@fə@f@f@ffffff@ffffff@f@f33333@fc33333@fFfffff@f#33333@e@e@e@efffff@efffff@e     @e33333@e@e     @e33333@efffff@ei@eL@e333333@e#33333@e#33333@e      @e@efffff@e@e@e@efffff@e@d@d@dfffff@dfffff@dfffff@d     @dy@dp     @dffffff@d\@dVfffff@dS33333@dP     @dFfffff@d<@d0     @d@c@cٙ@cfffff@c     @cFfffff@c@b     @bə@b@b@b     @b     @bfffff@b     @bffffff@b)@a@a33333@a@afffff@a     @a     @a     @a33333@afffff@afffff@a33333@a     @a33333@a33333@aVfffff@a@`fffff@`陙@`陙@`33333@`@`ٙ@`fffff@`@`l@`L@`I@`L@`Y@`ffffff@`ffffff@`ffffff@``     @`L@`)@`fffff@_@_fffff@_ٙ@_fffff@_@_     @_@_     @_s33333@_Y@_333333@_fffff@^33333@^     @^@^@^     @^y@^ffffff@^@     @^&fffff@^@^33333@^fffff@]@]fffff@]Ffffff@]      @]33333@]fffff@\@\@\     @\l@\`     @\ffffff@\L@\      @[     @[y@[S33333@[@     @[fffff@Zٙ@Z     @Z@Z@Zfffff@Z@Zl@Z9@Z@Z@Z      @Yٙ@Y33333@Y33333@Yl@Y&fffff@X33333@X33333@XY@X&fffff@W33333@W33333@W@W     @W     @W33333@W     @W`     @W@     @W333333@W&fffff@W      @W33333@W33333@Wfffff@V@V     @V@V33333@Vfffff@V     @V@Vffffff@V      @U@U@Ufffff@U33333@U@UL@U      @U@U      @T@T@T     @T@T@T@Tffffff@TL@T,@T33333@S@S     @S@S@Sfffff@Sl@Sffffff@S`     @SL@S9@S33333@R33333@R@Rٙ@R33333@Rfffff@R     @R     @Rfffff@Rl@RL@R,@Q@Q33333@Qfffff@Q     @Qfffff@Ql@QL@Q,@Qfffff@P@Pfffff@P@P@P33333@Py@PL@Pfffff@O     @Offfff@Os33333@O@     @Nfffff@Ns33333@N&fffff@N@N      @M33333@Mٙ@Mfffff@M     @ML@M@M      @Lٙ@L     @Lfffff@L@L     @LL@L@K33333@Kٙ@K     @K@KL@K      @J@J33333@J@Js33333@Jffffff@Jffffff@JY@JL@J@     @J333333@J&fffff@J333333@J333333@J&fffff@J      @Iٙ@Ifffff@Is33333@I     @Iffffff@IY@IL@I@H33333@H@Hfffff@H@H@H@H     @Hs33333@Hs33333@Hs33333@Hffffff@HL@H@     @H333333@H@     @H&fffff@H@H@G33333@G@G@Gs33333@GY@G&fffff@F33333@F     @F@Fs33333@FY@FL@FL@F333333@F@Eٙ@Efffff@E@Effffff@E&fffff@E@D33333@Dٙ@Dfffff@D     @D@DY@Dffffff@DL@DL@DL@D@     @D333333@D@Cfffff@Cfffff@Cٙ@C@C     @C     @C@C@C     @Cs33333@CL@C333333@B33333@B33333@Bffffff@BL@BL@B@     @B&fffff@B@A@A@A     @A@A33333@A@As33333@AL@A333333@A333333@A&fffff@A@A@@fffff@@@@fffff@@s33333@@s33333@@s33333@@L@@&fffff@?fffff@?33333@?@?@?     @?L@?333333@?@?@?      @>@>@>     @>L@>@=@=@=     @=333333@=333333@<@<     @<ffffff@<@<L@<333333@<      @;@;@;33333@;     @;     @;L@;L@;333333@:fffff@;      @:fffff@:@:fffff@:@:@:@:     @:ffffff@:L@:L@:@:      @:      @:      @:      @:      @:@:L@:333333@:333333@:      @9@9@9@9ffffff@9333333@9      @8fffff@833333@8@8ffffff@8ffffff@8L@8@8      @7fffff@733333@7ffffff@7L@7@7@6fffff@6fffff@633333@6@633333@6@6ffffff@6L@5fffff@5ffffff@5ffffff@5@5      @4fffff@4fffff@5      @4fffff@4fffff@433333@433333@4@4ffffff@4ffffff@4L@4L@4333333@4@4@3fffff@4@4333333@4@4@4      @4      @333333@3@3     @3ffffff@3ffffff@3ffffff@3333333@3L@3L@3L@3@3L@3L@3333333@3333333@3333333@3333333@3      @3@2fffff@3      @2fffff@233333@2fffff@2fffff@2fffff@2fffff@2fffff@2@2fffff@233333@2@2@2@233333@2@2@2@2ffffff@2ffffff@2ffffff@2L@2ffffff@2L@2333333@2      @2@2@1fffff@1fffff@1@1ffffff@1L@1ffffff@1L@1333333@1333333@1@1      @1      @1@0fffff@0fffff@0fffff@0@0@033333@033333@0@0@0     @0@0@0L@0      @0333333@0@0@0@0      @/@/@/@/@/@/333333@/333333@/333333@/333333@/333333@/333333@/      @.@.@/      @/      @.@.ffffff@.ffffff@.ffffff@.      @.      @.      @.      @-@.      @-@-@-@-ffffff@-ffffff@-ffffff@-333333@-      @-333333@,@-333333@-      @,@,@,@,@,@,@,@,@,ffffff@,ffffff@,@,ffffff@,ffffff@+@+@,      @+@+@+@+ffffff@+ffffff@+ffffff@+333333@+ffffff@+333333@+ffffff@+333333@+333333@+      @+      @*@*@+      @*@*@*@*@*@*@*@*ffffff@*ffffff@*333333@*333333@*333333@*333333@*      @)@*      @)@*      @*      @*      @)@)ffffff@)@)333333@)ffffff@)ffffff@)333333@)333333@)333333@)333333@)333333@(@)      @(@(@(@(@(ffffff@(@(ffffff@(333333@(333333@(333333@(      @(      @(      @(      @(      @'@'@(      @'@'@'ffffff@'@'ffffff@'333333@'ffffff@'333333@'333333@'333333@'333333@'      @'      @'      @&@'333333@'      @&@&@&@&@&@&@&@&@&@&ffffff@&ffffff@&@&@&ffffff@&333333@&ffffff@&333333@&333333@&333333@&ffffff@&ffffff@&333333@&ffffff@&      @&      @&ffffff@&      @&      @&      @&      @%@%@%@&333333@%@&      @%@%@%@%@%@%@%@%@%@%@%@%@%@%@%ffffff@%@%ffffff@%@%ffffff@%ffffff@%@%@%333333@%@%@%@%ffffff@%@%ffffff@%@%333333@%ffffff@%ffffff@%ffffff@%ffffff@%ffffff@%333333@%ffffff@%ffffff@%333333@%ffffff@%333333@%@%333333@%333333@%333333@%333333@%333333@%333333@%333333@%      @%333333@%333333@%      @%333333@%333333@%333333@%333333@%333333@%      @%333333@%333333@%      @%      @%333333@%333333@%      @%      @%      @%      @%333333@%      @%      @%333333@%333333@%      @%333333@%      @%      @%      @%      @%      @%      @%333333@%333333@%333333@%      @%333333@%333333@%      @%333333@%ffffff@%333333@%      @%      @%333333@%333333@%333333@%333333@%333333@%333333@%333333@%333333@%ffffff@%333333@%333333@%333333@%333333@%333333@%ffffff@%333333@%333333@%ffffff@%ffffff@%333333@%ffffff@%ffffff@%ffffff@%ffffff@%ffffff@%ffffff@%@%ffffff@%ffffff@%@%@%ffffff@%@%ffffff@%@%@%@&      @%@%@%@&      @%@%@%@%@%@&      @%@%@%@&      @&      @&      @&      @&      @&      @&      @&      @%@&      @&      @&333333@&333333@&333333@&333333@&@&      @&333333@&ffffff@&333333@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&ffffff@&@&@&ffffff@&@&@&@&@&@&@&@&@&@&@'      @'333333@'      @'      @'      @'ffffff@'      @'      @'ffffff@'333333@'ffffff@'ffffff@'ffffff@'333333@'ffffff@'ffffff@'ffffff@'@'@'@'@'@'@'@'@'@'@'@(      @(      @(333333@(ffffff@(333333@(ffffff@(ffffff@(ffffff@(@(@(@(@(@(@(@(@(@(@(@)      @)      @)333333@)ffffff@)ffffff@)@)@)@)@)@)@)ffffff@)@)@)@)@)@)@*      @*      @*333333@*      @)@*      @*      @*      @*333333@*      @*      @*333333@*333333@*333333@*333333@*333333@*@*333333@*333333@*ffffff@*@*@*@*@*@*@+      @*@+333333@+333333@*@+333333@+ffffff@+      @+333333@+ffffff@+333333@+333333@+ffffff@+@+@+@+@+@+ffffff@+@,ffffff@,333333@+@,      @,333333@,333333@,333333@,333333@,@,@,@-      @,@,@-      @-333333@-333333@-      @-333333@-333333@-ffffff@-ffffff@-ffffff@-ffffff@-@-ffffff@-@-@-@-@-@-@.333333@.333333@.ffffff@.ffffff@.ffffff@.ffffff@.@.@.@/      @/      @/      @.@/333333@/333333@/      @/@/@/333333@/@/@/ffffff@/@/@0      @0      @0      @0@0@0333333@0333333@0333333@0     @0ffffff@0ffffff@0     @0@0@0@033333@1      @0fffff@0fffff@0fffff@1333333@1333333@1333333@1333333@1333333@1L@1333333@1L@1L@1ffffff@1ffffff@1L@1ffffff@1L@1     @1ffffff@1     @1     @1@133333@1fffff@2@2333333@2333333@2      @2      @2333333@2L@2ffffff@2     @233333@2@2@2fffff@2@3      @3@3@3333333@3333333@3     @333333@333333@3@333333@3fffff@4      @4@4      @4@4333333@4     @4@4L@4     @4     @433333@5@5333333@5      @5      @5      @5333333@5      @5333333@5@5L@5     @5     @5@533333@5@5@5@5@5fffff@6      @5fffff@5@5@6L@6333333@6@6L@6333333@6333333@6333333@6L@6L@6L@6L@6333333@6L@6     @6L@6     @6     @6     @6@6@6@6     @6@6@6@6@633333@6fffff@6fffff@7      @7@7333333@7333333@7333333@7333333@7333333@7@7333333@7333333@7333333@7333333@7333333@7L@7333333@7333333@7     @7ffffff@7     @7@7@7     @7@7@7@7@7@7@7@7@7fffff@8      @7fffff@7@7fffff@7fffff@7@8      @8@8@8333333@8333333@8     @833333@8     @8fffff@9      @9@9      @9      @8fffff@9      @9@9333333@9ffffff@9     @9     @9     @9@:333333@:333333@:333333@:333333@:ffffff@:     @:@:fffff@;      @;@;      @;333333@;L@;L@;     @;ffffff@;ffffff@;     @;ffffff@;33333@;@;33333@;33333@;@;33333@<      @<@<      @<     @<@<fffff@<@<fffff@=      @=@=333333@=333333@=333333@=L@=333333@=L@=ffffff@=     @=@=33333@=33333@=@>@=fffff@=33333@=@=fffff@>333333@>@>@>333333@>@>@>     @>     @>33333@>@>33333@>33333@>@>fffff@>fffff@>fffff@?      @?333333@?333333@?      @?@?@?ffffff@?333333@?L@?33333@?33333@?@@      @?@@@?fffff@?fffff@@@@@@@@@@@@@     @@@     @@Y@@@     @@Y@@ffffff@@s33333@@     @@     @@fffff@@s33333@@@@@@@@@@@@@@@@@@@@@@33333@@33333@@fffff@@fffff@@fffff@@@@33333@@@@ٙ@@@@ٙ@@33333@@33333@@33333@@33333@A@A@@33333@@33333@A@@33333@@fffff@A@A@A@A333333@A&fffff@AL@Affffff@As33333@AY@AY@Affffff@As33333@Affffff@Affffff@As33333@As33333@Affffff@A@A@A@A     @A@A     @Afffff@A33333@Afffff@B@B@B@B&fffff@B333333@B&fffff@B@     @B@     @BL@BL@Bffffff@Bffffff@B@B     @Bfffff@B@B@B@B@B@Bfffff@Bfffff@Bfffff@Bfffff@B33333@B33333@B33333@B33333@Bfffff@Bٙ@Bٙ@B33333@B33333@B33333@B33333@C      @C      @C@C@C@C@C@C@C&fffff@C333333@C@     @Cffffff@Cs33333@Cs33333@Cffffff@C@C     @C@Cfffff@C@Cfffff@C@C33333@Cfffff@C33333@Cٙ@C     @C@C33333@Cfffff@D      @C33333@C33333@D@D@D@D@D333333@DY@Dffffff@Ds33333@Dffffff@Dffffff@D@D     @D@D@D33333@D     @D@Dٙ@Dٙ@D33333@Dfffff@Dfffff@E@E@E      @E@E&fffff@E@E&fffff@E333333@E333333@E@     @EL@Es33333@E@E@Efffff@Efffff@E33333@E@F      @F@E33333@F      @F@F@F@F&fffff@F@     @F@F&fffff@F333333@FY@F     @Fffffff@F     @FY@F     @F     @F@F33333@F     @Fٙ@Ffffff@Ffffff@F33333@G      @Fٙ@F33333@G      @G@G333333@G@     @G@     @GL@GY@Gs33333@GY@Gs33333@Gs33333@G@Gfffff@G33333@G33333@G33333@G     @Gٙ@Gٙ@G@Gٙ@Gٙ@Gٙ@Gٙ@G33333@H      @G33333@H&fffff@H@H@H&fffff@H@H@H&fffff@H@H@H&fffff@H&fffff@H@H@H333333@HL@H333333@H@     @H333333@HL@HY@Hffffff@HY@Hffffff@Hffffff@H     @H     @H@H@H@H@H@H@H@H33333@Hfffff@Hfffff@H33333@H33333@H@H33333@Hٙ@Hٙ@H     @Hٙ@Hٙ@H33333@I      @I      @I333333@I333333@I&fffff@I@IL@IL@IL@IL@I@     @Iffffff@IY@IY@IY@I@I@I@Ifffff@I33333@Ifffff@I33333@I33333@I@I     @Iٙ@Iٙ@I33333@J&fffff@J@J@J333333@J&fffff@J333333@JL@JL@J@     @J@     @J@     @JY@Js33333@J     @Js33333@Js33333@J     @J@J     @J@J@J@Jfffff@J     @J33333@J     @J     @Jٙ@Jfffff@Jfffff@Jٙ@Jfffff@K      @J33333@K      @K      @K@K@K@K@K333333@K333333@KL@KY@KY@K@     @Kffffff@KY@KY@K     @Kffffff@K     @K     @K     @K     @K@K     @K@K     @K     @K@K@K@K     @K@K33333@K33333@K33333@Kfffff@K33333@L      @Kfffff@Kfffff@L      @L@L      @L@L@L@L@L333333@LL@LL@LL@LL@LL@L     @Ls33333@L     @L@L     @Lfffff@Lfffff@L@Lfffff@Lfffff@Lfffff@Lfffff@Lfffff@L     @Lfffff@L@L     @L@Lfffff@L@Lfffff@L33333@Lfffff@M      @M      @L33333@M@M@M@M@M&fffff@M&fffff@M@M&fffff@M&fffff@M333333@M333333@M@     @M@     @ML@ML@ML@ML@ML@M     @Mffffff@M     @Ms33333@Ms33333@M     @Ms33333@M@Mfffff@Mfffff@Mfffff@M                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ?vȴ?\(?Q?띲-V?^5?|?`A7?nO?|hr?O;dZ?x?+I?E?ꟾvȴ9?Q?1&?=p
=?+?lC?;dZ?웥S?bM?ěS?l?Q?A7Kƨ?5?|h?zG{?9XbN?E?M?Q?ffffff?tj~?A7Kƨ?Q?\(\?E?$/?E?333333?Z1'?vȴ9?-V? ě?/w?
=p?tj~?S?I^5?}?5?|h?333333?C%?vȴ9X?tj?1&x?x?n?I^5?}?vȴ9X?7KƧ?$/?M?^5?|?l?-V?hr!?`A7L?^5?|?;dZ?`A7?Vt?Q?C%?bM?O;dZ?A7Kƨ?nP?tj~?\(?ȴ9Xb?&x?M?=p
=?QR?\(?KƧ?ָQ?\(?Q?C$?hr!?lC?n?ҏ\(?ӶE?љ?&x?1&?I^5??щ7KƧ?Ѻ^5?|?ЃnP?7KƧ? ěT??͑hr ?Vt?hr!?XbM?ȓtj~?ɺ^5?|?XbM?7KƧ?ȓtj~?xF?7KƧ?lC?S?S?+?ȴ9XbN?
=p
?E?x?
=p
?E?ffffff?\(?Q?Z1'?E?
=p?Q?\(?
=p?E?Õ$/?333333?vȴ9X?$/?-V?$/? ěT?Õ$/?`A7L?hr Ĝ?1&y?Q?hr Ĝ?nO;?Q?hr Ĝ?;dZ?I^5??/v? ěT?hr Ĝ?
=p?&x?S?lC?hr Ĝ?`A7L?Q?j~"?;dZ?E?vȴ9X?|hr?A7Kƨ?GzH?vȴ9?A7Kƨ?(\)?Q?A7Kƨ?Q?GzH?/v?/v?p
=q?GzH?
=p?vȴ9X?(\)?GzH?;dZ?hr!?° ě?Q?E?/v?/v?S?$/?hr Ĝ?GzH?-V?hr!?"`?;dZ?"`?E?Q?vȴ9X?      ? ěT?nO;? ěT?"`?hr Ĝ?\(?n?\(?nO;?vȴ9X?&x?&x?7KƧ?      ?7KƧ?/v?      ?bM?ěS?A7Kƨ?GzH?I^5??7KƧ?lD?-V?nP?nP?      ?-V?`A7?"`?&x?1&y?-V?A7Kƨ?&x?-V?
=p?5?|h?"`?bM?-V?&x?$/?/v?|hr?vȴ9X?bM?      ?E?;dZ?E?nP?vȴ9X?`A7L?
=p?A7Kƨ?dZ1?$/?lD?Q?A7Kƨ?Q?hr Ĝ?E?      ? ěT?nO;?"`?-V?GzH?$/?Q?`A7L?lD?      ?hr Ĝ?$/?bM?bM?`A7L?GzH?ļj~#?nP?5?|h? ěT?bM?GzH?-V?lD?`A7L?ěS?
=p?
=p?n?$/?
=p?vȴ9X?nP?n?&x?lD?|hr?&x?333333?&x?Q?nO;?I^5??&x?lD?GzH?`A7L?&x?`A7L?nO;?vȴ9X?$/?`A7?GzH?Q?E?bM?333333?hr Ĝ?I^5??`A7?7KƧ?nO;?nO;?p
=q?nP?Q?7KƧ?I^5??nO;?GzH?Q? ěT?GzH?I^5??vȴ9X?öE?GzH?l?nO;?GzH?bM?Q?`A7L?öE?n?;dZ?&x?A7Kƨ?nP?ěS?-V?nO?nO;?I^5??M?n?-V?GzH?`A7L?nO?lD?nO;?\(?nP?ěS?+?&x?vȴ9X?tj~? ěT?nO;?7KƧ?nO?$/?`A7?Q?hr Ĝ?`A7L?l?vȴ9X?`A7L?333333?Q?I^5??\(?-V?tj~?
=p?Q?S?ěS?Õ$/?hr Ĝ?333333?7KƧ?`A7L?vȴ9X?M?`A7L?7KƧ?bM?$/?hr Ĝ?333333?-V?7KƧ?hr Ĝ?Q?tj?GzH?öE?`A7?ěS?M?;dZ?I^5??ěS?M?nO;?9XbM?öE?l?nO?° ě?° ě?+?-V?Q?lD?hr Ĝ?-V?GzH?
=p?M?M?&x?7KƧ?° ě?E?nP?hr Ĝ?nO?I^5??nO;?bM?lD?vȴ9X?I^5??l?I^5??bM?ěS?nO?lD?9XbM?\(?`A7L?nP?GzH?M?Q?n?bM?nO;?I^5??lD?-V?
=p?\(?tj~?E?p
=q?M?tj~?I^5??tj?° ě?S?M?333333??|hs?Q?I^5??ļj~#?tj~?$/?M?nO;?`A7?
=p?&x?tj~?+?&x?\(?GzH?Q?Z1'?\(?E?333333?n?Q?`A7?zG{?$/?S?      ?-V?&x?nO;?zG{?nO?\(?Õ$/?-V?° ě?n?-V?nP?-V?n?öE?7KƧ?5?|h?`A7?lD?lD?&x?öE?GzH?7KƧ?S?\(?ļj~#?nO?&x?S?7KƧ?333333?\(?M?
=p?° ě?-V?S?nP?lD?A7Kƨ?nO?M?lD?lD?7KƧ?7KƧ?Q?nO;?+?-V?
=p?`A7?GzH?\(?n?7KƧ?333333?333333?tj~?I^5??`A7L?
=p?° ě?M?`A7?
=p?ļj~#?hr Ĝ?ļj~#?-V?M?l?I^5??hr Ĝ?n?tj~?° ě?nO;??|hs?n?° ě?I^5??lD?$/?\(?\(?Õ$/?S?tj?I^5??`A7?nO?`A7?I^5??Q?tj~?M?7KƧ?° ě?n?nO;?M?hr Ĝ?7KƧ?-V?° ě?-V?ěS?tj?nO;?
=p?\(?lD?M?M?I^5??
=p?`A7?Q?-V?`A7?nO?GzH?&x?I^5??nO;?9XbM?tj~?l?zG{?nO;?Q?° ě?Õ$/?M?tj~?
=p?333333?lD?öE?M?$/?vȴ9X?
=p?
=p?öE?tj?/w?`A7L?ěS?
=p?\(?I^5??öE?7KƧ?$/?7KƧ?9XbM?öE?tj~?n?+?M?nO?n?7KƧ?nO?E?$/?-V?S?`A7?S?/w?S?333333?tj~?nO;?I^5??-V?nO;?`A7?I^5??`A7?M?lD?n?`A7?öE?7KƧ?9XbM?\(?hr Ĝ?`A7?333333?öE?tj~?lD?lD?hr Ĝ?hr Ĝ?l?ļj~#?E?tj~?333333?tj~?S?lD?Q?nO?n?nO?zG{?7KƧ?tj~?° ě?šo?Q?öE?ěS?333333?-V?tj?° ě?tj?Õ$/?n?Q?Õ$/?tj~?&x?nO;?M?Õ$/?`A7L?Õ$/?l?
=p?Õ$/?$/?Z1'?\(?nO?I^5??9XbM?\(?nO?|hr?nO?\(?
=p?hr Ĝ?GzH?ěS?tj~?nO;?Õ$/?+?Q?tj~?
=p?nO;?S?$/?\(?7KƧ?7KƧ?tj~?
=p?I^5??nO;?lD?n?n?M?S?ěS?7KƧ?öE?
=p?9XbM?öE?nO?`A7K?S?I^5??lD?E?tj?Q?S?tj~?-V?Q?`A7?S?° ě?lD?\(?nO;?lD?zG{?-V?S?\(?&x?A7Kƨ?hr Ĝ?7KƧ?GzH?l?nO;?tj~?-V?333333?nO?Õ$/?\(?öE?Q?\(?S?zG{?`A7?`A7?Õ$/?nO?Õ$/?M?bM?M?`A7?/w?n?ěS?9XbM?`A7?nO?S?nO?M?+?+?ļj~#?333333?nO;?333333?ļj~#?Q?7KƧ?ļj~#?n?
=p?S?\(?Õ$/?nO?&x?333333?\(?l?-V?I^5??333333?9XbM?`A7?l?S?l?S?Z1'?9XbM?tj~?9XbM?tj?I^5??Õ$/?M?9XbM?\(?\(?S?° ě?bM?ěS?333333?lD?Õ$/?n?Z1'?n?333333?Õ$/?Z1'?333333?nO?\(?`A7?ěS?nO;?M?n?M?M?`A7?+?l?Q?M?° ě?333333?öE?Z1'?öE?E?`A7K?S?nO;?333333?nO;?nO?nO;?tj~?Q?`A7K?-V?I^5??Q?tj?\(?ěS?ļj~#?+?° ě?S?
=p??|hs?nO;?hr Ĝ?Q?tj?`A7?l?+?\(?nO;?l?Õ$/?-V?\(?`A7?&x?I^5??Õ$/?° ě?öE?
=p?333333?/w?9XbM?tj~?-V?° ě?° ě?tj~?hr Ĝ??|hs?öE?KƧ?S?333333?nO?l?M?`A7?9XbM?M?`A7?° ě?n?° ě?E?öE?Q?Õ$/?Õ$/?tj?l?333333?/w?ļj~#?S?ěS?+?`A7L?n?l?Q?ěS?M?Z1'?\(?$/?+?nO?I^5??`A7K?-V?nO;?9XbM?öE??|hs?öE?`A7?Õ$/?/w?\(?l?\(?-V?ěS?/w?öE?tj~?zG{?7KƧ?\(?I^5??-V?nO?`A7?-V?zG{?nO?l?S?+?öE?M?S?zG{?ļj~#?öE?GzH?333333?tj~?° ě?+?Õ$/?nO?nO?tj?n?GzH?M?\(?l?° ě?zG{?öE?ļj~#?
=p?+?333333?+?Õ$/?+?tj?Ł$/?° ě?+?ěS??|hs?nP?M?\(?öE?
=p?šo?`A7?nO;?`A7K?Õ$/?Q?M?l?M?l?S?333333?\(?öE?+?nO;?° ě?öE?nP?$/?nO;?7KƧ?&x?hr Ĝ?-V?nO?M?Ł$/?M?tj~?+?l?öE?tj?7KƧ?9XbM?nO?9XbM?öE?öE?`A7?+?`A7?A7Kƨ?I^5??Q?`A7?zG{?öE?ļj~#?nO?nO?7KƧ?S?tj?nO;?tj~?`A7L?nO;?+?bM?333333?tj?333333?
=p?\(?/w?9XbM?l?hr Ĝ?n?333333?Q?S?° ě?tj?`A7?S?S?/w?° ě?-V?333333?I^5??öE?`A7K?\(?nO?n?E?M?l?Z1'?n?n?M?\(?\(?`A7?l?lD?333333?Q?lD?`A7L?nO;?I^5??\(?S?E?\(?I^5??nO?nO;?S?&x?E?E?7KƧ?° ě?tj~??|hs?\(?n?tj~?Z1'?333333?tj~?n?Q?333333?`A7?tj~?Q?° ě?S?zG{?Ł$/?nO;?`A7?nO;?M?333333?Ł$/?Õ$/?tj?Q?zG{?lD?
=p?° ě?l?S?tj~?E?tj?° ě?$/?S?öE?tj?S?I^5??-V?vȴ9X?333333?Z1'?333333?l?nO;?öE?nO;?tj?-V?-V?`A7?l?M?° ě?l?Q?öE?333333?333333?Z1'?I^5??nP?tj~?lD?nO;?tj~?Q?tj~?7KƧ?S?Q?+?l?l?l?tj~?öE??|hs?nO;?Z1'?333333?nO?GzH?`A7?Õ$/?tj~?lD?nO;?l?öE?S?-V?° ě?n?S?Õ$/?tj~?tj?S?tj~?M?tj?
=p?`A7?hr Ĝ?hr Ĝ?Q?öE?+?
=p?S?\(?I^5??hr Ĝ?öE?&x?I^5??° ě?tj?`A7?ļj~#?ěS?M?`A7L?tj~?
=p?333333?-V?nO;?Z1'?° ě?öE?S?hr Ĝ?lD?M?bM?`A7?n?
=p?+?`A7?9XbM?tj~?tj~?333333?&x?GzH?öE?° ě?Q?tj~?7KƧ?n?&x?333333?° ě?333333?+?\(?+?\(?ļj~#?hr Ĝ?`A7L?\(?ěS?öE?\(?zG{?nO;?M?Q?Õ$/?\(?$/?
=p?M?ļj~#?nO?&x?Õ$/?tj~?333333?tj~?l?lD?tj?lD?GzH?nO;?-V?`A7L?nO?n?Õ$/?`A7L?333333?I^5??öE?hr Ĝ?
=p?Õ$/?° ě?n?-V?-V?° ě?+?nO;?S?Z1'?nO;?-V?\(?`A7?I^5??M?M?l?nO;?GzH?333333?° ě?° ě?Q?Q?Q?`A7?zG{?333333?tj?
=p?l?/w?9XbM?E?-V?nO;?
=p?333333?-V?/w?
=p?
=p?Z1'?333333?7KƧ?-V?A7Kƨ?GzH?nO?7KƧ?7KƧ?&x?GzH?$/?GzH?nO;?
=p?M?E??|hs?I^5??\(?`A7L?bM?tj~?n?hr Ĝ?`A7K?tj~?lD?
=p?7KƧ?`A7?° ě?\(?nP?° ě?333333?l?$/?nO;?\(?9XbM?&x?bM?7KƧ?+?
=p?Õ$/?`A7?nO?
=p?tj~?
=p?333333?+?M?`A7?&x?A7Kƨ?Q?Q?nO;?Q?`A7?GzH? ěT?A7Kƨ?333333?$/?\(?
=p?ěS?      ?M?-V?nO;?I^5??\(?7KƧ?n?lD?I^5??9XbM?n?lD?M?l?Q?GzH?nO?tj~?-V?n?nO;?nO;?Õ$/?7KƧ?hr Ĝ?n? ěT?nO?nO;?&x?n?öE?A7Kƨ?Q?l?I^5??nO?hr Ĝ?GzH?-V?333333?lD?-V?+?
=p?nO?tj?lD?
=p?Õ$/?Q?nP?-V?Q?n?Õ$/?`A7L?I^5??GzH?`A7?7KƧ?
=p?hr Ĝ?$/?      ?bM?n?nO;?Q?7KƧ?Õ$/?l?Q?7KƧ?$/?nO;?-V?\(?nP?$/?333333?
=p?`A7?$/?\(?ěS?lD?Q?hr Ĝ?-V?° ě?Q?&x?Q?\(?Q?I^5??
=p?
=p?M?
=p?7KƧ?+?$/?nO;?-V?S?\(?$/?nO;?&x?ěS?A7Kƨ?n?nP?I^5??hr Ĝ?`A7L?lD?$/?Q?-V?I^5??l?$/?n?Ł$/?nO;?7KƧ?n?&x?      ?GzH?° ě?öE?nO;?hr Ĝ?
=p?nO;?Q?`A7L?`A7L?
=p?S?° ě?ļj~#?
=p?-V?° ě?ěS?`A7L?nO?`A7L?
=p?° ě?hr!?vȴ9X?A7Kƨ?hr Ĝ?&x?I^5??`A7?9XbM?nO?zG{?-V?bM?M?$/?GzH?GzH?\(?nO;?\(?-V?nP?nO?öE?&x?vȴ9X?`A7L?hr Ĝ?n?nO?Õ$/?
=p?n?ěS?lD?° ě?;dZ?7KƧ?n?|hr?° ě?lD?$/?$/?S?n?I^5??$/?"`?7KƧ?lD?Q?-V?&x? ěT?
=p?GzH?-V?-V?nO;?`A7?l?° ě?`A7L?7KƧ?lD?vȴ9X?`A7?n?nO?tj?GzH?GzH?Q?"`?&x?333333?$/?nO?Q?° ě?lD?;dZ?7KƧ?nP?bM?\(?Õ$/?M?° ě?nO;?A7Kƨ?A7Kƨ?$/?hr Ĝ?nO?`A7L?bM?nP?GzH?Q?"`?n?lD?tj~?nO?nO;?lD?Q?A7Kƨ?bM?`A7L?;dZ? ěT?      ?;dZ?I^5??hr Ĝ?Q?nP?&x?M?lD?+?nO;?\(?$/?lD?hr Ĝ?GzH?l?-V?A7Kƨ?|hr?7KƧ?M?vȴ9X?&x?S?M?GzH?nP?bM?° ě?hr Ĝ?|hr?5?|h?      ?$/?$/?n?nO?-V?7KƧ?-V?Q?&x?`A7L?nP? ěT?S?nP?&x?333333?      ?hr Ĝ?nP?7KƧ?`A7?333333?hr Ĝ?Q?
=p?GzH?`A7L?I^5??GzH?n?\(?`A7L?ěS?`A7L?`A7L?/v?&x?
=p?n?GzH?ěS?"`?vȴ9X?lD?hr Ĝ?"`?&x?hr Ĝ?&x?`A7L?I^5??&x?n?lD?&x?I^5??\(?;dZ?      ?n?$/?ěS?bM?A7Kƨ?&x?7KƧ?\(?hr Ĝ?ěS?hr Ĝ?bM?ěS?\(?M?
=p?$/?5?|h?
=p?Q?vȴ9X?hr!?`A7L?hr Ĝ?GzH?hr Ĝ?vȴ9X?nO;?nP?`A7L?&x?7KƧ?n?`A7L?Q?Q?Q?GzH?hr Ĝ?I^5??
=p?7KƧ?5?|h?hr Ĝ?Q?`A7L?GzH?hr Ĝ?;dZ?A7Kƨ?I^5??&x?&x?ěS?nO?&x?`A7?GzH?lD?A7Kƨ?333333?n?hr Ĝ?-V?$/?bM?5?|h?hr Ĝ?n?$/?`A7L?GzH?
=p?ěS?bM?
=p?hr Ĝ?7KƧ?ěS?nP?hr Ĝ?&x?M?M?|hr?I^5??"`?hr Ĝ?GzH?
=p?lD?-V?A7Kƨ?Q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@O&fffff@O333333@O@     @O@     @O@     @O@     @O@     @O@     @O      @Nٙ@O@O@     @O333333@O&fffff@O@     @O@     @O@     @O@     @O@     @O@     @O@     @O333333@O@     @O@     @O333333@O333333@O&fffff@O&fffff@O333333@O@Nfffff@O333333@O333333@O333333@O&fffff@O@O@Nfffff@O&fffff@O@O@O@O@O      @O      @Nfffff@Nٙ@N@N@Nfffff@O      @O      @O333333@O@     @OY@O     @O@O@O@O@O     @Oٙ@O33333@Pfffff@P@P33333@P      @P,@P9@P9@P@     @P9@P@     @PFfffff@P@     @P@     @P9@P9@P@     @PFfffff@PL@P`     @Ps33333@Py@Py@Py@Py@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P     @P     @Pfffff@P33333@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@Pfffff@P@P@P@P@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P@P33333@P33333@P@P@P33333@P33333@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P     @P     @P@P     @P     @P     @P@P     @P     @P     @P@P     @P@P@P@P@P     @P     @P     @P     @P@P@P@P@P33333@P@P33333@P@P@P@P@P33333@P@P@P@P33333@P@P@P33333@P@P@P@P@P33333@P33333@P33333@P@P@P33333@P@P33333@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P     @P@P@P@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pٙ@P33333@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@Pfffff@P@Pfffff@P@P@Pfffff@Pfffff@P@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P33333@P@P@P@P@P@P@Pfffff@P@P@P@P@P33333@P@P33333@P33333@P@P@P@P@P@P@P     @P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P33333@P33333@P@P@P@P@P33333@P@P@P@P33333@P@P@P@P@P@P@P@P@P33333@P@P@Pfffff@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P@P@P@P33333@P33333@P@P@P@P@P@P@P33333@P@P@P33333@P@P33333@P33333@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P33333@P@P@P@P@P33333@P@P@P@P33333@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P33333@P@P@P@P33333@P@P33333@P@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P33333@P@P@P@P@P@P33333@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P@P@P33333@P33333@P@P@P33333@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              P12                                     4                                       
BC3